/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.waypoint;

import java.util.List;
import journeymap.client.Constants;
import journeymap.client.data.WorldData;
import journeymap.client.ui.component.Button;
import journeymap.client.waypoint.WaypointStore;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;

class DimensionsButton
extends Button {
    static boolean needInit = true;
    static WorldData.DimensionProvider currentWorldProvider;
    final List<WorldData.DimensionProvider> dimensionProviders = WorldData.getDimensionProviders(WaypointStore.INSTANCE.getLoadedDimensions());
    static int index;

    public DimensionsButton(Button.OnPress onPress) {
        super(0, 0, "", onPress);
        if (needInit) {
            currentWorldProvider = null;
            needInit = false;
        }
        this.updateLabel();
        this.fitWidth(Minecraft.m_91087_().f_91062_);
    }

    public void setDim(ResourceKey<Level> dim) {
        index = -1;
        WorldData.DimensionProvider provider = this.dimensionProviders.stream().filter(dimensionProvider -> dim.equals(dimensionProvider.getDimension())).findFirst().orElse(null);
        for (WorldData.DimensionProvider p : this.dimensionProviders) {
            ++index;
            this.getProvider();
            if (!p.equals(provider)) continue;
            return;
        }
    }

    @Override
    protected void updateLabel() {
        String dimName = currentWorldProvider != null ? currentWorldProvider.getName() : Constants.getString("jm.waypoint.dimension_all");
        this.m_93666_((Component)Constants.getStringTextComponent(Constants.getString("jm.waypoint.dimension", dimName)));
    }

    @Override
    public int getFitWidth(Font fr) {
        int maxWidth = 0;
        for (WorldData.DimensionProvider dimensionProvider : this.dimensionProviders) {
            String name = Constants.getString("jm.waypoint.dimension", WorldData.getSafeDimensionName(dimensionProvider));
            maxWidth = Math.max(maxWidth, Minecraft.m_91087_().f_91062_.m_92895_(name));
        }
        return maxWidth + 12;
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        boolean clicked = super.m_6375_(mouseX, mouseY, button);
        if (clicked && button == 0) {
            ++index;
            this.getProvider();
        } else if (clicked && button == 1) {
            --index;
            this.getProvider();
        }
        if (clicked) {
            super.m_5691_();
        }
        return clicked;
    }

    @Override
    public void m_5691_() {
    }

    protected boolean m_7972_(int button) {
        return button == 0 || button == 1;
    }

    private void getProvider() {
        if (index >= this.dimensionProviders.size()) {
            index = -1;
        } else if (index < -1) {
            index = this.dimensionProviders.size() - 1;
        }
        currentWorldProvider = index >= this.dimensionProviders.size() || index < 0 ? null : this.dimensionProviders.get(index);
        this.updateLabel();
    }

    static {
        index = -1;
    }
}

