/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.event;

import com.github.alexmodguy.alexscaves.AlexsCaves;
import com.github.alexmodguy.alexscaves.client.ClientProxy;
import com.github.alexmodguy.alexscaves.client.gui.ACAdvancementTabs;
import com.github.alexmodguy.alexscaves.client.render.blockentity.AmbersolBlockRenderer;
import com.github.alexmodguy.alexscaves.client.render.blockentity.HologramProjectorBlockRenderer;
import com.github.alexmodguy.alexscaves.client.render.entity.CorrodentRenderer;
import com.github.alexmodguy.alexscaves.client.render.entity.SubmarineRenderer;
import com.github.alexmodguy.alexscaves.client.render.item.RaygunRenderHelper;
import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import com.github.alexmodguy.alexscaves.server.block.fluid.ACFluidRegistry;
import com.github.alexmodguy.alexscaves.server.entity.item.BeholderEyeEntity;
import com.github.alexmodguy.alexscaves.server.entity.item.NuclearBombEntity;
import com.github.alexmodguy.alexscaves.server.entity.item.SubmarineEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.AtlatitanEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.DinosaurEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.SubterranodonEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.TremorsaurusEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.TremorzillaEntity;
import com.github.alexmodguy.alexscaves.server.entity.util.HeadRotationEntityAccessor;
import com.github.alexmodguy.alexscaves.server.entity.util.MagnetUtil;
import com.github.alexmodguy.alexscaves.server.entity.util.MagneticEntityAccessor;
import com.github.alexmodguy.alexscaves.server.entity.util.PossessesCamera;
import com.github.alexmodguy.alexscaves.server.entity.util.ShakesScreen;
import com.github.alexmodguy.alexscaves.server.item.ACItemRegistry;
import com.github.alexmodguy.alexscaves.server.item.DarknessArmorItem;
import com.github.alexmodguy.alexscaves.server.item.GalenaGauntletItem;
import com.github.alexmodguy.alexscaves.server.item.RaygunItem;
import com.github.alexmodguy.alexscaves.server.item.ResistorShieldItem;
import com.github.alexmodguy.alexscaves.server.item.SpearItem;
import com.github.alexmodguy.alexscaves.server.item.TotemOfPossessionItem;
import com.github.alexmodguy.alexscaves.server.level.biome.ACBiomeRegistry;
import com.github.alexmodguy.alexscaves.server.level.biome.BiomeSampler;
import com.github.alexmodguy.alexscaves.server.misc.ACVanillaMapUtil;
import com.github.alexmodguy.alexscaves.server.potion.ACEffectRegistry;
import com.github.alexmodguy.alexscaves.server.potion.DarknessIncarnateEffect;
import com.github.alexmodguy.alexscaves.server.potion.DeepsightEffect;
import com.github.alexthe666.citadel.client.event.EventGetOutlineColor;
import com.github.alexthe666.citadel.client.event.EventLivingRenderer;
import com.github.alexthe666.citadel.client.event.EventPosePlayerHand;
import com.github.alexthe666.citadel.client.event.EventRenderSplashText;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Arrays;
import java.util.UUID;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.screens.advancements.AdvancementsScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ComputeFovModifierEvent;
import net.minecraftforge.client.event.CustomizeGuiOverlayEvent;
import net.minecraftforge.client.event.RenderBlockScreenEffectEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class ClientEvents {
    private static final ResourceLocation POTION_EFFECT_HUD_OVERLAYS = new ResourceLocation("alexscaves", "textures/misc/potion_effect_hud_overlays.png");
    private static final ResourceLocation BOSS_BAR_HUD_OVERLAYS = new ResourceLocation("alexscaves", "textures/misc/boss_bar_hud_overlays.png");
    private static final ResourceLocation DINOSAUR_HUD_OVERLAYS = new ResourceLocation("alexscaves", "textures/misc/dinosaur_hud_overlays.png");
    private static final ResourceLocation ARMOR_HUD_OVERLAYS = new ResourceLocation("alexscaves", "textures/misc/armor_hud_overlays.png");
    private static final ResourceLocation SUBMARINE_SHADER = new ResourceLocation("alexscaves", "shaders/post/submarine_light.json");
    private static final ResourceLocation WATCHER_SHADER = new ResourceLocation("alexscaves", "shaders/post/watcher_perspective.json");
    private static final ResourceLocation TRAIL_TEXTURE = new ResourceLocation("alexscaves", "textures/particle/teletor_trail.png");
    private static float lastSampledFogNearness = 0.0f;
    private static float lastSampledWaterFogFarness = 0.0f;
    private static Vec3 lastSampledFogColor = Vec3.f_82478_;
    private static Vec3 lastSampledWaterFogColor = Vec3.f_82478_;
    public static PoseStack lastVanillaMapPoseStack;
    public static MultiBufferSource lastVanillaMapRenderBuffer;
    public static int lastVanillaMapRenderPackedLight;
    private static final RenderType UNDERGROUND_CABIN_MAP_ICONS;

    @SubscribeEvent
    public void setupEntityRotations(EventLivingRenderer.SetupRotations event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof MagneticEntityAccessor) {
            MagneticEntityAccessor magnetic = (MagneticEntityAccessor)livingEntity;
            float width = event.getEntity().m_20205_();
            float height = event.getEntity().m_20206_();
            float progress = magnetic.getAttachmentProgress(event.getPartialTicks());
            float prevProg = 1.0f - progress;
            float bodyRot = 180.0f - event.getBodyYRot();
            if (magnetic.getMagneticAttachmentFace().m_122434_() != Direction.Axis.Y) {
                event.getPoseStack().m_252781_(Axis.f_252392_.m_252977_(1.0f * bodyRot));
            }
            this.rotateForAngle(event.getEntity(), event.getPoseStack(), magnetic.getPrevMagneticAttachmentFace(), prevProg, width, height);
            this.rotateForAngle(event.getEntity(), event.getPoseStack(), magnetic.getMagneticAttachmentFace(), progress, width, height);
        }
    }

    @SubscribeEvent
    public void preRenderLiving(RenderLivingEvent.Pre event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof HeadRotationEntityAccessor) {
            HeadRotationEntityAccessor magnetic = (HeadRotationEntityAccessor)livingEntity;
            magnetic.setMagnetHeadRotation();
        }
        if (ClientProxy.blockedEntityRenders.contains(event.getEntity().m_20148_())) {
            if (!AlexsCaves.PROXY.isFirstPersonPlayer((Entity)event.getEntity())) {
                MinecraftForge.EVENT_BUS.post((Event)new RenderLivingEvent.Post(event.getEntity(), event.getRenderer(), event.getPartialTick(), event.getPoseStack(), event.getMultiBufferSource(), event.getPackedLight()));
                event.setCanceled(true);
            }
            ClientProxy.blockedEntityRenders.remove(event.getEntity().m_20148_());
        }
    }

    @SubscribeEvent
    public void postRenderLiving(RenderLivingEvent.Post event) {
        LivingEntity entity = event.getEntity();
        float partialTick = event.getPartialTick();
        if (entity instanceof HeadRotationEntityAccessor) {
            HeadRotationEntityAccessor magnetic = (HeadRotationEntityAccessor)entity;
            magnetic.resetMagnetHeadRotation();
        }
        if (!Minecraft.m_91087_().f_91066_.m_92176_().m_90612_()) {
            RaygunRenderHelper.renderRaysFor(entity, entity.m_20318_(partialTick), event.getPoseStack(), event.getMultiBufferSource(), partialTick, false, 0);
        }
        if (entity.m_21023_((MobEffect)ACEffectRegistry.DARKNESS_INCARNATE.get()) && entity.m_6084_()) {
            Vec3 trailOffset = new Vec3(0.0, (double)(entity.m_20206_() * 0.5f), 0.0);
            double x = Mth.m_14139_((double)partialTick, (double)entity.f_19790_, (double)entity.m_20185_());
            double y = Mth.m_14139_((double)partialTick, (double)entity.f_19791_, (double)entity.m_20186_());
            double z = Mth.m_14139_((double)partialTick, (double)entity.f_19792_, (double)entity.m_20189_());
            int sampleSize = 60;
            float trailHeight = entity.m_20206_() * 0.8f;
            Vec3 topAngleVec = new Vec3(0.0, (double)trailHeight, 0.0);
            Vec3 bottomAngleVec = new Vec3(0.0, (double)(-trailHeight), 0.0);
            Vec3 drawFrom = trailOffset;
            VertexConsumer vertexconsumer = event.getMultiBufferSource().m_6299_(RenderType.m_110473_((ResourceLocation)TRAIL_TEXTURE));
            float trailA = DarknessIncarnateEffect.getIntensity(entity, partialTick, 20.0f);
            int packedLightIn = event.getPackedLight();
            for (int samples = 0; samples < sampleSize; ++samples) {
                Vec3 sample = AlexsCaves.PROXY.getDarknessTrailPosFor(entity, samples + 5, partialTick).m_82492_(x, y, z).m_82549_(trailOffset);
                float u1 = (float)samples / (float)sampleSize;
                float u2 = u1 + 1.0f / (float)sampleSize;
                Vec3 draw1 = drawFrom;
                Vec3 draw2 = sample;
                PoseStack.Pose posestack$pose = event.getPoseStack().m_85850_();
                Matrix4f matrix4f = posestack$pose.m_252922_();
                Matrix3f matrix3f = posestack$pose.m_252943_();
                vertexconsumer.m_252986_(matrix4f, (float)draw1.f_82479_ + (float)bottomAngleVec.f_82479_, (float)draw1.f_82480_ + (float)bottomAngleVec.f_82480_, (float)draw1.f_82481_ + (float)bottomAngleVec.f_82481_).m_85950_(0.0f, 0.0f, 0.0f, trailA).m_7421_(u1, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
                vertexconsumer.m_252986_(matrix4f, (float)draw2.f_82479_ + (float)bottomAngleVec.f_82479_, (float)draw2.f_82480_ + (float)bottomAngleVec.f_82480_, (float)draw2.f_82481_ + (float)bottomAngleVec.f_82481_).m_85950_(0.0f, 0.0f, 0.0f, trailA).m_7421_(u2, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
                vertexconsumer.m_252986_(matrix4f, (float)draw2.f_82479_ + (float)topAngleVec.f_82479_, (float)draw2.f_82480_ + (float)topAngleVec.f_82480_, (float)draw2.f_82481_ + (float)topAngleVec.f_82481_).m_85950_(0.0f, 0.0f, 0.0f, trailA).m_7421_(u2, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
                vertexconsumer.m_252986_(matrix4f, (float)draw1.f_82479_ + (float)topAngleVec.f_82479_, (float)draw1.f_82480_ + (float)topAngleVec.f_82480_, (float)draw1.f_82481_ + (float)topAngleVec.f_82481_).m_85950_(0.0f, 0.0f, 0.0f, trailA).m_7421_(u1, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
                drawFrom = sample;
            }
        }
    }

    private static void attemptLoadShader(ResourceLocation resourceLocation) {
        GameRenderer renderer = Minecraft.m_91087_().f_91063_;
        if (ClientProxy.shaderLoadAttemptCooldown <= 0) {
            renderer.m_109128_(resourceLocation);
            if (!renderer.f_109053_) {
                ClientProxy.shaderLoadAttemptCooldown = 12000;
                AlexsCaves.LOGGER.warn("Alex's Caves could not load the shader {}, will attempt to load shader in 30 seconds", (Object)resourceLocation);
            }
        }
    }

    @SubscribeEvent
    public void postRenderStage(RenderLevelStageEvent event) {
        Entity cameraPos;
        MultiBufferSource.BufferSource multibuffersource$buffersource;
        LivingEntity living;
        Entity player = Minecraft.m_91087_().m_91288_();
        boolean firstPerson = Minecraft.m_91087_().f_91066_.m_92176_().m_90612_();
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_SKY) {
            LivingEntity afflicted;
            SubmarineEntity submarine;
            if (firstPerson && player instanceof LivingEntity) {
                living = (LivingEntity)player;
                multibuffersource$buffersource = Minecraft.m_91087_().m_91269_().m_110104_();
                cameraPos = event.getCamera().m_90583_();
                RaygunRenderHelper.renderRaysFor(living, (Vec3)cameraPos, event.getPoseStack(), (MultiBufferSource)multibuffersource$buffersource, event.getPartialTick(), true, 2);
            }
            GameRenderer renderer = Minecraft.m_91087_().f_91063_;
            if (firstPerson && player.m_20159_() && (cameraPos = player.m_20202_()) instanceof SubmarineEntity && SubmarineRenderer.isFirstPersonFloodlightsMode(submarine = (SubmarineEntity)cameraPos)) {
                if (renderer.m_109149_() == null || !SUBMARINE_SHADER.toString().equals(renderer.m_109149_().m_110022_())) {
                    ClientEvents.attemptLoadShader(SUBMARINE_SHADER);
                }
            } else if (renderer.m_109149_() != null && SUBMARINE_SHADER.toString().equals(renderer.m_109149_().m_110022_())) {
                renderer.m_109106_(null);
            }
            if (firstPerson && player instanceof PossessesCamera || player instanceof LivingEntity && (afflicted = (LivingEntity)player).m_21023_((MobEffect)ACEffectRegistry.DARKNESS_INCARNATE.get())) {
                if (renderer.m_109149_() == null || !WATCHER_SHADER.toString().equals(renderer.m_109149_().m_110022_())) {
                    ClientEvents.attemptLoadShader(WATCHER_SHADER);
                }
            } else if (renderer.m_109149_() != null && WATCHER_SHADER.toString().equals(renderer.m_109149_().m_110022_())) {
                renderer.m_109106_(null);
            }
        }
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_ENTITIES) {
            if (firstPerson && player instanceof LivingEntity) {
                living = (LivingEntity)player;
                multibuffersource$buffersource = Minecraft.m_91087_().m_91269_().m_110104_();
                cameraPos = event.getCamera().m_90583_();
                RaygunRenderHelper.renderRaysFor(living, (Vec3)cameraPos, event.getPoseStack(), (MultiBufferSource)multibuffersource$buffersource, event.getPartialTick(), true, 1);
            }
            RenderSystem.runAsFancy(() -> HologramProjectorBlockRenderer.renderEntireBatch(event.getLevelRenderer(), event.getPoseStack(), event.getRenderTick(), event.getCamera(), event.getPartialTick()));
        }
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_CUTOUT_BLOCKS) {
            RenderSystem.runAsFancy(() -> CorrodentRenderer.renderEntireBatch(event.getLevelRenderer(), event.getPoseStack(), event.getRenderTick(), event.getCamera(), event.getPartialTick()));
        }
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS && ((Boolean)AlexsCaves.CLIENT_CONFIG.ambersolShines.get()).booleanValue()) {
            RenderSystem.runAsFancy(() -> AmbersolBlockRenderer.renderEntireBatch(event.getLevelRenderer(), event.getPoseStack(), event.getRenderTick(), event.getCamera(), event.getPartialTick()));
        }
    }

    @SubscribeEvent
    public void computeCameraAngles(ViewportEvent.ComputeCameraAngles event) {
        LivingEntity livingEntity;
        float tremorAmount;
        Entity player = Minecraft.m_91087_().m_91288_();
        float partialTick = Minecraft.m_91087_().getPartialTick();
        float f = tremorAmount = ClientProxy.renderNukeSkyDarkFor > 0 ? 1.5f : 0.0f;
        if (player instanceof PossessesCamera) {
            PossessesCamera watcherEntity = (PossessesCamera)player;
            Minecraft.m_91087_().f_91066_.m_92157_(CameraType.FIRST_PERSON);
            float f2 = tremorAmount = watcherEntity.isPossessionBreakable() ? AlexsCaves.PROXY.getPossessionStrengthAmount(partialTick) : 0.0f;
        }
        if (player != null && ((Boolean)AlexsCaves.CLIENT_CONFIG.screenShaking.get()).booleanValue()) {
            double shakeDistanceScale = 64.0;
            double distance = Double.MAX_VALUE;
            if (tremorAmount == 0.0f) {
                AABB aabb = player.m_20191_().m_82400_(shakeDistanceScale);
                for (Mob screenShaker : Minecraft.m_91087_().f_91073_.m_6443_(Mob.class, aabb, mob -> mob instanceof ShakesScreen)) {
                    ShakesScreen shakesScreen = (ShakesScreen)screenShaker;
                    if (!shakesScreen.canFeelShake(player) || !((double)screenShaker.m_20270_(player) < distance)) continue;
                    distance = screenShaker.m_20270_(player);
                    tremorAmount = Math.min((1.0f - (float)Math.min(1.0, distance / shakesScreen.getShakeDistance())) * Math.max(shakesScreen.getScreenShakeAmount(partialTick), 0.0f), 2.0f);
                }
            }
            if (tremorAmount > 0.0f) {
                if (ClientProxy.lastTremorTick != player.f_19797_) {
                    RandomSource rng = player.m_9236_().f_46441_;
                    ClientProxy.randomTremorOffsets[0] = rng.m_188501_();
                    ClientProxy.randomTremorOffsets[1] = rng.m_188501_();
                    ClientProxy.randomTremorOffsets[2] = rng.m_188501_();
                    ClientProxy.lastTremorTick = player.f_19797_;
                }
                double intensity = (double)tremorAmount * (Double)Minecraft.m_91087_().f_91066_.m_231924_().m_231551_();
                event.getCamera().m_90568_((double)(ClientProxy.randomTremorOffsets[0] * 0.2f) * intensity, (double)(ClientProxy.randomTremorOffsets[1] * 0.2f) * intensity, (double)(ClientProxy.randomTremorOffsets[2] * 0.5f) * intensity);
            }
        }
        if (player != null && player.m_20159_() && player.m_20202_() instanceof SubmarineEntity && event.getCamera().m_90594_()) {
            event.getCamera().m_90568_(-event.getCamera().m_90566_(4.0), 0.0, 0.0);
        }
        if (player != null && player.m_20159_() && player.m_20202_() instanceof TremorsaurusEntity && event.getCamera().m_90594_()) {
            event.getCamera().m_90568_(-event.getCamera().m_90566_(2.0), 0.0, 0.0);
        }
        if (player != null && player.m_20159_() && player.m_20202_() instanceof AtlatitanEntity && event.getCamera().m_90594_()) {
            event.getCamera().m_90568_(-event.getCamera().m_90566_(4.0), 0.0, 0.0);
        }
        if (player != null && player.m_20159_() && player.m_20202_() instanceof TremorzillaEntity && event.getCamera().m_90594_()) {
            event.getCamera().m_90568_(-event.getCamera().m_90566_(10.0), 0.0, 0.0);
        }
        if (player != null && player instanceof LivingEntity && (livingEntity = (LivingEntity)player).m_21023_((MobEffect)ACEffectRegistry.STUNNED.get())) {
            event.setRoll((float)(Math.sin(((float)player.f_19797_ + partialTick) * 0.2f) * 10.0));
        }
        Direction dir = MagnetUtil.getEntityMagneticDirection(player);
    }

    @SubscribeEvent
    public void clientLivingTick(LivingEvent.LivingTickEvent event) {
        LivingEntity entity = event.getEntity();
        if (!entity.m_9236_().f_46443_) {
            return;
        }
        if (entity.m_21023_((MobEffect)ACEffectRegistry.DARKNESS_INCARNATE.get()) && entity.m_6084_()) {
            int trailPointer = ClientProxy.darknessTrailPointerMap.getOrDefault(entity, -1);
            Vec3 latest = entity.m_20182_();
            if (ClientProxy.darknessTrailPosMap.get(entity) == null) {
                Object[] trailPositions = new Vec3[64];
                if (trailPointer == -1) {
                    Arrays.fill(trailPositions, latest);
                }
                ClientProxy.darknessTrailPosMap.put(entity, (Vec3[])trailPositions);
            }
            if (++trailPointer == ClientProxy.darknessTrailPosMap.get(entity).length) {
                trailPointer = 0;
            }
            ClientProxy.darknessTrailPointerMap.put(entity, trailPointer);
            Vec3[] vector3ds = ClientProxy.darknessTrailPosMap.get(entity);
            vector3ds[trailPointer] = latest;
            ClientProxy.darknessTrailPosMap.put(entity, vector3ds);
        } else if (ClientProxy.darknessTrailPosMap.containsKey(entity)) {
            ClientProxy.darknessTrailPosMap.remove(entity);
            ClientProxy.darknessTrailPointerMap.remove(entity);
        }
    }

    @SubscribeEvent
    public void onRenderHand(RenderHandEvent event) {
        if (Minecraft.m_91087_().m_91288_() instanceof PossessesCamera) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onPreRenderGuiOverlay(RenderGuiOverlayEvent.Pre event) {
        DinosaurEntity dinosaur;
        Entity entity;
        Entity player = Minecraft.m_91087_().m_91288_();
        if (player instanceof PossessesCamera && (event.getOverlay().id().equals((Object)VanillaGuiOverlay.CROSSHAIR.id()) || event.getOverlay().id().equals((Object)VanillaGuiOverlay.EXPERIENCE_BAR.id()) || event.getOverlay().id().equals((Object)VanillaGuiOverlay.JUMP_BAR.id()) || event.getOverlay().id().equals((Object)VanillaGuiOverlay.ITEM_NAME.id()))) {
            event.setCanceled(true);
        }
        if (player != null && (entity = player.m_20202_()) instanceof DinosaurEntity && (dinosaur = (DinosaurEntity)entity).hasRidingMeter() && event.getOverlay().id().equals((Object)VanillaGuiOverlay.EXPERIENCE_BAR.id())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onPoseHand(EventPosePlayerHand event) {
        float armTilt;
        float useProgressUp;
        Entity entity;
        float f7;
        LivingEntity player = (LivingEntity)event.getEntityIn();
        float f = Minecraft.m_91087_().m_91296_();
        float rightHandResistorShieldUseProgress = 0.0f;
        float leftHandResistorShieldUseProgress = 0.0f;
        float rightHandGalenaGauntletUseProgress = 0.0f;
        float leftHandGalenaGauntletUseProgress = 0.0f;
        float rightHandSpearUseProgress = 0.0f;
        float leftHandSpearUseProgress = 0.0f;
        float rightHandRaygunUseProgress = 0.0f;
        float leftHandRaygunUseProgress = 0.0f;
        if (player.m_21120_(InteractionHand.MAIN_HAND).m_41720_() instanceof ResistorShieldItem) {
            if (player.m_5737_() == HumanoidArm.RIGHT) {
                rightHandResistorShieldUseProgress = Math.max(rightHandResistorShieldUseProgress, ResistorShieldItem.getLerpedUseTime(player.m_21120_(InteractionHand.MAIN_HAND), f));
            } else {
                leftHandResistorShieldUseProgress = Math.max(leftHandResistorShieldUseProgress, ResistorShieldItem.getLerpedUseTime(player.m_21120_(InteractionHand.MAIN_HAND), f));
            }
        }
        if (player.m_21120_(InteractionHand.OFF_HAND).m_41720_() instanceof ResistorShieldItem) {
            if (player.m_5737_() == HumanoidArm.RIGHT) {
                leftHandResistorShieldUseProgress = Math.max(leftHandResistorShieldUseProgress, ResistorShieldItem.getLerpedUseTime(player.m_21120_(InteractionHand.OFF_HAND), f));
            } else {
                rightHandResistorShieldUseProgress = Math.max(rightHandResistorShieldUseProgress, ResistorShieldItem.getLerpedUseTime(player.m_21120_(InteractionHand.OFF_HAND), f));
            }
        }
        if (player.m_21120_(InteractionHand.MAIN_HAND).m_41720_() instanceof GalenaGauntletItem) {
            if (player.m_5737_() == HumanoidArm.RIGHT) {
                rightHandGalenaGauntletUseProgress = Math.max(rightHandGalenaGauntletUseProgress, GalenaGauntletItem.getLerpedUseTime(player.m_21120_(InteractionHand.MAIN_HAND), f));
            } else {
                leftHandGalenaGauntletUseProgress = Math.max(leftHandGalenaGauntletUseProgress, GalenaGauntletItem.getLerpedUseTime(player.m_21120_(InteractionHand.MAIN_HAND), f));
            }
        }
        if (player.m_21120_(InteractionHand.OFF_HAND).m_41720_() instanceof GalenaGauntletItem) {
            if (player.m_5737_() == HumanoidArm.RIGHT) {
                leftHandGalenaGauntletUseProgress = Math.max(leftHandGalenaGauntletUseProgress, GalenaGauntletItem.getLerpedUseTime(player.m_21120_(InteractionHand.OFF_HAND), f));
            } else {
                rightHandGalenaGauntletUseProgress = Math.max(rightHandGalenaGauntletUseProgress, GalenaGauntletItem.getLerpedUseTime(player.m_21120_(InteractionHand.OFF_HAND), f));
            }
        }
        if (player.m_21120_(InteractionHand.MAIN_HAND).m_41720_() instanceof SpearItem && player.m_6117_() && player.m_21212_() > 0) {
            f7 = ((float)player.m_21120_(InteractionHand.MAIN_HAND).m_41779_() - ((float)player.m_21212_() - f + 1.0f)) / 10.0f;
            if (player.m_5737_() == HumanoidArm.RIGHT) {
                rightHandSpearUseProgress = Math.max(rightHandSpearUseProgress, f7);
            } else {
                leftHandSpearUseProgress = Math.max(leftHandSpearUseProgress, f7);
            }
        }
        if (player.m_21120_(InteractionHand.OFF_HAND).m_41720_() instanceof SpearItem && player.m_6117_() && player.m_21212_() > 0) {
            f7 = ((float)player.m_21120_(InteractionHand.OFF_HAND).m_41779_() - ((float)player.m_21212_() - f + 1.0f)) / 10.0f;
            if (player.m_5737_() == HumanoidArm.RIGHT) {
                leftHandSpearUseProgress = Math.max(leftHandSpearUseProgress, f7);
            } else {
                rightHandSpearUseProgress = Math.max(rightHandSpearUseProgress, f7);
            }
        }
        if (player.m_21120_(InteractionHand.MAIN_HAND).m_41720_() instanceof RaygunItem) {
            if (player.m_5737_() == HumanoidArm.RIGHT) {
                rightHandRaygunUseProgress = Math.max(rightHandRaygunUseProgress, RaygunItem.getLerpedUseTime(player.m_21120_(InteractionHand.MAIN_HAND), f));
            } else {
                leftHandRaygunUseProgress = Math.max(leftHandRaygunUseProgress, RaygunItem.getLerpedUseTime(player.m_21120_(InteractionHand.MAIN_HAND), f));
            }
        }
        if (player.m_21120_(InteractionHand.OFF_HAND).m_41720_() instanceof RaygunItem) {
            if (player.m_5737_() == HumanoidArm.RIGHT) {
                leftHandRaygunUseProgress = Math.max(leftHandRaygunUseProgress, RaygunItem.getLerpedUseTime(player.m_21120_(InteractionHand.OFF_HAND), f));
            } else {
                rightHandRaygunUseProgress = Math.max(rightHandRaygunUseProgress, RaygunItem.getLerpedUseTime(player.m_21120_(InteractionHand.OFF_HAND), f));
            }
        }
        if (player.m_20159_() && (entity = player.m_20202_()) instanceof SubterranodonEntity) {
            SubterranodonEntity subterranodon = (SubterranodonEntity)entity;
            float flight = subterranodon.getFlyProgress(f) - subterranodon.getHoverProgress(f);
            if (flight > 0.0f) {
                event.getModel().f_102812_.f_104203_ = -((float)Math.toRadians(180.0)) * flight;
                event.getModel().f_102812_.f_104205_ = (float)Math.toRadians(-10.0) * flight;
                event.getModel().f_102811_.f_104203_ = -((float)Math.toRadians(180.0)) * flight;
                event.getModel().f_102811_.f_104205_ = (float)Math.toRadians(10.0) * flight;
            }
            event.setResult(Event.Result.ALLOW);
        }
        if (leftHandResistorShieldUseProgress > 0.0f) {
            float useProgress = Math.min(10.0f, leftHandResistorShieldUseProgress) / 10.0f;
            float useProgressTurn = Math.min(useProgress * 4.0f, 1.0f);
            useProgressUp = (float)Math.sin((double)useProgress * Math.PI);
            armTilt = event.getModel().f_102817_ ? 120.0f : 80.0f;
            event.getModel().f_102812_.f_104203_ = -((float)Math.toRadians(armTilt)) - (float)Math.toRadians(80.0) * useProgressUp;
            event.getModel().f_102812_.f_104204_ = (float)Math.toRadians(20.0) * useProgressTurn;
            event.setResult(Event.Result.ALLOW);
        }
        if (rightHandResistorShieldUseProgress > 0.0f) {
            float useProgress = Math.min(10.0f, rightHandResistorShieldUseProgress) / 10.0f;
            float useProgressTurn = Math.min(useProgress * 4.0f, 1.0f);
            useProgressUp = (float)Math.sin((double)useProgress * Math.PI);
            armTilt = event.getModel().f_102817_ ? 120.0f : 80.0f;
            event.getModel().f_102811_.f_104203_ = -((float)Math.toRadians(armTilt)) - (float)Math.toRadians(80.0) * useProgressUp;
            event.getModel().f_102811_.f_104204_ = -((float)Math.toRadians(20.0)) * useProgressTurn;
            event.setResult(Event.Result.ALLOW);
        }
        if (leftHandGalenaGauntletUseProgress > 0.0f) {
            float useProgress = Math.min(5.0f, leftHandGalenaGauntletUseProgress) / 5.0f;
            event.getModel().f_102812_.f_104203_ = (event.getModel().f_102808_.f_104203_ - (float)Math.toRadians(80.0)) * useProgress;
            event.getModel().f_102812_.f_104204_ = event.getModel().f_102808_.f_104204_ * useProgress;
            event.setResult(Event.Result.ALLOW);
        }
        if (rightHandGalenaGauntletUseProgress > 0.0f) {
            float useProgress = Math.min(5.0f, rightHandGalenaGauntletUseProgress) / 5.0f;
            event.getModel().f_102811_.f_104203_ = (event.getModel().f_102808_.f_104203_ - (float)Math.toRadians(80.0)) * useProgress;
            event.getModel().f_102811_.f_104204_ = event.getModel().f_102808_.f_104204_ * useProgress;
            event.setResult(Event.Result.ALLOW);
        }
        if (leftHandSpearUseProgress > 0.0f) {
            float useProgress = Math.min(1.0f, leftHandSpearUseProgress);
            float useProgressMiddle = (float)Math.sin((double)useProgress * Math.PI);
            event.getModel().f_102812_.f_104203_ = useProgress * ((float)Math.toRadians(-180.0) + event.getModel().f_102808_.f_104203_);
            event.getModel().f_102812_.f_104204_ = useProgressMiddle * ((float)Math.toRadians(-25.0) - event.getModel().f_102808_.f_104204_);
            event.getModel().f_102812_.f_104205_ = useProgress * (float)Math.toRadians(50.0) - (float)Math.toRadians(25.0);
            event.setResult(Event.Result.ALLOW);
        }
        if (rightHandSpearUseProgress > 0.0f) {
            float useProgress = Math.min(1.0f, rightHandSpearUseProgress);
            float useProgressMiddle = (float)Math.sin((double)useProgress * Math.PI);
            event.getModel().f_102811_.f_104203_ = useProgress * ((float)Math.toRadians(-180.0) + event.getModel().f_102808_.f_104203_);
            event.getModel().f_102811_.f_104204_ = useProgressMiddle * ((float)Math.toRadians(25.0) - event.getModel().f_102808_.f_104204_);
            event.getModel().f_102811_.f_104205_ = useProgress * -((float)Math.toRadians(50.0)) + (float)Math.toRadians(25.0);
            event.setResult(Event.Result.ALLOW);
        }
        if (event.getEntityIn().m_20202_() instanceof NuclearBombEntity) {
            float ageInTicks = (float)event.getEntityIn().f_19797_ + f;
            event.getModel().f_102811_.f_104203_ = (float)Math.toRadians(-170.0);
            event.getModel().f_102811_.f_104204_ = (float)Math.toRadians(100.0) + (float)Math.cos(ageInTicks * 0.35f) * (float)Math.toRadians(20.0);
            event.getModel().f_102811_.f_104205_ = (float)Math.sin(ageInTicks * 0.35f) * (float)Math.toRadians(50.0) - (float)Math.toRadians(70.0);
            event.getModel().f_102812_.f_104204_ = (float)Math.toRadians(30.0);
            event.setResult(Event.Result.ALLOW);
        }
        if (leftHandRaygunUseProgress > 0.0f) {
            float useProgress = Math.min(5.0f, leftHandRaygunUseProgress) / 5.0f;
            event.getModel().f_102812_.f_104203_ = (event.getModel().f_102808_.f_104203_ - (float)Math.toRadians(80.0)) * useProgress;
            event.getModel().f_102812_.f_104204_ = event.getModel().f_102808_.f_104204_ * useProgress;
            event.getModel().f_102812_.f_104205_ = 0.0f;
            event.setResult(Event.Result.ALLOW);
        }
        if (rightHandRaygunUseProgress > 0.0f) {
            float useProgress = Math.min(5.0f, rightHandRaygunUseProgress) / 5.0f;
            event.getModel().f_102811_.f_104203_ = (event.getModel().f_102808_.f_104203_ - (float)Math.toRadians(80.0)) * useProgress;
            event.getModel().f_102811_.f_104204_ = event.getModel().f_102808_.f_104204_ * useProgress;
            event.getModel().f_102811_.f_104205_ = 0.0f;
            event.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent
    public void onPostRenderGuiOverlay(RenderGuiOverlayEvent.Post event) {
        float invProgress;
        float f;
        int k22;
        int j;
        int forgeGuiY;
        int screenHeight;
        DinosaurEntity dinosaur;
        Entity entity;
        Player player = AlexsCaves.PROXY.getClientSidePlayer();
        int hudY = 0;
        if (event.getOverlay().id().equals((Object)VanillaGuiOverlay.CROSSHAIR.id()) && (entity = player.m_20202_()) instanceof DinosaurEntity && (dinosaur = (DinosaurEntity)entity).hasRidingMeter()) {
            int screenWidth = event.getWindow().m_85445_();
            screenHeight = event.getWindow().m_85446_();
            Gui gui = Minecraft.m_91087_().f_91065_;
            if (gui instanceof ForgeGui) {
                ForgeGui forgeGui = (ForgeGui)gui;
                v0 = Math.max(forgeGui.leftHeight, forgeGui.rightHeight);
            } else {
                v0 = forgeGuiY = 0;
            }
            if (player.m_21230_() > 0 && dinosaur instanceof SubterranodonEntity) {
                forgeGuiY += 25;
            }
            if (forgeGuiY < 53) {
                forgeGuiY = 53;
            }
            j = screenWidth / 2 - (Integer)AlexsCaves.CLIENT_CONFIG.subterranodonIndicatorX.get();
            k22 = screenHeight - forgeGuiY - (Integer)AlexsCaves.CLIENT_CONFIG.subterranodonIndicatorY.get();
            f = dinosaur.getMeterAmount();
            invProgress = 1.0f - f;
            boolean uOffset = false;
            int vOffset = 0;
            int dinoHeight = 31;
            if (dinosaur instanceof TremorsaurusEntity) {
                vOffset = 63;
                k22 += 5;
                hudY = 20;
            } else if (dinosaur instanceof AtlatitanEntity) {
                vOffset = 126;
                dinoHeight = 32;
                k22 += 3;
                hudY = 40;
            } else if (dinosaur instanceof TremorzillaEntity) {
                TremorzillaEntity tremorzilla = (TremorzillaEntity)dinosaur;
                vOffset = 193;
                if (tremorzilla.isPowered() && !tremorzilla.isFiring() && tremorzilla.getSpikesDownAmount() > 0.0f) {
                    if (tremorzilla.f_19797_ / 2 % 2 == 1) {
                        vOffset = 251;
                    }
                    invProgress = 1.0f;
                }
                dinoHeight = 29;
                k22 += 5;
                hudY = 20;
            } else {
                hudY = 40;
            }
            event.getGuiGraphics().m_280168_().m_85836_();
            event.getGuiGraphics().m_280398_(DINOSAUR_HUD_OVERLAYS, j, k22, 50, (float)uOffset, (float)(vOffset + dinoHeight), 43, dinoHeight, 128, 512);
            event.getGuiGraphics().m_280398_(DINOSAUR_HUD_OVERLAYS, j, k22, 50, (float)uOffset, (float)vOffset, 43, (int)Math.floor((float)dinoHeight * invProgress), 128, 512);
            event.getGuiGraphics().m_280168_().m_85849_();
        }
        if (event.getOverlay().id().equals((Object)VanillaGuiOverlay.CROSSHAIR.id()) && DarknessArmorItem.hasMeter(player)) {
            ItemStack stack = player.m_6844_(EquipmentSlot.CHEST);
            int screenWidth = event.getWindow().m_85445_();
            screenHeight = event.getWindow().m_85446_();
            Gui k22 = Minecraft.m_91087_().f_91065_;
            if (k22 instanceof ForgeGui) {
                ForgeGui forgeGui = (ForgeGui)k22;
                v1 = Math.max(forgeGui.leftHeight, forgeGui.rightHeight);
            } else {
                v1 = forgeGuiY = 0;
            }
            if (forgeGuiY < 53) {
                forgeGuiY = 53;
            }
            j = screenWidth / 2 - (Integer)AlexsCaves.CLIENT_CONFIG.subterranodonIndicatorX.get() + 13;
            k22 = screenHeight - forgeGuiY - (Integer)AlexsCaves.CLIENT_CONFIG.subterranodonIndicatorY.get() + 9 - hudY;
            f = DarknessArmorItem.getMeterProgress(stack);
            invProgress = 1.0f - f;
            int uvOffset = DarknessArmorItem.canChargeUp(stack) && f >= 1.0f ? 0 : 18;
            event.getGuiGraphics().m_280168_().m_85836_();
            event.getGuiGraphics().m_280398_(ARMOR_HUD_OVERLAYS, j, k22, 50, (float)uvOffset, 19.0f, 18, 19, 128, 128);
            event.getGuiGraphics().m_280398_(ARMOR_HUD_OVERLAYS, j, k22, 50, 0.0f, 0.0f, 18, (int)Math.floor(19.0f * invProgress), 128, 128);
            event.getGuiGraphics().m_280168_().m_85849_();
        }
        if (event.getOverlay().id().equals((Object)VanillaGuiOverlay.PLAYER_HEALTH.id()) && Minecraft.m_91087_().f_91072_.m_105205_() && Minecraft.m_91087_().m_91288_() instanceof Player && player.m_21023_((MobEffect)ACEffectRegistry.IRRADIATED.get())) {
            int n;
            int leftHeight = 39;
            int width = event.getWindow().m_85445_();
            int height = event.getWindow().m_85446_();
            int health = Mth.m_14167_((float)player.m_21223_());
            Gui f2 = Minecraft.m_91087_().f_91065_;
            if (f2 instanceof ForgeGui) {
                ForgeGui forgeGui = (ForgeGui)f2;
                n = forgeGui.m_93079_();
            } else {
                n = 0;
            }
            int forgeGuiTick = n;
            AttributeInstance attrMaxHealth = player.m_21051_(Attributes.f_22276_);
            float healthMax = (float)attrMaxHealth.m_22135_();
            float absorb = Mth.m_14167_((float)player.m_6103_());
            int healthRows = Mth.m_14167_((float)((healthMax + absorb) / 2.0f / 10.0f));
            int rowHeight = Math.max(10 - (healthRows - 2), 3);
            ClientProxy.random.m_188584_((long)(forgeGuiTick * 312871));
            int left = width / 2 - 91;
            int top = height - leftHeight;
            int regen = -1;
            if (player.m_21023_(MobEffects.f_19605_)) {
                regen = forgeGuiTick % Mth.m_14167_((float)(healthMax + 5.0f));
            }
            int heartV = player.m_9236_().m_6106_().m_5466_() ? 9 : 0;
            int heartU = 0;
            float absorbRemaining = absorb;
            event.getGuiGraphics().m_280168_().m_85836_();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShader(GameRenderer::m_172817_);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)POTION_EFFECT_HUD_OVERLAYS);
            for (int i = Mth.m_14167_((float)((healthMax + absorb) / 2.0f)) - 1; i >= 0; --i) {
                int row = Mth.m_14167_((float)((float)(i + 1) / 10.0f)) - 1;
                int x = left + i % 10 * 8;
                int y = top - row * rowHeight;
                if (health <= 4) {
                    y += ClientProxy.random.m_188503_(2);
                }
                if (i == regen) {
                    y -= 2;
                }
                event.getGuiGraphics().m_280398_(POTION_EFFECT_HUD_OVERLAYS, x, y, 50, (float)heartU, (float)(heartV + 18), 9, 9, 32, 32);
                if (absorbRemaining > 0.0f) {
                    if (absorbRemaining == absorb && absorb % 2.0f == 1.0f) {
                        event.getGuiGraphics().m_280398_(POTION_EFFECT_HUD_OVERLAYS, x, y, 50, (float)heartU, (float)heartV, 9, 9, 32, 32);
                        absorbRemaining -= 1.0f;
                        continue;
                    }
                    event.getGuiGraphics().m_280398_(POTION_EFFECT_HUD_OVERLAYS, x, y, 50, (float)(heartU + 9), (float)heartV, 9, 9, 32, 32);
                    absorbRemaining -= 2.0f;
                    continue;
                }
                if (i * 2 + 1 < health) {
                    event.getGuiGraphics().m_280398_(POTION_EFFECT_HUD_OVERLAYS, x, y, 50, (float)heartU, (float)heartV, 9, 9, 32, 32);
                    continue;
                }
                if (i * 2 + 1 != health) continue;
                event.getGuiGraphics().m_280398_(POTION_EFFECT_HUD_OVERLAYS, x, y, 50, (float)(heartU + 9), (float)heartV, 9, 9, 32, 32);
            }
            event.getGuiGraphics().m_280168_().m_85849_();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void renderBossOverlay(CustomizeGuiOverlayEvent.BossEventProgress event) {
        if (ClientProxy.bossBarRenderTypes.containsKey(event.getBossEvent().m_18860_())) {
            int renderTypeFor = ClientProxy.bossBarRenderTypes.get(event.getBossEvent().m_18860_());
            int i = event.getGuiGraphics().m_280182_();
            int j = event.getY();
            Component component = event.getBossEvent().m_18861_();
            if (renderTypeFor == 0) {
                event.setCanceled(true);
                event.getGuiGraphics().m_280218_(BOSS_BAR_HUD_OVERLAYS, event.getX(), event.getY(), 0, 0, 182, 15);
                int progressScaled = (int)(event.getBossEvent().m_142717_() * 183.0f);
                event.getGuiGraphics().m_280218_(BOSS_BAR_HUD_OVERLAYS, event.getX(), event.getY(), 0, 15, progressScaled, 15);
                int l = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)component);
                int i1 = i / 2 - l / 2;
                int j1 = j - 9;
                PoseStack poseStack = event.getGuiGraphics().m_280168_();
                poseStack.m_85836_();
                poseStack.m_252880_((float)i1, (float)j1, 0.0f);
                Minecraft.m_91087_().f_91062_.m_168645_(component.m_7532_(), 0.0f, 0.0f, 16732416, 3544341, poseStack.m_85850_().m_252922_(), (MultiBufferSource)event.getGuiGraphics().m_280091_(), 240);
                poseStack.m_85849_();
                event.setIncrement(event.getIncrement() + 7);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void fogRender(ViewportEvent.RenderFog event) {
        if (event.isCanceled()) {
            return;
        }
        float defaultFarPlaneDistance = RenderSystem.getShaderFogEnd();
        float defaultNearPlaneDistance = RenderSystem.getShaderFogStart();
        Entity player = Minecraft.m_91087_().m_91288_();
        FluidState fluidstate = player.m_9236_().m_6425_(event.getCamera().m_90588_());
        BlockState blockState = player.m_9236_().m_8055_(event.getCamera().m_90588_());
        if (!fluidstate.m_76178_() && fluidstate.m_76152_().getFluidType().equals(ACFluidRegistry.ACID_FLUID_TYPE.get())) {
            event.setCanceled(true);
            float farness = 10.0f;
            if (Minecraft.m_91087_().f_91074_.m_21023_((MobEffect)ACEffectRegistry.DEEPSIGHT.get())) {
                farness *= 1.0f + 1.5f * DeepsightEffect.getIntensity((Player)Minecraft.m_91087_().f_91074_, (float)event.getPartialTick());
            }
            event.setFarPlaneDistance(farness);
            event.setNearPlaneDistance(0.0f);
            return;
        }
        if (blockState.m_60713_((Block)ACBlockRegistry.PRIMAL_MAGMA.get()) || blockState.m_60713_((Block)ACBlockRegistry.FISSURE_PRIMAL_MAGMA.get())) {
            event.setCanceled(true);
            float farness = 2.0f;
            if (Minecraft.m_91087_().f_91074_.m_21023_((MobEffect)ACEffectRegistry.DEEPSIGHT.get())) {
                farness *= 1.0f + 1.5f * DeepsightEffect.getIntensity((Player)Minecraft.m_91087_().f_91074_, (float)event.getPartialTick());
            }
            event.setFarPlaneDistance(farness);
            event.setNearPlaneDistance(0.0f);
            return;
        }
        if (event.getCamera().m_167685_() == FogType.WATER && ((Boolean)AlexsCaves.CLIENT_CONFIG.biomeWaterFogOverrides.get()).booleanValue()) {
            float farness = lastSampledWaterFogFarness;
            if (Minecraft.m_91087_().f_91074_.m_21023_((MobEffect)ACEffectRegistry.DEEPSIGHT.get())) {
                farness *= 1.0f + 1.5f * DeepsightEffect.getIntensity((Player)Minecraft.m_91087_().f_91074_, (float)event.getPartialTick());
            }
            if (farness != 1.0f) {
                event.setCanceled(true);
                event.setFarPlaneDistance(defaultFarPlaneDistance * farness);
            }
        } else if (event.getMode() == FogRenderer.FogMode.FOG_TERRAIN && ((Boolean)AlexsCaves.CLIENT_CONFIG.biomeSkyFogOverrides.get()).booleanValue()) {
            boolean flag;
            float nearness = lastSampledFogNearness;
            float primordialBossAmount = AlexsCaves.PROXY.getPrimordialBossActiveAmount((float)event.getPartialTick());
            boolean bl = flag = Math.abs(nearness) - 1.0f < 0.01f;
            if (primordialBossAmount > 0.0f) {
                flag = true;
                nearness *= 1.0f - primordialBossAmount * 0.75f;
            }
            if (flag) {
                event.setCanceled(true);
                event.setNearPlaneDistance(defaultNearPlaneDistance * nearness);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void fogColor(ViewportEvent.ComputeFogColor event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        BlockState blockState = player.m_9236_().m_8055_(event.getCamera().m_90588_());
        if (blockState.m_60713_((Block)ACBlockRegistry.PRIMAL_MAGMA.get()) || blockState.m_60713_((Block)ACBlockRegistry.FISSURE_PRIMAL_MAGMA.get())) {
            event.setRed(1.0f);
            event.setGreen(0.4f);
            event.setBlue(0.0f);
        } else if (player.getEyeInFluidType() != null && player.getEyeInFluidType().equals(ACFluidRegistry.ACID_FLUID_TYPE.get())) {
            event.setRed(0.0f);
            event.setGreen(1.0f);
            event.setBlue(0.0f);
        } else if (event.getCamera().m_167685_() == FogType.NONE && ((Boolean)AlexsCaves.CLIENT_CONFIG.biomeSkyFogOverrides.get()).booleanValue()) {
            float primordialBossAmount;
            float override = ClientProxy.acSkyOverrideAmount;
            float setR = event.getRed();
            float setG = event.getGreen();
            float setB = event.getBlue();
            boolean flag = false;
            if (override != 0.0f) {
                flag = true;
                Vec3 vec3 = lastSampledFogColor;
                setR = (float)(vec3.f_82479_ - (double)setR) * override + setR;
                setG = (float)(vec3.f_82480_ - (double)setG) * override + setG;
                setB = (float)(vec3.f_82481_ - (double)setB) * override + setB;
            }
            if ((primordialBossAmount = AlexsCaves.PROXY.getPrimordialBossActiveAmount((float)event.getPartialTick())) > 0.0f) {
                flag = true;
                setR = (0.8f - setR) * primordialBossAmount + setR;
                setG = (0.2f - setG) * primordialBossAmount + setG;
                setB = (0.15f - setB) * primordialBossAmount + setB;
            }
            if (flag) {
                event.setRed(setR);
                event.setGreen(setG);
                event.setBlue(setB);
            }
        } else if (event.getCamera().m_167685_() == FogType.WATER && ((Boolean)AlexsCaves.CLIENT_CONFIG.biomeWaterFogOverrides.get()).booleanValue()) {
            int i = (Integer)Minecraft.m_91087_().f_91066_.m_232121_().m_231551_();
            float override = ClientProxy.acSkyOverrideAmount;
            if (override != 0.0f) {
                Vec3 vec3 = lastSampledWaterFogColor;
                event.setRed((float)((double)event.getRed() + (vec3.f_82479_ - (double)event.getRed()) * (double)override));
                event.setGreen((float)((double)event.getGreen() + (vec3.f_82480_ - (double)event.getGreen()) * (double)override));
                event.setBlue((float)((double)event.getBlue() + (vec3.f_82481_ - (double)event.getBlue()) * (double)override));
            }
        }
    }

    private void rotateForAngle(LivingEntity entity, PoseStack matrixStackIn, Direction rotate, float f, float width, float height) {
        boolean down = entity.f_20902_ < 0.0f;
        switch (rotate) {
            case DOWN: {
                break;
            }
            case UP: {
                matrixStackIn.m_85837_(0.0, (double)(height * f), 0.0);
                matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(-180.0f * f));
                matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(-180.0f * f));
                break;
            }
            case NORTH: {
                matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(90.0f * f));
                matrixStackIn.m_85837_(0.0, (double)(-0.25f * f), 0.0);
                if (!down) break;
                matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(180.0f * f));
                break;
            }
            case SOUTH: {
                matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(180.0f * f));
                matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(90.0f * f));
                matrixStackIn.m_85837_(0.0, (double)(-0.25f * f), 0.0);
                if (!down) break;
                matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(180.0f * f));
                break;
            }
            case WEST: {
                matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(90.0f * f));
                matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(90.0f * f));
                matrixStackIn.m_85837_(0.0, (double)(-0.25f * f), 0.0);
                if (!down) break;
                matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(180.0f * f));
                break;
            }
            case EAST: {
                matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(-90.0f * f));
                matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(90.0f * f));
                matrixStackIn.m_85837_(0.0, (double)(-0.25f * f), 0.0);
                if (!down) break;
                matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(180.0f * f));
            }
        }
    }

    private static float calculateBiomeAmbientLight(Entity player) {
        int i = (Integer)Minecraft.m_91087_().f_91066_.m_232121_().m_231551_();
        if (i == 0) {
            return ACBiomeRegistry.getBiomeAmbientLight((Holder<Biome>)player.m_9236_().m_204166_(player.m_20183_()));
        }
        return BiomeSampler.sampleBiomesFloat((LevelReader)player.m_9236_(), player.m_20182_(), ACBiomeRegistry::getBiomeAmbientLight);
    }

    private static Vec3 calculateBiomeLightColor(Entity player) {
        int i = (Integer)Minecraft.m_91087_().f_91066_.m_232121_().m_231551_();
        if (i == 0) {
            return ACBiomeRegistry.getBiomeLightColorOverride((Holder<Biome>)player.m_9236_().m_204166_(player.m_20183_()));
        }
        return BiomeSampler.sampleBiomesVec3((LevelReader)player.m_9236_(), player.m_20182_(), ACBiomeRegistry::getBiomeLightColorOverride);
    }

    private static float calculateBiomeFogNearness(Entity player) {
        int i = (Integer)Minecraft.m_91087_().f_91066_.m_232121_().m_231551_();
        float nearness = i == 0 ? ACBiomeRegistry.getBiomeFogNearness((Holder<Biome>)player.m_9236_().m_204166_(player.m_20183_())) : BiomeSampler.sampleBiomesFloat((LevelReader)player.m_9236_(), player.m_20182_(), ACBiomeRegistry::getBiomeFogNearness);
        return nearness;
    }

    private static float calculateBiomeWaterFogFarness(Entity player) {
        int i = (Integer)Minecraft.m_91087_().f_91066_.m_232121_().m_231551_();
        float farness = i == 0 ? ACBiomeRegistry.getBiomeWaterFogFarness((Holder<Biome>)player.m_9236_().m_204166_(player.m_20183_())) : BiomeSampler.sampleBiomesFloat((LevelReader)player.m_9236_(), player.m_20182_(), ACBiomeRegistry::getBiomeWaterFogFarness);
        return farness;
    }

    private static Vec3 calculateBiomeFogColor(Entity player) {
        int i = (Integer)Minecraft.m_91087_().f_91066_.m_232121_().m_231551_();
        Vec3 vec3 = i == 0 ? ((ClientLevel)player.m_9236_()).m_104583_().m_5927_(Vec3.m_82501_((int)((Biome)player.m_9236_().m_7062_().m_204216_(player.m_20183_()).m_203334_()).m_47539_()), 1.0f) : ((ClientLevel)player.m_9236_()).m_104583_().m_5927_(BiomeSampler.sampleBiomesVec3((LevelReader)player.m_9236_(), player.m_20182_(), biomeHolder -> Vec3.m_82501_((int)((Biome)biomeHolder.m_203334_()).m_47539_())), 1.0f);
        return vec3;
    }

    private Vec3 calculateBiomeWaterFogColor(Entity player) {
        int i = (Integer)Minecraft.m_91087_().f_91066_.m_232121_().m_231551_();
        Vec3 vec3 = i == 0 ? ((ClientLevel)player.m_9236_()).m_104583_().m_5927_(Vec3.m_82501_((int)((Biome)player.m_9236_().m_7062_().m_204216_(player.m_20183_()).m_203334_()).m_47561_()), 1.0f) : ((ClientLevel)player.m_9236_()).m_104583_().m_5927_(BiomeSampler.sampleBiomesVec3((LevelReader)player.m_9236_(), player.m_20182_(), biomeHolder -> Vec3.m_82501_((int)((Biome)biomeHolder.m_203334_()).m_47561_())), 1.0f);
        return vec3;
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            Object beholderEye;
            Entity cameraEntity = Minecraft.m_91087_().f_91075_;
            float partialTicks = AlexsCaves.PROXY.getPartialTicks();
            if (ClientProxy.shaderLoadAttemptCooldown > 0) {
                --ClientProxy.shaderLoadAttemptCooldown;
            }
            ClientProxy.prevPrimordialBossActiveAmount = ClientProxy.primordialBossActiveAmount;
            ClientProxy.prevNukeFlashAmount = ClientProxy.nukeFlashAmount;
            if (cameraEntity != null) {
                ClientProxy.acSkyOverrideAmount = ACBiomeRegistry.calculateBiomeSkyOverride(cameraEntity);
                if (ClientProxy.acSkyOverrideAmount > 0.0f) {
                    ClientProxy.acSkyOverrideColor = BiomeSampler.sampleBiomesVec3((LevelReader)Minecraft.m_91087_().f_91073_, Minecraft.m_91087_().f_91075_.m_20182_(), biomeHolder -> Vec3.m_82501_((int)((Biome)biomeHolder.m_203334_()).m_47463_()));
                }
                ClientProxy.lastBiomeLightColorPrev = ClientProxy.lastBiomeLightColor;
                ClientProxy.lastBiomeLightColor = ClientEvents.calculateBiomeLightColor(cameraEntity);
                ClientProxy.lastBiomeAmbientLightAmountPrev = ClientProxy.lastBiomeAmbientLightAmount;
                ClientProxy.lastBiomeAmbientLightAmount = ClientEvents.calculateBiomeAmbientLight(cameraEntity);
                lastSampledFogNearness = ClientEvents.calculateBiomeFogNearness(cameraEntity);
                lastSampledWaterFogFarness = ClientEvents.calculateBiomeWaterFogFarness(cameraEntity);
                if (cameraEntity.m_9236_() instanceof ClientLevel) {
                    lastSampledFogColor = ClientEvents.calculateBiomeFogColor(cameraEntity);
                    lastSampledWaterFogColor = this.calculateBiomeWaterFogColor(cameraEntity);
                }
            }
            if (ClientProxy.renderNukeSkyDarkFor > 0) {
                --ClientProxy.renderNukeSkyDarkFor;
            }
            if (ClientProxy.muteNonNukeSoundsFor > 0) {
                --ClientProxy.muteNonNukeSoundsFor;
                if (ClientProxy.masterVolumeNukeModifier < 1.0f) {
                    ClientProxy.masterVolumeNukeModifier += 0.1f;
                }
            } else if (ClientProxy.masterVolumeNukeModifier > 0.0f) {
                ClientProxy.masterVolumeNukeModifier -= 0.1f;
            }
            if (ClientProxy.lastBossLevel != Minecraft.m_91087_().f_91073_) {
                ClientProxy.primordialBossActive = false;
                ClientProxy.primordialBossActiveAmount = 0.0f;
                ClientProxy.lastBossLevel = Minecraft.m_91087_().f_91073_;
            }
            if (ClientProxy.primordialBossActive) {
                if (ClientProxy.primordialBossActiveAmount < 1.0f) {
                    ClientProxy.primordialBossActiveAmount += 0.025f;
                }
            } else if (ClientProxy.primordialBossActiveAmount > 0.0f) {
                ClientProxy.primordialBossActiveAmount -= 0.025f;
            }
            if (ClientProxy.renderNukeFlashFor > 0) {
                if (ClientProxy.nukeFlashAmount < 1.0f) {
                    ClientProxy.nukeFlashAmount = Math.min(ClientProxy.nukeFlashAmount + 0.4f, 1.0f);
                }
                --ClientProxy.renderNukeFlashFor;
            } else if (ClientProxy.nukeFlashAmount > 0.0f) {
                ClientProxy.nukeFlashAmount = Math.max(ClientProxy.nukeFlashAmount - 0.05f, 0.0f);
            }
            ClientProxy.prevPossessionStrengthAmount = ClientProxy.possessionStrengthAmount;
            Entity entity = Minecraft.m_91087_().m_91288_();
            if (entity instanceof PossessesCamera) {
                PossessesCamera watcherEntity = (PossessesCamera)entity;
                ClientProxy.possessionStrengthAmount = watcherEntity.instant() ? watcherEntity.getPossessionStrength(partialTicks) : (ClientProxy.possessionStrengthAmount < watcherEntity.getPossessionStrength(partialTicks) ? Math.min(ClientProxy.possessionStrengthAmount + 0.2f, watcherEntity.getPossessionStrength(partialTicks)) : Math.max(ClientProxy.possessionStrengthAmount - 0.2f, watcherEntity.getPossessionStrength(partialTicks)));
                if (watcherEntity instanceof BeholderEyeEntity) {
                    beholderEye = (BeholderEyeEntity)watcherEntity;
                    ((BeholderEyeEntity)beholderEye).setOldRots();
                    ((BeholderEyeEntity)beholderEye).setEyeYRot(Minecraft.m_91087_().f_91074_.m_6080_());
                    ((BeholderEyeEntity)beholderEye).setEyeXRot(Minecraft.m_91087_().f_91074_.m_146909_());
                    if (AlexsCaves.PROXY.isKeyDown(4)) {
                        AlexsCaves.PROXY.resetRenderViewEntity((Player)Minecraft.m_91087_().f_91074_);
                    }
                }
            } else if (ClientProxy.possessionStrengthAmount > 0.0f) {
                ClientProxy.possessionStrengthAmount = Math.max(ClientProxy.possessionStrengthAmount - 0.05f, 0.0f);
            }
            beholderEye = Minecraft.m_91087_().f_91080_;
            if (beholderEye instanceof AdvancementsScreen) {
                AdvancementsScreen advancementsScreen = (AdvancementsScreen)beholderEye;
                if (advancementsScreen.f_97336_ != null && ACAdvancementTabs.isAlexsCavesWidget(advancementsScreen.f_97336_.m_97182_())) {
                    ACAdvancementTabs.tick();
                }
            }
            if (ClientProxy.primordialBossActive && Minecraft.m_91087_().f_91073_ != null && !Minecraft.m_91087_().m_91104_()) {
                ClientLevel level = Minecraft.m_91087_().f_91073_;
                BlockPos cameraBlockPos = Minecraft.m_91087_().m_91288_().m_20183_();
                BlockPos.MutableBlockPos trySpawnParticleBlockPos = new BlockPos.MutableBlockPos();
                int dist = 16;
                for (int particles = 0; particles < 100; ++particles) {
                    int i = cameraBlockPos.m_123341_() + level.f_46441_.m_188503_(dist) - level.f_46441_.m_188503_(dist);
                    int j = cameraBlockPos.m_123342_() + level.f_46441_.m_188503_(dist) - level.f_46441_.m_188503_(dist);
                    int k = cameraBlockPos.m_123343_() + level.f_46441_.m_188503_(dist) - level.f_46441_.m_188503_(dist);
                    trySpawnParticleBlockPos.m_122178_(i, j, k);
                    BlockState blockstate = level.m_8055_((BlockPos)trySpawnParticleBlockPos);
                    if (blockstate.m_60838_((BlockGetter)level, (BlockPos)trySpawnParticleBlockPos)) continue;
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123783_, (double)trySpawnParticleBlockPos.m_123341_() + level.f_46441_.m_188500_(), (double)trySpawnParticleBlockPos.m_123342_() + level.f_46441_.m_188500_(), (double)trySpawnParticleBlockPos.m_123343_() + level.f_46441_.m_188500_(), 0.0, 0.0, 0.0);
                }
            }
        }
    }

    @SubscribeEvent
    public void onRenderBlockScreenEffect(RenderBlockScreenEffectEvent event) {
        Player player = event.getPlayer();
        if (player.m_20159_() && player.m_20202_() instanceof SubmarineEntity && event.getOverlayType() == RenderBlockScreenEffectEvent.OverlayType.WATER) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onComputeFOV(ViewportEvent.ComputeFov event) {
        if (event.getCamera().m_90592_() instanceof PossessesCamera) {
            event.setFOV(90.0);
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        FogType fogtype = event.getCamera().m_167685_();
        if (player.m_20159_() && player.m_20202_() instanceof SubmarineEntity && fogtype == FogType.WATER) {
            float f = (float)Mth.m_14139_((double)((Double)Minecraft.m_91087_().f_91066_.m_231925_().m_231551_()), (double)1.0, (double)0.8571428656578064);
            event.setFOV(event.getFOV() / (double)f);
        }
    }

    @SubscribeEvent
    public void onComputeFOVModifier(ComputeFovModifierEvent event) {
        ItemStack itemstack = event.getPlayer().m_21211_();
        if (event.getPlayer().m_6117_() && itemstack.m_150930_((Item)ACItemRegistry.DREADBOW.get())) {
            int i = event.getPlayer().m_21252_();
            float f1 = (float)i / 20.0f;
            f1 = f1 > 1.0f ? 1.0f : (f1 *= f1);
            event.setNewFovModifier(event.getFovModifier() * (1.0f - f1 * 0.15f));
        }
    }

    @SubscribeEvent
    public void onSplashTextRender(EventRenderSplashText.Pre event) {
        if (ClientProxy.hasACSplashText) {
            event.setResult(Event.Result.ALLOW);
            event.setSplashText("30k downloads max");
            event.setSplashTextColor(46805);
        }
    }

    @SubscribeEvent
    public void outlineColor(EventGetOutlineColor event) {
        ItemEntity item;
        Entity entity;
        ItemStack stack;
        UUID boundUUID;
        if (Minecraft.m_91087_().f_91074_.m_21211_() != null && Minecraft.m_91087_().f_91074_.m_21211_().m_150930_((Item)ACItemRegistry.TOTEM_OF_POSSESSION.get()) && (boundUUID = TotemOfPossessionItem.getBoundEntityUUID(stack = Minecraft.m_91087_().f_91074_.m_21211_())) != null && boundUUID.equals(event.getEntityIn().m_20148_())) {
            event.setResult(Event.Result.ALLOW);
            event.setColor(0xFF0000);
        }
        if ((entity = event.getEntityIn()) instanceof ItemEntity && (item = (ItemEntity)entity).m_32055_().m_150930_((Item)ACItemRegistry.TECTONIC_SHARD.get())) {
            event.setResult(Event.Result.ALLOW);
            event.setColor(16767744);
        }
    }

    public static void renderVanillaMapDecoration(MapDecoration mapdecoration, int k) {
        if (mapdecoration.m_77803_() == ACVanillaMapUtil.UNDERGROUND_CABIN_MAP_DECORATION) {
            MultiBufferSource multiBufferSource = lastVanillaMapRenderBuffer == null ? Minecraft.m_91087_().m_91269_().m_110104_() : lastVanillaMapRenderBuffer;
            PoseStack poseStack = lastVanillaMapPoseStack == null ? new PoseStack() : lastVanillaMapPoseStack;
            poseStack.m_85836_();
            poseStack.m_252880_(0.0f + (float)mapdecoration.m_77804_() / 2.0f + 64.0f, 0.0f + (float)mapdecoration.m_77805_() / 2.0f + 64.0f, -0.02f);
            poseStack.m_252781_(Axis.f_252403_.m_252977_((float)(mapdecoration.m_77806_() * 360) / 16.0f));
            poseStack.m_85841_(4.0f, 4.0f, 3.0f);
            poseStack.m_252880_(-0.125f, 0.125f, 0.0f);
            byte b0 = ACVanillaMapUtil.getMapIconRenderOrdinal(mapdecoration.m_77803_());
            float f1 = (float)(b0 % 16 + 0) / 16.0f;
            float f2 = (float)(b0 / 16 + 0) / 16.0f;
            float f3 = (float)(b0 % 16 + 1) / 16.0f;
            float f4 = (float)(b0 / 16 + 1) / 16.0f;
            Matrix4f matrix4f1 = poseStack.m_85850_().m_252922_();
            float f5 = -0.001f;
            VertexConsumer vertexconsumer1 = multiBufferSource.m_6299_(UNDERGROUND_CABIN_MAP_ICONS);
            vertexconsumer1.m_252986_(matrix4f1, -1.0f, 1.0f, (float)k * -0.001f).m_6122_(255, 255, 255, 255).m_7421_(f1, f2).m_85969_(lastVanillaMapRenderPackedLight).m_5752_();
            vertexconsumer1.m_252986_(matrix4f1, 1.0f, 1.0f, (float)k * -0.001f).m_6122_(255, 255, 255, 255).m_7421_(f3, f2).m_85969_(lastVanillaMapRenderPackedLight).m_5752_();
            vertexconsumer1.m_252986_(matrix4f1, 1.0f, -1.0f, (float)k * -0.001f).m_6122_(255, 255, 255, 255).m_7421_(f3, f4).m_85969_(lastVanillaMapRenderPackedLight).m_5752_();
            vertexconsumer1.m_252986_(matrix4f1, -1.0f, -1.0f, (float)k * -0.001f).m_6122_(255, 255, 255, 255).m_7421_(f1, f4).m_85969_(lastVanillaMapRenderPackedLight).m_5752_();
            poseStack.m_85849_();
            if (mapdecoration.m_77810_() != null) {
                Font font = Minecraft.m_91087_().f_91062_;
                Component component = mapdecoration.m_77810_();
                float f6 = font.m_92852_((FormattedText)component);
                float f7 = Mth.m_14036_((float)(25.0f / f6), (float)0.0f, (float)0.6666667f);
                poseStack.m_85836_();
                poseStack.m_252880_(0.0f + (float)mapdecoration.m_77804_() / 2.0f + 64.0f - f6 * f7 / 2.0f, 0.0f + (float)mapdecoration.m_77805_() / 2.0f + 64.0f + 4.0f, -0.025f);
                poseStack.m_85841_(f7, f7, 1.0f);
                poseStack.m_252880_(0.0f, 0.0f, -0.1f);
                font.m_272077_(component, 0.0f, 0.0f, -1, false, poseStack.m_85850_().m_252922_(), multiBufferSource, Font.DisplayMode.NORMAL, Integer.MIN_VALUE, lastVanillaMapRenderPackedLight);
                poseStack.m_85849_();
            }
        }
    }

    static {
        UNDERGROUND_CABIN_MAP_ICONS = RenderType.m_110497_((ResourceLocation)new ResourceLocation("alexscaves", "textures/misc/underground_cabin_map_icons.png"));
    }
}

