/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.gui.book.widget;

import com.github.alexmodguy.alexscaves.client.gui.book.widget.BookWidget;
import com.github.alexmodguy.alexscaves.client.gui.book.widget.EntityWidget;
import com.github.alexmodguy.alexscaves.client.render.ACRenderTypes;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class EntityBoxWidget
extends EntityWidget {
    @Expose
    @SerializedName(value="box_width")
    private float boxWidth;
    @Expose
    @SerializedName(value="box_height")
    private float boxHeight;
    @Expose
    @SerializedName(value="box_scale")
    private float boxScale;
    @Expose
    @SerializedName(value="entity_x_offset")
    private float entityXOffset;
    @Expose
    @SerializedName(value="entity_y_offset")
    private float entityYOffset;
    @Expose
    @SerializedName(value="box_image")
    private String borderImage;
    @Expose(serialize=false, deserialize=false)
    private ResourceLocation borderTexture;
    private static final int BORDER_TEXTURE_SIZE = 64;
    private static final int PIX_WIDTH_CORNER = 10;
    private static final int PIX_WIDTH_LINE = 4;

    public EntityBoxWidget(int displayPage, String entityId, boolean sepia, float boxWidth, float boxHeight, float boxScale, float entityXOffset, float entityYOffset, String borderImage, String entityNBT, int x, int y, float scale) {
        super(displayPage, BookWidget.Type.ENTITY_BOX, entityId, sepia, entityNBT, x, y, scale);
        this.boxHeight = boxHeight;
        this.boxWidth = boxWidth;
        this.borderImage = borderImage;
        this.boxScale = boxScale;
        this.entityXOffset = entityXOffset;
        this.entityYOffset = entityYOffset;
    }

    @Override
    public void render(PoseStack poseStack, MultiBufferSource.BufferSource bufferSource, float partialTicks, boolean onFlippingPage) {
        if (this.borderTexture == null) {
            this.borderTexture = new ResourceLocation(this.borderImage);
        }
        poseStack.m_85836_();
        poseStack.m_252880_(this.entityXOffset * this.getScale(), this.entityYOffset * this.getScale(), 0.0f);
        super.render(poseStack, bufferSource, partialTicks, onFlippingPage);
        poseStack.m_85849_();
        VertexConsumer vertexconsumer = bufferSource.m_6299_(ACRenderTypes.getBookWidget(this.borderTexture, this.isSepia()));
        float endUV = 14.0f;
        float endSub = 5.0f;
        float endUV1 = endUV + 10.0f;
        Lighting.m_84930_();
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, 0.0f, 2.0f);
        poseStack.m_252880_((float)this.getX() - this.boxWidth * 0.5f * this.boxScale, (float)this.getY() - this.boxHeight * 0.5f * this.boxScale, -15.0f);
        poseStack.m_85841_(this.boxScale, this.boxScale, 1.0f);
        poseStack.m_85836_();
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, 0.0f, 2.0f);
        this.renderCorner(poseStack, vertexconsumer, 0.0f, 10.0f, 0.0f, 10.0f);
        poseStack.m_85849_();
        this.renderQuad(poseStack, vertexconsumer, this.boxWidth - endSub, 5.0f, -5.0f, 5.0f, 10.0f, 14.0f, 0.0f, 10.0f);
        poseStack.m_85836_();
        poseStack.m_252880_(this.boxWidth, 0.0f, 2.0f);
        this.renderCorner(poseStack, vertexconsumer, endUV, endUV1, 0.0f, 10.0f);
        poseStack.m_85849_();
        this.renderQuad(poseStack, vertexconsumer, 5.0f, -5.0f, 4.9f, this.boxHeight - endSub, 0.0f, 10.0f, 10.0f, 14.0f);
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, this.boxHeight, 2.0f);
        this.renderCorner(poseStack, vertexconsumer, 0.0f, 10.0f, endUV, endUV1);
        poseStack.m_85849_();
        this.renderQuad(poseStack, vertexconsumer, this.boxWidth - endSub, 5.0f, this.boxHeight - 5.0f, this.boxHeight + 5.0f, 10.0f, 14.0f, 14.0f, 24.0f);
        poseStack.m_85836_();
        poseStack.m_252880_(this.boxWidth, this.boxHeight, 2.0f);
        this.renderCorner(poseStack, vertexconsumer, endUV, endUV1, endUV, endUV1);
        poseStack.m_85849_();
        this.renderQuad(poseStack, vertexconsumer, this.boxWidth + 5.0f, this.boxWidth - 5.0f, 4.9f, this.boxHeight - endSub, 14.0f, 24.0f, 10.0f, 14.0f);
        poseStack.m_85849_();
        poseStack.m_85849_();
    }

    private void renderCorner(PoseStack poseStack, VertexConsumer vertexconsumer, float u0, float u1, float v0, float v1) {
        float texWidth = (u1 - u0) / 2.0f;
        float texHeight = (v1 - v0) / 2.0f;
        this.renderQuad(poseStack, vertexconsumer, texWidth, -texWidth, -texHeight, texHeight, u0, u1, v0, v1);
    }

    private void renderQuad(PoseStack poseStack, VertexConsumer vertexconsumer, float x0, float x1, float y0, float y1, float u0, float u1, float v0, float v1) {
        PoseStack.Pose posestack$pose = poseStack.m_85850_();
        Matrix4f matrix4f = posestack$pose.m_252922_();
        Matrix3f matrix3f = posestack$pose.m_252943_();
        float scaledU0 = u0 / 64.0f;
        float scaledU1 = u1 / 64.0f;
        float scaledV0 = v0 / 64.0f;
        float scaledV1 = v1 / 64.0f;
        vertexconsumer.m_252986_(matrix4f, x0, y0, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(scaledU1, scaledV0).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
        vertexconsumer.m_252986_(matrix4f, x1, y0, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(scaledU0, scaledV0).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_7421_(scaledU0, scaledV1).m_5752_();
        vertexconsumer.m_252986_(matrix4f, x1, y1, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(scaledU0, scaledV1).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_7421_(scaledU0, scaledV0).m_5752_();
        vertexconsumer.m_252986_(matrix4f, x0, y1, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(scaledU1, scaledV1).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_7421_(scaledU1, scaledV0).m_5752_();
    }
}

