/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.model;

import com.github.alexmodguy.alexscaves.server.entity.item.DinosaurSpiritEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.SubterranodonEntity;
import com.github.alexmodguy.alexscaves.server.misc.ACMath;
import com.github.alexthe666.citadel.client.model.AdvancedEntityModel;
import com.github.alexthe666.citadel.client.model.AdvancedModelBox;
import com.github.alexthe666.citadel.client.model.basic.BasicModelPart;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4fc;
import org.joml.Vector4f;

public class SubterranodonModel
extends AdvancedEntityModel<SubterranodonEntity> {
    private final AdvancedModelBox body;
    private final AdvancedModelBox neck;
    private final AdvancedModelBox head;
    private final AdvancedModelBox jaw;
    private final AdvancedModelBox lwing;
    private final AdvancedModelBox lhand;
    private final AdvancedModelBox lwingTip;
    private final AdvancedModelBox rwing;
    private final AdvancedModelBox rhand;
    private final AdvancedModelBox rwingTip;
    private final AdvancedModelBox lleg;
    private final AdvancedModelBox ltalon;
    private final AdvancedModelBox rleg;
    private final AdvancedModelBox rtalon;
    private final AdvancedModelBox tail;
    private final AdvancedModelBox tailTip;

    public SubterranodonModel() {
        this.texWidth = 256;
        this.texHeight = 256;
        this.body = new AdvancedModelBox((AdvancedEntityModel)this);
        this.body.setRotationPoint(0.0f, 19.0f, -1.0f);
        this.body.setTextureOffset(0, 46).addBox(-5.0f, -5.0f, -7.0f, 10.0f, 10.0f, 14.0f, 0.0f, false);
        this.neck = new AdvancedModelBox((AdvancedEntityModel)this);
        this.neck.setRotationPoint(0.0f, -4.0f, -6.5f);
        this.body.addChild((BasicModelPart)this.neck);
        this.neck.setTextureOffset(74, 27).addBox(-2.0f, -1.0f, -8.5f, 4.0f, 5.0f, 8.0f, 0.0f, false);
        this.head = new AdvancedModelBox((AdvancedEntityModel)this);
        this.head.setRotationPoint(0.0f, 1.0f, -5.5f);
        this.neck.addChild((BasicModelPart)this.head);
        this.head.setTextureOffset(48, 46).addBox(0.0f, -15.0f, -13.0f, 0.0f, 12.0f, 19.0f, 0.0f, false);
        this.head.setTextureOffset(0, 79).addBox(-3.0f, -6.0f, -8.0f, 6.0f, 7.0f, 9.0f, 0.0f, false);
        this.head.setTextureOffset(74, 10).addBox(-1.0f, -3.0f, -22.0f, 2.0f, 3.0f, 14.0f, 0.0f, false);
        this.head.setTextureOffset(51, 78).addBox(-2.0f, -7.0f, -32.0f, 4.0f, 9.0f, 10.0f, 0.0f, false);
        this.jaw = new AdvancedModelBox((AdvancedEntityModel)this);
        this.jaw.setRotationPoint(0.0f, -1.0f, -8.0f);
        this.head.addChild((BasicModelPart)this.jaw);
        this.jaw.setTextureOffset(0, 0).addBox(-1.5f, -3.0f, -23.5f, 3.0f, 8.0f, 9.0f, 0.0f, false);
        this.jaw.setTextureOffset(71, 62).addBox(-0.5f, -1.0f, -15.0f, 1.0f, 3.0f, 15.0f, 0.0f, false);
        this.lwing = new AdvancedModelBox((AdvancedEntityModel)this);
        this.lwing.setRotationPoint(4.5f, -3.0f, -5.0f);
        this.body.addChild((BasicModelPart)this.lwing);
        this.lwing.setTextureOffset(12, 36).addBox(0.5f, 0.5f, 2.0f, 26.0f, 0.0f, 10.0f, 0.0f, false);
        this.lwing.setTextureOffset(72, 42).addBox(0.5f, -1.0f, -2.0f, 26.0f, 3.0f, 4.0f, 0.0f, false);
        this.lhand = new AdvancedModelBox((AdvancedEntityModel)this);
        this.lhand.setRotationPoint(25.0f, 0.5f, -2.0f);
        this.lwing.addChild((BasicModelPart)this.lhand);
        this.lhand.setTextureOffset(30, 87).addBox(-1.5f, 0.0f, -4.0f, 3.0f, 3.0f, 4.0f, 0.0f, false);
        this.lwingTip = new AdvancedModelBox((AdvancedEntityModel)this);
        this.lwingTip.setRotationPoint(26.5f, 0.5f, -1.0f);
        this.lwing.addChild((BasicModelPart)this.lwingTip);
        this.lwingTip.setTextureOffset(0, 0).addBox(0.0f, 0.0f, 1.0f, 26.0f, 0.0f, 24.0f, 0.0f, false);
        this.lwingTip.setTextureOffset(72, 49).addBox(0.0f, -1.0f, -1.0f, 26.0f, 2.0f, 2.0f, 0.0f, false);
        this.rwing = new AdvancedModelBox((AdvancedEntityModel)this);
        this.rwing.setRotationPoint(-4.5f, -3.0f, -5.0f);
        this.body.addChild((BasicModelPart)this.rwing);
        this.rwing.setTextureOffset(12, 36).addBox(-26.5f, 0.5f, 2.0f, 26.0f, 0.0f, 10.0f, 0.0f, true);
        this.rwing.setTextureOffset(72, 42).addBox(-26.5f, -1.0f, -2.0f, 26.0f, 3.0f, 4.0f, 0.0f, true);
        this.rhand = new AdvancedModelBox((AdvancedEntityModel)this);
        this.rhand.setRotationPoint(-25.0f, 2.0f, -2.0f);
        this.rwing.addChild((BasicModelPart)this.rhand);
        this.rhand.setTextureOffset(30, 87).addBox(-1.5f, -1.5f, -4.0f, 3.0f, 3.0f, 4.0f, 0.0f, false);
        this.rwingTip = new AdvancedModelBox((AdvancedEntityModel)this);
        this.rwingTip.setRotationPoint(-26.5f, 0.5f, -1.0f);
        this.rwing.addChild((BasicModelPart)this.rwingTip);
        this.rwingTip.setTextureOffset(72, 49).addBox(-26.0f, -1.0f, -1.0f, 26.0f, 2.0f, 2.0f, 0.0f, true);
        this.rwingTip.setTextureOffset(0, 0).addBox(-26.0f, 0.0f, 1.0f, 26.0f, 0.0f, 24.0f, 0.0f, true);
        this.lleg = new AdvancedModelBox((AdvancedEntityModel)this);
        this.lleg.setRotationPoint(2.0f, -2.5f, 6.5f);
        this.body.addChild((BasicModelPart)this.lleg);
        this.lleg.setTextureOffset(25, 70).addBox(-2.0f, 0.0f, -0.5f, 5.0f, 0.0f, 13.0f, 0.0f, false);
        this.ltalon = new AdvancedModelBox((AdvancedEntityModel)this);
        this.ltalon.setRotationPoint(0.5f, 0.0f, 12.5f);
        this.lleg.addChild((BasicModelPart)this.ltalon);
        this.ltalon.setTextureOffset(98, 30).addBox(-2.5f, 0.0f, 0.0f, 5.0f, 4.0f, 4.0f, 0.0f, false);
        this.rleg = new AdvancedModelBox((AdvancedEntityModel)this);
        this.rleg.setRotationPoint(-2.0f, -2.5f, 6.5f);
        this.body.addChild((BasicModelPart)this.rleg);
        this.rleg.setTextureOffset(25, 70).addBox(-3.0f, 0.0f, -0.5f, 5.0f, 0.0f, 13.0f, 0.0f, true);
        this.rtalon = new AdvancedModelBox((AdvancedEntityModel)this);
        this.rtalon.setRotationPoint(-0.5f, 0.0f, 12.5f);
        this.rleg.addChild((BasicModelPart)this.rtalon);
        this.rtalon.setTextureOffset(98, 30).addBox(-2.5f, 0.0f, 0.0f, 5.0f, 4.0f, 4.0f, 0.0f, true);
        this.tail = new AdvancedModelBox((AdvancedEntityModel)this);
        this.tail.setRotationPoint(0.0f, -3.5f, 6.5f);
        this.body.addChild((BasicModelPart)this.tail);
        this.tail.setTextureOffset(41, 46).addBox(-3.0f, 0.0f, -0.5f, 6.0f, 0.0f, 19.0f, 0.0f, false);
        this.tailTip = new AdvancedModelBox((AdvancedEntityModel)this);
        this.tailTip.setRotationPoint(0.0f, 0.0f, 18.5f);
        this.tail.addChild((BasicModelPart)this.tailTip);
        this.tailTip.setTextureOffset(0, 51).addBox(0.0f, -5.0f, 0.0f, 0.0f, 9.0f, 19.0f, 0.0f, false);
        this.tailTip.setTextureOffset(29, 46).addBox(-3.0f, 0.0f, 0.0f, 6.0f, 0.0f, 19.0f, 0.0f, false);
        this.updateDefaultPose();
    }

    public Iterable<BasicModelPart> parts() {
        return ImmutableList.of((Object)this.body);
    }

    public void setupAnim(SubterranodonEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.resetToDefaultPose();
        float walkSpeed = 1.0f;
        float walkDegree = 1.0f;
        float partialTick = ageInTicks - (float)entity.f_19797_;
        float flyProgress = entity.getFlyProgress(partialTick);
        float buryEggsAmount = entity.getBuryEggsProgress(partialTick);
        float groundProgress = 1.0f - flyProgress;
        float flapAmount = flyProgress * entity.getFlapAmount(partialTick);
        float groundStill = groundProgress * (1.0f - limbSwingAmount);
        float groundMove = groundProgress * limbSwingAmount;
        float glide = flyProgress * (1.0f - flapAmount);
        float hoverProgress = flyProgress * entity.getHoverProgress(partialTick);
        float openMouthProgress = entity.getBiteProgress(partialTick);
        float sitProgress = entity.getSitProgress(partialTick) * groundProgress;
        float rollAmount = entity.getFlightRoll(partialTick) / 57.295776f * flyProgress;
        float pitchAmount = entity.getFlightPitch(partialTick) / 57.295776f * (flyProgress - hoverProgress);
        float yaw = entity.f_20884_ + (entity.f_20883_ - entity.f_20884_) * partialTick;
        float tailYaw = Mth.m_14177_((float)(entity.getTailYaw(partialTick) - yaw)) / 57.295776f;
        float danceAmount = entity.getDanceProgress(partialTick);
        float danceSpeed = 0.5f;
        this.progressPositionPrev(this.body, groundProgress, 0.0f, -8.0f, 2.0f, 1.0f);
        this.progressPositionPrev(this.rwing, groundProgress, 3.0f, -1.0f, 1.0f, 1.0f);
        this.progressPositionPrev(this.lwing, groundProgress, -3.0f, -1.0f, 1.0f, 1.0f);
        this.progressRotationPrev(this.lleg, groundProgress, (float)Math.toRadians(-70.0), 0.0f, 0.0f, 1.0f);
        this.progressRotationPrev(this.rleg, groundProgress, (float)Math.toRadians(-70.0), 0.0f, 0.0f, 1.0f);
        this.progressRotationPrev(this.ltalon, groundProgress, (float)Math.toRadians(-20.0), 0.0f, 0.0f, 1.0f);
        this.progressRotationPrev(this.rtalon, groundProgress, (float)Math.toRadians(-20.0), 0.0f, 0.0f, 1.0f);
        this.progressRotationPrev(this.lwing, groundProgress, 0.0f, (float)Math.toRadians(10.0), (float)Math.toRadians(35.0), 1.0f);
        this.progressRotationPrev(this.rwing, groundProgress, 0.0f, (float)Math.toRadians(-10.0), (float)Math.toRadians(-35.0), 1.0f);
        this.progressRotationPrev(this.lwingTip, groundProgress, 0.0f, (float)Math.toRadians(-10.0), (float)Math.toRadians(-130.0), 1.0f);
        this.progressRotationPrev(this.rwingTip, groundProgress, 0.0f, (float)Math.toRadians(10.0), (float)Math.toRadians(130.0), 1.0f);
        this.progressRotationPrev(this.lhand, groundProgress, 0.0f, (float)Math.toRadians(-10.0), (float)Math.toRadians(-35.0), 1.0f);
        this.progressRotationPrev(this.rhand, groundProgress, 0.0f, (float)Math.toRadians(10.0), (float)Math.toRadians(35.0), 1.0f);
        this.progressRotationPrev(this.tail, groundProgress, (float)Math.toRadians(-20.0), 0.0f, 0.0f, 1.0f);
        this.progressRotationPrev(this.tailTip, groundProgress, (float)Math.toRadians(10.0), 0.0f, 0.0f, 1.0f);
        this.progressRotationPrev(this.tail, groundStill, (float)Math.toRadians(-20.0), 0.0f, 0.0f, 1.0f);
        this.progressRotationPrev(this.tailTip, groundStill, (float)Math.toRadians(20.0), 0.0f, 0.0f, 1.0f);
        this.progressRotationPrev(this.jaw, openMouthProgress, (float)Math.toRadians(30.0), 0.0f, 0.0f, 1.0f);
        this.progressPositionPrev(this.body, sitProgress, 0.0f, -1.0f, 0.0f, 1.0f);
        this.progressPositionPrev(this.lleg, sitProgress, 0.0f, -2.0f, -3.0f, 1.0f);
        this.progressPositionPrev(this.rleg, sitProgress, 0.0f, -2.0f, -3.0f, 1.0f);
        this.progressPositionPrev(this.lwing, sitProgress, 1.0f, 1.0f, -1.0f, 1.0f);
        this.progressPositionPrev(this.rwing, sitProgress, -1.0f, 1.0f, -1.0f, 1.0f);
        this.progressRotationPrev(this.body, sitProgress, (float)Math.toRadians(-50.0), 0.0f, 0.0f, 1.0f);
        this.progressRotationPrev(this.neck, sitProgress, (float)Math.toRadians(30.0), 0.0f, 0.0f, 1.0f);
        this.progressRotationPrev(this.head, sitProgress, (float)Math.toRadians(20.0), 0.0f, 0.0f, 1.0f);
        this.progressRotationPrev(this.tail, sitProgress, (float)Math.toRadians(55.0), 0.0f, 0.0f, 1.0f);
        this.progressRotationPrev(this.tailTip, sitProgress, (float)Math.toRadians(10.0), 0.0f, 0.0f, 1.0f);
        this.progressRotationPrev(this.lleg, sitProgress, (float)Math.toRadians(15.0), (float)Math.toRadians(15.0), 0.0f, 1.0f);
        this.progressRotationPrev(this.rleg, sitProgress, (float)Math.toRadians(15.0), (float)Math.toRadians(-15.0), 0.0f, 1.0f);
        this.progressRotationPrev(this.lwing, sitProgress, (float)Math.toRadians(40.0), (float)Math.toRadians(-20.0), (float)Math.toRadians(20.0), 1.0f);
        this.progressRotationPrev(this.rwing, sitProgress, (float)Math.toRadians(40.0), (float)Math.toRadians(20.0), (float)Math.toRadians(-20.0), 1.0f);
        this.progressRotationPrev(this.lhand, sitProgress, (float)Math.toRadians(20.0), 0.0f, 0.0f, 1.0f);
        this.progressRotationPrev(this.rhand, sitProgress, (float)Math.toRadians(20.0), 0.0f, 0.0f, 1.0f);
        this.animateFlight(ageInTicks, flyProgress, hoverProgress, glide, flapAmount, entity.m_20160_(), true);
        if (buryEggsAmount > 0.0f) {
            limbSwing = ageInTicks;
            groundMove = buryEggsAmount * 0.5f;
            this.body.swing(0.25f, 0.4f, false, 0.0f, 0.0f, ageInTicks, buryEggsAmount);
            this.neck.swing(0.25f, 0.4f, true, -1.0f, 0.0f, ageInTicks, buryEggsAmount);
        }
        this.swing(this.tail, 0.1f, 0.2f, false, 2.0f, 0.0f, ageInTicks, 1.0f);
        this.swing(this.tailTip, 0.1f, 0.2f, false, 1.0f, 0.0f, ageInTicks, 1.0f);
        this.swing(this.lwing, walkSpeed, walkDegree, false, -1.0f, 0.2f, limbSwing, groundMove);
        this.swing(this.rwing, walkSpeed, walkDegree, false, -1.0f, -0.2f, limbSwing, groundMove);
        this.flap(this.lwingTip, walkSpeed, walkDegree * 1.0f, true, 1.0f, -0.2f, limbSwing, groundMove);
        this.flap(this.rwingTip, walkSpeed, walkDegree * 1.0f, true, 1.0f, 0.2f, limbSwing, groundMove);
        this.walk(this.lhand, walkSpeed, walkDegree, true, 0.0f, -0.2f, limbSwing, groundMove);
        this.walk(this.rhand, walkSpeed, walkDegree, false, 0.0f, -0.2f, limbSwing, groundMove);
        this.swing(this.neck, walkSpeed, walkDegree * 0.5f, false, 1.0f, 0.0f, limbSwing, groundMove);
        this.swing(this.head, walkSpeed, walkDegree * 0.5f, true, 0.5f, 0.0f, limbSwing, groundMove);
        this.walk(this.lleg, walkSpeed, walkDegree * 0.6f, false, -2.0f, 0.3f, limbSwing, groundMove);
        this.walk(this.rleg, walkSpeed, walkDegree * 0.6f, true, -2.0f, -0.3f, limbSwing, groundMove);
        this.walk(this.ltalon, walkSpeed, walkDegree * 0.6f, false, -1.0f, -0.3f, limbSwing, groundMove);
        this.walk(this.rtalon, walkSpeed, walkDegree * 0.6f, true, -1.0f, 0.3f, limbSwing, groundMove);
        this.swing(this.tail, walkSpeed, walkDegree * 0.5f, true, 0.5f, 0.0f, limbSwing, groundMove);
        this.bob(this.body, walkSpeed * 2.0f, walkDegree * 3.0f, false, limbSwing, groundMove);
        this.bob(this.neck, 0.1f, 0.5f, false, ageInTicks, 1.0f);
        this.faceTarget(netHeadYaw, headPitch, 1.0f, new AdvancedModelBox[]{this.head, this.neck});
        this.swing(this.neck, danceSpeed, 0.5f, true, 0.0f, 0.0f, ageInTicks, danceAmount);
        this.swing(this.head, danceSpeed, 0.25f, true, 1.0f, 0.0f, ageInTicks, danceAmount);
        this.flap(this.head, danceSpeed, 0.25f, true, 1.0f, 0.0f, ageInTicks, danceAmount);
        this.walk(this.jaw, danceSpeed, 0.25f, false, 2.0f, 0.2f, ageInTicks, danceAmount);
        this.swing(this.body, danceSpeed, 0.1f, false, 1.0f, 0.0f, ageInTicks, danceAmount);
        this.body.rotateAngleX += pitchAmount;
        this.body.rotateAngleZ += rollAmount;
        this.tail.rotateAngleY += tailYaw * 0.8f;
        this.tailTip.rotateAngleY += tailYaw * 0.2f;
        this.lleg.rotateAngleY += tailYaw * flyProgress * 0.4f;
        this.rleg.rotateAngleY += tailYaw * flyProgress * 0.4f;
    }

    private void animateFlight(float ageInTicks, float flyProgress, float hoverProgress, float glide, float flapAmount, boolean carrying, boolean bob) {
        this.progressPositionPrev(this.head, glide, 0.0f, 3.0f, 0.0f, 1.0f);
        this.progressPositionPrev(this.neck, glide, 0.0f, 1.0f, 0.0f, 1.0f);
        this.progressRotationPrev(this.body, hoverProgress, (float)Math.toRadians(-50.0), 0.0f, 0.0f, 1.0f);
        this.progressRotationPrev(this.neck, hoverProgress, (float)Math.toRadians(30.0), 0.0f, 0.0f, 1.0f);
        this.progressRotationPrev(this.head, hoverProgress, (float)Math.toRadians(30.0), 0.0f, 0.0f, 1.0f);
        this.progressRotationPrev(this.lleg, hoverProgress, (float)Math.toRadians(-40.0), 0.0f, 0.0f, 1.0f);
        this.progressRotationPrev(this.rleg, hoverProgress, (float)Math.toRadians(-40.0), 0.0f, 0.0f, 1.0f);
        this.progressRotationPrev(this.ltalon, hoverProgress, (float)Math.toRadians(-20.0), 0.0f, 0.0f, 1.0f);
        this.progressRotationPrev(this.rtalon, hoverProgress, (float)Math.toRadians(-20.0), 0.0f, 0.0f, 1.0f);
        this.progressPositionPrev(this.neck, glide, 0.0f, 1.0f, 0.0f, 1.0f);
        this.walk(this.lleg, 0.3f, 0.2f, false, 1.0f, -0.1f, ageInTicks, flyProgress);
        this.walk(this.rleg, 0.3f, 0.2f, false, 1.0f, -0.1f, ageInTicks, flyProgress);
        this.flap(this.rwing, 0.5f, 1.0f, false, 1.0f, -0.2f, ageInTicks, flapAmount);
        this.flap(this.lwing, 0.5f, 1.0f, true, 1.0f, -0.2f, ageInTicks, flapAmount);
        this.flap(this.rwingTip, 0.5f, 0.5f, false, 0.0f, -0.2f, ageInTicks, flapAmount);
        this.flap(this.lwingTip, 0.5f, 0.5f, true, 0.0f, -0.2f, ageInTicks, flapAmount);
        float bodyFlightBob = bob ? ACMath.walkValue(ageInTicks, flapAmount, 0.5f, 0.0f, 4.0f, false) : 0.0f;
        this.body.rotationPointY -= bodyFlightBob;
        this.bob(this.neck, 0.5f, -1.0f, false, ageInTicks, flapAmount);
        this.walk(this.neck, 0.5f, 0.1f, false, 1.0f, 0.0f, ageInTicks, flyProgress);
        if (carrying) {
            this.walk(this.lleg, 0.3f, 0.2f, true, 1.0f, -0.1f, ageInTicks, flyProgress);
            this.walk(this.rleg, 0.3f, 0.2f, true, 1.0f, -0.1f, ageInTicks, flyProgress);
            this.rleg.rotationPointY += bodyFlightBob * 0.25f;
            this.rleg.rotationPointZ += bodyFlightBob * 0.25f;
            this.lleg.rotationPointY += bodyFlightBob * 0.25f;
            this.lleg.rotationPointZ += bodyFlightBob * 0.25f;
        }
        this.walk(this.rwing, 2.0f, 0.05f, false, 2.0f, 0.1f, ageInTicks, glide);
        this.walk(this.lwing, 2.0f, 0.05f, false, 2.0f, 0.1f, ageInTicks, glide);
    }

    public Vec3 getLegPosition(boolean right, Vec3 offsetIn) {
        PoseStack translationStack = new PoseStack();
        translationStack.m_85836_();
        this.body.translateAndRotate(translationStack);
        if (right) {
            this.rleg.translateAndRotate(translationStack);
        } else {
            this.lleg.translateAndRotate(translationStack);
        }
        Vector4f armOffsetVec = new Vector4f((float)offsetIn.f_82479_, (float)offsetIn.f_82480_, (float)offsetIn.f_82481_, 1.0f);
        armOffsetVec.mul((Matrix4fc)translationStack.m_85850_().m_252922_());
        Vec3 vec3 = new Vec3((double)armOffsetVec.x(), (double)armOffsetVec.y(), (double)armOffsetVec.z());
        translationStack.m_85849_();
        return vec3;
    }

    public void m_7695_(PoseStack matrixStackIn, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        if (this.f_102610_) {
            float f = 1.5f;
            this.head.setScale(f, f, f);
            this.head.setShouldScaleChildren(true);
            matrixStackIn.m_85836_();
            matrixStackIn.m_85841_(0.35f, 0.35f, 0.35f);
            matrixStackIn.m_85837_(0.0, 2.75, 0.125);
            this.parts().forEach(p_228292_8_ -> p_228292_8_.render(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha));
            matrixStackIn.m_85849_();
            this.head.setScale(1.0f, 1.0f, 1.0f);
        } else {
            matrixStackIn.m_85836_();
            this.parts().forEach(p_228290_8_ -> p_228290_8_.render(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha));
            matrixStackIn.m_85849_();
        }
    }

    public Iterable<AdvancedModelBox> getAllParts() {
        return ImmutableList.of((Object)this.body, (Object)this.tail, (Object)this.tailTip, (Object)this.lleg, (Object)this.rleg, (Object)this.ltalon, (Object)this.rtalon, (Object)this.neck, (Object)this.head, (Object)this.jaw, (Object)this.lwing, (Object)this.lwingTip, (Object[])new AdvancedModelBox[]{this.lhand, this.rwing, this.rwingTip, this.rhand});
    }

    public void animateSpirit(DinosaurSpiritEntity entityIn, float partialTicks) {
        float flyProgress;
        this.resetToDefaultPose();
        float ageInTicks = (float)entityIn.f_19797_ + partialTicks;
        float flapAmount = flyProgress = 1.0f;
        float hoverProgress = 1.0f;
        this.body.rotationPointY -= 16.0f;
        this.animateFlight(ageInTicks, flyProgress, hoverProgress, 0.0f, flapAmount, true, false);
    }
}

