/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.model;

import com.github.alexmodguy.alexscaves.client.model.misc.HideableModelBoxWithChildren;
import com.github.alexmodguy.alexscaves.server.entity.living.TremorzillaEntity;
import com.github.alexmodguy.alexscaves.server.entity.util.TremorzillaLegSolver;
import com.github.alexmodguy.alexscaves.server.misc.ACMath;
import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.github.alexthe666.citadel.client.model.AdvancedEntityModel;
import com.github.alexthe666.citadel.client.model.AdvancedModelBox;
import com.github.alexthe666.citadel.client.model.ModelAnimator;
import com.github.alexthe666.citadel.client.model.basic.BasicModelPart;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4fc;
import org.joml.Vector4f;

public class TremorzillaModel
extends AdvancedEntityModel<TremorzillaEntity> {
    private final AdvancedModelBox root;
    private final HideableModelBoxWithChildren torso;
    private final AdvancedModelBox torsoSpikes;
    private final AdvancedModelBox torsoSpike1;
    private final AdvancedModelBox torsoSpike2;
    private final AdvancedModelBox torsoSpike3;
    private final AdvancedModelBox rightLeg;
    private final AdvancedModelBox leftLeg;
    private final HideableModelBoxWithChildren tail1;
    private final HideableModelBoxWithChildren tail1Spikes;
    private final HideableModelBoxWithChildren tail1Spike1;
    private final HideableModelBoxWithChildren tail1Spike2;
    private final HideableModelBoxWithChildren tail2;
    private final HideableModelBoxWithChildren tail2Spikes;
    private final HideableModelBoxWithChildren tail3;
    private final HideableModelBoxWithChildren tail3Spikes;
    private final AdvancedModelBox tail4;
    private final AdvancedModelBox chest;
    private final AdvancedModelBox cube_r6;
    private final AdvancedModelBox neck;
    private final AdvancedModelBox neckSpikes;
    private final AdvancedModelBox head;
    private final AdvancedModelBox rightEar;
    private final AdvancedModelBox leftEar;
    private final AdvancedModelBox jaw;
    private final AdvancedModelBox leftArm;
    private final AdvancedModelBox leftThumb;
    private final AdvancedModelBox rightArm;
    private final AdvancedModelBox rightThumb;
    private final AdvancedModelBox chestSpikes;
    private final AdvancedModelBox chestSpike1;
    private final AdvancedModelBox chestSpike2;
    private final AdvancedModelBox chestSpike3;
    private final AdvancedModelBox neckSlope;
    private final ModelAnimator animator;
    public boolean straighten;

    public TremorzillaModel() {
        this.texWidth = 512;
        this.texHeight = 512;
        this.root = new AdvancedModelBox((AdvancedEntityModel)this);
        this.root.setRotationPoint(0.0f, 24.0f, 0.0f);
        this.torso = new HideableModelBoxWithChildren(this);
        this.torso.setRotationPoint(0.0f, -51.0f, 0.0f);
        this.root.addChild((BasicModelPart)this.torso);
        this.torso.setTextureOffset(0, 0).addBox(-26.0f, -31.0f, -28.0f, 52.0f, 62.0f, 56.0f, 0.0f, false);
        this.torsoSpikes = new AdvancedModelBox((AdvancedEntityModel)this);
        this.torsoSpikes.setRotationPoint(0.0f, -28.0671f, 27.4673f);
        this.torso.addChild((BasicModelPart)this.torsoSpikes);
        this.torsoSpike1 = new AdvancedModelBox((AdvancedEntityModel)this);
        this.torsoSpike1.setRotationPoint(0.0f, -15.9329f, -24.4673f);
        this.torsoSpikes.addChild((BasicModelPart)this.torsoSpike1);
        this.setRotateAngle(this.torsoSpike1, 0.2618f, 0.0f, 0.0f);
        this.torsoSpike1.setTextureOffset(284, 262).addBox(0.02f, -5.0f, 9.0f, 0.0f, 54.0f, 54.0f, 0.0f, false);
        this.torsoSpike2 = new AdvancedModelBox((AdvancedEntityModel)this);
        this.torsoSpike2.setRotationPoint(0.0f, -15.9329f, -24.4673f);
        this.torsoSpikes.addChild((BasicModelPart)this.torsoSpike2);
        this.setRotateAngle(this.torsoSpike2, 0.3927f, -0.3054f, -0.3054f);
        this.torsoSpike2.setTextureOffset(128, 290).addBox(-10.0f, -5.0f, 9.0f, 0.0f, 54.0f, 54.0f, 0.0f, true);
        this.torsoSpike3 = new AdvancedModelBox((AdvancedEntityModel)this);
        this.torsoSpike3.setRotationPoint(0.0f, -15.9329f, -24.4673f);
        this.torsoSpikes.addChild((BasicModelPart)this.torsoSpike3);
        this.setRotateAngle(this.torsoSpike3, 0.3927f, 0.3054f, 0.3054f);
        this.torsoSpike3.setTextureOffset(128, 290).addBox(10.0f, -5.0f, 9.0f, 0.0f, 54.0f, 54.0f, 0.0f, false);
        this.rightLeg = new AdvancedModelBox((AdvancedEntityModel)this);
        this.rightLeg.setRotationPoint(-24.0f, -2.0f, -3.0f);
        this.torso.addChild((BasicModelPart)this.rightLeg);
        this.rightLeg.setTextureOffset(160, 24).addBox(-20.5f, 44.5f, -24.0f, 27.0f, 8.0f, 8.0f, 0.0f, true);
        this.rightLeg.setTextureOffset(139, 148).addBox(-20.5f, 44.5f, -24.5f, 27.0f, 8.0f, 8.0f, 0.5f, true);
        this.rightLeg.setTextureOffset(1, 344).addBox(-21.0f, -11.0f, -16.0f, 28.0f, 64.0f, 34.0f, 0.0f, true);
        this.leftLeg = new AdvancedModelBox((AdvancedEntityModel)this);
        this.leftLeg.setRotationPoint(24.0f, -2.0f, -3.0f);
        this.torso.addChild((BasicModelPart)this.leftLeg);
        this.leftLeg.setTextureOffset(160, 24).addBox(-6.5f, 44.5f, -24.0f, 27.0f, 8.0f, 8.0f, 0.0f, false);
        this.leftLeg.setTextureOffset(139, 148).addBox(-6.5f, 44.5f, -24.5f, 27.0f, 8.0f, 8.0f, 0.5f, false);
        this.leftLeg.setTextureOffset(1, 344).addBox(-7.0f, -11.0f, -16.0f, 28.0f, 64.0f, 34.0f, 0.0f, false);
        this.tail1 = new HideableModelBoxWithChildren(this);
        this.tail1.setRotationPoint(-0.5f, 24.0f, 16.0f);
        this.torso.addChild((BasicModelPart)this.tail1);
        this.tail1.setTextureOffset(124, 164).addBox(-14.0f, -15.0f, -6.0f, 29.0f, 34.0f, 64.0f, 0.0f, false);
        this.tail1Spikes = new HideableModelBoxWithChildren(this);
        this.tail1Spikes.setRotationPoint(0.5f, -15.3829f, 26.0f);
        this.tail1.addChild((BasicModelPart)this.tail1Spikes);
        this.tail1Spikes.setTextureOffset(156, 238).addBox(0.0f, -39.6171f, -32.0f, 0.0f, 40.0f, 64.0f, 0.0f, false);
        this.tail1Spike1 = new HideableModelBoxWithChildren(this);
        this.tail1Spike1.setRotationPoint(6.0f, 0.3829f, 0.0f);
        this.tail1Spikes.addChild((BasicModelPart)this.tail1Spike1);
        this.setRotateAngle(this.tail1Spike1, 0.0f, 0.0f, 0.3054f);
        this.tail1Spike1.setTextureOffset(156, 198).addBox(0.0f, -40.0f, -32.0f, 0.0f, 40.0f, 64.0f, 0.0f, false);
        this.tail1Spike2 = new HideableModelBoxWithChildren(this);
        this.tail1Spike2.setRotationPoint(-6.0f, 0.3829f, 0.0f);
        this.tail1Spikes.addChild((BasicModelPart)this.tail1Spike2);
        this.setRotateAngle(this.tail1Spike2, 0.0f, 0.0f, -0.3054f);
        this.tail1Spike2.setTextureOffset(156, 198).addBox(0.0f, -40.0f, -32.0f, 0.0f, 40.0f, 64.0f, 0.0f, true);
        this.tail2 = new HideableModelBoxWithChildren(this);
        this.tail2.setRotationPoint(0.5f, -9.0f, 54.0f);
        this.tail1.addChild((BasicModelPart)this.tail2);
        this.tail2.setTextureOffset(140, 42).addBox(-9.0f, -4.01f, -7.99f, 18.0f, 28.0f, 76.0f, -0.01f, false);
        this.tail2Spikes = new HideableModelBoxWithChildren(this);
        this.tail2Spikes.setRotationPoint(-0.01f, -4.01f, 36.01f);
        this.tail2.addChild((BasicModelPart)this.tail2Spikes);
        this.tail2Spikes.setTextureOffset(0, 252).addBox(0.0f, -28.0f, -32.0f, 0.0f, 28.0f, 64.0f, -0.01f, false);
        this.tail3 = new HideableModelBoxWithChildren(this);
        this.tail3.setRotationPoint(0.0f, 10.0f, 66.0f);
        this.tail2.addChild((BasicModelPart)this.tail3);
        this.tail3.setTextureOffset(0, 228).addBox(-5.0f, -8.0f, -2.0f, 10.0f, 20.0f, 68.0f, 0.0f, false);
        this.tail3Spikes = new HideableModelBoxWithChildren(this);
        this.tail3Spikes.setRotationPoint(0.0f, -8.0f, 29.0f);
        this.tail3.addChild((BasicModelPart)this.tail3Spikes);
        this.tail3Spikes.setTextureOffset(261, 38).addBox(0.0f, -26.0f, -27.0f, 0.0f, 26.0f, 54.0f, 0.0f, true);
        this.tail4 = new AdvancedModelBox((AdvancedEntityModel)this);
        this.tail4.setRotationPoint(0.0f, 2.0f, 66.0f);
        this.tail3.addChild((BasicModelPart)this.tail4);
        this.tail4.setTextureOffset(248, 146).addBox(-3.0f, -6.0f, -4.0f, 6.0f, 12.0f, 68.0f, 0.0f, false);
        this.chest = new AdvancedModelBox((AdvancedEntityModel)this);
        this.chest.setRotationPoint(0.0f, -29.565f, 17.1508f);
        this.torso.addChild((BasicModelPart)this.chest);
        this.cube_r6 = new AdvancedModelBox((AdvancedEntityModel)this);
        this.cube_r6.setRotationPoint(0.0f, -14.6696f, -14.0691f);
        this.chest.addChild((BasicModelPart)this.cube_r6);
        this.setRotateAngle(this.cube_r6, 0.3927f, 0.0f, 0.0f);
        this.cube_r6.setTextureOffset(0, 118).addBox(-20.0f, -29.0f, -43.0f, 40.0f, 56.0f, 54.0f, 0.0f, false);
        this.neck = new AdvancedModelBox((AdvancedEntityModel)this);
        this.neck.setRotationPoint(1.5556f, -36.6696f, -20.1803f);
        this.chest.addChild((BasicModelPart)this.neck);
        this.neck.setTextureOffset(252, 0).addBox(-14.5556f, -50.0f, -33.8889f, 26.0f, 54.0f, 38.0f, 0.0f, false);
        this.neckSpikes = new AdvancedModelBox((AdvancedEntityModel)this);
        this.neckSpikes.setRotationPoint(-1.5556f, -38.0f, -0.8889f);
        this.neck.addChild((BasicModelPart)this.neckSpikes);
        this.neckSpikes.setTextureOffset(0, 200).addBox(-0.02f, -22.0f, -7.0f, 0.0f, 48.0f, 28.0f, 0.0f, false);
        this.neckSpikes.setTextureOffset(248, 118).addBox(-7.0f, -20.0f, -9.0f, 0.0f, 48.0f, 28.0f, 0.0f, true);
        this.neckSpikes.setTextureOffset(248, 118).addBox(7.0f, -20.0f, -9.0f, 0.0f, 48.0f, 28.0f, 0.0f, false);
        this.head = new AdvancedModelBox((AdvancedEntityModel)this);
        this.head.setRotationPoint(-1.5556f, -49.0f, -20.8889f);
        this.neck.addChild((BasicModelPart)this.head);
        this.head.setTextureOffset(335, 124).addBox(-13.5f, -4.0f, -36.0f, 27.0f, 14.0f, 36.0f, 0.0f, false);
        this.head.setTextureOffset(11, 443).addBox(-13.5f, 10.0f, -36.0f, 27.0f, 5.0f, 31.0f, 0.0f, false);
        this.head.setTextureOffset(4, 122).addBox(4.5f, -13.0f, -13.0f, 9.0f, 5.0f, 8.0f, 0.0f, false);
        this.head.setTextureOffset(4, 142).addBox(4.5f, -8.0f, -13.0f, 9.0f, 4.0f, 8.0f, 0.0f, false);
        this.head.setTextureOffset(4, 122).addBox(-13.5f, -13.0f, -13.0f, 9.0f, 5.0f, 8.0f, 0.0f, true);
        this.head.setTextureOffset(430, 52).addBox(-13.5f, 4.0f, -14.0f, 27.0f, 6.0f, 14.0f, 0.0f, false);
        this.head.setTextureOffset(4, 142).addBox(-13.5f, -8.0f, -13.0f, 9.0f, 4.0f, 8.0f, 0.0f, true);
        this.head.setTextureOffset(32, 14).addBox(-13.5f, -7.0f, 0.0f, 0.0f, 6.0f, 8.0f, 0.0f, true);
        this.rightEar = new AdvancedModelBox((AdvancedEntityModel)this);
        this.rightEar.setRotationPoint(-13.5f, -4.0f, 0.0f);
        this.head.addChild((BasicModelPart)this.rightEar);
        this.leftEar = new AdvancedModelBox((AdvancedEntityModel)this);
        this.leftEar.setRotationPoint(13.5f, -4.0f, 0.0f);
        this.head.addChild((BasicModelPart)this.leftEar);
        this.leftEar.setTextureOffset(32, 14).addBox(0.0f, -3.0f, 0.0f, 0.0f, 6.0f, 8.0f, 0.0f, false);
        this.jaw = new AdvancedModelBox((AdvancedEntityModel)this);
        this.jaw.setRotationPoint(0.0f, 5.2738f, -2.0631f);
        this.head.addChild((BasicModelPart)this.jaw);
        this.jaw.setTextureOffset(383, 3).addBox(-15.0f, -1.2738f, -11.9369f, 30.0f, 20.0f, 15.0f, 0.0f, false);
        this.jaw.setTextureOffset(368, 346).addBox(-15.0f, -9.2738f, -35.9369f, 30.0f, 14.0f, 24.0f, 0.0f, false);
        this.jaw.setTextureOffset(372, 202).addBox(-15.0f, 4.7262f, -35.9369f, 30.0f, 14.0f, 24.0f, 0.0f, false);
        this.leftArm = new AdvancedModelBox((AdvancedEntityModel)this);
        this.leftArm.setRotationPoint(17.5f, -19.6696f, -33.0691f);
        this.chest.addChild((BasicModelPart)this.leftArm);
        this.setRotateAngle(this.leftArm, 0.3927f, -0.3927f, 0.3927f);
        this.leftArm.setTextureOffset(312, 226).addBox(16.5f, -6.0f, -28.0f, 18.0f, 12.0f, 20.0f, 0.0f, false);
        this.leftArm.setTextureOffset(0, 0).addBox(16.5f, -6.0f, -38.0f, 18.0f, 12.0f, 10.0f, 0.0f, false);
        this.leftArm.setTextureOffset(160, 0).addBox(2.5f, -6.0f, -8.0f, 32.0f, 12.0f, 12.0f, 0.0f, false);
        this.leftThumb = new AdvancedModelBox((AdvancedEntityModel)this);
        this.leftThumb.setRotationPoint(16.5f, 4.0f, -22.0f);
        this.leftArm.addChild((BasicModelPart)this.leftThumb);
        this.leftThumb.setTextureOffset(10, 34).addBox(-6.0f, -2.0f, -6.0f, 6.0f, 4.0f, 6.0f, 0.0f, false);
        this.leftThumb.setTextureOffset(0, 46).addBox(-6.0f, -2.0f, -12.0f, 6.0f, 4.0f, 6.0f, 0.0f, false);
        this.rightArm = new AdvancedModelBox((AdvancedEntityModel)this);
        this.rightArm.setRotationPoint(-17.5f, -19.6696f, -33.0691f);
        this.chest.addChild((BasicModelPart)this.rightArm);
        this.setRotateAngle(this.rightArm, 0.3927f, 0.3927f, -0.3927f);
        this.rightArm.setTextureOffset(312, 226).addBox(-34.5f, -6.0f, -28.0f, 18.0f, 12.0f, 20.0f, 0.0f, true);
        this.rightArm.setTextureOffset(0, 0).addBox(-34.5f, -6.0f, -38.0f, 18.0f, 12.0f, 10.0f, 0.0f, true);
        this.rightArm.setTextureOffset(160, 0).addBox(-34.5f, -6.0f, -8.0f, 32.0f, 12.0f, 12.0f, 0.0f, true);
        this.rightThumb = new AdvancedModelBox((AdvancedEntityModel)this);
        this.rightThumb.setRotationPoint(-16.5f, 4.0f, -22.0f);
        this.rightArm.addChild((BasicModelPart)this.rightThumb);
        this.rightThumb.setTextureOffset(10, 34).addBox(0.0f, -2.0f, -6.0f, 6.0f, 4.0f, 6.0f, 0.0f, true);
        this.rightThumb.setTextureOffset(0, 46).addBox(0.0f, -2.0f, -12.0f, 6.0f, 4.0f, 6.0f, 0.0f, true);
        this.chestSpikes = new AdvancedModelBox((AdvancedEntityModel)this);
        this.chestSpikes.setRotationPoint(0.0f, -19.8909f, -9.5233f);
        this.chest.addChild((BasicModelPart)this.chestSpikes);
        this.chestSpike1 = new AdvancedModelBox((AdvancedEntityModel)this);
        this.chestSpike1.setRotationPoint(0.0f, 5.4558f, -4.6274f);
        this.chestSpikes.addChild((BasicModelPart)this.chestSpike1);
        this.setRotateAngle(this.chestSpike1, 0.7854f, 0.0f, 0.0f);
        this.chestSpike1.setTextureOffset(128, 290).addBox(0.0f, -29.0f, 11.0f, 0.0f, 54.0f, 54.0f, 0.0f, false);
        this.chestSpike2 = new AdvancedModelBox((AdvancedEntityModel)this);
        this.chestSpike2.setRotationPoint(10.0f, 0.0f, 0.0f);
        this.chestSpikes.addChild((BasicModelPart)this.chestSpike2);
        this.setRotateAngle(this.chestSpike2, 0.7854f, 0.2182f, 0.2618f);
        this.chestSpike2.setTextureOffset(236, 330).addBox(0.0f, -28.4142f, -0.1299f, 0.0f, 54.0f, 44.0f, 0.0f, false);
        this.chestSpike3 = new AdvancedModelBox((AdvancedEntityModel)this);
        this.chestSpike3.setRotationPoint(-10.0f, 0.0f, 0.0f);
        this.chestSpikes.addChild((BasicModelPart)this.chestSpike3);
        this.setRotateAngle(this.chestSpike3, 0.7854f, -0.2182f, -0.2618f);
        this.chestSpike3.setTextureOffset(236, 330).addBox(0.0f, -28.4142f, -0.1299f, 0.0f, 54.0f, 44.0f, 0.0f, true);
        this.neckSlope = new AdvancedModelBox((AdvancedEntityModel)this);
        this.neckSlope.setRotationPoint(-1.5556f, -50.0f, -24.8889f);
        this.neck.addChild((BasicModelPart)this.neckSlope);
        this.setRotateAngle(this.neckSlope, 1.0105f, 0.0f, 0.0f);
        this.neckSlope.setTextureOffset(426, 480).addBox(-13.0f, 0.0f, -17.0f, 26.0f, 15.0f, 17.0f, -0.01f, false);
        this.updateDefaultPose();
        this.animator = ModelAnimator.create();
    }

    public void m_7695_(PoseStack matrixStackIn, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        if (this.f_102610_) {
            float f = 1.5f;
            this.head.setScale(f, f, f);
            this.head.setShouldScaleChildren(true);
            matrixStackIn.m_85836_();
            matrixStackIn.m_85841_(0.15f, 0.15f, 0.15f);
            matrixStackIn.m_85837_(0.0, (double)8.55f, 0.0);
            this.parts().forEach(p_228292_8_ -> p_228292_8_.render(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha));
            matrixStackIn.m_85849_();
            this.head.setScale(1.0f, 1.0f, 1.0f);
        } else {
            matrixStackIn.m_85836_();
            this.parts().forEach(p_228290_8_ -> p_228290_8_.render(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha));
            matrixStackIn.m_85849_();
        }
    }

    public void animate(IAnimatedEntity entity) {
        this.animator.update(entity);
        this.animator.setAnimation(TremorzillaEntity.ANIMATION_SPEAK);
        this.animator.startKeyframe(5);
        this.animator.rotate(this.neck, (float)Math.toRadians(-5.0), 0.0f, 0.0f);
        this.animator.rotate(this.head, (float)Math.toRadians(-10.0), 0.0f, 0.0f);
        this.animator.endKeyframe();
        this.animator.startKeyframe(8);
        this.animator.rotate(this.neck, (float)Math.toRadians(10.0), 0.0f, 0.0f);
        this.animator.rotate(this.head, (float)Math.toRadians(-20.0), 0.0f, 0.0f);
        this.animator.rotate(this.jaw, (float)Math.toRadians(40.0), 0.0f, 0.0f);
        this.animator.endKeyframe();
        this.animator.setStaticKeyframe(2);
        this.animator.resetKeyframe(5);
        this.animator.setAnimation(TremorzillaEntity.ANIMATION_ROAR_1);
        this.animator.startKeyframe(10);
        this.animator.rotate(this.neck, (float)Math.toRadians(-15.0), 0.0f, 0.0f);
        this.animator.rotate(this.head, (float)Math.toRadians(-20.0), 0.0f, 0.0f);
        this.animator.rotate(this.jaw, (float)Math.toRadians(-10.0), 0.0f, 0.0f);
        this.animator.rotate(this.chest, (float)Math.toRadians(-5.0), 0.0f, 0.0f);
        this.animator.move(this.neck, 0.0f, 10.0f, 0.0f);
        this.animator.move(this.head, 0.0f, 1.0f, 2.0f);
        this.animator.endKeyframe();
        this.animator.setStaticKeyframe(2);
        this.animator.startKeyframe(8);
        this.animator.move(this.neck, 0.0f, -5.0f, -5.0f);
        this.animator.rotate(this.neck, (float)Math.toRadians(50.0), 0.0f, 0.0f);
        this.animator.rotate(this.head, (float)Math.toRadians(-60.0), 0.0f, 0.0f);
        this.animator.rotate(this.jaw, (float)Math.toRadians(50.0), 0.0f, 0.0f);
        this.animator.rotate(this.chest, (float)Math.toRadians(10.0), 0.0f, 0.0f);
        this.animator.endKeyframe();
        this.animator.setStaticKeyframe(30);
        this.animator.resetKeyframe(10);
        this.animator.setAnimation(TremorzillaEntity.ANIMATION_ROAR_2);
        this.animator.startKeyframe(10);
        this.animator.rotate(this.neck, (float)Math.toRadians(15.0), 0.0f, 0.0f);
        this.animator.rotate(this.head, (float)Math.toRadians(20.0), 0.0f, 0.0f);
        this.animator.rotate(this.chest, (float)Math.toRadians(10.0), 0.0f, 0.0f);
        this.animator.move(this.head, 0.0f, -1.0f, -2.0f);
        this.animator.endKeyframe();
        this.animator.setStaticKeyframe(2);
        this.animator.startKeyframe(13);
        this.animator.move(this.neck, 0.0f, 10.0f, -5.0f);
        this.animator.move(this.head, 0.0f, 1.0f, 5.0f);
        this.animator.rotate(this.neck, (float)Math.toRadians(-15.0), 0.0f, 0.0f);
        this.animator.rotate(this.chest, (float)Math.toRadians(-10.0), 0.0f, 0.0f);
        this.animator.rotate(this.head, (float)Math.toRadians(-80.0), 0.0f, 0.0f);
        this.animator.rotate(this.jaw, (float)Math.toRadians(60.0), 0.0f, 0.0f);
        this.animator.endKeyframe();
        this.animator.setStaticKeyframe(25);
        this.animator.resetKeyframe(10);
        this.animator.setAnimation(TremorzillaEntity.ANIMATION_RIGHT_SCRATCH);
        this.animator.startKeyframe(10);
        this.animator.rotate(this.chest, (float)Math.toRadians(-15.0), (float)Math.toRadians(15.0), 0.0f);
        this.animator.rotate(this.head, (float)Math.toRadians(15.0), (float)Math.toRadians(-15.0), 0.0f);
        this.animator.rotate(this.rightArm, (float)Math.toRadians(-85.0), (float)Math.toRadians(40.0), 0.0f);
        this.animator.rotate(this.leftArm, (float)Math.toRadians(10.0), (float)Math.toRadians(25.0), 0.0f);
        this.animator.endKeyframe();
        this.animator.setStaticKeyframe(5);
        this.animator.startKeyframe(5);
        this.animator.move(this.chest, -5.0f, -10.0f, 2.0f);
        this.animator.move(this.rightArm, 0.0f, 0.0f, -8.0f);
        this.animator.rotate(this.chest, (float)Math.toRadians(20.0), (float)Math.toRadians(-35.0), 0.0f);
        this.animator.rotate(this.head, (float)Math.toRadians(-20.0), (float)Math.toRadians(35.0), 0.0f);
        this.animator.rotate(this.rightArm, (float)Math.toRadians(-35.0), (float)Math.toRadians(-40.0), (float)Math.toRadians(-10.0));
        this.animator.endKeyframe();
        this.animator.setStaticKeyframe(5);
        this.animator.resetKeyframe(10);
        this.animator.setAnimation(TremorzillaEntity.ANIMATION_LEFT_SCRATCH);
        this.animator.startKeyframe(10);
        this.animator.rotate(this.chest, (float)Math.toRadians(-15.0), (float)Math.toRadians(-15.0), 0.0f);
        this.animator.rotate(this.head, (float)Math.toRadians(15.0), (float)Math.toRadians(15.0), 0.0f);
        this.animator.rotate(this.leftArm, (float)Math.toRadians(-85.0), (float)Math.toRadians(-40.0), 0.0f);
        this.animator.rotate(this.rightArm, (float)Math.toRadians(10.0), (float)Math.toRadians(-25.0), 0.0f);
        this.animator.endKeyframe();
        this.animator.setStaticKeyframe(5);
        this.animator.startKeyframe(5);
        this.animator.move(this.chest, 5.0f, -10.0f, 2.0f);
        this.animator.move(this.leftArm, 0.0f, 0.0f, -8.0f);
        this.animator.rotate(this.chest, (float)Math.toRadians(20.0), (float)Math.toRadians(35.0), 0.0f);
        this.animator.rotate(this.head, (float)Math.toRadians(-20.0), (float)Math.toRadians(-35.0), 0.0f);
        this.animator.rotate(this.leftArm, (float)Math.toRadians(-35.0), (float)Math.toRadians(40.0), (float)Math.toRadians(10.0));
        this.animator.endKeyframe();
        this.animator.setStaticKeyframe(5);
        this.animator.resetKeyframe(10);
        this.animator.setAnimation(TremorzillaEntity.ANIMATION_RIGHT_STOMP);
        this.animator.startKeyframe(10);
        this.animator.move((AdvancedModelBox)this.torso, 0.0f, -20.0f, 2.0f);
        this.animator.move(this.leftLeg, 0.0f, 20.0f, -2.0f);
        this.animator.move(this.rightLeg, 0.0f, -10.0f, -10.0f);
        this.animator.move((AdvancedModelBox)this.tail1, 0.0f, 10.0f, 2.0f);
        this.animator.move(this.rightArm, 0.0f, -8.0f, 2.0f);
        this.animator.move(this.leftArm, 0.0f, -8.0f, 2.0f);
        this.animator.rotate((AdvancedModelBox)this.torso, (float)Math.toRadians(-15.0), (float)Math.toRadians(-15.0), 0.0f);
        this.animator.rotate(this.chest, (float)Math.toRadians(5.0), (float)Math.toRadians(5.0), 0.0f);
        this.animator.rotate(this.neck, (float)Math.toRadians(10.0), (float)Math.toRadians(10.0), 0.0f);
        this.animator.rotate(this.leftLeg, (float)Math.toRadians(15.0), (float)Math.toRadians(15.0), (float)Math.toRadians(5.0));
        this.animator.rotate(this.rightLeg, (float)Math.toRadians(-15.0), 0.0f, (float)Math.toRadians(-5.0));
        this.animator.rotate((AdvancedModelBox)this.tail1, (float)Math.toRadians(10.0), (float)Math.toRadians(15.0), 0.0f);
        this.animator.rotate((AdvancedModelBox)this.tail2, (float)Math.toRadians(5.0), 0.0f, 0.0f);
        this.animator.endKeyframe();
        this.animator.setStaticKeyframe(5);
        this.animator.startKeyframe(5);
        this.animator.move((AdvancedModelBox)this.torso, 0.0f, 0.0f, 10.0f);
        this.animator.move(this.rightLeg, 0.0f, -10.0f, -30.0f);
        this.animator.rotate((AdvancedModelBox)this.torso, (float)Math.toRadians(15.0), 0.0f, 0.0f);
        this.animator.rotate(this.chest, (float)Math.toRadians(5.0), 0.0f, 0.0f);
        this.animator.rotate(this.neck, (float)Math.toRadians(5.0), 0.0f, 0.0f);
        this.animator.rotate(this.leftLeg, (float)Math.toRadians(-15.0), 0.0f, 0.0f);
        this.animator.rotate(this.rightLeg, (float)Math.toRadians(-15.0), 0.0f, 0.0f);
        this.animator.rotate(this.rightArm, (float)Math.toRadians(-35.0), 0.0f, 0.0f);
        this.animator.rotate(this.leftArm, (float)Math.toRadians(-35.0), 0.0f, 0.0f);
        this.animator.rotate((AdvancedModelBox)this.tail1, (float)Math.toRadians(-15.0), 0.0f, 0.0f);
        this.animator.endKeyframe();
        this.animator.setStaticKeyframe(5);
        this.animator.resetKeyframe(10);
        this.animator.setAnimation(TremorzillaEntity.ANIMATION_LEFT_STOMP);
        this.animator.startKeyframe(10);
        this.animator.move((AdvancedModelBox)this.torso, 0.0f, -20.0f, 2.0f);
        this.animator.move(this.rightLeg, 0.0f, 20.0f, -2.0f);
        this.animator.move(this.leftLeg, 0.0f, -10.0f, -10.0f);
        this.animator.move((AdvancedModelBox)this.tail1, 0.0f, 10.0f, 2.0f);
        this.animator.move(this.rightArm, 0.0f, -8.0f, 2.0f);
        this.animator.move(this.leftArm, 0.0f, -8.0f, 2.0f);
        this.animator.rotate((AdvancedModelBox)this.torso, (float)Math.toRadians(-15.0), (float)Math.toRadians(15.0), 0.0f);
        this.animator.rotate(this.chest, (float)Math.toRadians(5.0), (float)Math.toRadians(-5.0), 0.0f);
        this.animator.rotate(this.neck, (float)Math.toRadians(10.0), (float)Math.toRadians(-10.0), 0.0f);
        this.animator.rotate(this.rightLeg, (float)Math.toRadians(15.0), (float)Math.toRadians(-15.0), (float)Math.toRadians(-5.0));
        this.animator.rotate(this.leftLeg, (float)Math.toRadians(-15.0), 0.0f, (float)Math.toRadians(5.0));
        this.animator.rotate((AdvancedModelBox)this.tail1, (float)Math.toRadians(10.0), (float)Math.toRadians(-15.0), 0.0f);
        this.animator.rotate((AdvancedModelBox)this.tail2, (float)Math.toRadians(5.0), 0.0f, 0.0f);
        this.animator.endKeyframe();
        this.animator.setStaticKeyframe(5);
        this.animator.startKeyframe(5);
        this.animator.move((AdvancedModelBox)this.torso, 0.0f, 0.0f, 10.0f);
        this.animator.move(this.leftLeg, 0.0f, -10.0f, -30.0f);
        this.animator.rotate((AdvancedModelBox)this.torso, (float)Math.toRadians(15.0), 0.0f, 0.0f);
        this.animator.rotate(this.chest, (float)Math.toRadians(5.0), 0.0f, 0.0f);
        this.animator.rotate(this.neck, (float)Math.toRadians(5.0), 0.0f, 0.0f);
        this.animator.rotate(this.leftLeg, (float)Math.toRadians(-15.0), 0.0f, 0.0f);
        this.animator.rotate(this.rightLeg, (float)Math.toRadians(-15.0), 0.0f, 0.0f);
        this.animator.rotate(this.rightArm, (float)Math.toRadians(-35.0), 0.0f, 0.0f);
        this.animator.rotate(this.leftArm, (float)Math.toRadians(-35.0), 0.0f, 0.0f);
        this.animator.rotate((AdvancedModelBox)this.tail1, (float)Math.toRadians(-15.0), 0.0f, 0.0f);
        this.animator.endKeyframe();
        this.animator.setStaticKeyframe(5);
        this.animator.resetKeyframe(10);
        this.animator.setAnimation(TremorzillaEntity.ANIMATION_BITE);
        this.animator.startKeyframe(5);
        this.animator.rotate(this.chest, (float)Math.toRadians(-5.0), 0.0f, 0.0f);
        this.animator.rotate(this.neck, (float)Math.toRadians(-5.0), 0.0f, 0.0f);
        this.animator.endKeyframe();
        this.animator.startKeyframe(5);
        this.animator.move(this.chest, 0.0f, 0.0f, -5.0f);
        this.animator.move(this.neck, 0.0f, 2.0f, -5.0f);
        this.animator.rotate(this.chest, (float)Math.toRadians(25.0), 0.0f, 0.0f);
        this.animator.rotate(this.neck, (float)Math.toRadians(25.0), 0.0f, (float)Math.toRadians(15.0));
        this.animator.rotate(this.head, (float)Math.toRadians(-55.0), 0.0f, (float)Math.toRadians(-15.0));
        this.animator.rotate(this.jaw, (float)Math.toRadians(55.0), 0.0f, 0.0f);
        this.animator.endKeyframe();
        this.animator.startKeyframe(5);
        this.animator.move(this.chest, 0.0f, 0.0f, -5.0f);
        this.animator.move(this.neck, 0.0f, 2.0f, -5.0f);
        this.animator.rotate(this.chest, (float)Math.toRadians(35.0), 0.0f, 0.0f);
        this.animator.rotate(this.neck, (float)Math.toRadians(15.0), 0.0f, 0.0f);
        this.animator.rotate(this.head, (float)Math.toRadians(-55.0), 0.0f, 0.0f);
        this.animator.rotate(this.jaw, (float)Math.toRadians(5.0), 0.0f, 0.0f);
        this.animator.endKeyframe();
        this.animator.resetKeyframe(10);
        this.animator.setAnimation(TremorzillaEntity.ANIMATION_PREPARE_BREATH);
        this.animator.startKeyframe(13);
        this.animator.move(this.neck, 0.0f, 10.0f, -5.0f);
        this.animator.move(this.head, 0.0f, 5.0f, 8.0f);
        this.animator.rotate(this.chest, (float)Math.toRadians(-10.0), 0.0f, 0.0f);
        this.animator.rotate(this.neck, (float)Math.toRadians(-30.0), 0.0f, 0.0f);
        this.animator.rotate(this.head, (float)Math.toRadians(-70.0), 0.0f, 0.0f);
        this.animator.rotate(this.leftArm, (float)Math.toRadians(-35.0), (float)Math.toRadians(-40.0), (float)Math.toRadians(20.0));
        this.animator.rotate(this.rightArm, (float)Math.toRadians(-35.0), (float)Math.toRadians(40.0), (float)Math.toRadians(-20.0));
        this.animator.endKeyframe();
        this.animator.setStaticKeyframe(2);
        this.animator.resetKeyframe(5);
        this.animator.setAnimation(TremorzillaEntity.ANIMATION_CHEW);
        this.animator.startKeyframe(6);
        this.animator.rotate(this.jaw, (float)Math.toRadians(25.0), 0.0f, 0.0f);
        this.animator.rotate(this.head, (float)Math.toRadians(-10.0), 0.0f, 0.0f);
        this.animator.rotate(this.neck, 0.0f, 0.0f, (float)Math.toRadians(5.0));
        this.animator.endKeyframe();
        this.animator.startKeyframe(6);
        this.animator.rotate(this.jaw, (float)Math.toRadians(-5.0), 0.0f, 0.0f);
        this.animator.rotate(this.head, (float)Math.toRadians(5.0), 0.0f, 0.0f);
        this.animator.endKeyframe();
        this.animator.startKeyframe(6);
        this.animator.rotate(this.jaw, (float)Math.toRadians(25.0), 0.0f, 0.0f);
        this.animator.rotate(this.head, (float)Math.toRadians(-10.0), 0.0f, 0.0f);
        this.animator.rotate(this.neck, 0.0f, 0.0f, (float)Math.toRadians(-5.0));
        this.animator.endKeyframe();
        this.animator.startKeyframe(6);
        this.animator.rotate(this.jaw, (float)Math.toRadians(-5.0), 0.0f, 0.0f);
        this.animator.rotate(this.head, (float)Math.toRadians(5.0), 0.0f, 0.0f);
        this.animator.endKeyframe();
        this.animator.startKeyframe(6);
        this.animator.rotate(this.jaw, (float)Math.toRadians(25.0), 0.0f, 0.0f);
        this.animator.rotate(this.head, (float)Math.toRadians(-10.0), 0.0f, 0.0f);
        this.animator.rotate(this.neck, 0.0f, 0.0f, (float)Math.toRadians(5.0));
        this.animator.endKeyframe();
        this.animator.resetKeyframe(5);
    }

    public void setupAnim(TremorzillaEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.resetToDefaultPose();
        this.animate(entity);
        if (entity.getAnimation() != IAnimatedEntity.NO_ANIMATION) {
            this.setupAnimForAnimation(entity, entity.getAnimation(), limbSwing, limbSwingAmount, ageInTicks);
        }
        float partialTicks = ageInTicks - (float)entity.f_19797_;
        float burnProgress = entity.getBeamProgress(partialTicks);
        float danceProgress = entity.getDanceProgress(partialTicks);
        float sitProgress = entity.getSitProgress(partialTicks) * (1.0f - danceProgress);
        float swimProgress = entity.m_20998_(partialTicks) * (1.0f - sitProgress);
        float groundProgress = 1.0f - swimProgress;
        float standProgress = 1.0f - sitProgress;
        float spikesDownProgress = entity.getClientSpikeDownAmount(partialTicks);
        float buryEggsAmount = entity.getBuryEggsProgress(partialTicks);
        float spikes1Down = TremorzillaEntity.calculateSpikesDownAmountAtIndex(spikesDownProgress, 6.0f, 0.0f);
        float spikes2Down = TremorzillaEntity.calculateSpikesDownAmountAtIndex(spikesDownProgress, 6.0f, 1.0f);
        float spikes3Down = TremorzillaEntity.calculateSpikesDownAmountAtIndex(spikesDownProgress, 6.0f, 2.0f);
        float spikes4Down = TremorzillaEntity.calculateSpikesDownAmountAtIndex(spikesDownProgress, 6.0f, 3.0f);
        float spikes5Down = TremorzillaEntity.calculateSpikesDownAmountAtIndex(spikesDownProgress, 6.0f, 4.0f);
        float spikes6Down = TremorzillaEntity.calculateSpikesDownAmountAtIndex(spikesDownProgress, 6.0f, 5.0f);
        float walkSpeed = 0.25f;
        float walkDegree = 2.0f;
        float swimSpeed = 0.25f;
        float swimDegree = 2.0f;
        float limbSwingAmountGround = limbSwingAmount * groundProgress;
        float limbSwingAmountSwim = limbSwingAmount * swimProgress;
        float headYawAmount = netHeadYaw / 57.295776f * (1.0f - burnProgress) * standProgress;
        float headPitchAmount = headPitch / 57.295776f * (1.0f - burnProgress) * standProgress;
        Vec3 burnPos = entity.getClientBeamEndPosition(partialTicks);
        this.articulateLegs(entity.legSolver, partialTicks, groundProgress * (1.0f - danceProgress) * standProgress);
        if (!this.straighten && !entity.isFakeEntity()) {
            this.positionTail(entity, partialTicks);
        }
        if (buryEggsAmount > 0.0f) {
            limbSwing = ageInTicks;
            limbSwingAmount = buryEggsAmount * 0.5f;
        }
        this.animateDancing(entity, danceProgress, ageInTicks);
        this.progressPositionPrev(this.torso, swimProgress, 0.0f, 20.0f, 0.0f, 1.0f);
        this.progressPositionPrev(this.head, swimProgress, 0.0f, 5.0f, 5.0f, 1.0f);
        this.progressPositionPrev(this.neck, swimProgress, 0.0f, 3.0f, -5.0f, 1.0f);
        this.progressPositionPrev(this.leftLeg, swimProgress, 2.0f, 15.0f, 0.0f, 1.0f);
        this.progressPositionPrev(this.rightLeg, swimProgress, -2.0f, 15.0f, 0.0f, 1.0f);
        this.progressPositionPrev(this.neck, swimProgress, 0.0f, 3.0f, -5.0f, 1.0f);
        this.progressRotationPrev(this.torso, swimProgress, (float)Math.toRadians(70.0), 0.0f, 0.0f, 1.0f);
        this.progressRotationPrev(this.tail1, swimProgress, (float)Math.toRadians(-70.0), 0.0f, 0.0f, 1.0f);
        this.progressRotationPrev(this.neck, swimProgress, (float)Math.toRadians(-10.0), 0.0f, 0.0f, 1.0f);
        this.progressRotationPrev(this.head, swimProgress, (float)Math.toRadians(-40.0), 0.0f, 0.0f, 1.0f);
        this.progressRotationPrev(this.rightArm, swimProgress, (float)Math.toRadians(-50.0), (float)Math.toRadians(-60.0), (float)Math.toRadians(-30.0), 1.0f);
        this.progressRotationPrev(this.leftArm, swimProgress, (float)Math.toRadians(-50.0), (float)Math.toRadians(60.0), (float)Math.toRadians(30.0), 1.0f);
        this.progressPositionPrev(this.neck, burnProgress, 0.0f, -10.0f, -8.0f, 1.0f);
        this.progressPositionPrev(this.head, burnProgress, 0.0f, 2.5f, 5.0f, 1.0f);
        this.progressPositionPrev(this.chest, burnProgress, 0.0f, -5.0f, -5.0f, 1.0f);
        this.progressRotationPrev(this.jaw, burnProgress, (float)Math.toRadians(70.0), 0.0f, 0.0f, 1.0f);
        this.progressRotationPrev(this.head, burnProgress, (float)Math.toRadians(-110.0), 0.0f, 0.0f, 1.0f);
        this.progressRotationPrev(this.neck, burnProgress, (float)Math.toRadians(50.0), 0.0f, 0.0f, 1.0f);
        this.progressRotationPrev(this.chest, burnProgress, (float)Math.toRadians(20.0), 0.0f, 0.0f, 1.0f);
        this.progressPositionPrev(this.tail3Spikes, spikes1Down, 0.0f, 8.0f, 0.0f, 1.0f);
        this.progressPositionPrev(this.tail2Spikes, spikes2Down, 0.0f, 16.0f, 0.0f, 1.0f);
        this.progressPositionPrev(this.tail1Spikes, spikes3Down, 0.0f, 22.0f, 0.0f, 1.0f);
        this.progressPositionPrev(this.tail1Spike1, spikes3Down, -6.0f, 0.0f, 0.0f, 1.0f);
        this.progressPositionPrev(this.tail1Spike2, spikes3Down, 6.0f, 0.0f, 0.0f, 1.0f);
        this.progressPositionPrev(this.torsoSpikes, spikes4Down, 0.0f, 10.0f, -27.0f, 1.0f);
        this.progressPositionPrev(this.torsoSpike2, spikes4Down, 12.0f, 0.0f, 0.0f, 1.0f);
        this.progressPositionPrev(this.torsoSpike3, spikes4Down, -12.0f, 0.0f, 0.0f, 1.0f);
        this.progressPositionPrev(this.chestSpikes, spikes5Down, 0.0f, 20.0f, -22.0f, 1.0f);
        this.progressPositionPrev(this.chestSpike2, spikes5Down, -10.0f, 0.0f, 0.0f, 1.0f);
        this.progressPositionPrev(this.chestSpike3, spikes5Down, 10.0f, 0.0f, 0.0f, 1.0f);
        this.progressPositionPrev(this.neckSpikes, spikes6Down, 0.0f, 4.0f, -7.0f, 1.0f);
        this.progressPositionPrev(this.leftArm, limbSwingAmountGround, 0.0f, -3.0f, -5.0f, 1.0f);
        this.progressPositionPrev(this.rightArm, limbSwingAmountGround, 0.0f, -3.0f, -5.0f, 1.0f);
        this.progressPositionPrev(this.torso, sitProgress, 0.0f, 5.0f, -5.0f, 1.0f);
        this.progressPositionPrev(this.leftLeg, sitProgress, 0.0f, 8.0f, 10.0f, 1.0f);
        this.progressPositionPrev(this.rightLeg, sitProgress, 0.0f, 8.0f, 10.0f, 1.0f);
        this.progressPositionPrev(this.tail1, sitProgress, 0.0f, 0.0f, -20.0f, 1.0f);
        this.progressPositionPrev(this.neck, sitProgress, 0.0f, 5.0f, -5.0f, 1.0f);
        this.progressPositionPrev(this.head, sitProgress, 0.0f, 0.0f, 5.0f, 1.0f);
        this.progressPositionPrev(this.torsoSpikes, sitProgress, 0.0f, 9.0f, -3.0f, 1.0f);
        this.progressRotationPrev(this.torso, sitProgress, (float)Math.toRadians(80.0), 0.0f, 0.0f, 1.0f);
        this.progressRotationPrev(this.chest, sitProgress, (float)Math.toRadians(10.0), 0.0f, 0.0f, 1.0f);
        this.progressRotationPrev(this.leftLeg, sitProgress, (float)Math.toRadians(-80.0), 0.0f, 0.0f, 1.0f);
        this.progressRotationPrev(this.rightLeg, sitProgress, (float)Math.toRadians(-80.0), 0.0f, 0.0f, 1.0f);
        this.progressRotationPrev(this.tail1, sitProgress, (float)Math.toRadians(-90.0), (float)Math.toRadians(-20.0), (float)Math.toRadians(-10.0), 1.0f);
        this.progressRotationPrev(this.neck, sitProgress, (float)Math.toRadians(-25.0), 0.0f, (float)Math.toRadians(30.0), 1.0f);
        this.progressRotationPrev(this.head, sitProgress, (float)Math.toRadians(-40.0), (float)Math.toRadians(-20.0), (float)Math.toRadians(20.0), 1.0f);
        this.progressRotationPrev(this.rightArm, sitProgress, (float)Math.toRadians(-90.0), (float)Math.toRadians(-50.0), (float)Math.toRadians(50.0), 1.0f);
        this.progressRotationPrev(this.leftArm, sitProgress, (float)Math.toRadians(-90.0), (float)Math.toRadians(50.0), (float)Math.toRadians(-20.0), 1.0f);
        this.progressRotationPrev(this.chestSpikes, sitProgress, (float)Math.toRadians(-20.0), 0.0f, 0.0f, 1.0f);
        this.progressRotationPrev(this.torsoSpikes, sitProgress, (float)Math.toRadians(-40.0), 0.0f, 0.0f, 1.0f);
        float bodyIdleBob = ACMath.walkValue(ageInTicks, 1.0f, 0.025f, -1.0f, 3.0f, false) * standProgress;
        this.walk(this.neck, 0.025f, 0.03f, false, 1.0f, 0.0f, ageInTicks, 1.0f);
        this.walk(this.head, 0.025f, 0.03f, true, 2.0f, -0.03f, ageInTicks, 1.0f);
        this.walk(this.jaw, 0.025f, 0.03f, true, 3.0f, 0.0f, ageInTicks, 1.0f);
        this.swing(this.tail1, 0.025f, 0.05f, true, -1.0f, 0.0f, ageInTicks, 1.0f);
        this.swing(this.tail2, 0.025f, 0.05f, true, -2.0f, 0.0f, ageInTicks, 1.0f);
        this.swing(this.tail3, 0.025f, 0.1f, true, -3.0f, 0.0f, ageInTicks, 1.0f);
        this.flap(this.leftArm, 0.025f, 0.1f, true, 1.0f, -0.1f, ageInTicks, 1.0f);
        this.swing(this.leftArm, 0.025f, 0.1f, true, 2.0f, -0.1f, ageInTicks, 1.0f);
        this.flap(this.rightArm, 0.025f, 0.1f, false, 1.0f, -0.1f, ageInTicks, 1.0f);
        this.swing(this.rightArm, 0.025f, 0.1f, false, 2.0f, -0.1f, ageInTicks, 1.0f);
        this.walk(this.chest, 0.025f, 0.03f, true, -1.0f, -0.02f, ageInTicks, 1.0f);
        float bodyWalkBob = -Math.abs(ACMath.walkValue(limbSwing, limbSwingAmountGround, walkSpeed, -1.5f, 6.0f, false));
        this.torso.rotationPointY += bodyIdleBob + bodyWalkBob;
        this.leftLeg.rotationPointY -= (bodyIdleBob + bodyWalkBob) * groundProgress;
        this.rightLeg.rotationPointY -= (bodyIdleBob + bodyWalkBob) * groundProgress;
        this.tail1.rotationPointY -= (bodyIdleBob + bodyWalkBob) * groundProgress;
        this.walk(this.torso, walkSpeed, walkDegree * 0.05f, true, 1.5f, -0.2f, limbSwing, limbSwingAmountGround);
        this.walk(this.leftLeg, walkSpeed, walkDegree * 0.05f, false, 1.5f, -0.2f, limbSwing, limbSwingAmountGround);
        this.walk(this.rightLeg, walkSpeed, walkDegree * 0.05f, false, 1.5f, -0.2f, limbSwing, limbSwingAmountGround);
        this.walk(this.tail1, walkSpeed, walkDegree * 0.05f, false, 1.5f, -0.2f, limbSwing, limbSwingAmountGround);
        this.swing(this.tail1, walkSpeed, walkDegree * 0.05f, false, 2.0f, 0.0f, limbSwing, limbSwingAmountGround);
        this.swing(this.tail2, walkSpeed, walkDegree * 0.05f, false, 1.0f, 0.0f, limbSwing, limbSwingAmountGround);
        this.swing(this.tail3, walkSpeed, walkDegree * 0.05f, false, 0.0f, 0.0f, limbSwing, limbSwingAmountGround);
        this.swing(this.tail4, walkSpeed, walkDegree * 0.1f, false, -1.0f, 0.0f, limbSwing, limbSwingAmountGround);
        this.swing(this.leftArm, walkSpeed, walkDegree * 0.2f, false, -2.0f, 0.45f, limbSwing, limbSwingAmountGround);
        this.swing(this.rightArm, walkSpeed, walkDegree * 0.2f, false, -2.0f, -0.45f, limbSwing, limbSwingAmountGround);
        this.walk(this.neck, walkSpeed, walkDegree * 0.05f, true, 1.0f, -0.1f, limbSwing, limbSwingAmountGround);
        this.walk(this.head, walkSpeed, walkDegree * 0.05f, true, 2.5f, 0.2f, limbSwing, limbSwingAmountGround);
        this.walk(this.leftLeg, walkSpeed, walkDegree * 0.2f, false, 1.5f, 0.0f, limbSwing, limbSwingAmountGround);
        this.leftLeg.rotationPointY += Math.min(0.0f, ACMath.walkValue(limbSwing, limbSwingAmountGround, walkSpeed, -0.5f, 20.0f, true));
        this.leftLeg.rotationPointZ += Math.min(0.0f, ACMath.walkValue(limbSwing, limbSwingAmountGround, walkSpeed, -1.0f, 5.0f, true));
        this.walk(this.rightLeg, walkSpeed, walkDegree * 0.2f, true, 1.5f, 0.0f, limbSwing, limbSwingAmountGround);
        this.rightLeg.rotationPointY += Math.min(0.0f, ACMath.walkValue(limbSwing, limbSwingAmountGround, walkSpeed, -0.5f, 20.0f, false));
        this.rightLeg.rotationPointZ += Math.min(0.0f, ACMath.walkValue(limbSwing, limbSwingAmountGround, walkSpeed, -1.0f, 5.0f, false));
        this.bob(this.root, swimSpeed, 4.0f, false, limbSwing, limbSwingAmountSwim);
        this.swing(this.tail2, swimSpeed, 0.1f, true, -2.0f, 0.0f, limbSwing, limbSwingAmountSwim);
        this.swing(this.tail3, swimSpeed, 0.2f, true, -3.0f, 0.0f, limbSwing, limbSwingAmountSwim);
        this.swing(this.rightArm, swimSpeed, 0.5f, true, -1.0f, -0.5f, limbSwing, limbSwingAmountSwim);
        this.flap(this.rightArm, swimSpeed, 0.2f, true, -2.0f, -0.4f, limbSwing, limbSwingAmountSwim);
        this.swing(this.leftArm, swimSpeed, 0.5f, true, -1.0f, 0.5f, limbSwing, limbSwingAmountSwim);
        this.flap(this.leftArm, swimSpeed, 0.2f, true, -2.0f, 0.4f, limbSwing, limbSwingAmountSwim);
        this.walk(this.leftLeg, swimSpeed, 0.3f, true, -4.0f, 0.1f, limbSwing, limbSwingAmountSwim);
        this.flap(this.leftLeg, swimSpeed, 0.1f, false, -4.0f, -0.1f, limbSwing, limbSwingAmountSwim);
        this.walk(this.rightLeg, swimSpeed, 0.3f, false, -4.0f, -0.1f, limbSwing, limbSwingAmountSwim);
        this.flap(this.rightLeg, swimSpeed, 0.1f, true, -4.0f, -0.1f, limbSwing, limbSwingAmountSwim);
        this.swing(this.torso, swimSpeed, 0.05f, true, -3.0f, 0.0f, limbSwing, limbSwingAmountSwim);
        this.flap(this.chest, swimSpeed, 0.1f, true, -3.0f, 0.0f, limbSwing, limbSwingAmountSwim);
        this.flap(this.neck, swimSpeed, 0.2f, true, -3.0f, 0.0f, limbSwing, limbSwingAmountSwim);
        this.flap(this.head, swimSpeed, 0.2f, false, -3.0f, 0.0f, limbSwing, limbSwingAmountSwim);
        this.flap(this.chest, 1.0f, 0.03f, true, -1.0f, 0.0f, ageInTicks, burnProgress);
        this.flap(this.neck, 2.0f, 0.03f, true, -2.0f, 0.0f, ageInTicks, burnProgress);
        this.flap(this.head, 2.0f, 0.03f, true, -2.0f, 0.0f, ageInTicks, burnProgress);
        this.walk(this.jaw, 0.4f, 0.1f, true, -1.0f, 0.0f, ageInTicks, burnProgress);
        this.walk(this.head, 0.4f, 0.1f, false, 0.0f, 0.0f, ageInTicks, burnProgress);
        if (burnProgress > 0.0f && burnPos != null) {
            Vec3 vector3d = burnPos;
            Vec3 vector3d1 = entity.getBeamShootFrom(partialTicks);
            Vec3 normalized = burnPos.m_82546_(vector3d1).m_82541_();
            double d0 = Mth.m_14008_((double)normalized.f_82480_, (double)-1.0, (double)1.0) * Math.PI / 2.0;
            Vec3 vector3d2 = entity.getBodyRotViewVector(0.0f);
            vector3d2 = new Vec3(vector3d2.f_82479_, 0.0, vector3d2.f_82481_);
            Vec3 vector3d3 = new Vec3(vector3d.f_82479_ - vector3d1.f_82479_, 0.0, vector3d.f_82481_ - vector3d1.f_82481_).m_82541_().m_82524_(1.5707964f);
            double d1 = vector3d2.m_82526_(vector3d3);
            float xRotBy = (float)(d0 * (double)burnProgress);
            this.neck.rotateAngleX -= xRotBy * 0.5f;
            this.head.rotateAngleX -= xRotBy * 0.5f;
            this.neck.rotateAngleY = (float)((double)this.neck.rotateAngleY + d1 * (double)burnProgress);
            if (xRotBy > 0.0f) {
                this.neck.rotationPointY += 5.0f * xRotBy;
                this.neck.rotationPointZ += 5.0f * xRotBy;
                this.head.rotationPointZ += 5.0f * xRotBy;
            }
        }
        if (!entity.isTremorzillaSwimming()) {
            this.neck.rotateAngleY += headYawAmount * 0.5f;
            this.head.rotateAngleY += headYawAmount * 0.5f;
        }
        this.neck.rotateAngleX += headPitchAmount * 0.5f;
        this.head.rotateAngleX += headPitchAmount * 0.5f;
    }

    public void showSpikesBasedOnProgress(float spikesDownProgress, float threshold) {
        boolean spikes1Down = TremorzillaEntity.calculateSpikesDownAmountAtIndex(spikesDownProgress, 6.0f, 0.0f) > threshold;
        boolean spikes2Down = TremorzillaEntity.calculateSpikesDownAmountAtIndex(spikesDownProgress, 6.0f, 1.0f) > threshold;
        boolean spikes3Down = TremorzillaEntity.calculateSpikesDownAmountAtIndex(spikesDownProgress, 6.0f, 2.0f) > threshold;
        boolean spikes4Down = TremorzillaEntity.calculateSpikesDownAmountAtIndex(spikesDownProgress, 6.0f, 3.0f) > threshold;
        boolean spikes5Down = TremorzillaEntity.calculateSpikesDownAmountAtIndex(spikesDownProgress, 6.0f, 4.0f) > threshold;
        boolean spikes6Down = TremorzillaEntity.calculateSpikesDownAmountAtIndex(spikesDownProgress, 6.0f, 5.0f) > threshold;
        this.tail3.showModel = spikes1Down;
        this.tail3Spikes.showModel = spikes1Down;
        this.tail2.showModel = spikes2Down;
        this.tail2Spikes.showModel = spikes2Down;
        this.tail1.showModel = spikes3Down;
        this.tail1Spikes.showModel = spikes3Down;
        this.tail1Spike1.showModel = spikes3Down;
        this.tail1Spike2.showModel = spikes3Down;
        this.torso.showModel = spikes4Down;
        this.torsoSpikes.showModel = spikes4Down;
        this.torsoSpike1.showModel = spikes4Down;
        this.torsoSpike2.showModel = spikes4Down;
        this.torsoSpike3.showModel = spikes4Down;
        this.chest.showModel = spikes5Down;
        this.neck.showModel = spikes6Down;
    }

    public void showAllSpikes() {
        this.tail3.showModel = true;
        this.tail3Spikes.showModel = true;
        this.tail2.showModel = true;
        this.tail2Spikes.showModel = true;
        this.tail1.showModel = true;
        this.tail1Spikes.showModel = true;
        this.tail1Spike1.showModel = true;
        this.tail1Spike2.showModel = true;
        this.torso.showModel = true;
        this.torsoSpikes.showModel = true;
        this.torsoSpike1.showModel = true;
        this.torsoSpike2.showModel = true;
        this.torsoSpike3.showModel = true;
        this.chest.showModel = true;
        this.neck.showModel = true;
    }

    private void positionTail(TremorzillaEntity entity, float partialTicks) {
        float tailPart1Pitch = (float)Math.toRadians(entity.tailPart1.calculateAnimationAngle(partialTicks, true));
        float tailPart2Pitch = (float)Math.toRadians(entity.tailPart2.calculateAnimationAngle(partialTicks, true));
        float f = entity.tailPart3.calculateAnimationAngle(partialTicks, true) + entity.tailPart4.calculateAnimationAngle(partialTicks, true);
        float tailPart3Pitch = (float)Math.toRadians(Mth.m_14177_((float)f) * 0.25f);
        float f1 = entity.tailPart4.calculateAnimationAngle(partialTicks, true) + entity.tailPart5.calculateAnimationAngle(partialTicks, true);
        float tailPart4Pitch = (float)Math.toRadians(Mth.m_14177_((float)f1) * 0.25f);
        float tailPart1Yaw = (float)Math.toRadians(entity.tailPart1.calculateAnimationAngle(partialTicks, false));
        float tailPart2Yaw = (float)Math.toRadians(entity.tailPart2.calculateAnimationAngle(partialTicks, false));
        float f2 = entity.tailPart3.calculateAnimationAngle(partialTicks, false) + entity.tailPart4.calculateAnimationAngle(partialTicks, false);
        float tailPart3Yaw = (float)Math.toRadians(Mth.m_14177_((float)f2) * 0.25f);
        float f3 = entity.tailPart4.calculateAnimationAngle(partialTicks, false) + entity.tailPart5.calculateAnimationAngle(partialTicks, false);
        float tailPart4Yaw = (float)Math.toRadians(Mth.m_14177_((float)f3) * 0.25f);
        this.tail1.rotateAngleY += tailPart1Yaw;
        this.tail1.rotateAngleX += tailPart1Pitch;
        this.tail2.rotateAngleY += tailPart2Yaw;
        this.tail2.rotateAngleX += tailPart2Pitch;
        this.tail3.rotateAngleY += tailPart3Yaw;
        this.tail3.rotateAngleX += tailPart3Pitch;
        this.tail4.rotateAngleY += tailPart4Yaw;
        this.tail4.rotateAngleX += tailPart4Pitch;
    }

    private void articulateLegs(TremorzillaLegSolver legs, float partialTick, float modifier) {
        float heightBackLeft = legs.legs[0].getHeight(partialTick);
        float heightBackRight = legs.legs[1].getHeight(partialTick);
        float max = (1.0f - ACMath.smin(1.0f - heightBackLeft, 1.0f - heightBackRight, 0.1f)) * 0.8f;
        this.root.rotationPointY += max * 16.0f * modifier;
        this.rightLeg.rotationPointY += (heightBackRight - max) * 16.0f * modifier;
        this.leftLeg.rotationPointY += (heightBackLeft - max) * 16.0f * modifier;
    }

    private void animateDancing(TremorzillaEntity entity, float danceAmount, float ageInTicks) {
        float danceSpeed = 0.2f;
        this.root.rotationPointY -= Math.abs(ACMath.walkValue(ageInTicks, danceAmount, danceSpeed, -1.0f, 50.0f, true));
        this.swing(this.root, danceSpeed, 0.2f, true, 0.5f, 0.0f, ageInTicks, danceAmount);
        this.swing(this.neck, danceSpeed, 0.2f, false, 1.0f, 0.0f, ageInTicks, danceAmount);
        this.swing(this.tail1, danceSpeed, 0.2f, false, 1.0f, 0.0f, ageInTicks, danceAmount);
        this.swing(this.tail2, danceSpeed, 0.1f, false, 2.0f, 0.0f, ageInTicks, danceAmount);
        this.swing(this.tail4, danceSpeed, 0.1f, false, 3.0f, 0.0f, ageInTicks, danceAmount);
        this.walk(this.leftLeg, danceSpeed, 0.6f, false, 0.5f, 0.0f, ageInTicks, danceAmount);
        this.flap(this.leftLeg, danceSpeed, 0.1f, false, 2.0f, 0.1f, ageInTicks, danceAmount);
        this.walk(this.rightLeg, danceSpeed, 0.6f, true, 1.5f, 0.0f, ageInTicks, danceAmount);
        this.flap(this.rightLeg, danceSpeed, 0.1f, true, 2.0f, 0.1f, ageInTicks, danceAmount);
        this.walk(this.rightArm, danceSpeed, 0.75f, false, 1.5f, -0.5f, ageInTicks, danceAmount);
        this.swing(this.rightArm, danceSpeed, 0.75f, false, 1.0f, -0.4f, ageInTicks, danceAmount);
        this.walk(this.leftArm, danceSpeed, 0.75f, true, 1.5f, 0.5f, ageInTicks, danceAmount);
        this.swing(this.leftArm, danceSpeed, 0.75f, false, 1.0f, 0.4f, ageInTicks, danceAmount);
    }

    private void setupAnimForAnimation(TremorzillaEntity entity, Animation animation, float limbSwing, float limbSwingAmount, float ageInTicks) {
        float partialTick = ageInTicks - (float)entity.f_19797_;
        if (entity.getAnimation() == TremorzillaEntity.ANIMATION_ROAR_1 || entity.getAnimation() == TremorzillaEntity.ANIMATION_ROAR_2) {
            float animationIntensity = 0.0f;
            float neckSide = 1.0f;
            if (entity.getAnimation() == TremorzillaEntity.ANIMATION_ROAR_1) {
                animationIntensity = ACMath.cullAnimationTick(entity.getAnimationTick(), 1.0f, animation, partialTick, 10, 50);
            } else {
                neckSide = 0.2f;
                animationIntensity = ACMath.cullAnimationTick(entity.getAnimationTick(), 1.0f, animation, partialTick, 15, 50);
            }
            this.neck.swing(0.2f, neckSide * 0.7f, false, 0.0f, 0.0f, ageInTicks, animationIntensity);
            this.neck.walk(0.2f, neckSide * 0.3f, false, 1.0f, 0.0f, ageInTicks, animationIntensity);
            this.chest.swing(0.2f, 0.1f, false, 0.0f, 0.0f, ageInTicks, animationIntensity);
            this.chest.walk(0.2f, 0.05f, false, 1.0f, 0.0f, ageInTicks, animationIntensity);
            this.head.swing(0.2f, neckSide * 0.3f, false, 1.0f, 0.0f, ageInTicks, animationIntensity);
            this.head.swing(1.0f, 0.1f, false, -1.0f, 0.0f, ageInTicks, animationIntensity);
            this.head.walk(0.2f, 0.3f, false, 2.0f, -0.2f, ageInTicks, animationIntensity);
            this.jaw.walk(2.0f, 0.1f, false, 1.0f, 0.0f, ageInTicks, animationIntensity);
        }
    }

    public Vec3 getMouthPosition(Vec3 offsetIn) {
        PoseStack translationStack = new PoseStack();
        translationStack.m_85836_();
        this.root.translateAndRotate(translationStack);
        this.torso.translateAndRotate(translationStack);
        this.chest.translateAndRotate(translationStack);
        this.neck.translateAndRotate(translationStack);
        this.head.translateAndRotate(translationStack);
        Vector4f armOffsetVec = new Vector4f((float)offsetIn.f_82479_, (float)offsetIn.f_82480_, (float)offsetIn.f_82481_, 1.0f);
        armOffsetVec.mul((Matrix4fc)translationStack.m_85850_().m_252922_());
        Vec3 vec3 = new Vec3((double)(-armOffsetVec.x()), (double)(-armOffsetVec.y()), (double)armOffsetVec.z());
        translationStack.m_85849_();
        return vec3.m_82520_(0.0, 1.25, 0.0);
    }

    public void translateToNeck(PoseStack translationStack) {
        this.root.translateAndRotate(translationStack);
        this.torso.translateAndRotate(translationStack);
        this.chest.translateAndRotate(translationStack);
        this.neck.translateAndRotate(translationStack);
        this.head.translateAndRotate(translationStack);
    }

    public Iterable<BasicModelPart> parts() {
        return ImmutableList.of((Object)this.root);
    }

    public Iterable<AdvancedModelBox> getAllParts() {
        return ImmutableList.of((Object)this.root, (Object)((Object)this.torso), (Object)this.torsoSpikes, (Object)this.rightLeg, (Object)this.leftLeg, (Object)this.chest, (Object)this.chestSpikes, (Object)this.neck, (Object)this.neckSlope, (Object)this.rightArm, (Object)this.leftArm, (Object)this.rightThumb, (Object[])new AdvancedModelBox[]{this.leftThumb, this.head, this.jaw, this.rightEar, this.leftEar, this.neckSpikes, this.tail1, this.tail1Spikes, this.tail2, this.tail2Spikes, this.tail3, this.tail3Spikes, this.tail4, this.torsoSpike1, this.torsoSpike2, this.torsoSpike3, this.tail1Spike1, this.tail1Spike2, this.cube_r6, this.chestSpike1, this.chestSpike2, this.chestSpike3});
    }
}

