/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.render.entity;

import com.github.alexmodguy.alexscaves.client.model.NucleeperModel;
import com.github.alexmodguy.alexscaves.client.render.ACRenderTypes;
import com.github.alexmodguy.alexscaves.server.entity.living.NucleeperEntity;
import com.github.alexmodguy.alexscaves.server.misc.ACMath;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.ForgeRenderTypes;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class NucleeperRenderer
extends MobRenderer<NucleeperEntity, NucleeperModel> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("alexscaves:textures/entity/nucleeper/nucleeper.png");
    private static final ResourceLocation TEXTURE_GLOW = new ResourceLocation("alexscaves:textures/entity/nucleeper/nucleeper_glow.png");
    private static final ResourceLocation TEXTURE_GLASS = new ResourceLocation("alexscaves:textures/entity/nucleeper/nucleeper_glass.png");
    private static final ResourceLocation TEXTURE_BUTTONS_0 = new ResourceLocation("alexscaves:textures/entity/nucleeper/nucleeper_buttons_0.png");
    private static final ResourceLocation TEXTURE_BUTTONS_1 = new ResourceLocation("alexscaves:textures/entity/nucleeper/nucleeper_buttons_1.png");
    private static final ResourceLocation TEXTURE_BUTTONS_2 = new ResourceLocation("alexscaves:textures/entity/nucleeper/nucleeper_buttons_2.png");
    private static final ResourceLocation TEXTURE_EXPLODE = new ResourceLocation("alexscaves:textures/entity/nucleeper/nucleeper_explode.png");

    public NucleeperRenderer(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn, (EntityModel)new NucleeperModel(), 0.8f);
        this.m_115326_(new LayerGlow());
    }

    protected void scale(NucleeperEntity mob, PoseStack poseStack, float partialTicks) {
    }

    public ResourceLocation getTextureLocation(NucleeperEntity entity) {
        return TEXTURE;
    }

    private static void shineOriginVertex(VertexConsumer p_114220_, Matrix4f p_114221_, Matrix3f p_114092_, float xOffset, float yOffset) {
        p_114220_.m_252986_(p_114221_, 0.0f, 0.0f, 0.0f).m_6122_(0, 255, 0, 230).m_7421_(xOffset + 0.5f, yOffset).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(p_114092_, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    private static void shineLeftCornerVertex(VertexConsumer p_114215_, Matrix4f p_114216_, Matrix3f p_114092_, float p_114217_, float p_114218_, float xOffset, float yOffset) {
        p_114215_.m_252986_(p_114216_, -ACMath.HALF_SQRT_3 * p_114218_, p_114217_, 0.0f).m_6122_(0, 255, 0, 0).m_7421_(xOffset, yOffset + 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(p_114092_, 0.0f, -1.0f, 0.0f).m_5752_();
    }

    private static void shineRightCornerVertex(VertexConsumer p_114224_, Matrix4f p_114225_, Matrix3f p_114092_, float p_114226_, float p_114227_, float xOffset, float yOffset) {
        p_114224_.m_252986_(p_114225_, ACMath.HALF_SQRT_3 * p_114227_, p_114226_, 0.0f).m_6122_(0, 255, 0, 0).m_7421_(xOffset + 1.0f, yOffset + 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(p_114092_, 0.0f, -1.0f, 0.0f).m_5752_();
    }

    public void render(NucleeperEntity entityIn, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn) {
        float closeProgress = entityIn.getCloseProgress(partialTicks);
        if (closeProgress > 0.0f && entityIn.m_6084_() && !entityIn.isExploding()) {
            float sq = Mth.m_14116_((float)closeProgress);
            float length = sq * 3.0f;
            float width = (1.0f - sq) * 1.25f;
            Vec3 modelOffset = ((NucleeperModel)this.f_115290_).getSirenPosition(new Vec3(0.0, -0.5, 0.0));
            poseStack.m_85836_();
            poseStack.m_85837_(modelOffset.f_82479_, modelOffset.f_82480_, modelOffset.f_82481_);
            poseStack.m_252781_(Axis.f_252436_.m_252977_(entityIn.getSirenAngle(partialTicks)));
            poseStack.m_85836_();
            poseStack.m_252781_(Axis.f_252393_.m_252977_(90.0f));
            PoseStack.Pose posestack$pose = poseStack.m_85850_();
            Matrix4f matrix4f1 = posestack$pose.m_252922_();
            Matrix3f matrix3f1 = posestack$pose.m_252943_();
            VertexConsumer lightConsumer = bufferIn.m_6299_(ACRenderTypes.getNucleeperLights());
            NucleeperRenderer.shineOriginVertex(lightConsumer, matrix4f1, matrix3f1, 0.0f, 0.0f);
            NucleeperRenderer.shineLeftCornerVertex(lightConsumer, matrix4f1, matrix3f1, length, width, 0.0f, 0.0f);
            NucleeperRenderer.shineRightCornerVertex(lightConsumer, matrix4f1, matrix3f1, length, width, 0.0f, 0.0f);
            NucleeperRenderer.shineLeftCornerVertex(lightConsumer, matrix4f1, matrix3f1, length, width, 0.0f, 0.0f);
            Matrix4f matrix4f2 = posestack$pose.m_252922_();
            Matrix3f matrix3f2 = posestack$pose.m_252943_();
            poseStack.m_252781_(Axis.f_252393_.m_252977_(180.0f));
            NucleeperRenderer.shineOriginVertex(lightConsumer, matrix4f2, matrix3f2, 0.0f, 0.0f);
            NucleeperRenderer.shineLeftCornerVertex(lightConsumer, matrix4f2, matrix3f2, length, width, 0.0f, 0.0f);
            NucleeperRenderer.shineRightCornerVertex(lightConsumer, matrix4f2, matrix3f2, length, width, 0.0f, 0.0f);
            NucleeperRenderer.shineLeftCornerVertex(lightConsumer, matrix4f2, matrix3f2, length, width, 0.0f, 0.0f);
            poseStack.m_85849_();
            poseStack.m_85849_();
        }
        super.m_7392_((Mob)entityIn, entityYaw, partialTicks, poseStack, bufferIn, packedLightIn);
    }

    class LayerGlow
    extends RenderLayer<NucleeperEntity, NucleeperModel> {
        public LayerGlow() {
            super((RenderLayerParent)NucleeperRenderer.this);
        }

        public void render(PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn, NucleeperEntity entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            float alpha = (float)(1.0 + Math.sin(ageInTicks * 0.3f)) * 0.25f + 0.5f;
            float explodeProgress = entitylivingbaseIn.getExplodeProgress(partialTicks);
            VertexConsumer ivertexbuilder1 = bufferIn.m_6299_(ACRenderTypes.getEyesAlphaEnabled(TEXTURE_GLOW));
            ((NucleeperModel)this.m_117386_()).m_7695_(poseStack, ivertexbuilder1, packedLightIn, LivingEntityRenderer.m_115338_((LivingEntity)entitylivingbaseIn, (float)0.0f), 1.0f, 1.0f, 1.0f, alpha);
            VertexConsumer ivertexbuilder2 = bufferIn.m_6299_(ForgeRenderTypes.getUnlitTranslucent((ResourceLocation)TEXTURE_GLASS));
            ((NucleeperModel)this.m_117386_()).m_7695_(poseStack, ivertexbuilder2, packedLightIn, LivingEntityRenderer.m_115338_((LivingEntity)entitylivingbaseIn, (float)0.0f), 1.0f, 1.0f, 1.0f, 1.0f);
            int buttonDiv = entitylivingbaseIn.f_19797_ / 5 % 6;
            ResourceLocation buttons = buttonDiv < 2 ? TEXTURE_BUTTONS_0 : (buttonDiv < 4 ? TEXTURE_BUTTONS_1 : TEXTURE_BUTTONS_2);
            VertexConsumer ivertexbuilder3 = bufferIn.m_6299_(RenderType.m_110488_((ResourceLocation)buttons));
            ((NucleeperModel)this.m_117386_()).m_7695_(poseStack, ivertexbuilder3, packedLightIn, LivingEntityRenderer.m_115338_((LivingEntity)entitylivingbaseIn, (float)0.0f), 1.0f, 1.0f, 1.0f, 1.0f);
            VertexConsumer ivertexbuilder4 = bufferIn.m_6299_(ACRenderTypes.getEyesAlphaEnabled(TEXTURE_EXPLODE));
            ((NucleeperModel)this.m_117386_()).m_7695_(poseStack, ivertexbuilder4, packedLightIn, LivingEntityRenderer.m_115338_((LivingEntity)entitylivingbaseIn, (float)0.0f), 1.0f, 1.0f, 1.0f, explodeProgress);
        }
    }
}

