/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.render.entity;

import com.github.alexmodguy.alexscaves.client.model.TephraModel;
import com.github.alexmodguy.alexscaves.client.render.ACRenderTypes;
import com.github.alexmodguy.alexscaves.server.entity.item.TephraEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class TephraRenderer
extends EntityRenderer<TephraEntity> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("alexscaves", "textures/entity/tephra.png");
    private static final TephraModel MODEL = new TephraModel();
    private static final ResourceLocation TRAIL_TEXTURE = new ResourceLocation("alexscaves", "textures/particle/teletor_trail.png");

    public TephraRenderer(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn);
    }

    public void render(TephraEntity entityIn, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn) {
        float scale = entityIn.getLerpedScale(partialTicks) == 0.0f ? 1.0f : entityIn.getLerpedScale(partialTicks);
        float glowAmount = scale / Math.max(entityIn.getMaxScale(), 1.0f);
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, 0.25f, 0.0f);
        poseStack.m_85841_(scale, scale, scale);
        MODEL.setupAnim(entityIn, 0.0f, 0.0f, (float)entityIn.f_19797_ + partialTicks, 0.0f, 0.0f);
        VertexConsumer ivertexbuilder1 = bufferIn.m_6299_(RenderType.m_110458_((ResourceLocation)TEXTURE));
        MODEL.m_7695_(poseStack, ivertexbuilder1, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        VertexConsumer ivertexbuilder2 = bufferIn.m_6299_(ACRenderTypes.getEyesAlphaEnabled(TEXTURE));
        MODEL.m_7695_(poseStack, ivertexbuilder2, 240, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, glowAmount);
        poseStack.m_85849_();
        super.m_7392_((Entity)entityIn, entityYaw, partialTicks, poseStack, bufferIn, packedLightIn);
    }

    public ResourceLocation getTextureLocation(TephraEntity entity) {
        return TEXTURE;
    }
}

