/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.render.entity.layer;

import com.github.alexmodguy.alexscaves.AlexsCaves;
import com.github.alexmodguy.alexscaves.client.model.ForsakenModel;
import com.github.alexmodguy.alexscaves.client.render.entity.ForsakenRenderer;
import com.github.alexmodguy.alexscaves.server.entity.living.ForsakenEntity;
import com.github.alexmodguy.alexscaves.server.misc.ACMath;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public class ForsakenHeldMobLayer
extends RenderLayer<ForsakenEntity, ForsakenModel> {
    public ForsakenHeldMobLayer(ForsakenRenderer render) {
        super((RenderLayerParent)render);
    }

    public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, ForsakenEntity forsaken, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        Entity heldMob = forsaken.getHeldMob();
        if (heldMob != null) {
            float rightAmount;
            AlexsCaves.PROXY.releaseRenderingEntity(heldMob.m_20148_());
            float vehicleRot = forsaken.f_20884_ + (forsaken.f_20883_ - forsaken.f_20884_) * partialTicks;
            float riderRot = 0.0f;
            float animationIntensity = ACMath.cullAnimationTick(forsaken.getAnimationTick(), 1.0f, forsaken.getAnimation(), partialTicks, 25, 30) * 0.75f;
            boolean right = forsaken.getAnimation() == ForsakenEntity.ANIMATION_RIGHT_PICKUP;
            float f = rightAmount = right ? 1.0f : -1.0f;
            if (heldMob instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)heldMob;
                riderRot = living.f_20884_ + (living.f_20883_ - living.f_20884_) * partialTicks;
            }
            matrixStackIn.m_85836_();
            Vec3 offset = right ? new Vec3((double)(0.8f + animationIntensity), (double)(0.8f - animationIntensity), (double)(0.35f * heldMob.m_20206_() - animationIntensity * 0.5f)) : new Vec3((double)(-0.8f - animationIntensity), (double)(0.8f - animationIntensity), (double)(0.35f * heldMob.m_20206_() - animationIntensity * 0.5f));
            Vec3 handPosition = ((ForsakenModel)this.m_117386_()).getHandPosition(right, offset);
            matrixStackIn.m_85837_(handPosition.f_82479_, handPosition.f_82480_, handPosition.f_82481_);
            matrixStackIn.m_252781_(Axis.f_252403_.m_252977_(180.0f));
            matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(vehicleRot - riderRot));
            if (!AlexsCaves.PROXY.isFirstPersonPlayer(heldMob)) {
                this.renderEntity(heldMob, 0.0, 0.0, 0.0, 0.0f, partialTicks, matrixStackIn, bufferIn, packedLightIn);
            }
            matrixStackIn.m_85849_();
            AlexsCaves.PROXY.blockRenderingEntity(heldMob.m_20148_());
        }
    }

    public <E extends Entity> void renderEntity(E entityIn, double x, double y, double z, float yaw, float partialTicks, PoseStack matrixStack, MultiBufferSource bufferIn, int packedLight) {
        block4: {
            EntityRenderer render = null;
            EntityRenderDispatcher manager = Minecraft.m_91087_().m_91290_();
            try {
                render = manager.m_114382_(entityIn);
                if (render == null) break block4;
                try {
                    render.m_7392_(entityIn, yaw, partialTicks, matrixStack, bufferIn, packedLight);
                }
                catch (Throwable throwable1) {
                    throw new ReportedException(CrashReport.m_127521_((Throwable)throwable1, (String)"Rendering entity in world"));
                }
            }
            catch (Throwable throwable3) {
                CrashReport crashreport = CrashReport.m_127521_((Throwable)throwable3, (String)"Rendering entity in world");
                CrashReportCategory crashreportcategory = crashreport.m_127514_("Entity being rendered");
                entityIn.m_7976_(crashreportcategory);
                CrashReportCategory crashreportcategory1 = crashreport.m_127514_("Renderer details");
                crashreportcategory1.m_128159_("Assigned renderer", (Object)render);
                crashreportcategory1.m_128159_("Rotation", (Object)Float.valueOf(yaw));
                crashreportcategory1.m_128159_("Delta", (Object)Float.valueOf(partialTicks));
                throw new ReportedException(crashreport);
            }
        }
    }
}

