/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.mixin;

import com.github.alexmodguy.alexscaves.server.entity.util.MagnetUtil;
import com.github.alexmodguy.alexscaves.server.entity.util.MagneticEntityAccessor;
import com.github.alexmodguy.alexscaves.server.misc.ACTagRegistry;
import com.github.alexmodguy.alexscaves.server.potion.ACEffectRegistry;
import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public abstract class EntityMixin
implements MagneticEntityAccessor {
    @Shadow
    @Final
    protected SynchedEntityData f_19804_;
    @Shadow
    private Level f_19853_;
    @Shadow
    private Vec3 f_19825_;
    @Shadow
    private EntityDimensions f_19815_;
    @Shadow
    protected boolean f_19798_;
    private static final EntityDataAccessor<Float> MAGNET_DELTA_X = SynchedEntityData.m_135353_(Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> MAGNET_DELTA_Y = SynchedEntityData.m_135353_(Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> MAGNET_DELTA_Z = SynchedEntityData.m_135353_(Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Direction> MAGNET_ATTACHMENT_DIRECTION = SynchedEntityData.m_135353_(Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135040_);
    private float attachChangeProgress = 0.0f;
    private float prevAttachChangeProgress = 0.0f;
    private Direction prevAttachDir = Direction.DOWN;
    private int jumpFlipCooldown = 0;
    private BlockPos lastStepPos;

    @Shadow
    protected abstract void m_7355_(BlockPos var1, BlockState var2);

    @Shadow
    public abstract void m_8119_();

    @Shadow
    public abstract void m_6210_();

    @Shadow
    public abstract AABB m_20191_();

    @Shadow
    public abstract Level m_9236_();

    @Shadow
    public abstract boolean m_20096_();

    @Shadow
    public abstract double m_20186_();

    @Inject(at={@At(value="TAIL")}, remap=true, method={"Lnet/minecraft/world/entity/Entity;<init>(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V"})
    private void citadel_registerData(CallbackInfo ci) {
        this.f_19804_.m_135372_(MAGNET_DELTA_X, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(MAGNET_DELTA_Y, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(MAGNET_DELTA_Z, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(MAGNET_ATTACHMENT_DIRECTION, (Object)Direction.DOWN);
    }

    @Inject(method={"Lnet/minecraft/world/entity/Entity;tick()V"}, remap=true, at={@At(value="TAIL")})
    public void ac_tick(CallbackInfo ci) {
        Entity thisEntity = (Entity)this;
        this.prevAttachChangeProgress = this.attachChangeProgress;
        if (this.prevAttachDir != this.getMagneticAttachmentFace()) {
            if (this.attachChangeProgress < 1.0f) {
                this.attachChangeProgress += 0.1f;
            } else if (this.attachChangeProgress >= 1.0f) {
                this.prevAttachDir = this.getMagneticAttachmentFace();
            }
        } else {
            this.attachChangeProgress = 1.0f;
        }
        if (MagnetUtil.isPulledByMagnets(thisEntity)) {
            MagnetUtil.tickMagnetism(thisEntity);
            if (this.jumpFlipCooldown > 0) {
                --this.jumpFlipCooldown;
            }
        } else if (this.getMagneticAttachmentFace() != Direction.DOWN) {
            this.setMagneticAttachmentFace(Direction.DOWN);
            this.m_6210_();
        }
    }

    @Inject(method={"Lnet/minecraft/world/entity/Entity;onSyncedDataUpdated(Lnet/minecraft/network/syncher/EntityDataAccessor;)V"}, remap=true, at={@At(value="TAIL")})
    public void ac_onSyncedDataUpdated(EntityDataAccessor<?> entityDataAccessor, CallbackInfo ci) {
        if (MAGNET_ATTACHMENT_DIRECTION.equals(entityDataAccessor)) {
            this.prevAttachChangeProgress = 0.0f;
            this.attachChangeProgress = 0.0f;
        }
    }

    @Inject(method={"Lnet/minecraft/world/entity/Entity;getEyePosition()Lnet/minecraft/world/phys/Vec3;"}, remap=true, cancellable=true, at={@At(value="HEAD")})
    public void ac_getEyePosition(CallbackInfoReturnable<Vec3> cir) {
        if (this.getMagneticAttachmentFace() != Direction.DOWN) {
            cir.setReturnValue((Object)MagnetUtil.getEyePositionForAttachment((Entity)this, this.getMagneticAttachmentFace(), 1.0f));
        }
    }

    @Inject(method={"Lnet/minecraft/world/entity/Entity;getEyePosition(F)Lnet/minecraft/world/phys/Vec3;"}, remap=true, cancellable=true, at={@At(value="HEAD")})
    public void ac_getEyePosition_lerp(float partialTick, CallbackInfoReturnable<Vec3> cir) {
        if (this.getMagneticAttachmentFace() != Direction.DOWN && this.getMagneticAttachmentFace() != Direction.UP) {
            cir.setReturnValue((Object)MagnetUtil.getEyePositionForAttachment((Entity)this, this.getMagneticAttachmentFace(), partialTick));
        }
    }

    @Inject(method={"Lnet/minecraft/world/entity/Entity;collide(Lnet/minecraft/world/phys/Vec3;)Lnet/minecraft/world/phys/Vec3;"}, remap=true, cancellable=true, at={@At(value="HEAD")})
    public void ac_collide(Vec3 deltaIn, CallbackInfoReturnable<Vec3> cir) {
        List list;
        AABB aabb = this.m_20191_();
        Entity thisEntity = (Entity)this;
        if (this.m_20186_() > (double)(this.m_9236_().m_141937_() - 200)) {
            list = this.m_9236_().m_183134_(thisEntity, aabb.m_82369_(deltaIn));
            List<VoxelShape> list2 = MagnetUtil.getMovingBlockCollisions(thisEntity, aabb);
            list = ImmutableList.builder().addAll((Iterable)list).addAll(list2).build();
        } else {
            list = List.of();
        }
        Vec3 vec3 = deltaIn.m_82556_() == 0.0 ? deltaIn : Entity.m_198894_((Entity)thisEntity, (Vec3)deltaIn, (AABB)aabb, (Level)this.m_9236_(), (List)list);
        boolean flag = deltaIn.f_82479_ != vec3.f_82479_;
        boolean flag1 = deltaIn.f_82480_ != vec3.f_82480_;
        boolean flag2 = deltaIn.f_82481_ != vec3.f_82481_;
        boolean flag3 = this.m_20096_() || flag1 && deltaIn.f_82480_ < 0.0;
        float stepHeight = thisEntity.getStepHeight();
        if (stepHeight > 0.0f && flag3 && (flag || flag2)) {
            Vec3 vec33;
            Vec3 vec31 = Entity.m_198894_((Entity)thisEntity, (Vec3)new Vec3(deltaIn.f_82479_, (double)stepHeight, deltaIn.f_82481_), (AABB)aabb, (Level)this.f_19853_, (List)list);
            Vec3 vec32 = Entity.m_198894_((Entity)thisEntity, (Vec3)new Vec3(0.0, (double)stepHeight, 0.0), (AABB)aabb.m_82363_(deltaIn.f_82479_, 0.0, deltaIn.f_82481_), (Level)this.f_19853_, (List)list);
            if (vec32.f_82480_ < (double)stepHeight && (vec33 = Entity.m_198894_((Entity)thisEntity, (Vec3)new Vec3(deltaIn.f_82479_, 0.0, deltaIn.f_82481_), (AABB)aabb.m_82383_(vec32), (Level)this.m_9236_(), (List)list).m_82549_(vec32)).m_165925_() > vec31.m_165925_()) {
                vec31 = vec33;
            }
            if (vec31.m_165925_() > vec3.m_165925_()) {
                cir.setReturnValue((Object)vec31.m_82549_(Entity.m_198894_((Entity)thisEntity, (Vec3)new Vec3(0.0, -vec31.f_82480_ + deltaIn.f_82480_, 0.0), (AABB)aabb.m_82383_(vec31), (Level)this.m_9236_(), (List)list)));
                return;
            }
        }
        cir.setReturnValue((Object)vec3);
    }

    @Inject(method={"Lnet/minecraft/world/entity/Entity;turn(DD)V"}, remap=true, cancellable=true, at={@At(value="HEAD")})
    public void ac_turn(double yBy, double xBy, CallbackInfo ci) {
        if (this.getMagneticAttachmentFace() != Direction.DOWN) {
            ci.cancel();
            MagnetUtil.turnEntityOnMagnet((Entity)this, xBy, yBy, this.getMagneticAttachmentFace());
        }
    }

    @Inject(method={"Lnet/minecraft/world/entity/Entity;makeBoundingBox()Lnet/minecraft/world/phys/AABB;"}, remap=true, cancellable=true, at={@At(value="HEAD")})
    public void ac_makeBoundingBox(CallbackInfoReturnable<AABB> cir) {
        if (this.f_19804_.m_135352_() && this.getMagneticAttachmentFace() != Direction.DOWN) {
            cir.setReturnValue((Object)MagnetUtil.rotateBoundingBox(this.f_19815_, this.getMagneticAttachmentFace(), this.f_19825_));
        }
    }

    @Inject(method={"Lnet/minecraft/world/entity/Entity;isInWater()Z"}, remap=true, cancellable=true, at={@At(value="HEAD")})
    public void ac_isInWater(CallbackInfoReturnable<Boolean> cir) {
        LivingEntity living;
        EntityMixin entityMixin = this;
        if (entityMixin instanceof LivingEntity && (living = (LivingEntity)entityMixin).m_21220_() != null && living.m_21023_((MobEffect)ACEffectRegistry.BUBBLED.get()) && (living.m_6040_() || living.m_6336_() == MobType.f_21644_) && !living.m_6095_().m_204039_(ACTagRegistry.RESISTS_BUBBLED)) {
            cir.setReturnValue((Object)true);
        }
    }

    @Override
    public float getMagneticDeltaX() {
        return this.f_19804_.m_285897_(MAGNET_DELTA_X) ? ((Float)this.f_19804_.m_135370_(MAGNET_DELTA_X)).floatValue() : 0.0f;
    }

    @Override
    public float getMagneticDeltaY() {
        return this.f_19804_.m_285897_(MAGNET_DELTA_Y) ? ((Float)this.f_19804_.m_135370_(MAGNET_DELTA_Y)).floatValue() : 0.0f;
    }

    @Override
    public float getMagneticDeltaZ() {
        return this.f_19804_.m_285897_(MAGNET_DELTA_Z) ? ((Float)this.f_19804_.m_135370_(MAGNET_DELTA_Z)).floatValue() : 0.0f;
    }

    @Override
    public Direction getMagneticAttachmentFace() {
        return this.f_19804_.m_285897_(MAGNET_ATTACHMENT_DIRECTION) ? (Direction)this.f_19804_.m_135370_(MAGNET_ATTACHMENT_DIRECTION) : Direction.DOWN;
    }

    @Override
    public Direction getPrevMagneticAttachmentFace() {
        return this.prevAttachDir;
    }

    @Override
    public float getAttachmentProgress(float partialTicks) {
        return this.prevAttachChangeProgress + (this.attachChangeProgress - this.prevAttachChangeProgress) * partialTicks;
    }

    @Override
    public void setMagneticDeltaX(float f) {
        if (this.f_19804_.m_285897_(MAGNET_DELTA_X)) {
            this.f_19804_.m_135381_(MAGNET_DELTA_X, (Object)Float.valueOf(f));
        }
    }

    @Override
    public void setMagneticDeltaY(float f) {
        if (this.f_19804_.m_285897_(MAGNET_DELTA_Y)) {
            this.f_19804_.m_135381_(MAGNET_DELTA_Y, (Object)Float.valueOf(f));
        }
    }

    @Override
    public void setMagneticDeltaZ(float f) {
        if (this.f_19804_.m_285897_(MAGNET_DELTA_Z)) {
            this.f_19804_.m_135381_(MAGNET_DELTA_Z, (Object)Float.valueOf(f));
        }
    }

    @Override
    public void setMagneticAttachmentFace(Direction dir) {
        if (this.f_19804_.m_285897_(MAGNET_ATTACHMENT_DIRECTION)) {
            this.f_19804_.m_135381_(MAGNET_ATTACHMENT_DIRECTION, (Object)dir);
        }
    }

    @Override
    public void postMagnetJump() {
        this.jumpFlipCooldown = 20;
    }

    @Override
    public boolean canChangeDirection() {
        return this.jumpFlipCooldown <= 0 && this.getAttachmentProgress(1.0f) == 1.0f;
    }

    @Override
    public void stepOnMagnetBlock(BlockPos pos) {
        if (this.lastStepPos == null || this.lastStepPos.m_123331_((Vec3i)pos) > 2.0) {
            this.lastStepPos = pos;
            this.m_7355_(pos, this.f_19853_.m_8055_(pos));
        }
    }
}

