/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.block;

import com.github.alexmodguy.alexscaves.server.block.blockentity.ACBlockEntityRegistry;
import com.github.alexmodguy.alexscaves.server.block.blockentity.CopperValveBlockEntity;
import com.github.alexmodguy.alexscaves.server.misc.ACMath;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class CopperValveBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    public static final BooleanProperty TURNED = BooleanProperty.m_61465_((String)"turned");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final VoxelShape SHAPE_UP = ACMath.buildShape(Block.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)11.0, (double)9.0), Block.m_49796_((double)1.0, (double)9.0, (double)1.0, (double)15.0, (double)11.0, (double)15.0));
    private static final VoxelShape SHAPE_DOWN = ACMath.buildShape(Block.m_49796_((double)7.0, (double)4.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0), Block.m_49796_((double)1.0, (double)5.0, (double)1.0, (double)15.0, (double)7.0, (double)15.0));
    private static final VoxelShape SHAPE_NORTH = ACMath.buildShape(Block.m_49796_((double)7.0, (double)7.0, (double)4.0, (double)9.0, (double)9.0, (double)16.0), Block.m_49796_((double)1.0, (double)1.0, (double)5.0, (double)15.0, (double)15.0, (double)7.0));
    private static final VoxelShape SHAPE_SOUTH = ACMath.buildShape(Block.m_49796_((double)7.0, (double)7.0, (double)0.0, (double)9.0, (double)9.0, (double)11.0), Block.m_49796_((double)1.0, (double)1.0, (double)9.0, (double)15.0, (double)15.0, (double)11.0));
    private static final VoxelShape SHAPE_EAST = ACMath.buildShape(Block.m_49796_((double)0.0, (double)7.0, (double)7.0, (double)11.0, (double)9.0, (double)9.0), Block.m_49796_((double)9.0, (double)1.0, (double)1.0, (double)11.0, (double)15.0, (double)15.0));
    private static final VoxelShape SHAPE_WEST = ACMath.buildShape(Block.m_49796_((double)4.0, (double)7.0, (double)7.0, (double)16.0, (double)9.0, (double)9.0), Block.m_49796_((double)5.0, (double)1.0, (double)1.0, (double)7.0, (double)15.0, (double)15.0));

    protected CopperValveBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283750_).m_60999_().m_60913_(3.0f, 12.0f).m_60918_(SoundType.f_154663_));
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.UP)).m_61124_((Property)TURNED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        BlockPos blockpos = pos.m_121945_(direction.m_122424_());
        return level.m_8055_(blockpos).m_60783_((BlockGetter)level, blockpos, direction);
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> blockStateBuilder) {
        blockStateBuilder.m_61104_(new Property[]{FACING, TURNED, WATERLOGGED});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_43719_())).m_61124_((Property)TURNED, (Comparable)Boolean.valueOf(context.m_43725_().m_276867_(context.m_8083_())))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState state1, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos blockPos1) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            levelAccessor.m_186469_(blockPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)levelAccessor));
        }
        return super.m_7417_(state, direction, state1, levelAccessor, blockPos, blockPos1);
    }

    public void m_6810_(BlockState state, Level level, BlockPos blockPos, BlockState blockState, boolean b) {
        if (!b && !state.m_60713_(blockState.m_60734_())) {
            level.m_46672_(blockPos, state.m_60734_());
            level.m_46672_(blockPos.m_121945_(((Direction)state.m_61143_((Property)FACING)).m_122424_()), state.m_60734_());
            super.m_6810_(state, level, blockPos, blockState, b);
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        switch ((Direction)state.m_61143_((Property)FACING)) {
            case DOWN: {
                return SHAPE_DOWN;
            }
            case NORTH: {
                return SHAPE_NORTH;
            }
            case SOUTH: {
                return SHAPE_SOUTH;
            }
            case WEST: {
                return SHAPE_WEST;
            }
            case EAST: {
                return SHAPE_EAST;
            }
        }
        return SHAPE_UP;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @javax.annotation.Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level p_152180_, BlockState p_152181_, BlockEntityType<T> p_152182_) {
        return CopperValveBlock.m_152132_(p_152182_, (BlockEntityType)((BlockEntityType)ACBlockEntityRegistry.COPPER_VALVE.get()), CopperValveBlockEntity::tick);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        BlockEntity blockEntity = worldIn.m_7702_(pos);
        if (blockEntity instanceof CopperValveBlockEntity) {
            CopperValveBlockEntity copperValve = (CopperValveBlockEntity)blockEntity;
            if (!player.m_6144_()) {
                if (((Boolean)state.m_61143_((Property)TURNED)).booleanValue()) {
                    copperValve.moveDown(false);
                } else {
                    copperValve.moveDown(!copperValve.isMovingDown());
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new CopperValveBlockEntity(pos, state);
    }

    public int m_6378_(BlockState state, BlockGetter blockGetter, BlockPos blockPos, Direction direction) {
        return (Boolean)state.m_61143_((Property)TURNED) != false ? 15 : 0;
    }

    public int m_6376_(BlockState state, BlockGetter getter, BlockPos pos, Direction direction) {
        return (Boolean)state.m_61143_((Property)TURNED) != false && state.m_61143_((Property)FACING) == direction ? 15 : 0;
    }

    public boolean m_7899_(BlockState p_51114_) {
        return true;
    }
}

