/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.block;

import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import com.github.alexmodguy.alexscaves.server.block.CavePaintingBlock;
import com.github.alexmodguy.alexscaves.server.misc.ACAdvancementTriggerRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACTagRegistry;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.registries.RegistryObject;

public class SmoothLimestoneBlock
extends Block {
    private static final List<RegistryObject<Block>> RANDOM_CAVE_PAINTINGS = (List)Util.m_137469_((Object)Lists.newArrayList(), list -> {
        list.add(ACBlockRegistry.CAVE_PAINTING_AMBERSOL);
        list.add(ACBlockRegistry.CAVE_PAINTING_DARK);
        list.add(ACBlockRegistry.CAVE_PAINTING_FOOTPRINT);
        list.add(ACBlockRegistry.CAVE_PAINTING_FOOTPRINTS);
        list.add(ACBlockRegistry.CAVE_PAINTING_TREE_STARS);
        list.add(ACBlockRegistry.CAVE_PAINTING_PEWEN);
        list.add(ACBlockRegistry.CAVE_PAINTING_TRILOCARIS);
        list.add(ACBlockRegistry.CAVE_PAINTING_GROTTOCERATOPS);
        list.add(ACBlockRegistry.CAVE_PAINTING_GROTTOCERATOPS_FRIEND);
        list.add(ACBlockRegistry.CAVE_PAINTING_DINO_NUGGETS);
        list.add(ACBlockRegistry.CAVE_PAINTING_VALLUMRAPTOR_CHEST);
        list.add(ACBlockRegistry.CAVE_PAINTING_VALLUMRAPTOR_FRIEND);
        list.add(ACBlockRegistry.CAVE_PAINTING_RELICHEIRUS);
        list.add(ACBlockRegistry.CAVE_PAINTING_RELICHEIRUS_SLASH);
        list.add(ACBlockRegistry.CAVE_PAINTING_ENDERMAN);
        list.add(ACBlockRegistry.CAVE_PAINTING_PORTAL);
        list.add(ACBlockRegistry.CAVE_PAINTING_SUBTERRANODON);
        list.add(ACBlockRegistry.CAVE_PAINTING_SUBTERRANODON_RIDE);
        list.add(ACBlockRegistry.CAVE_PAINTING_TREMORSAURUS);
        list.add(ACBlockRegistry.CAVE_PAINTING_TREMORSAURUS_FRIEND);
    });

    public SmoothLimestoneBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        ItemStack itemstack = player.m_21120_(interactionHand);
        if (itemstack.m_150930_(Items.f_42414_) && level.m_8055_(blockPos).m_204336_(ACTagRegistry.TURNS_INTO_CAVE_PAINTINGS)) {
            if (!player.m_7500_()) {
                itemstack.m_41774_(1);
            }
            if (!level.f_46443_) {
                boolean isMystery = false;
                if (level.f_46441_.m_188501_() < 0.3f && this.attemptPlaceMysteryCavePainting(level, blockPos, blockHitResult.m_82434_(), true)) {
                    isMystery = this.attemptPlaceMysteryCavePainting(level, blockPos, blockHitResult.m_82434_(), false);
                }
                if (!isMystery) {
                    BlockState cavePainting = ((Block)((RegistryObject)Util.m_214621_(RANDOM_CAVE_PAINTINGS, (RandomSource)player.m_217043_())).get()).m_49966_();
                    level.m_46597_(blockPos, (BlockState)cavePainting.m_61124_((Property)CavePaintingBlock.f_52588_, (Comparable)blockHitResult.m_82434_()));
                }
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    if (isMystery) {
                        ACAdvancementTriggerRegistry.MYSTERY_CAVE_PAINTING.triggerForEntity((Entity)serverPlayer);
                    } else {
                        ACAdvancementTriggerRegistry.CAVE_PAINTING.triggerForEntity((Entity)serverPlayer);
                    }
                    CriteriaTriggers.f_10562_.m_285767_(serverPlayer, blockPos, itemstack);
                }
                level.m_142346_((Entity)player, GameEvent.f_157792_, blockPos);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, level, blockPos, player, interactionHand, blockHitResult);
    }

    private boolean attemptPlaceMysteryCavePainting(Level level, BlockPos pos, Direction facing, boolean checkOnly) {
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                BlockPos paintingPos = facing == Direction.DOWN ? pos.m_5484_(Direction.SOUTH, i).m_5484_(Direction.WEST, j) : (facing == Direction.UP ? pos.m_5484_(Direction.NORTH, i).m_5484_(Direction.WEST, j) : pos.m_6630_(i).m_5484_(facing.m_122427_(), j));
                if (!level.m_8055_(paintingPos).m_60713_((Block)ACBlockRegistry.SMOOTH_LIMESTONE.get())) {
                    return false;
                }
                if (checkOnly) continue;
                BlockState cavePainting = this.getMysteryCavePainting(i, j).m_49966_();
                level.m_46597_(paintingPos, (BlockState)cavePainting.m_61124_((Property)CavePaintingBlock.f_52588_, (Comparable)facing));
            }
        }
        return true;
    }

    private Block getMysteryCavePainting(int i, int j) {
        if (i == -1 && j == -1) {
            return (Block)ACBlockRegistry.CAVE_PAINTING_MYSTERY_9.get();
        }
        if (i == -1 && j == 0) {
            return (Block)ACBlockRegistry.CAVE_PAINTING_MYSTERY_8.get();
        }
        if (i == -1 && j == 1) {
            return (Block)ACBlockRegistry.CAVE_PAINTING_MYSTERY_7.get();
        }
        if (i == 0 && j == -1) {
            return (Block)ACBlockRegistry.CAVE_PAINTING_MYSTERY_6.get();
        }
        if (i == 0 && j == 0) {
            return (Block)ACBlockRegistry.CAVE_PAINTING_MYSTERY_5.get();
        }
        if (i == 0 && j == 1) {
            return (Block)ACBlockRegistry.CAVE_PAINTING_MYSTERY_4.get();
        }
        if (i == 1 && j == -1) {
            return (Block)ACBlockRegistry.CAVE_PAINTING_MYSTERY_3.get();
        }
        if (i == 1 && j == 0) {
            return (Block)ACBlockRegistry.CAVE_PAINTING_MYSTERY_2.get();
        }
        if (i == 1 && j == 1) {
            return (Block)ACBlockRegistry.CAVE_PAINTING_MYSTERY_1.get();
        }
        return (Block)ACBlockRegistry.CAVE_PAINTING_DARK.get();
    }
}

