/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.block.blockentity;

import com.github.alexmodguy.alexscaves.AlexsCaves;
import com.github.alexmodguy.alexscaves.client.particle.ACParticleRegistry;
import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import com.github.alexmodguy.alexscaves.server.block.NuclearFurnaceBlock;
import com.github.alexmodguy.alexscaves.server.block.blockentity.ACBlockEntityRegistry;
import com.github.alexmodguy.alexscaves.server.entity.ACEntityRegistry;
import com.github.alexmodguy.alexscaves.server.entity.item.NuclearExplosionEntity;
import com.github.alexmodguy.alexscaves.server.entity.util.FallingBlockEntityAccessor;
import com.github.alexmodguy.alexscaves.server.inventory.NuclearFurnaceMenu;
import com.github.alexmodguy.alexscaves.server.misc.ACAdvancementTriggerRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACTagRegistry;
import com.github.alexmodguy.alexscaves.server.potion.ACEffectRegistry;
import com.github.alexmodguy.alexscaves.server.recipe.ACRecipeRegistry;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import org.jetbrains.annotations.Nullable;

public class NuclearFurnaceBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer {
    private static final float SPEED_REDUCTION = 0.2f;
    public static int MAX_BARRELING_TIME = 100;
    public static int MAX_WASTE = 1000;
    public int age;
    private int barrelTime = 0;
    private int currentWaste = 0;
    private int fissionTime = 0;
    private int cookTime = 0;
    private int maxCookTime = 0;
    private static final int[] SLOTS_FOR_UP = new int[]{0};
    private static final int[] SLOTS_FOR_DOWN = new int[]{3, 4};
    private static final int[] SLOTS_FOR_LEFT = new int[]{2};
    private static final int[] SLOTS_FOR_RIGHT = new int[]{1};
    protected NonNullList<ItemStack> items = NonNullList.m_122780_((int)5, (Object)ItemStack.f_41583_);
    private final RecipeManager.CachedCheck<Container, ? extends AbstractCookingRecipe> quickCheck = RecipeManager.m_220267_(NuclearFurnaceBlockEntity.getRecipeType());
    private final Object2IntOpenHashMap<ResourceLocation> recipesUsed = new Object2IntOpenHashMap();
    private AbstractCookingRecipe currentRecipe;
    protected final ContainerData dataAccess = new ContainerData(){

        public int m_6413_(int type) {
            switch (type) {
                case 0: {
                    return NuclearFurnaceBlockEntity.this.currentWaste;
                }
                case 1: {
                    return NuclearFurnaceBlockEntity.this.barrelTime;
                }
                case 2: {
                    return NuclearFurnaceBlockEntity.this.fissionTime;
                }
                case 3: {
                    return NuclearFurnaceBlockEntity.this.cookTime;
                }
                case 4: {
                    return NuclearFurnaceBlockEntity.this.maxCookTime;
                }
            }
            return 0;
        }

        public void m_8050_(int type, int value) {
            switch (type) {
                case 0: {
                    NuclearFurnaceBlockEntity.this.currentWaste = value;
                }
                case 1: {
                    NuclearFurnaceBlockEntity.this.barrelTime = value;
                }
                case 2: {
                    NuclearFurnaceBlockEntity.this.fissionTime = value;
                }
                case 3: {
                    NuclearFurnaceBlockEntity.this.cookTime = value;
                }
                case 4: {
                    NuclearFurnaceBlockEntity.this.maxCookTime = value;
                }
            }
        }

        public int m_6499_() {
            return 5;
        }
    };
    private Player lastInteractedWithPlayer;
    private LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])new Direction[]{Direction.DOWN, Direction.UP, Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST});

    public NuclearFurnaceBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ACBlockEntityRegistry.NUCLEAR_FURNACE.get(), pos, state);
    }

    public static void tick(Level level, BlockPos blockPos, BlockState state, NuclearFurnaceBlockEntity entity) {
        ++entity.age;
        if (entity.getCriticality() >= 3) {
            vec3 = entity.getExhaustPos();
            if (!level.f_46443_ && (double)level.f_46441_.m_188501_() < 0.2) {
                entity.spreadFire(level, 6);
            }
            level.m_6485_((ParticleOptions)(level.f_46441_.m_188503_(3) == 0 ? ParticleTypes.f_123756_ : (ParticleOptions)ACParticleRegistry.MUSHROOM_CLOUD_SMOKE.get()), true, vec3.f_82479_, vec3.f_82480_ + 1.0, vec3.f_82481_, (double)((level.f_46441_.m_188501_() - 0.5f) * 0.2f), (double)(0.1f + level.f_46441_.m_188501_() * 0.2f), (double)((level.f_46441_.m_188501_() - 0.5f) * 0.2f));
        } else if (entity.getCriticality() == 2) {
            vec3 = entity.getExhaustPos();
            if (!level.f_46443_ && (double)level.f_46441_.m_188501_() < 0.05) {
                entity.spreadFire(level, 2);
            }
            level.m_6485_((ParticleOptions)ParticleTypes.f_123755_, true, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, (double)((level.f_46441_.m_188501_() - 0.5f) * 0.1f), (double)(level.f_46441_.m_188501_() * 0.1f), (double)((level.f_46441_.m_188501_() - 0.5f) * 0.1f));
        } else if (entity.isUndergoingFission() && level.f_46441_.m_188501_() < (float)entity.getCriticality() * 0.35f + 0.15f) {
            vec3 = entity.getExhaustPos();
            ParticleOptions particleOptions = (ParticleOptions)ACParticleRegistry.HAZMAT_BREATHE.get();
            if (entity.getCriticality() == 1 && level.f_46441_.m_188501_() < 0.1f) {
                particleOptions = ParticleTypes.f_123755_;
            }
            level.m_6485_(particleOptions, true, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, (double)((level.f_46441_.m_188501_() - 0.5f) * 0.7f), (double)(level.f_46441_.m_188501_() * 0.1f), (double)((level.f_46441_.m_188501_() - 0.5f) * 0.7f));
        }
        if (!level.f_46443_) {
            boolean flag = false;
            ItemStack cookStack = (ItemStack)entity.items.get(0);
            ItemStack rodStack = (ItemStack)entity.items.get(1);
            ItemStack barrelStack = (ItemStack)entity.items.get(2);
            if (!cookStack.m_41619_()) {
                if (entity.currentRecipe == null || !((Ingredient)entity.currentRecipe.m_7527_().get(0)).test(cookStack)) {
                    entity.currentRecipe = entity.getRecipeFor(cookStack).orElse(null);
                } else {
                    ItemStack cookResult = entity.currentRecipe.m_8043_(level.m_9598_());
                    entity.maxCookTime = Math.max((int)Math.ceil((float)entity.currentRecipe.m_43753_() * NuclearFurnaceBlockEntity.getSpeedReduction()), 5);
                    if (entity.canFitInResultSlot(cookResult, 3)) {
                        if (entity.fissionTime <= 0) {
                            if (!rodStack.m_41619_() && rodStack.m_204117_(ACTagRegistry.NUCLEAR_FURNACE_RODS)) {
                                entity.fissionTime = NuclearFurnaceBlockEntity.getMaxFissionTime();
                                rodStack.m_41774_(1);
                                entity.currentWaste += NuclearFurnaceBlockEntity.getWastePerBarrel();
                            }
                            entity.resetCookTime();
                        } else if (entity.cookTime < entity.maxCookTime) {
                            flag = true;
                            ++entity.cookTime;
                        } else {
                            entity.setRecipeUsed((Recipe<?>)entity.currentRecipe);
                            entity.resetCookTime();
                            cookStack.m_41774_(1);
                            if (ItemStack.m_41656_((ItemStack)((ItemStack)entity.items.get(3)), (ItemStack)cookResult)) {
                                ((ItemStack)entity.items.get(3)).m_41769_(1);
                            } else {
                                entity.m_6836_(3, cookResult.m_41777_());
                            }
                            flag = true;
                        }
                    } else {
                        entity.resetCookTime();
                    }
                }
            } else {
                entity.currentRecipe = null;
                entity.resetCookTime();
            }
            if (entity.fissionTime > 0) {
                --entity.fissionTime;
                flag = true;
            }
            if (entity.currentWaste >= NuclearFurnaceBlockEntity.getWastePerBarrel() && barrelStack.m_204117_(ACTagRegistry.NUCLEAR_FURNACE_BARRELS) && entity.canFitInResultSlot(new ItemStack((ItemLike)ACBlockRegistry.WASTE_DRUM.get()), 4)) {
                flag = true;
                if (entity.barrelTime < MAX_BARRELING_TIME) {
                    ++entity.barrelTime;
                } else {
                    ItemStack wasteDrum = new ItemStack((ItemLike)ACBlockRegistry.WASTE_DRUM.get());
                    entity.barrelTime = 0;
                    barrelStack.m_41774_(1);
                    float prevCriticality = entity.getCriticality();
                    entity.currentWaste -= NuclearFurnaceBlockEntity.getWastePerBarrel();
                    if (prevCriticality == 3.0f && entity.getCriticality() <= 2 && entity.lastInteractedWithPlayer != null) {
                        ACAdvancementTriggerRegistry.STOP_NUCLEAR_FURNACE_MELTDOWN.triggerForEntity((Entity)entity.lastInteractedWithPlayer);
                    }
                    if (ItemStack.m_41656_((ItemStack)((ItemStack)entity.items.get(4)), (ItemStack)wasteDrum)) {
                        ((ItemStack)entity.items.get(4)).m_41769_(1);
                    } else {
                        entity.m_6836_(4, wasteDrum);
                    }
                }
            } else {
                entity.barrelTime = 0;
                flag = true;
            }
            if (flag) {
                entity.syncWithClient();
            }
            if (entity.currentWaste >= MAX_WASTE) {
                entity.destroyWhileCritical(true);
            }
        } else if (entity.isUndergoingFission() && !entity.m_58901_()) {
            AlexsCaves.PROXY.playWorldSound((Object)entity, (byte)7);
        }
    }

    public void m_7651_() {
        AlexsCaves.PROXY.clearSoundCacheFor((BlockEntity)this);
        super.m_7651_();
    }

    public void destroyWhileCritical(boolean nuke) {
        int i;
        int wasteBlocks = MAX_WASTE / NuclearFurnaceBlockEntity.getWastePerBarrel();
        this.currentWaste = 0;
        Vec3 vec3 = this.getExhaustPos();
        BlockState waste = ((Block)ACBlockRegistry.UNREFINED_WASTE.get()).m_49966_();
        for (i = 0; i <= 1; ++i) {
            for (int j = 0; j <= 1; ++j) {
                for (int k = 0; k <= 1; ++k) {
                    this.f_58857_.m_46961_(this.m_58899_().m_7918_(i, j, k), false);
                }
            }
        }
        for (i = 0; i < wasteBlocks; ++i) {
            FallingBlockEntity fallingblockentity = (FallingBlockEntity)EntityType.f_20450_.m_20615_(this.f_58857_);
            if (fallingblockentity instanceof FallingBlockEntityAccessor) {
                FallingBlockEntityAccessor accessor = (FallingBlockEntityAccessor)fallingblockentity;
                accessor.setBlockState(waste);
            }
            fallingblockentity.m_146884_(vec3.m_82520_((double)(this.f_58857_.f_46441_.m_188501_() * 6.0f - 3.0f), (double)(this.f_58857_.f_46441_.m_188501_() * 3.0f), (double)(this.f_58857_.f_46441_.m_188501_() * 6.0f - 3.0f)));
            fallingblockentity.m_20256_(fallingblockentity.m_20182_().m_82546_(vec3).m_82541_().m_82490_(0.75));
            this.f_58857_.m_7967_((Entity)fallingblockentity);
        }
        if (nuke) {
            NuclearExplosionEntity explosion = (NuclearExplosionEntity)((EntityType)ACEntityRegistry.NUCLEAR_EXPLOSION.get()).m_20615_(this.f_58857_);
            explosion.m_146884_(vec3.m_82520_(0.0, -1.5, 0.0));
            explosion.setSize(0.75f);
            this.f_58857_.m_7967_((Entity)explosion);
        } else {
            AreaEffectCloud areaeffectcloud = new AreaEffectCloud(this.f_58857_, vec3.f_82479_, vec3.f_82480_ - 1.0, vec3.f_82481_);
            areaeffectcloud.m_19724_((ParticleOptions)ACParticleRegistry.GAMMAROACH.get());
            areaeffectcloud.m_19714_(7853582);
            areaeffectcloud.m_19716_(new MobEffectInstance((MobEffect)ACEffectRegistry.IRRADIATED.get(), 9600, this.getCriticality()));
            areaeffectcloud.m_19712_(8.0f);
            areaeffectcloud.m_19734_(12000);
            areaeffectcloud.m_19740_(3);
            areaeffectcloud.m_19738_(-areaeffectcloud.m_19743_() / (float)areaeffectcloud.m_19748_());
            this.f_58857_.m_7967_((Entity)areaeffectcloud);
        }
    }

    private void spreadFire(Level level, int range) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (int i = 0; i < 5; ++i) {
            mutableBlockPos.m_122178_(this.m_58899_().m_123341_() + 1 + range - level.f_46441_.m_188503_(range * 2), this.m_58899_().m_123342_() + 1 + range - level.f_46441_.m_188503_(range * 2), this.m_58899_().m_123343_() + 1 + range - level.f_46441_.m_188503_(range * 2));
            if (!level.m_46859_((BlockPos)mutableBlockPos)) continue;
            level.m_46597_((BlockPos)mutableBlockPos, BaseFireBlock.m_49245_((BlockGetter)level, (BlockPos)mutableBlockPos));
            break;
        }
    }

    private void resetCookTime() {
        int prev = this.cookTime;
        this.cookTime = 0;
        if (prev != this.cookTime) {
            this.syncWithClient();
        }
    }

    private void syncWithClient() {
        this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
    }

    private static int getWastePerBarrel() {
        return MAX_WASTE / 10;
    }

    private boolean canFitInResultSlot(ItemStack putIn, int resultSlot) {
        ItemStack currentlyInThere = (ItemStack)this.items.get(resultSlot);
        if (currentlyInThere.m_41619_()) {
            return true;
        }
        if (!ItemStack.m_41656_((ItemStack)currentlyInThere, (ItemStack)putIn)) {
            return false;
        }
        if (currentlyInThere.m_41613_() + putIn.m_41613_() <= currentlyInThere.m_41741_() && currentlyInThere.m_41613_() + putIn.m_41613_() <= currentlyInThere.m_41741_()) {
            return true;
        }
        return currentlyInThere.m_41613_() + putIn.m_41613_() <= putIn.m_41741_();
    }

    public Vec3 getExhaustPos() {
        return new Vec3((double)((float)this.m_58899_().m_123341_() + 1.0f), (double)((float)this.m_58899_().m_123342_() + 1.0f), (double)((float)this.m_58899_().m_123343_() + 1.0f));
    }

    public int[] m_7071_(Direction direction) {
        if (direction == Direction.DOWN) {
            return SLOTS_FOR_DOWN;
        }
        if (this.m_58900_().m_60734_() == ACBlockRegistry.NUCLEAR_FURNACE.get()) {
            Direction facing = (Direction)this.m_58900_().m_61143_((Property)NuclearFurnaceBlock.FACING);
            if (direction == facing.m_122427_()) {
                return SLOTS_FOR_LEFT;
            }
            if (direction == facing.m_122428_()) {
                return SLOTS_FOR_RIGHT;
            }
        }
        return SLOTS_FOR_UP;
    }

    public void onPlayerUse(Player player) {
        this.lastInteractedWithPlayer = player;
    }

    public boolean m_7155_(int slot, ItemStack stack, @Nullable Direction direction) {
        return this.m_7013_(slot, stack);
    }

    public boolean m_7157_(int slot, ItemStack stack, Direction direction) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public AABB getRenderBoundingBox() {
        BlockPos pos = this.m_58899_();
        return new AABB(pos.m_7918_(-1, -1, -1), pos.m_7918_(2, 2, 2));
    }

    public void m_142466_(CompoundTag compoundTag) {
        super.m_142466_(compoundTag);
        this.items.clear();
        ContainerHelper.m_18980_((CompoundTag)compoundTag, this.items);
        this.loadAdditional(compoundTag);
    }

    private void loadAdditional(CompoundTag compoundTag) {
        this.currentWaste = compoundTag.m_128451_("Waste");
        this.cookTime = compoundTag.m_128451_("CookTime");
        this.maxCookTime = compoundTag.m_128451_("MaxCookTime");
        this.fissionTime = compoundTag.m_128451_("FissionTime");
        this.barrelTime = compoundTag.m_128451_("BarrelTime");
        CompoundTag compoundtag = compoundTag.m_128469_("RecipesUsed");
        for (String s : compoundtag.m_128431_()) {
            this.recipesUsed.put((Object)new ResourceLocation(s), compoundtag.m_128451_(s));
        }
    }

    protected void m_183515_(CompoundTag compoundTag) {
        super.m_183515_(compoundTag);
        ContainerHelper.m_18976_((CompoundTag)compoundTag, this.items, (boolean)true);
        compoundTag.m_128405_("Waste", this.currentWaste);
        compoundTag.m_128405_("CookTime", this.cookTime);
        compoundTag.m_128405_("MaxCookTime", this.maxCookTime);
        compoundTag.m_128405_("FissionTime", this.fissionTime);
        compoundTag.m_128405_("BarrelTime", this.barrelTime);
        CompoundTag compoundtag = new CompoundTag();
        this.recipesUsed.forEach((resLoc, count) -> compoundtag.m_128405_(resLoc.toString(), count.intValue()));
        compoundtag.m_128365_("RecipesUsed", (Tag)compoundtag);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        if (packet != null && packet.m_131708_() != null) {
            this.loadAdditional(packet.m_131708_());
        }
    }

    public int m_6643_() {
        return this.items.size();
    }

    public boolean m_7983_() {
        for (ItemStack itemstack : this.items) {
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int slot) {
        return (ItemStack)this.items.get(slot);
    }

    public ItemStack m_7407_(int slot, int count) {
        return ContainerHelper.m_18969_(this.items, (int)slot, (int)count);
    }

    public ItemStack m_8016_(int slot) {
        return ContainerHelper.m_18966_(this.items, (int)slot);
    }

    public void m_6836_(int slot, ItemStack itemStack) {
        ItemStack itemstack = (ItemStack)this.items.get(slot);
        boolean flag = !itemStack.m_41619_() && ItemStack.m_150942_((ItemStack)itemstack, (ItemStack)itemStack);
        this.items.set(slot, (Object)itemStack);
        if (itemStack.m_41613_() > this.m_6893_()) {
            itemStack.m_41764_(this.m_6893_());
        }
        if (slot == 0 && !flag) {
            this.m_6596_();
        }
    }

    public boolean m_6542_(Player player) {
        return Container.m_272074_((BlockEntity)this, (Player)player);
    }

    public boolean m_7013_(int slot, ItemStack stack) {
        return (slot != 0 || this.getRecipeFor(stack).isPresent()) && slot != 3 && slot != 4;
    }

    private Optional<? extends AbstractCookingRecipe> getRecipeFor(ItemStack itemStack) {
        return this.quickCheck.m_213657_((Container)new SimpleContainer(new ItemStack[]{itemStack}), this.f_58857_);
    }

    public void m_6211_() {
        this.items.clear();
    }

    public boolean isUndergoingFission() {
        return this.fissionTime > 0;
    }

    public int getCriticality() {
        float f = this.getWasteScale();
        if (f >= 0.8f) {
            return 3;
        }
        if (f >= 0.6f) {
            return 2;
        }
        if (f >= 0.35f) {
            return 1;
        }
        return 0;
    }

    public float getWasteScale() {
        return (float)this.currentWaste / (float)MAX_WASTE;
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)"block.alexscaves.nuclear_furnace");
    }

    protected AbstractContainerMenu m_6555_(int id, Inventory inventory) {
        return new NuclearFurnaceMenu(id, inventory, (Container)this, this.dataAccess);
    }

    public WorldlyContainer getContainerFor(BlockPos offsetPos) {
        return this;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @javax.annotation.Nullable Direction facing) {
        if (!this.f_58859_ && facing != null && capability == ForgeCapabilities.ITEM_HANDLER) {
            return this.handlers[facing.ordinal()].cast();
        }
        return super.getCapability(capability, facing);
    }

    public void setRecipeUsed(@javax.annotation.Nullable Recipe<?> recipe) {
        if (recipe != null) {
            ResourceLocation resourcelocation = recipe.m_6423_();
            this.recipesUsed.addTo((Object)resourcelocation, 1);
        }
    }

    public void awardUsedRecipesAndPopExperience(ServerPlayer serverPlayer) {
        List<Recipe<?>> list = this.getRecipesToAwardAndPopExperience(serverPlayer.m_284548_(), serverPlayer.m_20182_());
        serverPlayer.m_7281_(list);
        for (Recipe<?> recipe : list) {
            if (recipe == null) continue;
            serverPlayer.m_280300_(recipe, this.items);
        }
        this.recipesUsed.clear();
    }

    public List<Recipe<?>> getRecipesToAwardAndPopExperience(ServerLevel serverLevel, Vec3 vec3) {
        ArrayList list = Lists.newArrayList();
        for (Object2IntMap.Entry entry : this.recipesUsed.object2IntEntrySet()) {
            serverLevel.m_7465_().m_44043_((ResourceLocation)entry.getKey()).ifPresent(p_155023_ -> {
                list.add(p_155023_);
                NuclearFurnaceBlockEntity.createExperience(serverLevel, vec3, entry.getIntValue(), ((AbstractCookingRecipe)p_155023_).m_43750_());
            });
        }
        return list;
    }

    private static void createExperience(ServerLevel serverLevel, Vec3 vec3, int i1, float scale) {
        int i = Mth.m_14143_((float)((float)i1 * scale));
        float f = Mth.m_14187_((float)((float)i1 * scale));
        if (f != 0.0f && Math.random() < (double)f) {
            ++i;
        }
        ExperienceOrb.m_147082_((ServerLevel)serverLevel, (Vec3)vec3, (int)i);
    }

    public static RecipeType<? extends AbstractCookingRecipe> getRecipeType() {
        if (((Boolean)AlexsCaves.COMMON_CONFIG.nuclearFurnaceCustomType.get()).booleanValue()) {
            return (RecipeType)ACRecipeRegistry.NUCLEAR_FURNACE_TYPE.get();
        }
        return (Boolean)AlexsCaves.COMMON_CONFIG.nuclearFurnaceBlastingOnly.get() != false ? RecipeType.f_44109_ : RecipeType.f_44108_;
    }

    public static float getSpeedReduction() {
        if (((Boolean)AlexsCaves.COMMON_CONFIG.nuclearFurnaceCustomType.get()).booleanValue()) {
            return 0.2f;
        }
        return (Boolean)AlexsCaves.COMMON_CONFIG.nuclearFurnaceBlastingOnly.get() != false ? 0.2f : 0.1f;
    }

    public static int getMaxFissionTime() {
        return (int)Math.ceil(6400.0f * NuclearFurnaceBlockEntity.getSpeedReduction());
    }
}

