/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.enchantment;

import com.github.alexmodguy.alexscaves.server.enchantment.ACWeaponEnchantment;
import com.github.alexmodguy.alexscaves.server.item.ACItemRegistry;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ACEnchantmentRegistry {
    public static final DeferredRegister<Enchantment> DEF_REG = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENCHANTMENTS, (String)"alexscaves");
    public static final EnchantmentCategory GALENA_GAUNTLET = EnchantmentCategory.create((String)"galena_gauntlet", item -> item == ACItemRegistry.GALENA_GAUNTLET.get());
    public static final EnchantmentCategory RESISTOR_SHIELD = EnchantmentCategory.create((String)"resistor_shield", item -> item == ACItemRegistry.RESISTOR_SHIELD.get());
    public static final EnchantmentCategory PRIMITIVE_CLUB = EnchantmentCategory.create((String)"primitive_club", item -> item == ACItemRegistry.PRIMITIVE_CLUB.get());
    public static final EnchantmentCategory EXTINCTION_SPEAR = EnchantmentCategory.create((String)"extinction_spear", item -> item == ACItemRegistry.EXTINCTION_SPEAR.get());
    public static final EnchantmentCategory RAYGUN = EnchantmentCategory.create((String)"raygun", item -> item == ACItemRegistry.RAYGUN.get());
    public static final EnchantmentCategory ORTHOLANCE = EnchantmentCategory.create((String)"ortholance", item -> item == ACItemRegistry.ORTHOLANCE.get());
    public static final EnchantmentCategory MAGIC_CONCH = EnchantmentCategory.create((String)"magic_conch", item -> item == ACItemRegistry.MAGIC_CONCH.get());
    public static final EnchantmentCategory SEA_STAFF = EnchantmentCategory.create((String)"sea_staff", item -> item == ACItemRegistry.SEA_STAFF.get());
    public static final EnchantmentCategory TOTEM_OF_POSSESSION = EnchantmentCategory.create((String)"totem_of_possession", item -> item == ACItemRegistry.TOTEM_OF_POSSESSION.get());
    public static final EnchantmentCategory DESOLATE_DAGGER = EnchantmentCategory.create((String)"desolate_dagger", item -> item == ACItemRegistry.DESOLATE_DAGGER.get());
    public static final EnchantmentCategory DREADBOW = EnchantmentCategory.create((String)"dreadbow", item -> item == ACItemRegistry.DREADBOW.get());
    public static final RegistryObject<Enchantment> FIELD_EXTENSION = DEF_REG.register("field_extension", () -> new ACWeaponEnchantment("field_extension", Enchantment.Rarity.COMMON, GALENA_GAUNTLET, 4, 6, EquipmentSlot.MAINHAND, EquipmentSlot.OFFHAND));
    public static final RegistryObject<Enchantment> CRYSTALLIZATION = DEF_REG.register("crystallization", () -> new ACWeaponEnchantment("crystallization", Enchantment.Rarity.RARE, GALENA_GAUNTLET, 1, 15, EquipmentSlot.MAINHAND, EquipmentSlot.OFFHAND));
    public static final RegistryObject<Enchantment> FERROUS_HASTE = DEF_REG.register("ferrous_haste", () -> new ACWeaponEnchantment("ferrous_haste", Enchantment.Rarity.RARE, GALENA_GAUNTLET, 1, 15, EquipmentSlot.MAINHAND, EquipmentSlot.OFFHAND));
    public static final RegistryObject<Enchantment> ARROW_INDUCTING = DEF_REG.register("arrow_inducting", () -> new ACWeaponEnchantment("arrow_inducting", Enchantment.Rarity.RARE, RESISTOR_SHIELD, 1, 18, EquipmentSlot.MAINHAND, EquipmentSlot.OFFHAND));
    public static final RegistryObject<Enchantment> HEAVY_SLAM = DEF_REG.register("heavy_slam", () -> new ACWeaponEnchantment("heavy_slam", Enchantment.Rarity.COMMON, RESISTOR_SHIELD, 3, 6, EquipmentSlot.MAINHAND, EquipmentSlot.OFFHAND));
    public static final RegistryObject<Enchantment> SWIFTWOOD = DEF_REG.register("swiftwood", () -> new ACWeaponEnchantment("swiftwood", Enchantment.Rarity.RARE, PRIMITIVE_CLUB, 3, 8, EquipmentSlot.MAINHAND));
    public static final RegistryObject<Enchantment> BONKING = DEF_REG.register("bonking", () -> new ACWeaponEnchantment("bonking", Enchantment.Rarity.VERY_RARE, PRIMITIVE_CLUB, 1, 18, EquipmentSlot.MAINHAND));
    public static final RegistryObject<Enchantment> DAZING_SWEEP = DEF_REG.register("dazing_sweep", () -> new ACWeaponEnchantment("dazing_sweep", Enchantment.Rarity.RARE, PRIMITIVE_CLUB, 2, 10, EquipmentSlot.MAINHAND));
    public static final RegistryObject<Enchantment> PLUMMETING_FLIGHT = DEF_REG.register("plummeting_flight", () -> new ACWeaponEnchantment("plummeting_flight", Enchantment.Rarity.RARE, EXTINCTION_SPEAR, 3, 13, EquipmentSlot.MAINHAND));
    public static final RegistryObject<Enchantment> HERD_PHALANX = DEF_REG.register("herd_phalanx", () -> new ACWeaponEnchantment("herd_phalanx", Enchantment.Rarity.RARE, EXTINCTION_SPEAR, 3, 13, EquipmentSlot.MAINHAND));
    public static final RegistryObject<Enchantment> CHOMPING_SPIRIT = DEF_REG.register("chomping_spirit", () -> new ACWeaponEnchantment("chomping_spirit", Enchantment.Rarity.RARE, EXTINCTION_SPEAR, 2, 10, EquipmentSlot.MAINHAND));
    public static final RegistryObject<Enchantment> ENERGY_EFFICIENCY = DEF_REG.register("energy_efficiency", () -> new ACWeaponEnchantment("energy_efficiency", Enchantment.Rarity.COMMON, RAYGUN, 3, 5, EquipmentSlot.MAINHAND));
    public static final RegistryObject<Enchantment> SOLAR = DEF_REG.register("solar", () -> new ACWeaponEnchantment("solar", Enchantment.Rarity.COMMON, RAYGUN, 1, 14, EquipmentSlot.MAINHAND));
    public static final RegistryObject<Enchantment> X_RAY = DEF_REG.register("x_ray", () -> new ACWeaponEnchantment("x_ray", Enchantment.Rarity.COMMON, RAYGUN, 1, 12, EquipmentSlot.MAINHAND));
    public static final RegistryObject<Enchantment> GAMMA_RAY = DEF_REG.register("gamma_ray", () -> new ACWeaponEnchantment("gamma_ray", Enchantment.Rarity.RARE, RAYGUN, 1, 18, EquipmentSlot.MAINHAND));
    public static final RegistryObject<Enchantment> SECOND_WAVE = DEF_REG.register("second_wave", () -> new ACWeaponEnchantment("second_wave", Enchantment.Rarity.RARE, ORTHOLANCE, 1, 12, EquipmentSlot.MAINHAND));
    public static final RegistryObject<Enchantment> FLINGING = DEF_REG.register("flinging", () -> new ACWeaponEnchantment("flinging", Enchantment.Rarity.COMMON, ORTHOLANCE, 3, 8, EquipmentSlot.MAINHAND));
    public static final RegistryObject<Enchantment> SEA_SWING = DEF_REG.register("sea_swing", () -> new ACWeaponEnchantment("sea_swing", Enchantment.Rarity.RARE, ORTHOLANCE, 1, 10, EquipmentSlot.MAINHAND));
    public static final RegistryObject<Enchantment> TSUNAMI = DEF_REG.register("tsunami", () -> new ACWeaponEnchantment("tsunami", Enchantment.Rarity.VERY_RARE, ORTHOLANCE, 1, 20, EquipmentSlot.MAINHAND));
    public static final RegistryObject<Enchantment> CHARTING_CALL = DEF_REG.register("charting_call", () -> new ACWeaponEnchantment("charting_call", Enchantment.Rarity.COMMON, MAGIC_CONCH, 4, 7, EquipmentSlot.MAINHAND));
    public static final RegistryObject<Enchantment> LASTING_MORALE = DEF_REG.register("lasting_morale", () -> new ACWeaponEnchantment("lasting_morale", Enchantment.Rarity.RARE, MAGIC_CONCH, 3, 8, EquipmentSlot.MAINHAND));
    public static final RegistryObject<Enchantment> TAXING_BELLOW = DEF_REG.register("taxing_bellow", () -> new ACWeaponEnchantment("taxing_bellow", Enchantment.Rarity.RARE, MAGIC_CONCH, 1, 19, EquipmentSlot.MAINHAND));
    public static final RegistryObject<Enchantment> ENVELOPING_BUBBLE = DEF_REG.register("enveloping_bubble", () -> new ACWeaponEnchantment("enveloping_bubble", Enchantment.Rarity.RARE, SEA_STAFF, 1, 13, EquipmentSlot.MAINHAND));
    public static final RegistryObject<Enchantment> BOUNCING_BOLT = DEF_REG.register("bouncing_bolt", () -> new ACWeaponEnchantment("bouncing_bolt", Enchantment.Rarity.RARE, SEA_STAFF, 1, 13, EquipmentSlot.MAINHAND));
    public static final RegistryObject<Enchantment> SEAPAIRING = DEF_REG.register("seapairing", () -> new ACWeaponEnchantment("seapairing", Enchantment.Rarity.VERY_RARE, SEA_STAFF, 1, 10, EquipmentSlot.MAINHAND));
    public static final RegistryObject<Enchantment> TRIPLE_SPLASH = DEF_REG.register("triple_splash", () -> new ACWeaponEnchantment("triple_splash", Enchantment.Rarity.RARE, SEA_STAFF, 1, 15, EquipmentSlot.MAINHAND));
    public static final RegistryObject<Enchantment> SOAK_SEEKING = DEF_REG.register("soak_seeking", () -> new ACWeaponEnchantment("soak_seeking", Enchantment.Rarity.COMMON, SEA_STAFF, 3, 5, EquipmentSlot.MAINHAND));
    public static final RegistryObject<Enchantment> DETONATING_DEATH = DEF_REG.register("detonating_death", () -> new ACWeaponEnchantment("detonating_death", Enchantment.Rarity.RARE, TOTEM_OF_POSSESSION, 1, 11, EquipmentSlot.MAINHAND));
    public static final RegistryObject<Enchantment> RAPID_POSSESSION = DEF_REG.register("rapid_possession", () -> new ACWeaponEnchantment("rapid_possession", Enchantment.Rarity.COMMON, TOTEM_OF_POSSESSION, 3, 5, EquipmentSlot.MAINHAND));
    public static final RegistryObject<Enchantment> SIGHTLESS = DEF_REG.register("sightless", () -> new ACWeaponEnchantment("sightless", Enchantment.Rarity.RARE, TOTEM_OF_POSSESSION, 1, 13, EquipmentSlot.MAINHAND));
    public static final RegistryObject<Enchantment> ASTRAL_TRANSFERRING = DEF_REG.register("astral_transferring", () -> new ACWeaponEnchantment("astral_transferring", Enchantment.Rarity.RARE, TOTEM_OF_POSSESSION, 1, 12, EquipmentSlot.MAINHAND));
    public static final RegistryObject<Enchantment> IMPENDING_STAB = DEF_REG.register("impending_stab", () -> new ACWeaponEnchantment("impending_stab", Enchantment.Rarity.COMMON, DESOLATE_DAGGER, 3, 6, EquipmentSlot.MAINHAND));
    public static final RegistryObject<Enchantment> SATED_BLADE = DEF_REG.register("sated_blade", () -> new ACWeaponEnchantment("sated_blade", Enchantment.Rarity.COMMON, DESOLATE_DAGGER, 2, 11, EquipmentSlot.MAINHAND));
    public static final RegistryObject<Enchantment> DOUBLE_STAB = DEF_REG.register("double_stab", () -> new ACWeaponEnchantment("double_stab", Enchantment.Rarity.RARE, DESOLATE_DAGGER, 1, 12, EquipmentSlot.MAINHAND));
    public static final RegistryObject<Enchantment> PRECISE_VOLLEY = DEF_REG.register("precise_volley", () -> new ACWeaponEnchantment("precise_volley", Enchantment.Rarity.RARE, DREADBOW, 1, 18, EquipmentSlot.MAINHAND));
    public static final RegistryObject<Enchantment> DARK_NOCK = DEF_REG.register("dark_nock", () -> new ACWeaponEnchantment("dark_nock", Enchantment.Rarity.RARE, DREADBOW, 3, 10, EquipmentSlot.MAINHAND));
    public static final RegistryObject<Enchantment> RELENTLESS_DARKNESS = DEF_REG.register("relentless_darkness", () -> new ACWeaponEnchantment("relentless_darkness", Enchantment.Rarity.VERY_RARE, DREADBOW, 1, 20, EquipmentSlot.MAINHAND));
    public static final RegistryObject<Enchantment> TWILIGHT_PERFECTION = DEF_REG.register("twilight_perfection", () -> new ACWeaponEnchantment("twilight_perfection", Enchantment.Rarity.RARE, DREADBOW, 3, 7, EquipmentSlot.MAINHAND));
    public static final RegistryObject<Enchantment> SHADED_RESPITE = DEF_REG.register("shaded_respite", () -> new ACWeaponEnchantment("shaded_respite", Enchantment.Rarity.VERY_RARE, DREADBOW, 1, 9, EquipmentSlot.MAINHAND));

    public static boolean areCompatible(ACWeaponEnchantment enchantment1, Enchantment enchantment2) {
        if (enchantment1 == X_RAY.get() && enchantment2 == GAMMA_RAY.get()) {
            return false;
        }
        if (enchantment1 == GAMMA_RAY.get() && enchantment2 == X_RAY.get()) {
            return false;
        }
        if (enchantment1 == SECOND_WAVE.get() && enchantment2 == TSUNAMI.get()) {
            return false;
        }
        if (enchantment1 == TSUNAMI.get() && enchantment2 == SECOND_WAVE.get()) {
            return false;
        }
        if (enchantment1 == TAXING_BELLOW.get() && (enchantment2 == Enchantments.f_44986_ || enchantment2 == Enchantments.f_44962_)) {
            return false;
        }
        if ((enchantment1 == Enchantments.f_44986_ || enchantment1 == Enchantments.f_44962_) && enchantment2 == TAXING_BELLOW.get()) {
            return false;
        }
        if (enchantment1 == BOUNCING_BOLT.get() && enchantment2 == TRIPLE_SPLASH.get()) {
            return false;
        }
        if (enchantment1 == TRIPLE_SPLASH.get() && enchantment2 == BOUNCING_BOLT.get()) {
            return false;
        }
        if (enchantment1 == DETONATING_DEATH.get() && enchantment2 == ASTRAL_TRANSFERRING.get()) {
            return false;
        }
        if (enchantment1 == ASTRAL_TRANSFERRING.get() && enchantment2 == DETONATING_DEATH.get()) {
            return false;
        }
        if (enchantment1 == IMPENDING_STAB.get() && enchantment2 == DOUBLE_STAB.get()) {
            return false;
        }
        if (enchantment1 == DOUBLE_STAB.get() && enchantment2 == IMPENDING_STAB.get()) {
            return false;
        }
        if (enchantment1 == RELENTLESS_DARKNESS.get() && (enchantment2 == PRECISE_VOLLEY.get() || enchantment2 == DARK_NOCK.get() || enchantment2 == TWILIGHT_PERFECTION.get())) {
            return false;
        }
        return enchantment1 != PRECISE_VOLLEY.get() && enchantment1 != DARK_NOCK.get() && enchantment1 != TWILIGHT_PERFECTION.get() || enchantment2 != RELENTLESS_DARKNESS.get();
    }

    public static void addAllEnchantsToCreativeTab(CreativeModeTab.Output output, EnchantmentCategory enchantmentCategory) {
        for (RegistryObject enchantObject : DEF_REG.getEntries()) {
            if (!enchantObject.isPresent()) continue;
            Enchantment enchant = (Enchantment)enchantObject.get();
            if (enchant.f_44672_ != enchantmentCategory) continue;
            EnchantmentInstance instance = new EnchantmentInstance(enchant, enchant.m_6586_());
            output.m_246342_(EnchantedBookItem.m_41161_((EnchantmentInstance)instance));
        }
    }
}

