/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.item;

import com.github.alexmodguy.alexscaves.AlexsCaves;
import com.github.alexmodguy.alexscaves.client.particle.ACParticleRegistry;
import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import com.github.alexmodguy.alexscaves.server.block.blockentity.NuclearSirenBlockEntity;
import com.github.alexmodguy.alexscaves.server.block.poi.ACPOIRegistry;
import com.github.alexmodguy.alexscaves.server.entity.ACEntityRegistry;
import com.github.alexmodguy.alexscaves.server.entity.item.NuclearExplosionEntity;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import com.google.common.base.Predicates;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.Tags;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;

public class NuclearBombEntity
extends Entity {
    private static final EntityDataAccessor<Integer> TIME = SynchedEntityData.m_135353_(NuclearBombEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final int MAX_TIME = 300;

    public NuclearBombEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    public NuclearBombEntity(PlayMessages.SpawnEntity spawnEntity, Level level) {
        this((EntityType)ACEntityRegistry.NUCLEAR_BOMB.get(), level);
        this.m_20011_(this.m_142242_());
    }

    public NuclearBombEntity(Level level, double x, double y, double z) {
        this((EntityType)ACEntityRegistry.NUCLEAR_BOMB.get(), level);
        this.m_6034_(x, y, z);
        double d0 = level.f_46441_.m_188500_() * 6.2831854820251465;
        this.m_20334_(-Math.sin(d0) * 0.02, 0.2f, -Math.cos(d0) * 0.02);
        this.f_19854_ = x;
        this.f_19855_ = y;
        this.f_19856_ = z;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void m_8119_() {
        int i;
        Level level;
        if (!this.m_20068_()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.04, 0.0));
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
        this.m_20256_(this.m_20184_().m_82490_(0.98));
        if (this.m_20096_()) {
            this.m_20256_(this.m_20184_().m_82542_(0.7, -0.7, 0.7));
        }
        if ((this.f_19797_ + this.m_19879_()) % 10 == 0 && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.getNearbySirens(serverLevel, 256).forEach(this::activateSiren);
        }
        if ((i = this.getTime() + 1) > 300) {
            this.m_146870_();
            if (!this.m_9236_().f_46443_) {
                this.explode();
            }
        } else {
            this.setTime(i);
            this.m_20073_();
            if (this.m_9236_().f_46443_ && 300 - i > 10 && this.f_19796_.m_188501_() < 0.3f && this.m_20096_()) {
                Vec3 center = this.m_146892_();
                this.m_9236_().m_7106_((ParticleOptions)ACParticleRegistry.PROTON.get(), center.f_82479_, center.f_82480_, center.f_82481_, center.f_82479_, center.f_82480_, center.f_82481_);
            }
        }
    }

    private void activateSiren(BlockPos pos) {
        BlockEntity blockEntity = this.m_9236_().m_7702_(pos);
        if (blockEntity instanceof NuclearSirenBlockEntity) {
            NuclearSirenBlockEntity nuclearSirenBlock = (NuclearSirenBlockEntity)blockEntity;
            nuclearSirenBlock.setNearestNuclearBomb(this);
        }
    }

    private void explode() {
        NuclearExplosionEntity explosion = (NuclearExplosionEntity)((EntityType)ACEntityRegistry.NUCLEAR_EXPLOSION.get()).m_20615_(this.m_9236_());
        explosion.m_20359_(this);
        explosion.setSize(((Double)AlexsCaves.COMMON_CONFIG.nukeExplosionSizeModifier.get()).floatValue());
        this.m_9236_().m_7967_((Entity)explosion);
    }

    public void m_183634_() {
        if (this.f_19789_ > 20.0f) {
            this.m_146870_();
            if (!this.m_9236_().f_46443_) {
                this.explode();
            }
        }
    }

    private Stream<BlockPos> getNearbySirens(ServerLevel world, int range) {
        PoiManager pointofinterestmanager = world.m_8904_();
        return pointofinterestmanager.m_27138_(poiTypeHolder -> poiTypeHolder.m_203565_(ACPOIRegistry.NUCLEAR_SIREN.getKey()), (Predicate)Predicates.alwaysTrue(), this.m_20183_(), range, PoiManager.Occupancy.ANY);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(TIME, (Object)0);
    }

    public int getTime() {
        return (Integer)this.f_19804_.m_135370_(TIME);
    }

    public void setTime(int time) {
        this.f_19804_.m_135381_(TIME, (Object)time);
    }

    protected void m_7378_(CompoundTag compoundTag) {
    }

    protected void m_7380_(CompoundTag compoundTag) {
    }

    public boolean m_6087_() {
        return !this.m_213877_();
    }

    public boolean m_142391_() {
        return !this.m_213877_();
    }

    public boolean m_6097_() {
        return false;
    }

    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)ACBlockRegistry.NUCLEAR_BOMB.get());
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (itemStack.m_204117_(Tags.Items.SHEARS)) {
            player.m_6674_(hand);
            this.m_216990_((SoundEvent)ACSoundRegistry.NUCLEAR_BOMB_DEFUSE.get());
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.m_19983_(new ItemStack((ItemLike)ACBlockRegistry.NUCLEAR_BOMB.get()));
            if (!player.m_150110_().f_35937_) {
                itemStack.m_41622_(1, (LivingEntity)player, e -> e.m_21190_(hand));
            }
            return InteractionResult.SUCCESS;
        }
        if (player.m_36341_()) {
            return InteractionResult.PASS;
        }
        if (!this.m_9236_().f_46443_) {
            return player.m_20329_((Entity)this) ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        return InteractionResult.SUCCESS;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void m_19956_(Entity passenger, Entity.MoveFunction moveFunction) {
        if (this.m_20365_(passenger) && passenger instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)passenger;
            if (!this.m_146899_()) {
                float progress = (float)this.getTime() / 300.0f;
                float expandScale = 1.0f + (float)Math.sin((double)(progress * progress) * Math.PI) * 0.5f;
                float f1 = -(this.m_146909_() / 40.0f);
                float j = expandScale - progress * 0.3f;
                double d0 = this.m_20186_() + (double)j + passenger.m_6049_() - (double)0.2f;
                moveFunction.m_20372_(passenger, this.m_20185_(), d0, this.m_20189_());
                passenger.f_19789_ = 0.0f;
                return;
            }
        }
        super.m_19956_(passenger, moveFunction);
    }

    public boolean m_142535_(float f, float f1, DamageSource damageSource) {
        return false;
    }
}

