/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.living;

import com.github.alexmodguy.alexscaves.client.particle.ACParticleRegistry;
import com.github.alexmodguy.alexscaves.server.entity.ai.DeepOneAttackGoal;
import com.github.alexmodguy.alexscaves.server.entity.ai.DeepOneBarterGoal;
import com.github.alexmodguy.alexscaves.server.entity.ai.DeepOneDisappearGoal;
import com.github.alexmodguy.alexscaves.server.entity.ai.DeepOneReactToPlayerGoal;
import com.github.alexmodguy.alexscaves.server.entity.ai.DeepOneTargetHostilePlayersGoal;
import com.github.alexmodguy.alexscaves.server.entity.ai.DeepOneWanderGoal;
import com.github.alexmodguy.alexscaves.server.entity.ai.VerticalSwimmingMoveControl;
import com.github.alexmodguy.alexscaves.server.entity.item.WaterBoltEntity;
import com.github.alexmodguy.alexscaves.server.entity.item.WaveEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.DeepOneBaseEntity;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import com.github.alexmodguy.alexscaves.server.potion.ACEffectRegistry;
import com.github.alexthe666.citadel.animation.Animation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class DeepOneMageEntity
extends DeepOneBaseEntity {
    public static final Animation ANIMATION_DISAPPEAR = Animation.create((int)55);
    public static final Animation ANIMATION_ATTACK = Animation.create((int)25);
    public static final Animation ANIMATION_SPIN = Animation.create((int)70);
    public static final Animation ANIMATION_TRADE = Animation.create((int)75);
    private static final EntityDimensions SWIMMING_SIZE = new EntityDimensions(1.2f, 1.5f, false);
    private int spinCooldown = 0;
    private int rangedCooldown = 0;
    private Vec3 strafeTarget = null;
    public static final ResourceLocation BARTER_LOOT = new ResourceLocation("alexscaves", "gameplay/deep_one_mage_barter");
    private boolean isMageInWater = true;

    public DeepOneMageEntity(EntityType entityType, Level level) {
        super(entityType, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22276_, 80.0).m_22268_(Attributes.f_22281_, 4.0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new DeepOneAttackGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new DeepOneBarterGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new DeepOneReactToPlayerGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new DeepOneDisappearGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new DeepOneWanderGoal(this, 12, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0, 45){

            public boolean m_8036_() {
                return !DeepOneMageEntity.this.m_20072_() && super.m_8036_() && DeepOneMageEntity.this.getAnimation() != ANIMATION_TRADE;
            }

            public boolean m_8045_() {
                return !DeepOneMageEntity.this.m_20072_() && DeepOneMageEntity.this.getAnimation() != ANIMATION_TRADE && super.m_8045_();
            }

            protected Vec3 m_7037_() {
                Vec3 prev = super.m_7037_();
                return prev == null ? prev : prev.m_82520_(0.0, 1.0, 0.0);
            }
        });
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 16.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new DeepOneBaseEntity.HurtByHostileTargetGoal());
        this.f_21346_.m_25352_(2, (Goal)new DeepOneTargetHostilePlayersGoal(this));
    }

    @Override
    protected void switchNavigator(boolean onLand) {
        if (onLand) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, 0.1, 0.0));
            this.f_21344_ = this.createFlightNavigation(this.m_9236_());
            this.f_21342_ = new FlightMoveController();
            this.isLandNavigator = true;
        } else {
            this.f_21344_ = this.m_6037_(this.m_9236_());
            this.f_21342_ = new VerticalSwimmingMoveControl((Mob)this, 0.8f, 10.0f);
            this.isLandNavigator = false;
        }
    }

    public float m_5610_(BlockPos pos, LevelReader level) {
        return this.m_9236_().m_8055_(pos).m_60795_() ? 10.0f : super.m_5610_(pos, level);
    }

    @Override
    public void m_8119_() {
        LivingEntity target;
        super.m_8119_();
        if (!this.m_20072_() && !this.m_21023_((MobEffect)ACEffectRegistry.BUBBLED.get())) {
            this.m_7292_(new MobEffectInstance((MobEffect)ACEffectRegistry.BUBBLED.get(), 200));
        }
        if (this.m_20072_() && this.m_21023_((MobEffect)ACEffectRegistry.BUBBLED.get())) {
            this.m_21195_((MobEffect)ACEffectRegistry.BUBBLED.get());
        }
        this.isMageInWater = this.m_20072_();
        if (this.getAnimation() == ANIMATION_SPIN) {
            this.m_20256_(this.m_20184_().m_82490_((double)0.6f));
            target = this.m_5448_();
            if (target != null) {
                Vec3 vec = target.m_20182_().m_82546_(this.m_20182_()).m_82541_();
                this.m_20256_(this.m_20184_().m_82549_(vec.m_82490_(0.1)));
            }
            if (this.getAnimationTick() % 6 == 0) {
                AABB bashBox = this.m_20191_().m_82377_(2.0, 0.0, 2.0);
                for (LivingEntity entity : this.m_9236_().m_45976_(LivingEntity.class, bashBox)) {
                    if (this.m_7307_((Entity)entity) || entity instanceof DeepOneBaseEntity) continue;
                    this.checkAndDealMeleeDamage(entity, 0.4f, 1.0f);
                }
            }
        }
        if (this.getAnimation() == ANIMATION_ATTACK && (target = this.m_5448_()) != null && target.m_6084_()) {
            if (this.getAnimationTick() == 16) {
                this.useMagicAttack(target);
            } else if (this.getAnimationTick() < 16) {
                this.m_9236_().m_7605_((Entity)this, (byte)68);
            }
            this.m_21563_().m_24950_(target.m_20185_(), target.m_20188_(), target.m_20189_(), 180.0f, 10.0f);
        }
        if (this.spinCooldown > 0) {
            --this.spinCooldown;
        }
        if (this.rangedCooldown > 0) {
            --this.rangedCooldown;
        }
    }

    @Override
    protected ResourceLocation getBarterLootTable() {
        return BARTER_LOOT;
    }

    public boolean m_20068_() {
        return !this.isDeepOneSwimming() || super.m_20068_();
    }

    public boolean causeFallDamage(float distance, float damageMultiplier) {
        return false;
    }

    protected void m_7840_(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public void useMagicAttack(LivingEntity target) {
        this.m_9236_().m_7605_((Entity)this, (byte)68);
        if (this.f_19796_.m_188499_()) {
            int lifespan = (int)Math.floor(this.m_20270_((Entity)target)) + 10;
            Vec3 vec3 = target.m_20182_().m_82546_(this.m_20182_());
            for (int i = -2; i <= 2; ++i) {
                WaveEntity waveEntity = new WaveEntity(this.m_9236_(), (LivingEntity)this);
                waveEntity.m_6034_(this.m_20185_(), target.m_20186_(), this.m_20189_());
                waveEntity.setLifespan(lifespan);
                waveEntity.m_146922_(-((float)(Mth.m_14136_((double)vec3.f_82479_, (double)vec3.f_82481_) * 57.2957763671875)) + (float)(i * 10));
                this.m_9236_().m_7967_((Entity)waveEntity);
            }
        } else {
            WaterBoltEntity waterBoltEntity = new WaterBoltEntity(this.m_9236_(), (LivingEntity)this);
            double d0 = target.m_20185_() - this.m_20185_();
            double d1 = target.m_20227_(0.3333333333333333) - waterBoltEntity.m_20186_();
            double d2 = target.m_20189_() - this.m_20189_();
            double d3 = Math.sqrt(d0 * d0 + d2 * d2);
            waterBoltEntity.setBubbling(this.f_19796_.m_188503_(2) == 0);
            waterBoltEntity.setArcingTowards(target.m_20148_());
            waterBoltEntity.m_6686_(d0, d1 + d3 * (double)0.67f, d2, 0.6f, 30.0f);
            this.m_9236_().m_7967_((Entity)waterBoltEntity);
        }
    }

    @Override
    public void startAttackBehavior(LivingEntity target) {
        float f;
        this.f_20883_ = this.m_146908_();
        double distance = this.m_20270_((Entity)target);
        if (distance > (double)(20.0f + (f = this.m_20205_() + target.m_20205_()))) {
            this.m_21573_().m_5624_((Entity)target, 1.2);
        } else if (distance < (double)(2.0f + f) && this.spinCooldown <= 0) {
            if (this.getAnimation() == NO_ANIMATION) {
                this.setAnimation(ANIMATION_SPIN);
                this.spinCooldown = 1000 + this.f_19796_.m_188503_(60);
            }
        } else {
            if (this.strafeTarget == null || this.strafeTarget.m_82554_(this.m_20182_()) < 4.0) {
                Vec3 possible = target.m_20182_().m_82520_((double)(this.f_19796_.m_188503_(20) - 10), (double)this.f_19796_.m_188503_(2), (double)(this.f_19796_.m_188503_(20) - 10));
                if (!this.isTargetBlocked(possible)) {
                    this.strafeTarget = possible;
                }
            } else {
                this.m_21573_().m_26519_(this.strafeTarget.f_82479_, this.strafeTarget.f_82480_, this.strafeTarget.f_82481_, 1.5);
            }
            if (this.rangedCooldown <= 0 && this.getAnimation() == NO_ANIMATION && this.m_142582_((Entity)target)) {
                this.setAnimation(ANIMATION_ATTACK);
                this.m_216990_((SoundEvent)ACSoundRegistry.DEEP_ONE_MAGE_ATTACK.get());
                this.rangedCooldown = 30 + this.f_19796_.m_188503_(20);
            }
            this.m_21563_().m_24950_(target.m_20185_(), target.m_20188_(), target.m_20189_(), 30.0f, 10.0f);
        }
    }

    private boolean isTargetBlocked(Vec3 target) {
        Vec3 Vector3d = new Vec3(this.m_20185_(), this.m_20188_(), this.m_20189_());
        return this.m_9236_().m_45547_(new ClipContext(Vector3d, target, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this)).m_6662_() != HitResult.Type.MISS;
    }

    @Override
    public EntityDimensions getSwimmingSize() {
        return SWIMMING_SIZE;
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_DISAPPEAR, ANIMATION_ATTACK, ANIMATION_SPIN, ANIMATION_TRADE};
    }

    @Override
    public boolean isDeepOneSwimming() {
        return this.isMageInWater && !this.m_20096_();
    }

    @Override
    public Animation getTradingAnimation() {
        return ANIMATION_TRADE;
    }

    protected PathNavigation createFlightNavigation(Level level) {
        FlyingPathNavigation flyingpathnavigation = new FlyingPathNavigation((Mob)this, level){

            public boolean m_6342_(BlockPos pos) {
                return !this.f_26495_.m_8055_(pos.m_7495_()).m_60795_();
            }
        };
        flyingpathnavigation.m_26440_(false);
        flyingpathnavigation.m_7008_(false);
        flyingpathnavigation.m_26443_(true);
        return flyingpathnavigation;
    }

    @Override
    public boolean startDisappearBehavior(Player player) {
        this.m_21563_().m_24950_(player.m_20185_(), player.m_20188_(), player.m_20189_(), 20.0f, (float)this.m_8132_());
        this.m_21573_().m_26573_();
        if (this.getAnimation() == NO_ANIMATION) {
            this.setAnimation(ANIMATION_DISAPPEAR);
        }
        if (this.getAnimation() == ANIMATION_DISAPPEAR) {
            if (this.getAnimationTick() > 50) {
                this.m_9236_().m_7605_((Entity)this, (byte)67);
                this.m_142687_(Entity.RemovalReason.DISCARDED);
                return true;
            }
            this.m_9236_().m_7605_((Entity)this, (byte)66);
        }
        return false;
    }

    @Override
    public void m_7822_(byte b) {
        if (b == 66) {
            for (int i = 0; i < 2 + this.f_19796_.m_188503_(4); ++i) {
                this.m_9236_().m_7106_((ParticleOptions)(this.f_19796_.m_188499_() ? (ParticleOptions)ACParticleRegistry.DEEP_ONE_MAGIC.get() : ParticleTypes.f_123776_), this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), 0.0, (double)-0.1f, 0.0);
            }
        } else if (b == 67) {
            for (int i = 0; i < 13 + this.f_19796_.m_188503_(6); ++i) {
                this.m_9236_().m_7106_((ParticleOptions)ACParticleRegistry.DEEP_ONE_MAGIC.get(), this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), (double)(this.f_19796_.m_188501_() - 0.5f), (double)(this.f_19796_.m_188501_() - 0.5f), (double)(this.f_19796_.m_188501_() - 0.5f));
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123775_, this.m_20208_(1.0), this.m_20187_() + 1.0, this.m_20262_(1.0), (double)(this.f_19796_.m_188501_() - 0.5f), (double)(this.f_19796_.m_188501_() - 0.5f), (double)(this.f_19796_.m_188501_() - 0.5f));
            }
        } else if (b == 68) {
            Vec3 deltaPos = this.m_20182_().m_82549_(this.m_20184_());
            Vec3 rVec = new Vec3((double)0.65f, (double)(this.m_20206_() * 0.5f + 0.15f), (double)0.2f).m_82496_(-this.m_146909_() * ((float)Math.PI / 180)).m_82524_(-this.m_6080_() * ((float)Math.PI / 180)).m_82549_(deltaPos);
            Vec3 lVec = new Vec3((double)-0.65f, (double)(this.m_20206_() * 0.5f + 0.15f), (double)0.2f).m_82496_(-this.m_146909_() * ((float)Math.PI / 180)).m_82524_(-this.m_6080_() * ((float)Math.PI / 180)).m_82549_(deltaPos);
            this.m_9236_().m_7106_((ParticleOptions)ACParticleRegistry.DEEP_ONE_MAGIC.get(), rVec.f_82479_ + (double)((this.f_19796_.m_188501_() - 0.5f) * 0.1f), rVec.f_82480_ + (double)((this.f_19796_.m_188501_() - 0.5f) * 0.1f), rVec.f_82481_ + (double)((this.f_19796_.m_188501_() - 0.5f) * 0.1f), (double)((this.f_19796_.m_188501_() - 0.5f) * 0.3f) + this.m_20184_().f_82479_, 1.0, (double)((this.f_19796_.m_188501_() - 0.5f) * 0.3f) + this.m_20184_().f_82481_);
            this.m_9236_().m_7106_((ParticleOptions)ACParticleRegistry.DEEP_ONE_MAGIC.get(), lVec.f_82479_ + (double)((this.f_19796_.m_188501_() - 0.5f) * 0.1f), lVec.f_82480_ + (double)((this.f_19796_.m_188501_() - 0.5f) * 0.1f), lVec.f_82481_ + (double)((this.f_19796_.m_188501_() - 0.5f) * 0.1f), (double)((this.f_19796_.m_188501_() - 0.5f) * 0.3f) + this.m_20184_().f_82479_, 1.0, (double)((this.f_19796_.m_188501_() - 0.5f) * 0.3f) + this.m_20184_().f_82481_);
        } else {
            super.m_7822_(b);
        }
    }

    public float getStepHeight() {
        return 1.3f;
    }

    @Override
    public SoundEvent getAdmireSound() {
        return (SoundEvent)ACSoundRegistry.DEEP_ONE_MAGE_ADMIRE.get();
    }

    protected SoundEvent m_7515_() {
        return this.soundsAngry() ? (SoundEvent)ACSoundRegistry.DEEP_ONE_MAGE_HOSTILE.get() : (SoundEvent)ACSoundRegistry.DEEP_ONE_MAGE_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)ACSoundRegistry.DEEP_ONE_MAGE_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ACSoundRegistry.DEEP_ONE_MAGE_DEATH.get();
    }

    class FlightMoveController
    extends MoveControl {
        private final Mob parentEntity;

        public FlightMoveController() {
            super((Mob)DeepOneMageEntity.this);
            this.parentEntity = DeepOneMageEntity.this;
        }

        public void m_8126_() {
            this.parentEntity.m_20256_(this.parentEntity.m_20184_().m_82520_(0.0, Math.sin((double)DeepOneMageEntity.this.f_19797_ * 0.1) * (double)0.005f, 0.0));
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO) {
                Vec3 vector3d = new Vec3(this.f_24975_ - this.parentEntity.m_20185_(), this.f_24976_ - this.parentEntity.m_20186_(), this.f_24977_ - this.parentEntity.m_20189_());
                double d0 = vector3d.m_82553_();
                double width = this.parentEntity.m_20191_().m_82309_();
                LivingEntity attackTarget = this.parentEntity.m_5448_();
                Vec3 vector3d1 = vector3d.m_82490_(this.f_24978_ * 0.025 / d0);
                this.parentEntity.m_20256_(this.parentEntity.m_20184_().m_82549_(vector3d1));
                if (d0 < width * (double)0.3f) {
                    this.f_24981_ = MoveControl.Operation.WAIT;
                } else if (d0 >= width && attackTarget == null) {
                    if (DeepOneMageEntity.this.m_5448_() != null) {
                        this.parentEntity.f_20883_ = this.parentEntity.m_146908_();
                    } else {
                        this.parentEntity.m_146922_(-((float)Mth.m_14136_((double)vector3d1.f_82479_, (double)vector3d1.f_82481_)) * 57.295776f);
                    }
                }
            }
        }
    }
}

