/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.living;

import com.github.alexmodguy.alexscaves.client.particle.ACParticleRegistry;
import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import com.github.alexmodguy.alexscaves.server.entity.ACEntityRegistry;
import com.github.alexmodguy.alexscaves.server.entity.util.LaysEggs;
import com.github.alexmodguy.alexscaves.server.item.ACItemRegistry;
import com.github.alexmodguy.alexscaves.server.level.storage.ACWorldData;
import com.github.alexmodguy.alexscaves.server.misc.ACAdvancementTriggerRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACMath;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACTagRegistry;
import com.github.alexthe666.citadel.server.entity.IDancesToJukebox;
import com.github.alexthe666.citadel.server.entity.pathfinding.raycoms.IAdvancedPathingMob;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public abstract class DinosaurEntity
extends TamableAnimal
implements IDancesToJukebox,
LaysEggs,
IAdvancedPathingMob {
    private static final EntityDataAccessor<Boolean> DANCING = SynchedEntityData.m_135353_(DinosaurEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> HAS_EGG = SynchedEntityData.m_135353_(DinosaurEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> COMMAND = SynchedEntityData.m_135353_(DinosaurEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ALT_SKIN = SynchedEntityData.m_135353_(DinosaurEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public float prevDanceProgress;
    public float danceProgress;
    private BlockPos jukeboxPosition;
    private float prevSitProgress;
    private float sitProgress;
    private float prevBuryEggsProgress;
    private float buryEggsProgress;
    public boolean buryingEggs;

    public DinosaurEntity(EntityType entityType, Level level) {
        super(entityType, level);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DANCING, (Object)false);
        this.f_19804_.m_135372_(HAS_EGG, (Object)false);
        this.f_19804_.m_135372_(COMMAND, (Object)0);
        this.f_19804_.m_135372_(ALT_SKIN, (Object)0);
    }

    public static boolean checkPrehistoricSpawnRules(EntityType<? extends Animal> type, LevelAccessor levelAccessor, MobSpawnType mobType, BlockPos pos, RandomSource randomSource) {
        return levelAccessor.m_8055_(pos.m_7495_()).m_204336_(ACTagRegistry.DINOSAURS_SPAWNABLE_ON) && levelAccessor.m_6425_(pos).m_76178_() && levelAccessor.m_6425_(pos.m_7495_()).m_76178_();
    }

    public static boolean checkPrehistoricPostBossSpawnRules(EntityType<? extends Animal> type, LevelAccessor levelAccessor, MobSpawnType mobType, BlockPos pos, RandomSource randomSource) {
        if (DinosaurEntity.checkPrehistoricSpawnRules(type, levelAccessor, mobType, pos, randomSource) && levelAccessor instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)levelAccessor;
            ACWorldData data = ACWorldData.get((Level)serverLevel);
            return data != null && data.isPrimordialBossDefeatedOnce();
        }
        return false;
    }

    public void m_8119_() {
        super.m_8119_();
        this.prevDanceProgress = this.danceProgress;
        this.prevSitProgress = this.sitProgress;
        this.prevBuryEggsProgress = this.buryEggsProgress;
        if (this.jukeboxPosition == null || !this.jukeboxPosition.m_203195_((Position)this.m_20182_(), 15.0) || !this.m_9236_().m_8055_(this.jukeboxPosition).m_60713_(Blocks.f_50131_)) {
            this.setDancing(false);
            this.jukeboxPosition = null;
        }
        if (this.isDancing() && this.danceProgress < 5.0f) {
            this.danceProgress += 1.0f;
        }
        if (!this.isDancing() && this.danceProgress > 0.0f) {
            this.danceProgress -= 1.0f;
        }
        if (this.m_21825_() && this.sitProgress < this.maxSitTicks()) {
            this.sitProgress += 1.0f;
        }
        if (!this.m_21825_() && this.sitProgress > 0.0f) {
            this.sitProgress -= 1.0f;
        }
        if (this.buryingEggs && this.buryEggsProgress < 5.0f) {
            this.buryEggsProgress += 1.0f;
        }
        if (!this.buryingEggs && this.buryEggsProgress > 0.0f) {
            this.buryEggsProgress -= 1.0f;
        }
    }

    public float maxSitTicks() {
        return 10.0f;
    }

    public boolean isDancing() {
        return (Boolean)this.f_19804_.m_135370_(DANCING);
    }

    public void setDancing(boolean bool) {
        this.f_19804_.m_135381_(DANCING, (Object)bool);
    }

    @Override
    public boolean hasEgg() {
        return (Boolean)this.f_19804_.m_135370_(HAS_EGG);
    }

    @Override
    public void setHasEgg(boolean hasEgg) {
        this.f_19804_.m_135381_(HAS_EGG, (Object)hasEgg);
    }

    public int getCommand() {
        return (Integer)this.f_19804_.m_135370_(COMMAND);
    }

    public void setCommand(int command) {
        this.f_19804_.m_135381_(COMMAND, (Object)command);
    }

    public int getAltSkin() {
        return (Integer)this.f_19804_.m_135370_(ALT_SKIN);
    }

    public void setAltSkin(int skinIndex) {
        this.f_19804_.m_135381_(ALT_SKIN, (Object)skinIndex);
    }

    public void m_6818_(BlockPos pos, boolean playing) {
        this.onClientPlayMusicDisc(this.m_19879_(), pos, playing);
    }

    public void setJukeboxPos(BlockPos blockPos) {
        this.jukeboxPosition = blockPos;
    }

    public float getDanceProgress(float partialTicks) {
        return (this.prevDanceProgress + (this.danceProgress - this.prevDanceProgress) * partialTicks) * 0.2f;
    }

    public float getSitProgress(float partialTicks) {
        return (this.prevSitProgress + (this.sitProgress - this.prevSitProgress) * partialTicks) / this.maxSitTicks();
    }

    public float getBuryEggsProgress(float partialTicks) {
        return (this.prevBuryEggsProgress + (this.buryEggsProgress - this.prevBuryEggsProgress) * partialTicks) * 0.2f;
    }

    public void m_7023_(Vec3 vec3d) {
        if (this.isDancing() || this.m_21825_()) {
            if (this.m_21573_().m_26570_() != null) {
                this.m_21573_().m_26573_();
            }
            vec3d = Vec3.f_82478_;
        }
        super.m_7023_(vec3d);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Command", this.getCommand());
        compound.m_128379_("Egg", this.hasEgg());
        compound.m_128405_("AltSkin", this.getAltSkin());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setCommand(compound.m_128451_("Command"));
        this.setHasEgg(compound.m_128471_("Egg"));
        int altSkin = compound.m_128451_("AltSkin");
        if (compound.m_128441_("Retro") && compound.m_128471_("Retro")) {
            altSkin = 1;
        }
        this.setAltSkin(altSkin);
    }

    public boolean tamesFromHatching() {
        return false;
    }

    public boolean hasRidingMeter() {
        return false;
    }

    public float getMeterAmount() {
        return 0.0f;
    }

    protected void clampRotation(LivingEntity livingEntity, float clampRange) {
        livingEntity.m_5618_(this.m_146908_());
        float f = Mth.m_14177_((float)(livingEntity.m_146908_() - this.m_146908_()));
        float f1 = Mth.m_14036_((float)f, (float)(-clampRange), (float)clampRange);
        livingEntity.f_19859_ += f1 - f;
        livingEntity.f_20884_ += f1 - f;
        livingEntity.m_146922_(livingEntity.m_146908_() + f1 - f);
        livingEntity.m_5616_(livingEntity.m_146908_());
    }

    @Override
    public void onLayEggTick(BlockPos belowEgg, int time) {
        this.f_267362_.m_267566_(0.5f, 0.4f);
        this.m_9236_().m_7605_((Entity)this, (byte)77);
    }

    public void m_7822_(byte b) {
        if (b == 77) {
            this.buryingEggs = true;
            float radius = this.m_20205_() * 0.55f;
            float particleCount = (float)(5 + this.f_19796_.m_188503_(5)) * radius;
            int i1 = 0;
            while ((float)i1 < particleCount) {
                double motionX = (double)(this.m_217043_().m_188501_() - 0.5f) * 0.7;
                double motionY = (double)this.m_217043_().m_188501_() * 0.7 + (double)0.8f;
                double motionZ = (double)(this.m_217043_().m_188501_() - 0.5f) * 0.7;
                float angle = (float)Math.PI / 180 * (this.f_20883_ + (float)i1 / particleCount * 360.0f);
                double extraX = radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
                double extraY = 1.2f;
                double extraZ = radius * Mth.m_14089_((float)angle);
                BlockPos ground = BlockPos.m_274446_((Position)ACMath.getGroundBelowPosition((BlockGetter)this.m_9236_(), new Vec3((double)Mth.m_14107_((double)(this.m_20185_() + extraX)), (double)Mth.m_14107_((double)(this.m_20186_() + extraY)), (double)Mth.m_14107_((double)(this.m_20189_() + extraZ)))));
                BlockState groundState = this.m_9236_().m_8055_(ground.m_7495_());
                if (groundState.m_280296_() && this.m_9236_().f_46443_) {
                    this.m_9236_().m_6493_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, groundState), true, this.m_20185_() + extraX, (double)ground.m_123342_(), this.m_20189_() + extraZ, motionX, motionY, motionZ);
                }
                ++i1;
            }
        } else if (b == 78) {
            this.buryingEggs = false;
        } else if (b == 82 || b == 83) {
            ParticleOptions options = b == 82 ? (ParticleOptions)ACParticleRegistry.DINOSAUR_TRANSFORMATION_AMBER.get() : (ParticleOptions)ACParticleRegistry.DINOSAUR_TRANSFORMATION_TECTONIC.get();
            for (int i = 0; i < 15 + this.m_9236_().f_46441_.m_188503_(5); ++i) {
                this.m_9236_().m_7106_(options, this.m_20185_(), this.m_20227_(0.5), this.m_20189_(), (double)this.m_19879_(), 0.0, 0.0);
            }
        } else {
            super.m_7822_(b);
        }
    }

    public boolean onFeedMixture(ItemStack itemStack, Player player) {
        return false;
    }

    public boolean m_21825_() {
        return super.m_21825_() && !this.m_20160_() && !this.m_20159_();
    }

    public int getAltSkinForItem(ItemStack stack) {
        if (stack.m_150930_((Item)ACItemRegistry.AMBER_CURIOSITY.get())) {
            return 1;
        }
        if (stack.m_150930_((Item)ACItemRegistry.TECTONIC_SHARD.get())) {
            return 2;
        }
        return 0;
    }

    public BlockState createEggBeddingBlockState() {
        return ((Block)ACBlockRegistry.FERN_THATCH.get()).m_49966_();
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        InteractionResult interactionresult = itemstack.m_41647_(player, (LivingEntity)this, hand);
        InteractionResult type = super.m_6071_(player, hand);
        if (!interactionresult.m_19077_() && !type.m_19077_()) {
            int altSkinFromItem = this.getAltSkinForItem(itemstack);
            if (altSkinFromItem > 0) {
                this.m_142075_(player, hand, itemstack);
                this.m_216990_(altSkinFromItem == 2 ? (SoundEvent)ACSoundRegistry.TECTONIC_SHARD_TRANSFORM.get() : (SoundEvent)ACSoundRegistry.AMBER_MONOLITH_SUMMON.get());
                if (!this.m_9236_().f_46443_) {
                    if (altSkinFromItem == this.getAltSkin()) {
                        this.setAltSkin(0);
                    } else {
                        this.setAltSkin(altSkinFromItem);
                    }
                    this.m_9236_().m_7605_((Entity)this, (byte)(altSkinFromItem == 2 ? 83 : 82));
                }
                return InteractionResult.SUCCESS;
            }
            if (this.m_21824_() && this.m_21830_((LivingEntity)player) && !this.m_6898_(itemstack)) {
                if (this.canOwnerCommand(player)) {
                    boolean sit;
                    this.setCommand(this.getCommand() + 1);
                    if (this.getCommand() == 3) {
                        this.setCommand(0);
                    }
                    player.m_5661_((Component)Component.m_237110_((String)("entity.alexscaves.all.command_" + this.getCommand()), (Object[])new Object[]{this.m_7755_()}), true);
                    boolean bl = sit = this.getCommand() == 1;
                    if (sit) {
                        this.m_21839_(true);
                    } else {
                        this.m_21839_(false);
                    }
                    return InteractionResult.SUCCESS;
                }
                if (this.canOwnerMount(player)) {
                    if (this.m_6095_() == ACEntityRegistry.SUBTERRANODON.get() && this.m_7310_((Entity)player)) {
                        this.m_6027_(this.m_20185_(), this.m_20186_() + (double)player.m_20206_() + 0.5, this.m_20189_());
                    }
                    if (!this.m_9236_().f_46443_ && player.m_20329_((Entity)this)) {
                        return InteractionResult.CONSUME;
                    }
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return type;
    }

    public boolean m_7998_(Entity entity, boolean force) {
        boolean flag = super.m_7998_(entity, force);
        if (flag && entity instanceof AbstractMinecart) {
            ArrayList<EntityType> nearbyDinosaurEntityTypes = new ArrayList<EntityType>();
            double advancementRange = 30.0;
            for (DinosaurEntity dinosaur : this.m_9236_().m_45976_(DinosaurEntity.class, this.m_20191_().m_82377_(advancementRange, advancementRange, advancementRange))) {
                if (!(dinosaur.m_20201_() instanceof AbstractMinecart) || nearbyDinosaurEntityTypes.contains(dinosaur.m_6095_())) continue;
                nearbyDinosaurEntityTypes.add(dinosaur.m_6095_());
            }
            if (nearbyDinosaurEntityTypes.size() >= 5) {
                for (Player player : this.m_9236_().m_45976_(Player.class, this.m_20191_().m_82400_(advancementRange))) {
                    if (!((double)player.m_20270_((Entity)this) < advancementRange)) continue;
                    ACAdvancementTriggerRegistry.DINOSAURS_MINECART.triggerForEntity((Entity)player);
                }
            }
        }
        return flag;
    }

    public boolean m_7307_(Entity entityIn) {
        if (this.m_21824_()) {
            LivingEntity livingentity = this.m_269323_();
            if (entityIn == livingentity) {
                return true;
            }
            if (entityIn instanceof TamableAnimal) {
                return ((TamableAnimal)entityIn).m_21830_(livingentity);
            }
            if (livingentity != null) {
                return livingentity.m_7307_(entityIn);
            }
        }
        return super.m_7307_(entityIn);
    }

    public boolean canOwnerMount(Player player) {
        return false;
    }

    public boolean canOwnerCommand(Player ownerPlayer) {
        return false;
    }

    public boolean stopTickingPathing() {
        return this.m_21825_() || this.m_20160_() || this.isDancing();
    }
}

