/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.living;

import com.github.alexmodguy.alexscaves.AlexsCaves;
import com.github.alexmodguy.alexscaves.client.particle.ACParticleRegistry;
import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import com.github.alexmodguy.alexscaves.server.block.FissurePrimalMagmaBlock;
import com.github.alexmodguy.alexscaves.server.entity.ai.LookForwardsGoal;
import com.github.alexmodguy.alexscaves.server.entity.ai.LuxtructosaurusMeleeGoal;
import com.github.alexmodguy.alexscaves.server.entity.ai.MobTarget3DGoal;
import com.github.alexmodguy.alexscaves.server.entity.item.TephraEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.DinosaurEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.SauropodBaseEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.TremorzillaEntity;
import com.github.alexmodguy.alexscaves.server.entity.util.ACBossEvent;
import com.github.alexmodguy.alexscaves.server.entity.util.KaijuMob;
import com.github.alexmodguy.alexscaves.server.level.storage.ACWorldData;
import com.github.alexmodguy.alexscaves.server.message.UpdateBossEruptionStatus;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACTagRegistry;
import com.github.alexmodguy.alexscaves.server.misc.VoronoiGenerator;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;

public class LuxtructosaurusEntity
extends SauropodBaseEntity
implements Enemy {
    private static final EntityDataAccessor<Boolean> ENRAGED = SynchedEntityData.m_135353_(LuxtructosaurusEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final VoronoiGenerator VORONOI_GENERATOR = new VoronoiGenerator(42L);
    private float prevEnragedProgress = 0.0f;
    private float enragedProgress = 0.0f;
    public Vec3 jumpTarget = null;
    public int enragedFor = 0;
    private BlockPos lastStompPos;
    private int postStopTicks;
    private boolean stompMakesFissures;
    private boolean prevOnGround;
    private final ACBossEvent bossEvent = (ACBossEvent)new ACBossEvent(this.m_5446_(), 0).m_7005_(true);
    private int reducedDamageTicks;
    private boolean collectedLoot = false;
    private List<ItemStack> deathItems = new ArrayList<ItemStack>();
    private int lastScareTimestamp;

    public LuxtructosaurusEntity(EntityType entityType, Level level) {
        super(entityType, level);
        this.m_21441_(BlockPathTypes.LEAVES, 0.0f);
        VORONOI_GENERATOR.setOffsetAmount(1.0);
        VORONOI_GENERATOR.setDistanceType(VoronoiGenerator.DistanceType.euclidean);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new LuxtructosaurusMeleeGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0, 10){

            protected Vec3 m_7037_() {
                return DefaultRandomPos.m_148403_((PathfinderMob)this.f_25725_, (int)30, (int)7);
            }
        });
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 30.0f));
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 10.0f));
        this.f_21345_.m_25352_(6, (Goal)new LookForwardsGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{LuxtructosaurusEntity.class}));
        this.f_21346_.m_25352_(2, (Goal)new MobTarget3DGoal((Mob)this, Player.class, false));
        this.f_21346_.m_25352_(3, (Goal)new MobTarget3DGoal((Mob)this, DinosaurEntity.class, false, 200, dinosaur -> !(dinosaur instanceof LuxtructosaurusEntity)));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ENRAGED, (Object)false);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, 0.325).m_22268_(Attributes.f_22276_, 600.0).m_22268_(Attributes.f_22284_, 20.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22281_, 12.0).m_22268_(Attributes.f_22277_, 256.0);
    }

    @Override
    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        if (this.m_8077_()) {
            this.bossEvent.m_6456_(this.m_5446_());
        }
    }

    public int m_6056_() {
        return super.m_6056_() + 10;
    }

    public void m_6593_(@Nullable Component name) {
        super.m_6593_(name);
        this.bossEvent.m_6456_(this.m_5446_());
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    @Override
    public BlockState createEggBlockState() {
        return Blocks.f_50016_.m_49966_();
    }

    @org.jetbrains.annotations.Nullable
    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob mob) {
        return null;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.prevEnragedProgress = this.enragedProgress;
        if (this.isEnraged() && this.enragedProgress < 20.0f) {
            this.enragedProgress += 1.0f;
        }
        if (!this.isEnraged() && this.enragedProgress > 0.0f) {
            this.enragedProgress -= 1.0f;
        }
        if (this.m_9236_().f_46443_) {
            if (this.m_6084_()) {
                if (this.isEnraged()) {
                    if (this.f_19796_.m_188503_(8) == 0) {
                        this.m_9236_().m_7106_((ParticleOptions)ACParticleRegistry.LUXTRUCTOSAURUS_SPIT.get(), this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), (double)this.m_19879_(), 0.0, 0.0);
                    }
                    if (this.getAnimation() == ANIMATION_RIGHT_WHIP || this.getAnimation() == ANIMATION_LEFT_WHIP) {
                        float tailPitch = this.tailPart1.calculateAnimationAngle(1.0f, true) + this.tailPart2.calculateAnimationAngle(1.0f, true) + this.tailPart3.calculateAnimationAngle(1.0f, true);
                        float tailYaw = this.f_20883_ + this.tailPart1.calculateAnimationAngle(1.0f, false) + this.tailPart2.calculateAnimationAngle(1.0f, false) + this.tailPart3.calculateAnimationAngle(1.0f, false);
                        Vec3 tailOffset = this.rotateOffsetVec(new Vec3((double)((this.f_19796_.m_188501_() - 0.5f) * 0.1f), (double)(0.5f + (this.f_19796_.m_188501_() - 0.5f) * 0.2f), (double)(-2.0f + (this.f_19796_.m_188501_() - 0.5f) * 2.0f)), tailPitch, tailYaw);
                        Vec3 tailCenter = this.tailPart3.centeredPosition().m_82549_(tailOffset);
                        this.m_9236_().m_7106_((ParticleOptions)ACParticleRegistry.TEPHRA_FLAME.get(), tailCenter.f_82479_, tailCenter.f_82480_, tailCenter.f_82481_, (double)((this.f_19796_.m_188501_() - 0.5f) * 0.1f), (double)(this.f_19796_.m_188501_() * 0.1f), (double)((this.f_19796_.m_188501_() - 0.5f) * 0.1f));
                    }
                }
                if (this.getAnimation() == ANIMATION_SPEW_FLAMES && (float)this.getAnimationTick() > 10.0f && (float)this.getAnimationTick() < 70.0f) {
                    Vec3 headPos = this.headPart.centeredPosition().m_82520_((double)((this.f_19796_.m_188501_() - 0.5f) * 0.1f), (double)((this.f_19796_.m_188501_() - 0.5f) * 0.1f), (double)((this.f_19796_.m_188501_() - 0.5f) * 0.1f));
                    float flameRot = this.f_20883_ + (this.neckPart1.calculateAnimationAngle(1.0f, false) + this.neckPart2.calculateAnimationAngle(1.0f, false) + this.neckPart3.calculateAnimationAngle(1.0f, false)) / 3.0f;
                    for (int i = -3; i <= 3; ++i) {
                        Vec3 flameDelta = this.rotateOffsetVec(new Vec3(0.0, (double)(this.f_19796_.m_188501_() * 0.2f - 0.1f), (double)(this.f_19796_.m_188501_() * 0.5f + 0.5f)), (this.f_19796_.m_188501_() - 0.5f) * 5.0f, 180.0f + flameRot + (float)(i * 10));
                        this.m_9236_().m_7106_((ParticleOptions)ACParticleRegistry.TEPHRA_FLAME.get(), headPos.f_82479_, headPos.f_82480_, headPos.f_82481_, flameDelta.f_82479_, flameDelta.f_82480_, flameDelta.f_82481_);
                    }
                }
                if (this.getAnimation() == ANIMATION_JUMP && this.getAnimationTick() > 25 && this.m_20096_() && this.getAnimationTick() > 25 && this.screenShakeAmount < 3.0f) {
                    this.screenShakeAmount = 3.0f;
                }
            }
        } else {
            Vec3 armPos;
            if (this.getAnimation() == ANIMATION_JUMP) {
                if (this.getAnimationTick() >= 15 && this.getAnimationTick() <= 25 && this.jumpTarget != null) {
                    Vec3 vec3 = this.m_20184_();
                    Vec3 vec31 = new Vec3(this.jumpTarget.f_82479_ - this.m_20185_(), 0.0, this.jumpTarget.f_82481_ - this.m_20189_());
                    if (vec31.m_82553_() > 250.0) {
                        vec31 = vec3.m_82541_().m_82490_(250.0);
                    }
                    if (vec31.m_82556_() > 1.0E-7) {
                        vec31 = vec31.m_82490_((double)0.155f).m_82549_(vec3.m_82490_(0.2));
                    }
                    this.m_20334_(vec31.f_82479_, (double)((float)(10 - Math.min(this.getAnimationTick() - 10, 10)) * 0.2f) + vec31.m_82553_() * (double)0.3f, vec31.f_82481_);
                } else {
                    if (this.m_20096_() && !this.prevOnGround) {
                        this.hurtEntitiesAround(this.m_20182_(), 10.0f, (float)this.m_21133_(Attributes.f_22281_) * 0.5f, 2.0f, false, false);
                    }
                    this.m_20256_(this.m_20184_().m_82492_(0.0, 0.2, 0.0));
                }
            }
            if (this.getAnimation() == ANIMATION_ROAR && this.getAnimationTick() >= 10 && this.getAnimationTick() < 55 && this.getAnimationTick() % 5 == 0 && this.m_6084_()) {
                BlockPos tephraSpawnAt = this.m_20183_().m_7918_(this.f_19796_.m_188503_(20) - 10, 2, this.f_19796_.m_188503_(20) - 10);
                while (tephraSpawnAt.m_123342_() < Math.min(this.m_9236_().m_151558_(), this.m_146904_() + 100) && !this.m_9236_().m_8055_(tephraSpawnAt).m_280296_()) {
                    tephraSpawnAt = tephraSpawnAt.m_7494_();
                }
                tephraSpawnAt = tephraSpawnAt.m_7495_();
                TephraEntity tephra = new TephraEntity(this.m_9236_(), (LivingEntity)this);
                tephra.m_146884_(tephraSpawnAt.m_252807_());
                tephra.setMaxScale(1.0f + 2.0f * this.m_9236_().f_46441_.m_188501_());
                Vec3 targetVec = new Vec3((double)(this.m_9236_().f_46441_.m_188501_() - 0.5f), -1.0, (double)(this.m_9236_().f_46441_.m_188501_() - 0.5f)).m_82541_().m_82490_((double)(this.m_9236_().f_46441_.m_188503_(20) + 20));
                tephra.m_6686_(targetVec.f_82479_, targetVec.f_82480_, targetVec.f_82481_, 5.0f + this.m_9236_().f_46441_.m_188501_() * 2.0f, 1.0f + this.m_9236_().f_46441_.m_188501_() * 0.5f);
                this.m_9236_().m_7967_((Entity)tephra);
            }
            if (this.getAnimation() == ANIMATION_STOMP && this.getAnimationTick() == 30 && this.postStopTicks <= 0) {
                this.stompMakesFissures = this.isEnraged();
                this.postStopTicks = this.stompMakesFissures ? 15 : 50;
                this.m_5496_((SoundEvent)ACSoundRegistry.LUXTRUCTOSAURUS_STOMP.get(), 3.0f, 1.0f);
                this.lastStompPos = this.m_20183_();
                this.hurtEntitiesAround(this.m_20182_(), 10.0f, (float)this.m_21133_(Attributes.f_22281_) * 1.2f, 2.0f, false, false);
            }
            if (this.getAnimation() == ANIMATION_RIGHT_KICK && this.getAnimationTick() == 8) {
                armPos = this.m_20182_().m_82549_(this.rotateOffsetVec(new Vec3(-2.0, 0.0, 2.5), 0.0f, this.f_20883_));
                this.hurtEntitiesAround(armPos, 5.0f, (float)this.m_21133_(Attributes.f_22281_) * 0.8f, 2.0f, false, false);
            }
            if (this.getAnimation() == ANIMATION_LEFT_KICK && this.getAnimationTick() == 8) {
                armPos = this.m_20182_().m_82549_(this.rotateOffsetVec(new Vec3(2.0, 0.0, 2.5), 0.0f, this.f_20883_));
                this.hurtEntitiesAround(armPos, 5.0f, (float)this.m_21133_(Attributes.f_22281_) * 0.8f, 2.0f, false, false);
            }
            if ((this.getAnimation() == ANIMATION_LEFT_WHIP || this.getAnimation() == ANIMATION_RIGHT_WHIP) && this.getAnimationTick() > 20 && this.getAnimationTick() < 30) {
                this.hurtEntitiesAround(this.tailPart2.m_20182_(), 12.0f, (float)this.m_21133_(Attributes.f_22281_), 2.0f, this.isEnraged(), true);
            }
            if (this.getAnimation() == ANIMATION_SPEW_FLAMES && this.getAnimationTick() > 10 && this.getAnimationTick() < 70) {
                this.burnWithBreath(13.0f);
            }
            if (this.postStopTicks > 0) {
                --this.postStopTicks;
                if (this.screenShakeAmount < 3.0f) {
                    this.screenShakeAmount = 3.0f;
                }
                this.tickStompAttack();
            }
            if (this.reducedDamageTicks > 0) {
                --this.reducedDamageTicks;
            }
            if (!this.m_21525_() && this.f_19797_ % 10 == 0) {
                LivingEntity target = this.m_5448_();
                Player closestPlayer = this.m_9236_().m_45930_((Entity)this, 150.0);
                if (target != null && target.m_6084_() && !(target instanceof Player) && closestPlayer == null) {
                    this.m_5634_(6.0f);
                }
            }
        }
        if (!this.m_21525_()) {
            if (this.f_19797_ % 60 == 0 && this.getAnimation() != ANIMATION_ROAR && this.m_6084_()) {
                if (this.m_9236_().f_46443_) {
                    Vec3 headCenter = this.headPart.centeredPosition();
                    Vec3 nostilRightDelta = this.rotateOffsetVec(new Vec3(-0.25, 0.5, 0.75), this.m_146909_(), this.m_6080_());
                    Vec3 nostilRight = headCenter.m_82549_(nostilRightDelta);
                    Vec3 nostilLeftDelta = this.rotateOffsetVec(new Vec3(0.25, 0.5, 0.75), this.m_146909_(), this.m_6080_());
                    Vec3 nostilLeft = headCenter.m_82549_(nostilLeftDelta);
                    nostilRightDelta = nostilRightDelta.m_82490_((double)0.1f);
                    nostilLeftDelta = nostilLeftDelta.m_82490_((double)0.1f);
                    ParticleOptions types = (ParticleOptions)ACParticleRegistry.TEPHRA_SMALL.get();
                    this.m_9236_().m_7106_(types, nostilRight.f_82479_, nostilRight.f_82480_, nostilRight.f_82481_, nostilRightDelta.f_82479_, nostilRightDelta.f_82480_, nostilRightDelta.f_82481_);
                    this.m_9236_().m_7106_(types, nostilLeft.f_82479_, nostilLeft.f_82480_, nostilLeft.f_82481_, nostilLeftDelta.f_82479_, nostilLeftDelta.f_82480_, nostilLeftDelta.f_82481_);
                }
                this.m_5496_((SoundEvent)ACSoundRegistry.LUXTRUCTOSAURUS_SNORT.get(), this.m_6121_(), this.m_6100_());
            }
            if (this.getAnimation() == ANIMATION_ROAR && this.getAnimationTick() > 10 && this.getAnimationTick() < 50 && !this.m_9236_().f_46443_) {
                this.scareMobs();
            }
        }
        if (this.getAnimation() == ANIMATION_SUMMON && this.getAnimationTick() > 5 && !this.m_21023_(MobEffects.f_19609_)) {
            this.m_6842_(false);
            this.m_5496_((SoundEvent)ACSoundRegistry.LUXTRUCTOSAURUS_SUMMON.get(), 3.0f, 1.0f);
        }
        if (this.getAnimation() == ANIMATION_ROAR && this.getAnimationTick() == 2 && this.m_6084_()) {
            this.m_5496_((SoundEvent)ACSoundRegistry.LUXTRUCTOSAURUS_ROAR.get(), 5.0f, this.m_6100_());
        }
        if (this.getAnimation() == ANIMATION_SPEW_FLAMES && this.getAnimationTick() == 10) {
            this.m_5496_((SoundEvent)ACSoundRegistry.LUXTRUCTOSAURUS_BREATH.get(), 5.0f, this.m_6100_());
        }
        this.prevOnGround = this.m_20096_();
    }

    protected void m_6153_() {
        if (this.f_20919_ <= 0) {
            this.toggleServerEruptionStatus(false);
        }
        ++this.f_20919_;
        this.setAnimation(ANIMATION_EPIC_DEATH);
        this.setEnraged(true);
        this.screenShakeAmount = 0.0f;
        this.m_146926_(0.0f);
        this.m_5616_(this.m_146908_());
        if (!this.m_9236_().f_46443_ && !this.collectedLoot) {
            this.populateDeathLootForLuxtructosaurus();
        }
        if (this.getAnimation() == ANIMATION_EPIC_DEATH) {
            if (this.getAnimationTick() >= 100 && this.getAnimationTick() <= 110 && this.m_9236_().f_46443_) {
                for (int i = 0; i < 50; ++i) {
                    this.m_9236_().m_6485_((ParticleOptions)ACParticleRegistry.LUXTRUCTOSAURUS_ASH.get(), true, this.m_20185_(), this.m_20186_(), this.m_20189_(), (double)this.m_19879_(), 0.0, 0.0);
                }
            }
            if (this.getAnimationTick() > 110 && !this.m_9236_().m_5776_() & !this.m_213877_()) {
                if (!this.deathItems.isEmpty()) {
                    ItemStack currentStack = ItemStack.f_41583_;
                    while (!this.deathItems.isEmpty() || !currentStack.m_41619_()) {
                        if (currentStack.m_41619_()) {
                            currentStack = this.deathItems.remove(0);
                        }
                        if (currentStack.m_41613_() <= 0) continue;
                        ItemStack one = currentStack.m_41777_();
                        one.m_41764_(1);
                        currentStack.m_41774_(1);
                        this.m_19983_(one);
                    }
                }
                this.m_9236_().m_7605_((Entity)this, (byte)60);
                this.m_142687_(Entity.RemovalReason.KILLED);
            }
        }
    }

    private void populateDeathLootForLuxtructosaurus() {
        ResourceLocation resourcelocation = this.m_5743_();
        DamageSource damageSource = this.m_21225_();
        if (damageSource != null) {
            LootTable loottable = this.m_9236_().m_7654_().m_278653_().m_278676_(resourcelocation);
            LootParams.Builder lootparams$builder = new LootParams.Builder((ServerLevel)this.m_9236_()).m_287286_(LootContextParams.f_81455_, (Object)this).m_287286_(LootContextParams.f_81460_, (Object)this.m_20182_()).m_287286_(LootContextParams.f_81457_, (Object)damageSource).m_287289_(LootContextParams.f_81458_, (Object)damageSource.m_7639_()).m_287289_(LootContextParams.f_81459_, (Object)damageSource.m_7640_());
            if (this.f_20888_ != null) {
                lootparams$builder = lootparams$builder.m_287286_(LootContextParams.f_81456_, (Object)this.f_20888_).m_287239_(this.f_20888_.m_36336_());
            }
            LootParams lootparams = lootparams$builder.m_287235_(LootContextParamSets.f_81415_);
            loottable.m_287276_(lootparams, this.m_287233_(), this.deathItems::add);
        }
        this.collectedLoot = true;
    }

    public ItemEntity m_19983_(ItemStack stack) {
        ItemEntity itementity = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), stack);
        if (itementity != null) {
            Vec3 centerOfMob = this.m_20182_().m_82520_((double)(3.0f - 6.0f * this.f_19796_.m_188501_()), 4.0, (double)(3.0f - 6.0f * this.f_19796_.m_188501_()));
            Vec3 randomDelta = new Vec3((double)(1.0f - this.f_19796_.m_188501_()), 0.0, (double)(1.0f - this.f_19796_.m_188501_())).m_82541_().m_82490_((double)(this.f_19796_.m_188501_() * 0.4f + 0.4f)).m_82520_(0.0, 0.2, 0.0);
            itementity.m_146884_(centerOfMob);
            itementity.m_20256_(randomDelta);
            itementity.m_146915_(true);
            itementity.m_32060_();
            itementity.m_149678_();
        }
        this.m_9236_().m_7967_((Entity)itementity);
        return itementity;
    }

    protected void m_7625_(DamageSource damageSource, boolean b) {
    }

    protected float m_6121_() {
        return 3.0f;
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().f_46443_) {
            this.bossEvent.m_142711_(this.m_21223_() / this.m_21233_());
            if (this.enragedFor > 0) {
                --this.enragedFor;
            } else if (this.isEnraged() && (double)this.m_21223_() >= Math.ceil(this.m_21233_() * 0.25f)) {
                this.setEnraged(false);
            }
            if (this.f_19862_ || this.m_20069_() || ForgeEventFactory.getMobGriefingEvent((Level)this.m_9236_(), (Entity)this)) {
                AABB aabb = this.m_20191_().m_82400_(0.2);
                if (this.getAnimation() == ANIMATION_JUMP && this.getAnimationTick() > 24 && this.m_20096_()) {
                    return;
                }
                for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)(aabb.f_82288_ - 1.0)), (int)Mth.m_14107_((double)(aabb.f_82289_ - 1.0)), (int)Mth.m_14107_((double)(aabb.f_82290_ - 1.0)), (int)Mth.m_14165_((double)(aabb.f_82291_ + 1.0)), (int)Mth.m_14165_((double)(aabb.f_82292_ + 2.0)), (int)Mth.m_14165_((double)(aabb.f_82293_ + 1.0)))) {
                    BlockState blockstate = this.m_9236_().m_8055_(blockpos);
                    if (blockstate.m_204336_(ACTagRegistry.LUXTRUCTOSAURUS_BREAKS)) {
                        this.m_9236_().m_46953_(blockpos, (double)this.f_19796_.m_188501_() < (Double)AlexsCaves.COMMON_CONFIG.luxtructosaurusBlockDropChance.get(), (Entity)this);
                    }
                    if (!blockstate.m_60819_().m_205070_(FluidTags.f_13131_)) continue;
                    this.m_9236_().m_7731_(blockpos, ForgeEventFactory.fireFluidPlaceBlockEvent((LevelAccessor)this.m_9236_(), (BlockPos)blockpos, (BlockPos)blockpos, (BlockState)Blocks.f_50069_.m_49966_()), 3);
                    this.m_9236_().m_46796_(1501, blockpos, 0);
                }
            }
        }
    }

    @Override
    protected void onStep() {
        if (this.screenShakeAmount <= 1.0f) {
            this.m_5496_((SoundEvent)ACSoundRegistry.LUXTRUCTOSAURUS_STEP.get(), 4.0f, 1.0f);
        }
        if (this.screenShakeAmount <= 3.0f) {
            this.screenShakeAmount = 3.0f;
        }
    }

    public void m_6457_(ServerPlayer serverPlayer) {
        super.m_6457_(serverPlayer);
        this.bossEvent.m_6543_(serverPlayer);
        this.toggleServerEruptionStatus(true);
    }

    public void m_6452_(ServerPlayer serverPlayer) {
        super.m_6452_(serverPlayer);
        this.bossEvent.m_6539_(serverPlayer);
        if (this.bossEvent.m_8324_().isEmpty()) {
            this.toggleServerEruptionStatus(false);
        }
    }

    public boolean m_6094_() {
        return false;
    }

    public void m_7334_(Entity entity) {
        double d1;
        double d0;
        double d2;
        if (!this.m_20365_(entity) && !entity.f_19794_ && !this.f_19794_ && (d2 = Mth.m_14005_((double)(d0 = entity.m_20185_() - this.m_20185_()), (double)(d1 = entity.m_20189_() - this.m_20189_()))) >= (double)0.01f) {
            d2 = Math.sqrt(d2);
            d0 /= d2;
            d1 /= d2;
            double d3 = 1.0 / d2;
            if (d3 > 1.0) {
                d3 = 1.0;
            }
            d0 *= d3;
            d1 *= d3;
            d0 *= (double)0.05f;
            d1 *= (double)0.05f;
            if (!entity.m_20160_() && (entity.m_6094_() || entity instanceof KaijuMob)) {
                entity.m_5997_(d0, 0.0, d1);
            }
        }
    }

    protected boolean m_8028_() {
        return true;
    }

    @Override
    public boolean canFeelShake(Entity player) {
        return player.m_20096_() || this.getAnimation() == ANIMATION_ROAR && this.m_6084_();
    }

    public void m_142687_(Entity.RemovalReason removalReason) {
        super.m_142687_(removalReason);
        this.toggleServerEruptionStatus(false);
    }

    private void toggleServerEruptionStatus(boolean erupting) {
        ACWorldData worldData;
        if (!this.m_9236_().f_46443_ && (worldData = ACWorldData.get(this.m_9236_())) != null) {
            worldData.trackPrimordialBoss(this.m_19879_(), erupting);
            AlexsCaves.sendMSGToAll(new UpdateBossEruptionStatus(this.m_19879_(), worldData.isPrimordialBossActive(this.m_9236_())));
        }
    }

    public boolean isLoadedInWorld() {
        return this.m_9236_().m_7232_(SectionPos.m_235865_((double)this.m_20185_()), SectionPos.m_235865_((double)this.m_20189_()));
    }

    public boolean isEnraged() {
        return (Boolean)this.f_19804_.m_135370_(ENRAGED);
    }

    public void setEnraged(boolean enraged) {
        this.f_19804_.m_135381_(ENRAGED, (Object)enraged);
    }

    public float getEnragedProgress(float partialTicks) {
        return (this.prevEnragedProgress + (this.enragedProgress - this.prevEnragedProgress) * partialTicks) * 0.05f;
    }

    protected void m_7840_(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    @Override
    public boolean isDancing() {
        return false;
    }

    private void tickStompAttack() {
        BlockPos pos;
        BlockPos blockPos = pos = this.lastStompPos == null ? this.m_20183_() : this.lastStompPos;
        if (this.stompMakesFissures) {
            int fissureProgress = Math.max(0, (int)Math.ceil((float)(20 - this.postStopTicks) * 2.3f));
            this.placeFissureRing(1 + fissureProgress, pos.m_123341_(), pos.m_123343_());
        } else if (this.postStopTicks >= 15) {
            this.crushBlocksInRing(12, pos.m_123341_(), pos.m_123343_(), 0.2f);
        }
    }

    @Override
    public boolean m_6469_(DamageSource damageSource, float damageAmount) {
        boolean prev;
        if (this.reducedDamageTicks > 0) {
            damageAmount *= 0.35f;
        }
        if (damageSource.m_7640_() instanceof DinosaurEntity && !(damageSource.m_7640_() instanceof TremorzillaEntity)) {
            damageAmount = (float)((double)damageAmount * 0.65);
        }
        if (damageSource.m_7639_() instanceof AbstractGolem) {
            damageAmount *= 0.5f;
        }
        if (damageSource.m_7639_() instanceof Warden) {
            damageAmount *= 0.25f;
        }
        if ((prev = super.m_6469_(damageSource, damageAmount)) && this.reducedDamageTicks == 0) {
            this.reducedDamageTicks = 10;
        }
        return prev;
    }

    @Override
    public boolean m_6673_(DamageSource damageSource) {
        return damageSource.m_276093_(DamageTypes.f_268612_) | super.m_6673_(damageSource);
    }

    private void scareMobs() {
        if (this.f_19797_ - this.lastScareTimestamp > 5) {
            this.lastScareTimestamp = this.f_19797_;
        }
        List list = this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82377_(64.0, 20.0, 64.0));
        for (LivingEntity e : list) {
            PathfinderMob mob;
            if (e.m_6095_().m_204039_(ACTagRegistry.RESISTS_TREMORSAURUS_ROAR) || this.m_7307_((Entity)e)) continue;
            if (!(!(e instanceof PathfinderMob) || (mob = (PathfinderMob)e) instanceof TamableAnimal && ((TamableAnimal)mob).m_21825_())) {
                Vec3 vec;
                mob.m_6710_(null);
                mob.m_6703_(null);
                if (mob.m_20096_()) {
                    Vec3 randomShake = new Vec3((double)(this.f_19796_.m_188501_() - 0.5f), 0.0, (double)(this.f_19796_.m_188501_() - 0.5f)).m_82490_((double)0.1f);
                    mob.m_20256_(mob.m_20184_().m_82542_((double)0.7f, 1.0, (double)0.7f).m_82549_(randomShake));
                }
                if (this.lastScareTimestamp == this.f_19797_) {
                    mob.m_21573_().m_26573_();
                }
                if (mob.m_21573_().m_26571_() && (vec = LandRandomPos.m_148521_((PathfinderMob)mob, (int)30, (int)7, (Vec3)this.m_20182_())) != null) {
                    mob.m_21573_().m_26519_(vec.f_82479_, vec.f_82480_, vec.f_82481_, 2.0);
                }
            }
            if (!this.m_21824_()) continue;
            e.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 200, 0, true, true));
        }
    }

    private void placeFissureRing(int width, int fissureStartX, int fissureStartZ) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        int eyeBlockY = (int)this.m_20227_(0.5);
        BlockPos center = new BlockPos(fissureStartX, eyeBlockY, fissureStartZ);
        for (int i = -width - 1; i <= width + 1; ++i) {
            for (int j = -width - 1; j <= width + 1; ++j) {
                mutableBlockPos.m_122178_(this.m_146903_() + i, eyeBlockY, this.m_146907_() + j);
                double dist = Math.sqrt(mutableBlockPos.m_123331_((Vec3i)center));
                if (!(dist <= (double)(width + 2)) || !(dist > (double)(width - 2)) || !this.m_9236_().m_46749_((BlockPos)mutableBlockPos)) continue;
                while (this.canFissureMoveThrough(mutableBlockPos)) {
                    mutableBlockPos.m_122184_(0, -1, 0);
                }
                mutableBlockPos.m_122184_(0, 1, 0);
                if (!this.placeFissureBlock(mutableBlockPos)) continue;
                ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)((SimpleParticleType)ACParticleRegistry.MUSHROOM_CLOUD_EXPLOSION.get()), (double)((float)mutableBlockPos.m_123341_() + this.f_19796_.m_188501_()), (double)((float)mutableBlockPos.m_123342_() + 0.5f + this.f_19796_.m_188501_()), (double)((float)mutableBlockPos.m_123343_() + this.f_19796_.m_188501_()), 0, 0.0, 0.0, 0.0, 1.0);
            }
        }
    }

    private boolean placeFissureBlock(BlockPos.MutableBlockPos blockPos) {
        float sampleScale = 0.08f;
        int depth = 4;
        VoronoiGenerator.VoronoiInfo info = VORONOI_GENERATOR.get2((float)blockPos.m_123341_() * sampleScale, (float)blockPos.m_123343_() * sampleScale);
        boolean flag = false;
        if (info.distance1() - (double)(sampleScale * 4.0f) < info.distance()) {
            if (ForgeEventFactory.getMobGriefingEvent((Level)this.m_9236_(), (Entity)this)) {
                int y = blockPos.m_123342_();
                for (int i = 0; i <= depth; ++i) {
                    BlockState state = this.m_9236_().m_8055_((BlockPos)blockPos);
                    if (blockPos.m_123342_() <= this.m_9236_().m_141937_() || state.m_204336_(ACTagRegistry.UNMOVEABLE) || state.m_60713_((Block)ACBlockRegistry.FISSURE_PRIMAL_MAGMA.get())) break;
                    if (i < depth && !state.m_204336_(ACTagRegistry.REGENERATES_AFTER_PRIMORDIAL_BOSS_FIGHT)) {
                        this.m_9236_().m_46961_((BlockPos)blockPos, (double)this.f_19796_.m_188501_() < (Double)AlexsCaves.COMMON_CONFIG.luxtructosaurusBlockDropChance.get());
                    } else {
                        this.m_9236_().m_46597_((BlockPos)blockPos, i == depth ? (BlockState)((Block)ACBlockRegistry.FISSURE_PRIMAL_MAGMA.get()).m_49966_().m_61124_((Property)FissurePrimalMagmaBlock.REGEN_HEIGHT, (Comparable)Integer.valueOf(Mth.m_14045_((int)(i - 1), (int)0, (int)4))) : Blocks.f_50016_.m_49966_());
                    }
                    flag = true;
                    blockPos.m_122184_(0, -1, 0);
                }
                blockPos.m_142448_(y);
            } else {
                return true;
            }
        }
        return flag;
    }

    private boolean canFissureMoveThrough(BlockPos.MutableBlockPos blockPos) {
        if (blockPos.m_123342_() <= this.m_9236_().m_141937_()) {
            return false;
        }
        BlockState state = this.m_9236_().m_8055_((BlockPos)blockPos);
        return !state.m_280296_() || state.m_204336_(BlockTags.f_13035_) || state.m_204336_(BlockTags.f_13106_) || !state.m_60838_((BlockGetter)this.m_9236_(), (BlockPos)blockPos);
    }

    @Override
    public float getProjectileDamageReduction() {
        return 0.55f;
    }

    @Override
    public int getAltSkinForItem(ItemStack stack) {
        return 0;
    }

    private void burnWithBreath(float maxDistance) {
        float burnWidth = 1.0f;
        Vec3 headPos = this.headPart.centeredPosition();
        float burnAngle = this.f_20883_ + this.neckYRot;
        for (float distanceBurned = 0.0f; distanceBurned < maxDistance; distanceBurned += burnWidth) {
            burnWidth += 1.0f;
            Vec3 burnPos = headPos.m_82549_(this.rotateOffsetVec(new Vec3(0.0, 0.0, (double)distanceBurned), 0.0f, burnAngle));
            if (this.f_19796_.m_188501_() < 0.5f * (1.0f - (maxDistance - distanceBurned) / maxDistance)) {
                BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
                pos.m_122169_(burnPos.f_82479_ + (double)((this.f_19796_.m_188501_() - 0.5f) * 2.0f * distanceBurned), burnPos.f_82480_, burnPos.f_82481_ + (double)((this.f_19796_.m_188501_() - 0.5f) * 2.0f * distanceBurned));
                while (this.canFissureMoveThrough(pos)) {
                    pos.m_122184_(0, -1, 0);
                }
                pos.m_122184_(0, 1, 0);
                if (this.m_9236_().m_8055_((BlockPos)pos).m_247087_()) {
                    this.m_9236_().m_46597_((BlockPos)pos, Blocks.f_50083_.m_49966_());
                }
            }
            this.hurtEntitiesAround(burnPos, burnWidth, 3.0f, 0.3f, true, false);
        }
    }

    protected void m_21268_(@Nullable LivingEntity living) {
        ACWorldData worldData;
        if (living != null && (worldData = ACWorldData.get(this.m_9236_())) != null) {
            boolean prev = worldData.isPrimordialBossDefeatedOnce();
            worldData.setPrimordialBossDefeatedOnce(true);
            if (!prev) {
                worldData.setFirstPrimordialBossDefeatTimestamp(this.m_9236_().m_46467_());
                Level level = this.m_9236_();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.m_8795_(EntitySelector.f_20408_).forEach(serverPlayer -> serverPlayer.m_5661_((Component)Component.m_237115_((String)"entity.alexscaves.luxtructosaurus.slain_message").m_130940_(ChatFormatting.GOLD), true));
                }
            }
        }
        super.m_21268_(living);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ACSoundRegistry.LUXTRUCTOSAURUS_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)ACSoundRegistry.LUXTRUCTOSAURUS_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ACSoundRegistry.LUXTRUCTOSAURUS_DEATH.get();
    }

    public int m_213860_() {
        return 100;
    }
}

