/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.living;

import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import com.github.alexmodguy.alexscaves.server.block.PewenBranchBlock;
import com.github.alexmodguy.alexscaves.server.entity.ACEntityRegistry;
import com.github.alexmodguy.alexscaves.server.entity.ai.AdvancedPathNavigateNoTeleport;
import com.github.alexmodguy.alexscaves.server.entity.ai.AnimalBreedEggsGoal;
import com.github.alexmodguy.alexscaves.server.entity.ai.AnimalLayEggGoal;
import com.github.alexmodguy.alexscaves.server.entity.ai.RelicheirusMeleeGoal;
import com.github.alexmodguy.alexscaves.server.entity.ai.RelicheirusNibblePewensGoal;
import com.github.alexmodguy.alexscaves.server.entity.ai.RelicheirusPushTreesGoal;
import com.github.alexmodguy.alexscaves.server.entity.living.DinosaurEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.TrilocarisEntity;
import com.github.alexmodguy.alexscaves.server.item.ACItemRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.github.alexthe666.citadel.animation.LegSolverQuadruped;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class RelicheirusEntity
extends DinosaurEntity
implements IAnimatedEntity {
    public LegSolverQuadruped legSolver = new LegSolverQuadruped(-0.15f, 0.6f, 0.5f, 0.75f, 1.0f);
    private static final EntityDataAccessor<Integer> PECK_Y = SynchedEntityData.m_135353_(RelicheirusEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> HELD_MOB_ID = SynchedEntityData.m_135353_(RelicheirusEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> PUSHING_TREES_FOR = SynchedEntityData.m_135353_(RelicheirusEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private Animation currentAnimation;
    private int animationTick;
    public static final Animation ANIMATION_SPEAK_1 = Animation.create((int)13);
    public static final Animation ANIMATION_SPEAK_2 = Animation.create((int)20);
    public static final Animation ANIMATION_EAT_TREE = Animation.create((int)40);
    public static final Animation ANIMATION_EAT_TRILOCARIS = Animation.create((int)50);
    public static final Animation ANIMATION_PUSH_TREE = Animation.create((int)60);
    public static final Animation ANIMATION_SCRATCH_1 = Animation.create((int)60);
    public static final Animation ANIMATION_SCRATCH_2 = Animation.create((int)40);
    public static final Animation ANIMATION_SHAKE = Animation.create((int)30);
    public static final Animation ANIMATION_MELEE_SLASH_1 = Animation.create((int)20);
    public static final Animation ANIMATION_MELEE_SLASH_2 = Animation.create((int)20);
    private float prevRaiseArmsAmount = 0.0f;
    private float raiseArmsAmount = 0.0f;

    public RelicheirusEntity(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(PECK_Y, (Object)0);
        this.f_19804_.m_135372_(HELD_MOB_ID, (Object)-1);
        this.f_19804_.m_135372_(PUSHING_TREES_FOR, (Object)0);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22281_, 12.0).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22276_, 120.0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new RelicheirusMeleeGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new AnimalBreedEggsGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new AnimalLayEggGoal((Animal)this, 100, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new TemptGoal((PathfinderMob)this, 1.1, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ACBlockRegistry.TREE_STAR.get()}), false));
        this.f_21345_.m_25352_(5, (Goal)new RelicheirusPushTreesGoal(this, 25));
        this.f_21345_.m_25352_(6, (Goal)new RelicheirusNibblePewensGoal(this, 20));
        this.f_21345_.m_25352_(7, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0, 45));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(9, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{RelicheirusEntity.class}));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, TrilocarisEntity.class, 100, true, false, null));
    }

    protected PathNavigation m_6037_(Level level) {
        return new AdvancedPathNavigateNoTeleport((Mob)this, level);
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        if (!this.m_6162_()) {
            this.m_5496_((SoundEvent)ACSoundRegistry.RELICHEIRUS_STEP.get(), 1.0f, 1.0f);
        }
    }

    protected float m_6431_(Pose pose, EntityDimensions dimensions) {
        return 0.99f * dimensions.f_20378_;
    }

    @Override
    public boolean onFeedMixture(ItemStack itemStack, Player player) {
        if (itemStack.m_150930_((Item)ACItemRegistry.PRIMORDIAL_SOUP.get())) {
            this.setPushingTreesFor(1200);
            return true;
        }
        return false;
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        InteractionResult prev = super.m_6071_(player, hand);
        ItemStack itemstack = player.m_21120_(hand);
        if (!prev.m_19077_() && itemstack.m_150930_((Item)ACItemRegistry.PRIMORDIAL_SOUP.get())) {
            if (!itemstack.getCraftingRemainingItem().m_41619_()) {
                this.m_19983_(itemstack.getCraftingRemainingItem().m_41777_());
            }
            this.m_142075_(player, hand, itemstack);
            return InteractionResult.SUCCESS;
        }
        return prev;
    }

    public void m_5997_(double x, double y, double z) {
        if (this.getAnimation() != ANIMATION_EAT_TRILOCARIS) {
            super.m_5997_(x, y, z);
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.getAnimation() != ANIMATION_EAT_TREE) {
            this.f_20883_ = Mth.m_14148_((float)this.f_20884_, (float)this.f_20883_, (float)this.m_21529_());
        }
        this.prevRaiseArmsAmount = this.raiseArmsAmount;
        this.legSolver.update((LivingEntity)this, this.f_20883_, this.m_6134_());
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
        if (this.shouldRaiseArms() && this.raiseArmsAmount < 5.0f) {
            this.raiseArmsAmount += 1.0f;
        }
        if (!this.shouldRaiseArms() && this.raiseArmsAmount > 0.0f) {
            this.raiseArmsAmount -= 1.0f;
        }
        if (this.f_19797_ % 100 == 0 && this.m_21223_() < this.m_21233_()) {
            this.m_5634_(2.0f);
        }
        if (!this.m_9236_().f_46443_) {
            if (this.isStillEnough() && this.f_19796_.m_188503_(200) == 0 && this.getAnimation() == NO_ANIMATION && !this.isDancing()) {
                float rand = this.f_19796_.m_188501_();
                Animation idle = rand < 0.15f ? ANIMATION_SCRATCH_1 : (rand < 0.3f ? ANIMATION_SCRATCH_2 : ANIMATION_SHAKE);
                this.setAnimation(idle);
            }
            boolean held = false;
            LivingEntity target = this.m_5448_();
            if (target != null && target.m_20270_((Entity)this) < 10.0f && target instanceof TrilocarisEntity && this.getAnimation() == ANIMATION_EAT_TRILOCARIS) {
                if (this.getAnimationTick() < 20) {
                    held = true;
                    this.setHeldMobId(target.m_19879_());
                } else if (this.getAnimationTick() <= 50) {
                    Vec3 trilocarisPos = this.getTrilocarisPos();
                    target.m_146884_(trilocarisPos);
                    if (this.getAnimationTick() >= 45 && target.m_6084_()) {
                        target.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), 20.0f);
                    }
                    held = true;
                    target.f_19789_ = 0.0f;
                }
            }
            if (!held && this.getHeldMobId() != -1) {
                this.setHeldMobId(-1);
            }
            if (this.getPushingTreesFor() > 0) {
                this.setPushingTreesFor(this.getPushingTreesFor() - 1);
            }
        }
        if (this.getAnimation() == ANIMATION_SPEAK_1 && this.getAnimationTick() == 1 || this.getAnimation() == ANIMATION_SPEAK_2 && this.getAnimationTick() == 1) {
            this.actuallyPlayAmbientSound();
        }
    }

    public AABB m_6921_() {
        return this.m_20191_().m_82377_(3.0, 3.0, 3.0);
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel level, AgeableMob mob) {
        return (AgeableMob)((EntityType)ACEntityRegistry.RELICHEIRUS.get()).m_20615_((Level)level);
    }

    private Vec3 getTrilocarisPos() {
        Vec3 triloUp = new Vec3(0.0, 0.0, 1.5);
        if (this.getAnimation() == ANIMATION_EAT_TRILOCARIS && (float)this.getAnimationTick() >= 15.0f) {
            float anim1 = Math.min((float)this.getAnimationTick() - 15.0f, 15.0f) / 15.0f;
            float anim2 = Math.min((float)this.getAnimationTick(), 15.0f) / 15.0f;
            triloUp = triloUp.m_82520_(0.0, (double)((this.m_20192_() + 1.0f) * anim1), (double)(anim2 * -1.0f + 1.0f));
        }
        Vec3 head = triloUp.m_82496_(-this.m_146909_() * ((float)Math.PI / 180)).m_82524_(-this.m_6080_() * ((float)Math.PI / 180));
        return this.m_20182_().m_82549_(head);
    }

    private boolean isStillEnough() {
        return this.m_20184_().m_165924_() < 0.05;
    }

    public boolean shouldRaiseArms() {
        return this.getAnimation() == ANIMATION_EAT_TREE || this.getAnimation() == ANIMATION_PUSH_TREE || this.getAnimation() == ANIMATION_SCRATCH_1 || this.getAnimation() == ANIMATION_SCRATCH_2 || this.getAnimation() == ANIMATION_MELEE_SLASH_1 || this.getAnimation() == ANIMATION_MELEE_SLASH_2;
    }

    public void setPeckY(int y) {
        this.f_19804_.m_135381_(PECK_Y, (Object)y);
    }

    public int getPeckY() {
        return (Integer)this.f_19804_.m_135370_(PECK_Y);
    }

    public void setHeldMobId(int i) {
        this.f_19804_.m_135381_(HELD_MOB_ID, (Object)i);
    }

    @Override
    public void m_7023_(Vec3 vec3d) {
        if (this.getAnimation() == ANIMATION_EAT_TRILOCARIS || this.isDancing()) {
            vec3d = Vec3.f_82478_;
        }
        super.m_7023_(vec3d);
    }

    public int getHeldMobId() {
        return (Integer)this.f_19804_.m_135370_(HELD_MOB_ID);
    }

    public Entity getHeldMob() {
        int id = this.getHeldMobId();
        return id == -1 ? null : this.m_9236_().m_6815_(id);
    }

    public void setPushingTreesFor(int time) {
        this.f_19804_.m_135381_(PUSHING_TREES_FOR, (Object)time);
    }

    public int getPushingTreesFor() {
        return (Integer)this.f_19804_.m_135370_(PUSHING_TREES_FOR);
    }

    public float getRaiseArmsAmount(float partialTick) {
        return (this.prevRaiseArmsAmount + (this.raiseArmsAmount - this.prevRaiseArmsAmount) * partialTick) * 0.2f;
    }

    public int m_21529_() {
        return 5;
    }

    public void m_8032_() {
        if (this.getAnimation() == NO_ANIMATION && !this.m_9236_().f_46443_) {
            this.setAnimation(this.f_19796_.m_188499_() ? ANIMATION_SPEAK_2 : ANIMATION_SPEAK_1);
        }
    }

    public void actuallyPlayAmbientSound() {
        SoundEvent soundevent = this.m_7515_();
        if (soundevent != null) {
            this.m_5496_(soundevent, this.m_6121_(), this.m_6100_());
        }
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_SPEAK_1, ANIMATION_SPEAK_2, ANIMATION_EAT_TREE, ANIMATION_EAT_TRILOCARIS, ANIMATION_PUSH_TREE, ANIMATION_SCRATCH_1, ANIMATION_SCRATCH_2, ANIMATION_SHAKE, ANIMATION_MELEE_SLASH_1, ANIMATION_MELEE_SLASH_2};
    }

    public float m_6134_() {
        return this.m_6162_() ? 0.25f : 1.0f;
    }

    public BlockPos getStandAtTreePos(BlockPos target) {
        Vec3 vec3 = Vec3.m_82512_((Vec3i)target).m_82546_(this.m_20182_());
        float f = -((float)Mth.m_14136_((double)vec3.f_82479_, (double)vec3.f_82481_)) * 180.0f / (float)Math.PI;
        BlockState state = this.m_9236_().m_8055_(target);
        Direction dir = Direction.m_122364_((double)f);
        if (state.m_60713_((Block)ACBlockRegistry.PEWEN_BRANCH.get())) {
            dir = Direction.m_122364_((double)((Integer)state.m_61143_((Property)PewenBranchBlock.ROTATION) * 45));
        }
        if (this.m_9236_().m_8055_(target.m_7495_()).m_60795_()) {
            target = target.m_121945_(dir);
        }
        return target.m_5484_(dir.m_122424_(), 4).m_175288_((int)this.m_20186_());
    }

    public boolean lockTreePosition(BlockPos target) {
        Vec3 vec31;
        Vec3 vec32;
        Vec3 vec3 = Vec3.m_82512_((Vec3i)target).m_82546_(this.m_20182_());
        float f = -((float)Mth.m_14136_((double)vec3.f_82479_, (double)vec3.f_82481_)) * 180.0f / (float)Math.PI;
        BlockState state = this.m_9236_().m_8055_(target);
        Direction dir = Direction.m_122364_((double)f);
        if (state.m_60713_((Block)ACBlockRegistry.PEWEN_BRANCH.get())) {
            dir = Direction.m_122364_((double)((Integer)state.m_61143_((Property)PewenBranchBlock.ROTATION) * 45));
        }
        float targetRot = Mth.m_14148_((float)this.m_146908_(), (float)dir.m_122435_(), (float)20.0f);
        this.m_146922_(targetRot);
        this.m_5616_(targetRot);
        this.f_20883_ = targetRot;
        if (this.m_9236_().m_8055_(target.m_7495_()).m_60795_()) {
            target = target.m_121945_(dir);
        }
        if ((vec32 = (vec31 = Vec3.m_82512_((Vec3i)target.m_5484_(dir.m_122424_(), 2))).m_82546_(this.m_20182_())).m_82553_() > 1.0) {
            vec32 = vec32.m_82541_();
        }
        Vec3 delta = new Vec3(vec32.f_82479_ * (double)0.1f, 0.0, vec32.f_82481_ * (double)0.1f);
        this.m_20256_(this.m_20184_().m_82549_(delta));
        return this.m_20275_(vec31.f_82479_, this.m_20186_(), vec31.f_82481_) < 4.0 && Mth.m_14145_((float)this.m_146908_(), (float)dir.m_122435_()) < 7.0f;
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_150930_(((Block)ACBlockRegistry.TREE_STAR.get()).m_5456_());
    }

    @Override
    public BlockState createEggBlockState() {
        return ((Block)ACBlockRegistry.RELICHEIRUS_EGG.get()).m_49966_();
    }

    public float getStepHeight() {
        return 1.1f;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ACSoundRegistry.RELICHEIRUS_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)ACSoundRegistry.RELICHEIRUS_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ACSoundRegistry.RELICHEIRUS_DEATH.get();
    }
}

