/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.living;

import com.github.alexmodguy.alexscaves.server.item.ACItemRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACTagRegistry;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.EnumSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public class SeaPigEntity
extends WaterAnimal
implements Bucketable {
    private static final EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.m_135353_(SeaPigEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private float digestProgress;
    private float prevDigestProgress;
    private float squishProgress;
    private float prevSquishProgress;
    public static final ResourceLocation DIGESTION_LOOT_TABLE = new ResourceLocation("alexscaves", "gameplay/sea_pig_digestion");

    public SeaPigEntity(EntityType entityType, Level level) {
        super(entityType, level);
        this.f_21342_ = new SmoothSwimmingMoveControl((Mob)this, 85, 10, 0.75f, 0.5f, false);
        this.m_20301_(40);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FROM_BUCKET, (Object)false);
    }

    protected PathNavigation m_6037_(Level worldIn) {
        return new WaterBoundPathNavigation((Mob)this, worldIn);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, 0.05).m_22268_(Attributes.f_22276_, 8.0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new WanderGoal());
        this.f_21345_.m_25352_(2, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
    }

    public int m_5792_() {
        return 4;
    }

    public boolean m_7296_(int sizeIn) {
        return false;
    }

    public static boolean checkSeaPigSpawnRules(EntityType<? extends LivingEntity> type, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource randomSource) {
        return level.m_6425_(pos).m_205070_(FluidTags.f_13131_) && pos.m_123342_() < level.m_5736_() - 25;
    }

    public float m_5610_(BlockPos pos, LevelReader worldIn) {
        return worldIn.m_6425_(pos.m_7495_()).m_76178_() && worldIn.m_6425_(pos).m_205070_(FluidTags.f_13131_) ? 10.0f : 0.0f;
    }

    public void m_8119_() {
        boolean grounded;
        super.m_8119_();
        this.prevDigestProgress = this.digestProgress;
        this.prevSquishProgress = this.squishProgress;
        if (this.isDigesting() && this.digestProgress < 1.0f) {
            if (this.digestProgress == 0.0f) {
                this.m_216990_((SoundEvent)ACSoundRegistry.SEA_PIG_EAT.get());
            }
            this.digestProgress += 0.05f;
            if (this.digestProgress >= 1.0f) {
                this.digestProgress = 0.0f;
                this.prevDigestProgress = 0.0f;
                this.digestItem();
            }
        }
        boolean bl = grounded = this.m_20096_() && !this.m_20072_();
        if (grounded && this.squishProgress < 5.0f) {
            this.squishProgress += 1.0f;
        }
        if (!grounded && this.squishProgress > 0.0f) {
            this.squishProgress -= 1.0f;
        }
    }

    protected void m_5625_(float f) {
    }

    protected SoundEvent m_5501_() {
        return SoundEvents.f_11938_;
    }

    protected void m_6229_(int prevAir) {
        if (this.m_6084_() && !this.m_20072_()) {
            this.m_20301_(prevAir - 1);
            if (this.m_20146_() == -20) {
                this.m_20301_(0);
                this.m_6469_(this.m_269291_().m_269483_(), 2.0f);
            }
        } else {
            this.m_20301_(40);
        }
    }

    public void m_7023_(Vec3 travelVector) {
        if (this.m_21515_() && this.m_20072_()) {
            this.m_19920_(this.m_6113_(), travelVector);
            Vec3 delta = this.m_20184_();
            this.m_6478_(MoverType.SELF, delta);
            delta = delta.m_82490_(0.8);
            delta = this.f_20899_ || this.f_19862_ && this.m_9236_().m_8055_(this.m_20183_().m_7494_()).m_60819_().m_205070_(FluidTags.f_13131_) ? delta.m_82520_(0.0, (double)0.03f, 0.0) : delta.m_82520_(0.0, (double)-0.03f, 0.0);
            this.m_20256_(delta.m_82490_(0.8));
        } else {
            super.m_7023_(travelVector);
        }
    }

    private void doInitialPosing(LevelAccessor world) {
        BlockPos down = this.m_20183_();
        while (!world.m_6425_(down).m_76178_() && down.m_123342_() > world.m_141937_()) {
            down = down.m_7495_();
        }
        this.m_6034_((float)down.m_123341_() + 0.5f, down.m_123342_() + 1, (float)down.m_123343_() + 0.5f);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        if (reason == MobSpawnType.NATURAL) {
            this.doInitialPosing((LevelAccessor)worldIn);
        }
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    private void digestItem() {
        if (!this.m_9236_().f_46443_) {
            LootTable loottable = this.m_9236_().m_7654_().m_278653_().m_278676_(DIGESTION_LOOT_TABLE);
            ObjectArrayList items = loottable.m_287195_(new LootParams.Builder((ServerLevel)this.m_9236_()).m_287286_(LootContextParams.f_81455_, (Object)this).m_287235_(LootContextParamSets.f_81417_));
            items.forEach(arg_0 -> ((SeaPigEntity)this).m_19983_(arg_0));
        }
        this.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        InteractionResult type = Bucketable.m_148828_((Player)player, (InteractionHand)hand, (LivingEntity)this).orElse(super.m_6071_(player, hand));
        if (itemstack.m_204117_(ACTagRegistry.SEA_PIG_DIGESTS) && !this.isDigesting() && !type.m_19077_()) {
            ItemStack copy = itemstack.m_41777_();
            if (!player.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            copy.m_41764_(1);
            this.m_21008_(InteractionHand.MAIN_HAND, copy);
            return InteractionResult.SUCCESS;
        }
        return type;
    }

    public float getDigestProgress(float partialTick) {
        return Math.min(1.0f, this.prevDigestProgress + (this.digestProgress - this.prevDigestProgress) * partialTick);
    }

    public float getSquishProgress(float partialTicks) {
        return (this.prevSquishProgress + (this.squishProgress - this.prevSquishProgress) * partialTicks) * 0.2f;
    }

    public boolean isDigesting() {
        return this.m_21120_(InteractionHand.MAIN_HAND).m_204117_(ACTagRegistry.SEA_PIG_DIGESTS);
    }

    public void m_267651_(boolean flying) {
        float f1 = (float)Mth.m_184648_((double)(this.m_20185_() - this.f_19854_), (double)(flying ? this.m_20186_() - this.f_19855_ : 0.0), (double)(this.m_20189_() - this.f_19856_));
        float f2 = Math.min(f1 * 128.0f, 1.0f);
        this.f_267362_.m_267566_(f2, 0.4f);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("FromBucket", this.m_27487_());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.m_27497_(compound.m_128471_("FromBucket"));
    }

    public void m_6872_(@Nonnull ItemStack bucket) {
        if (this.m_8077_()) {
            bucket.m_41714_(this.m_7770_());
        }
        CompoundTag platTag = new CompoundTag();
        this.m_7380_(platTag);
        CompoundTag compound = bucket.m_41784_();
        compound.m_128365_("FishBucketTag", (Tag)platTag);
    }

    public boolean m_8023_() {
        return super.m_8023_() || this.m_27487_();
    }

    public boolean m_6785_(double dist) {
        return !this.m_27487_() && !this.m_8077_();
    }

    public boolean m_27487_() {
        return (Boolean)this.f_19804_.m_135370_(FROM_BUCKET);
    }

    public void m_27497_(boolean sit) {
        this.f_19804_.m_135381_(FROM_BUCKET, (Object)sit);
    }

    public void m_142278_(@Nonnull CompoundTag compound) {
        if (compound.m_128441_("FishBucketTag")) {
            this.m_7378_(compound.m_128469_("FishBucketTag"));
        }
        this.m_20301_(2000);
    }

    public ItemStack m_28282_() {
        return new ItemStack((ItemLike)ACItemRegistry.SEA_PIG_BUCKET.get());
    }

    @Nonnull
    public SoundEvent m_142623_() {
        return SoundEvents.f_11782_;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ACSoundRegistry.SEA_PIG_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)ACSoundRegistry.SEA_PIG_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ACSoundRegistry.SEA_PIG_DEATH.get();
    }

    private class WanderGoal
    extends Goal {
        private double x;
        private double y;
        private double z;

        public WanderGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (SeaPigEntity.this.m_217043_().m_188503_(50) != 0) {
                return false;
            }
            Vec3 target = this.getPosition();
            if (target == null) {
                return false;
            }
            this.x = target.f_82479_;
            this.y = target.f_82480_;
            this.z = target.f_82481_;
            return true;
        }

        public boolean m_8045_() {
            double dist = SeaPigEntity.this.m_20275_(this.x, this.y, this.z);
            return dist > 4.0;
        }

        public void m_8037_() {
            SeaPigEntity.this.m_21573_().m_26519_(this.x, this.y, this.z, 1.0);
        }

        public BlockPos findWaterBlock() {
            BlockPos result = null;
            RandomSource random = SeaPigEntity.this.m_217043_();
            int range = 10;
            for (int i = 0; i < 15; ++i) {
                BlockPos blockPos = SeaPigEntity.this.m_20183_().m_7918_(random.m_188503_(range) - range / 2, random.m_188503_(range) - range / 2, random.m_188503_(range) - range / 2);
                if (!SeaPigEntity.this.m_9236_().m_6425_(blockPos).m_205070_(FluidTags.f_13131_) || blockPos.m_123342_() <= SeaPigEntity.this.m_9236_().m_141937_() + 1) continue;
                result = blockPos;
            }
            return result;
        }

        @Nullable
        protected Vec3 getPosition() {
            BlockPos water = this.findWaterBlock();
            if (SeaPigEntity.this.m_20072_()) {
                if (water == null) {
                    return null;
                }
                while (SeaPigEntity.this.m_9236_().m_6425_(water.m_7495_()).m_205070_(FluidTags.f_13131_) && water.m_123342_() > SeaPigEntity.this.m_9236_().m_141937_() + 1) {
                    water = water.m_7495_();
                }
                water = water.m_7494_();
                return Vec3.m_82512_((Vec3i)water);
            }
            return water == null ? DefaultRandomPos.m_148403_((PathfinderMob)SeaPigEntity.this, (int)7, (int)3) : Vec3.m_82512_((Vec3i)water);
        }
    }
}

