/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.living;

import com.github.alexmodguy.alexscaves.AlexsCaves;
import com.github.alexmodguy.alexscaves.client.particle.ACParticleRegistry;
import com.github.alexmodguy.alexscaves.server.entity.ai.GroundPathNavigatorNoSpin;
import com.github.alexmodguy.alexscaves.server.entity.ai.MobTarget3DGoal;
import com.github.alexmodguy.alexscaves.server.entity.ai.WatcherAttackGoal;
import com.github.alexmodguy.alexscaves.server.entity.living.ForsakenEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.UnderzealotEntity;
import com.github.alexmodguy.alexscaves.server.entity.util.PossessesCamera;
import com.github.alexmodguy.alexscaves.server.entity.util.WatcherPossessionAccessor;
import com.github.alexmodguy.alexscaves.server.message.PossessionKeyMessage;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public class WatcherEntity
extends Monster
implements IAnimatedEntity,
PossessesCamera {
    private static final EntityDataAccessor<Boolean> RUNNING = SynchedEntityData.m_135353_(WatcherEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SHADE_MODE = SynchedEntityData.m_135353_(WatcherEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Optional<UUID>> POSSESSED_ENTITY_UUID = SynchedEntityData.m_135353_(WatcherEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Integer> POSSESSED_ENTITY_ID = SynchedEntityData.m_135353_(WatcherEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> POSSESSION_STRENGTH = SynchedEntityData.m_135353_(WatcherEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final Animation ANIMATION_ATTACK_0 = Animation.create((int)15);
    public static final Animation ANIMATION_ATTACK_1 = Animation.create((int)15);
    private Animation currentAnimation;
    private int animationTick;
    private float runProgress;
    private float prevRunProgress;
    private float shadeProgress;
    private float prevShadeProgress;
    private boolean isLandNavigator;
    private final PathNavigation groundNavigator;
    private final PathNavigation airNavigator;
    private BlockPos lastPossessionSite = null;
    private int lastPossessionTimestamp;
    private Entity prevPossessedEntity;
    private boolean isPossessionBreakable;
    private int possessedTimeout = 0;
    private static final String LAST_POSSESSED_TIME_IDENTIFIER = "alexscaves_last_possessed_time";
    private UUID previousPossessionUUID;

    public WatcherEntity(EntityType entityType, Level level) {
        super(entityType, level);
        this.groundNavigator = this.m_6037_(level);
        this.airNavigator = this.createShadeNavigation(level);
        this.switchNavigator(true);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22281_, 4.0).m_22268_(Attributes.f_22277_, 256.0);
    }

    protected PathNavigation m_6037_(Level level) {
        return new GroundPathNavigatorNoSpin((Mob)this, level);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new WatcherAttackGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0, 100));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 15.0f));
        this.f_21345_.m_25352_(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{UnderzealotEntity.class, WatcherEntity.class, ForsakenEntity.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new MobTarget3DGoal((Mob)this, Player.class, false, 10, this::canPossessTargetEntity));
    }

    protected PathNavigation createShadeNavigation(Level level) {
        FlyingPathNavigation flyingpathnavigation = new FlyingPathNavigation((Mob)this, level){

            public boolean m_6342_(BlockPos pos) {
                return !this.f_26495_.m_8055_(pos.m_7495_()).m_60795_();
            }
        };
        flyingpathnavigation.m_26440_(false);
        flyingpathnavigation.m_7008_(false);
        flyingpathnavigation.m_26443_(true);
        return flyingpathnavigation;
    }

    private void switchNavigator(boolean onLand) {
        if (onLand) {
            this.f_21342_ = new MoveControl((Mob)this);
            this.f_21344_ = this.groundNavigator;
            this.isLandNavigator = true;
        } else {
            this.f_21342_ = new MoveController();
            this.f_21344_ = this.airNavigator;
            this.isLandNavigator = false;
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(RUNNING, (Object)false);
        this.f_19804_.m_135372_(SHADE_MODE, (Object)false);
        this.f_19804_.m_135372_(POSSESSED_ENTITY_UUID, Optional.empty());
        this.f_19804_.m_135372_(POSSESSED_ENTITY_ID, (Object)-1);
        this.f_19804_.m_135372_(POSSESSION_STRENGTH, (Object)Float.valueOf(0.0f));
    }

    public boolean isRunning() {
        return (Boolean)this.f_19804_.m_135370_(RUNNING);
    }

    public void setRunning(boolean bool) {
        this.f_19804_.m_135381_(RUNNING, (Object)bool);
    }

    public boolean isShadeMode() {
        return (Boolean)this.f_19804_.m_135370_(SHADE_MODE);
    }

    public void setShadeMode(boolean bool) {
        this.f_19804_.m_135381_(SHADE_MODE, (Object)bool);
    }

    @Override
    public float getPossessionStrength(float partialTicks) {
        return ((Float)this.f_19804_.m_135370_(POSSESSION_STRENGTH)).floatValue();
    }

    @Override
    public boolean instant() {
        return false;
    }

    public void setPossessionStrength(float possessionStrength) {
        this.f_19804_.m_135381_(POSSESSION_STRENGTH, (Object)Float.valueOf(possessionStrength));
    }

    @Nullable
    public UUID getPossessedEntityUUID() {
        return ((Optional)this.f_19804_.m_135370_(POSSESSED_ENTITY_UUID)).orElse(null);
    }

    public void setPossessedEntityUUID(@Nullable UUID hologram) {
        this.f_19804_.m_135381_(POSSESSED_ENTITY_UUID, Optional.ofNullable(hologram));
    }

    @Override
    public boolean isPossessionBreakable() {
        return this.isPossessionBreakable;
    }

    public Entity getPossessedEntity() {
        if (!this.m_9236_().f_46443_) {
            UUID id = this.getPossessedEntityUUID();
            return id == null ? null : ((ServerLevel)this.m_9236_()).m_8791_(id);
        }
        int id = (Integer)this.f_19804_.m_135370_(POSSESSED_ENTITY_ID);
        return id == -1 ? null : this.m_9236_().m_6815_(id);
    }

    public boolean canReach(LivingEntity target, boolean flying) {
        int k;
        int j;
        Path path = (flying ? this.airNavigator : this.groundNavigator).m_6570_((Entity)target, 0);
        if (path == null) {
            return false;
        }
        Node node = path.m_77395_();
        if (node == null) {
            return false;
        }
        int i = node.f_77271_ - target.m_146903_();
        return (double)(i * i + (j = node.f_77272_ - target.m_146904_()) * j + (k = node.f_77273_ - target.m_146907_()) * k) <= 3.0;
    }

    public void m_8119_() {
        super.m_8119_();
        this.prevRunProgress = this.runProgress;
        this.prevShadeProgress = this.shadeProgress;
        Entity possessedEntity = this.getPossessedEntity();
        if (this.isRunning() && this.runProgress < 5.0f) {
            this.runProgress += 1.0f;
        }
        if (!this.isRunning() && this.runProgress > 0.0f) {
            this.runProgress -= 1.0f;
        }
        if (this.isShadeMode() && this.shadeProgress < 5.0f) {
            this.shadeProgress += 1.0f;
        }
        if (!this.isShadeMode() && this.shadeProgress > 0.0f) {
            this.shadeProgress -= 1.0f;
        }
        if (this.isShadeMode()) {
            this.f_19789_ = 0.0f;
            if (this.isLandNavigator) {
                this.switchNavigator(false);
            }
        } else if (!this.isLandNavigator) {
            this.switchNavigator(true);
        }
        if (possessedEntity instanceof Player) {
            this.f_20885_ = Mth.m_14148_((float)this.f_20886_, (float)this.f_20885_, (float)3.0f);
        }
        if (!this.m_9236_().f_46443_) {
            if (possessedEntity != null && possessedEntity.m_6084_()) {
                double dist = possessedEntity.m_20270_((Entity)this);
                if (((Integer)this.f_19804_.m_135370_(POSSESSED_ENTITY_ID)).intValue() != possessedEntity.m_19879_()) {
                    this.f_19804_.m_135381_(POSSESSED_ENTITY_ID, (Object)possessedEntity.m_19879_());
                    this.setPossessionStrength(1.0f);
                }
                this.lastPossessionTimestamp = this.f_19797_;
                if (this.possessedTimeout++ > 140) {
                    this.setPossessionStrength(Math.max(0.0f, this.getPossessionStrength(1.0f) + 0.1f));
                }
                if (dist < 1.0 || this.stopPossession(possessedEntity) || !this.m_6084_()) {
                    if (possessedEntity instanceof WatcherPossessionAccessor) {
                        WatcherPossessionAccessor possessionAccessor = (WatcherPossessionAccessor)possessedEntity;
                        possessionAccessor.setPossessedByWatcher(false);
                    }
                    if (possessedEntity instanceof Player) {
                        Player player = (Player)possessedEntity;
                        WatcherEntity.setLastPossessedTimeFor(player);
                    }
                    this.m_9236_().m_7605_((Entity)this, (byte)78);
                    this.setPossessedEntityUUID(null);
                    this.f_19804_.m_135381_(POSSESSED_ENTITY_ID, (Object)-1);
                } else {
                    this.m_9236_().m_7605_((Entity)this, (byte)77);
                    if (possessedEntity instanceof LivingEntity) {
                        LivingEntity living = (LivingEntity)possessedEntity;
                        living.f_20902_ = 0.0f;
                        living.f_20901_ = 0.0f;
                        living.f_20900_ = 0.0f;
                    }
                }
            } else {
                if (possessedEntity != null || (Integer)this.f_19804_.m_135370_(POSSESSED_ENTITY_ID) != -1) {
                    this.m_9236_().m_7605_((Entity)this, (byte)78);
                }
                this.possessedTimeout = 0;
                this.f_19804_.m_135381_(POSSESSED_ENTITY_ID, (Object)-1);
            }
        } else if (possessedEntity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)possessedEntity;
            living.f_20902_ = 0.0f;
            living.f_20901_ = 0.0f;
            living.f_20900_ = 0.0f;
            if (this.getPossessionStrength(1.0f) == 0.0f) {
                this.isPossessionBreakable = true;
            }
            if (living instanceof Player) {
                Player player = (Player)living;
                if (this.isPossessionBreakable) {
                    player.f_20899_ = false;
                    Player clientSidePlayer = AlexsCaves.PROXY.getClientSidePlayer();
                    if (AlexsCaves.PROXY.isKeyDown(-1) && player == clientSidePlayer) {
                        AlexsCaves.sendMSGToServer(new PossessionKeyMessage(this.m_19879_(), player.m_19879_(), 0));
                    }
                }
            }
            if (this.prevPossessedEntity != living) {
                this.isPossessionBreakable = false;
            }
            this.prevPossessedEntity = living;
        } else {
            this.prevPossessedEntity = null;
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    public boolean causeFallDamage(float distance, float damageMultiplier) {
        return false;
    }

    protected void m_7840_(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    private boolean stopPossession(Entity possessed) {
        float possessionStrength = this.getPossessionStrength(1.0f);
        this.setPossessionStrength(Math.max(0.0f, possessionStrength - 0.05f));
        return possessionStrength >= 1.0f && this.possessedTimeout > 40;
    }

    public boolean canPossessTargetEntity(Entity entity) {
        Player player;
        CompoundTag playerData;
        CompoundTag data;
        if (entity instanceof Player && (data = (playerData = (player = (Player)entity).getPersistentData()).m_128469_("PlayerPersisted")) != null) {
            long timeElapsed = this.m_9236_().m_46467_() - data.m_128454_(LAST_POSSESSED_TIME_IDENTIFIER);
            return timeElapsed >= (long)((Integer)AlexsCaves.COMMON_CONFIG.watcherPossessionCooldown.get()).intValue();
        }
        return true;
    }

    public void m_7822_(byte b) {
        if (b == 77 || b == 78) {
            Player player;
            Entity possessedEntity = this.getPossessedEntity();
            if (possessedEntity == null && this.getPossessedEntityUUID() != null) {
                possessedEntity = this.m_9236_().m_46003_(this.getPossessedEntityUUID());
            }
            if (possessedEntity instanceof Player && (player = (Player)possessedEntity) == AlexsCaves.PROXY.getClientSidePlayer()) {
                if (b == 77) {
                    if (((Boolean)AlexsCaves.COMMON_CONFIG.watcherPossession.get()).booleanValue()) {
                        AlexsCaves.PROXY.setRenderViewEntity(player, (Entity)this);
                    }
                } else {
                    this.m_9236_().m_7106_((ParticleOptions)ACParticleRegistry.WATCHER_APPEARANCE.get(), player.m_20185_(), player.m_20188_(), player.m_20189_(), 0.0, 0.0, 0.0);
                    player.m_9236_().m_6263_(player, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)ACSoundRegistry.WATCHER_SCARE.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
                    if (((Boolean)AlexsCaves.COMMON_CONFIG.watcherPossession.get()).booleanValue()) {
                        AlexsCaves.PROXY.resetRenderViewEntity(player);
                    }
                }
            }
        } else {
            super.m_7822_(b);
        }
    }

    public void m_267651_(boolean flying) {
        float f1 = (float)Mth.m_184648_((double)(this.m_20185_() - this.f_19854_), (double)(this.m_20186_() - this.f_19855_), (double)(this.m_20189_() - this.f_19856_));
        float f2 = Math.min(f1 * 6.0f, 1.0f);
        this.f_267362_.m_267566_(f2, 0.4f);
    }

    public float getShadeAmount(float partialTick) {
        return (this.prevShadeProgress + (this.shadeProgress - this.prevShadeProgress) * partialTick) * 0.2f;
    }

    public float getRunAmount(float partialTick) {
        return (this.prevRunProgress + (this.runProgress - this.prevRunProgress) * partialTick) * 0.2f;
    }

    public boolean attemptPossession(LivingEntity living) {
        if (this.f_19797_ - this.lastPossessionTimestamp > 100 && (this.lastPossessionSite == null || this.lastPossessionSite.m_123331_((Vec3i)this.m_20183_()) > 10.0) && this.canPossessTargetEntity((Entity)living)) {
            this.lastPossessionSite = this.m_20183_();
            this.lastPossessionTimestamp = this.f_19797_;
            if (living instanceof Player) {
                Player player = (Player)living;
                WatcherEntity.setLastPossessedTimeFor(player);
                ((WatcherPossessionAccessor)player).setPossessedByWatcher(true);
            }
            return true;
        }
        return false;
    }

    public static void setLastPossessedTimeFor(Player player) {
        CompoundTag playerData = player.getPersistentData();
        CompoundTag data = playerData.m_128469_("PlayerPersisted");
        if (data != null) {
            data.m_128356_(LAST_POSSESSED_TIME_IDENTIFIER, player.m_9236_().m_46467_());
            playerData.m_128365_("PlayerPersisted", (Tag)data);
        }
    }

    @Override
    public void onPossessionKeyPacket(Entity keyPresser, int type) {
        Entity possessed = this.getPossessedEntity();
        if (possessed.equals((Object)keyPresser)) {
            this.setPossessionStrength(this.getPossessionStrength(1.0f) + 0.07f);
        }
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_ATTACK_0, ANIMATION_ATTACK_1};
    }

    public static boolean checkWatcherSpawnRules(EntityType<? extends Monster> entityType, ServerLevelAccessor levelAccessor, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource randomSource) {
        return WatcherEntity.m_219013_(entityType, (ServerLevelAccessor)levelAccessor, (MobSpawnType)mobSpawnType, (BlockPos)blockPos, (RandomSource)randomSource) && randomSource.m_188503_(20) == 0;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ACSoundRegistry.WATCHER_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)ACSoundRegistry.WATCHER_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ACSoundRegistry.WATCHER_DEATH.get();
    }

    class MoveController
    extends MoveControl {
        private final Mob parentEntity;

        public MoveController() {
            super((Mob)WatcherEntity.this);
            this.parentEntity = WatcherEntity.this;
        }

        public void m_8126_() {
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO) {
                Vec3 ed = this.f_24974_.m_21573_().m_26567_().m_252807_();
                double d1 = this.f_24976_ - this.f_24974_.m_20186_();
                Vec3 vector3d = new Vec3(this.f_24975_ - this.parentEntity.m_20185_(), this.f_24976_ - this.parentEntity.m_20186_(), this.f_24977_ - this.parentEntity.m_20189_());
                double d0 = vector3d.m_82553_();
                double width = this.parentEntity.m_20191_().m_82309_();
                LivingEntity attackTarget = this.parentEntity.m_5448_();
                Vec3 vector3d1 = vector3d.m_82490_(this.f_24978_ * 0.025 / d0).m_82520_(0.0, 0.08 + d1 / d0 * 0.1, 0.0);
                this.parentEntity.m_20256_(this.parentEntity.m_20184_().m_82549_(vector3d1));
                if (d0 < width * (double)0.8f) {
                    this.f_24981_ = MoveControl.Operation.WAIT;
                } else if (d0 >= width && attackTarget == null) {
                    this.parentEntity.m_146922_(-((float)Mth.m_14136_((double)vector3d1.f_82479_, (double)vector3d1.f_82481_)) * 57.295776f);
                    if (WatcherEntity.this.m_5448_() != null) {
                        this.parentEntity.f_20883_ = this.parentEntity.m_146908_();
                    }
                }
            }
        }
    }
}

