/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.util;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LuxtructosaurusLegSolver {
    public final Leg backLeft;
    public final Leg backRight;
    public final Leg frontLeft;
    public final Leg frontRight;
    public final Leg[] legs;

    public LuxtructosaurusLegSolver(float forward, float side) {
        this(0.0f, forward, side, side, 1.0f);
    }

    public LuxtructosaurusLegSolver(float forwardCenter, float forward, float sideBack, float sideFront, float range) {
        this.legs = new Leg[]{new Leg(forwardCenter - forward, sideBack, range, false), new Leg(forwardCenter - forward, -sideBack, range, false), new Leg(forwardCenter + forward, sideFront, range, true), new Leg(forwardCenter + forward, -sideFront, range, true)};
        this.backLeft = this.legs[0];
        this.backRight = this.legs[1];
        this.frontLeft = this.legs[2];
        this.frontRight = this.legs[3];
    }

    public final void update(LivingEntity entity, float scale) {
        this.update(entity, entity.f_20883_, scale);
    }

    public final void update(LivingEntity entity, float yaw, float scale) {
        double sideTheta = (double)yaw / 57.29577951308232;
        double sideX = Math.cos(sideTheta) * (double)scale;
        double sideZ = Math.sin(sideTheta) * (double)scale;
        double forwardTheta = sideTheta + 1.5707963267948966;
        double forwardX = Math.cos(forwardTheta) * (double)scale;
        double forwardZ = Math.sin(forwardTheta) * (double)scale;
        for (Leg leg : this.legs) {
            leg.update(entity, sideX, sideZ, forwardX, forwardZ, scale);
        }
    }

    public static final class Leg {
        public final float forward;
        public final float side;
        public Vec3 samplePos = Vec3.f_82478_;
        private final float range;
        private float height;
        private float prevHeight;
        private boolean isWing;

        public Leg(float forward, float side, float range, boolean isWing) {
            this.forward = forward;
            this.side = side;
            this.range = range;
            this.isWing = isWing;
        }

        public float getHeight(float delta) {
            return this.prevHeight + (this.height - this.prevHeight) * delta;
        }

        public void update(LivingEntity entity, double sideX, double sideZ, double forwardX, double forwardZ, float scale) {
            this.prevHeight = this.height;
            double posY = entity.m_20186_();
            this.samplePos = new Vec3(entity.m_20185_() + sideX * (double)this.side + forwardX * (double)this.forward, posY, entity.m_20189_() + sideZ * (double)this.side + forwardZ * (double)this.forward);
            float settledHeight = this.settle(entity, entity.m_20185_() + sideX * (double)this.side + forwardX * (double)this.forward, posY - 1.0, entity.m_20189_() + sideZ * (double)this.side + forwardZ * (double)this.forward, this.height);
            this.height = Mth.m_14036_((float)settledHeight, (float)(-this.range * scale), (float)(this.range * scale));
        }

        protected float settle(LivingEntity entity, double x, double y, double z, float height) {
            float dist;
            BlockPos pos = new BlockPos((int)Math.floor(x), (int)Math.floor(y + 0.001), (int)Math.floor(z));
            Vec3 vec3 = new Vec3(x, y, z);
            float lastDistance = dist = this.getDistance(entity.m_9236_(), pos, vec3);
            while (lastDistance == 1.0f) {
                pos = pos.m_7495_();
                lastDistance = this.getDistance(entity.m_9236_(), pos, vec3);
                dist += lastDistance;
            }
            if (entity.m_20096_() && height <= dist) {
                return height == dist ? height : Math.min(height + this.getFallSpeed(), dist);
            }
            if (height > 0.0f) {
                return height == dist ? height : Math.max(height - this.getRiseSpeed(), dist);
            }
            return height;
        }

        protected float getDistance(Level world, BlockPos pos, Vec3 position) {
            BlockState state = world.m_8055_(pos);
            VoxelShape shape = state.m_60812_((BlockGetter)world, pos);
            if (pos.m_123342_() < world.m_141937_()) {
                return 0.0f;
            }
            if (shape.m_83281_()) {
                return 1.0f;
            }
            Vec3 modIn = new Vec3(position.f_82479_ % 1.0, position.f_82480_, position.f_82481_ % 1.0);
            Optional closest = shape.m_166067_(modIn);
            if (closest.isEmpty()) {
                return 1.0f;
            }
            float closestY = Math.min((float)((Vec3)closest.get()).f_82480_, 1.0f);
            return position.f_82480_ < 0.0 ? closestY : 1.0f - closestY;
        }

        protected float getFallSpeed() {
            return 0.15f;
        }

        protected float getRiseSpeed() {
            return 0.15f;
        }
    }
}

