/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.event;

import com.github.alexmodguy.alexscaves.AlexsCaves;
import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import com.github.alexmodguy.alexscaves.server.config.BiomeGenerationConfig;
import com.github.alexmodguy.alexscaves.server.enchantment.ACEnchantmentRegistry;
import com.github.alexmodguy.alexscaves.server.entity.ACEntityRegistry;
import com.github.alexmodguy.alexscaves.server.entity.ACFrogRegistry;
import com.github.alexmodguy.alexscaves.server.entity.item.SeekingArrowEntity;
import com.github.alexmodguy.alexscaves.server.entity.item.SubmarineEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.DinosaurEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.RaycatEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.VallumraptorEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.WatcherEntity;
import com.github.alexmodguy.alexscaves.server.entity.util.EntityDropChanceAccessor;
import com.github.alexmodguy.alexscaves.server.entity.util.FlyingMount;
import com.github.alexmodguy.alexscaves.server.entity.util.MagneticEntityAccessor;
import com.github.alexmodguy.alexscaves.server.entity.util.VillagerUndergroundCabinMapTrade;
import com.github.alexmodguy.alexscaves.server.entity.util.WatcherPossessionAccessor;
import com.github.alexmodguy.alexscaves.server.item.ACItemRegistry;
import com.github.alexmodguy.alexscaves.server.item.AlwaysCombinableOnAnvil;
import com.github.alexmodguy.alexscaves.server.item.ExtinctionSpearItem;
import com.github.alexmodguy.alexscaves.server.level.biome.ACBiomeRarity;
import com.github.alexmodguy.alexscaves.server.level.biome.ACBiomeRegistry;
import com.github.alexmodguy.alexscaves.server.level.biome.BiomeSourceAccessor;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACTagRegistry;
import com.github.alexmodguy.alexscaves.server.potion.ACEffectRegistry;
import com.github.alexmodguy.alexscaves.server.potion.DarknessIncarnateEffect;
import com.github.alexthe666.citadel.server.event.EventReplaceBiome;
import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.event.village.WandererTradesEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;

public class CommonEvents {
    @SubscribeEvent
    public void resizeEntity(EntityEvent.Size event) {
        Entity entity = event.getEntity();
        if (entity instanceof MagneticEntityAccessor) {
            MagneticEntityAccessor magnet = (MagneticEntityAccessor)entity;
            if (event.getEntity().m_20088_().m_135352_()) {
                Direction dir = magnet.getMagneticAttachmentFace();
                float defaultHeight = event.getOldSize().f_20378_;
                float defaultEyeHeight = event.getEntity().getEyeHeightAccess(event.getPose(), event.getOldSize());
                if (dir == Direction.DOWN && event.getEntity() instanceof Player && event.getEntity().m_20089_() == Pose.STANDING) {
                    event.setNewSize(event.getNewSize(), true);
                } else if (dir == Direction.UP) {
                    event.setNewEyeHeight(defaultHeight - defaultEyeHeight);
                } else if (dir.m_122434_() != Direction.Axis.Y) {
                    event.setNewEyeHeight(0.0f);
                }
            }
        }
    }

    @SubscribeEvent
    public void livingDie(LivingDeathEvent event) {
        LivingEntity livingEntity;
        Frog frog;
        Entity entity;
        if (event.getEntity().m_6095_() == EntityType.f_20468_ && event.getSource() != null && (entity = event.getSource().m_7639_()) instanceof Frog && (frog = (Frog)entity).m_28554_() == ACFrogRegistry.PRIMORDIAL.get()) {
            event.getEntity().m_19983_(new ItemStack((ItemLike)ACBlockRegistry.CARMINE_FROGLIGHT.get()));
        }
        if (!event.getEntity().m_9236_().f_46443_ && (livingEntity = event.getEntity()) instanceof Mob) {
            Creeper fakeCreeperForSkullDrop;
            LivingEntity directSource;
            Mob mob = (Mob)livingEntity;
            if (event.getSource() != null && (livingEntity = event.getSource().m_7640_()) instanceof LivingEntity && (directSource = livingEntity).m_21120_(InteractionHand.MAIN_HAND).m_150930_((Item)ACItemRegistry.PRIMITIVE_CLUB.get()) && directSource.m_21120_(InteractionHand.MAIN_HAND).getEnchantmentLevel((Enchantment)ACEnchantmentRegistry.BONKING.get()) > 0 && event.getEntity().m_9236_().f_46441_.m_188501_() < 0.33f && (fakeCreeperForSkullDrop = (Creeper)EntityType.f_20558_.m_20615_(mob.m_9236_())) != null) {
                ServerLevel serverLevel;
                LightningBolt fakeThunder;
                Level level = event.getEntity().m_9236_();
                if (level instanceof ServerLevel && (fakeThunder = (LightningBolt)EntityType.f_20465_.m_20615_((Level)(serverLevel = (ServerLevel)level))) != null) {
                    fakeThunder.m_20874_(true);
                    fakeCreeperForSkullDrop.m_8038_(serverLevel, fakeThunder);
                }
                DamageSource fakeCreeperDamage = mob.m_9236_().m_269111_().m_269333_((LivingEntity)fakeCreeperForSkullDrop);
                HashMap<EquipmentSlot, Float> prevLootDropChances = new HashMap<EquipmentSlot, Float>();
                EntityDropChanceAccessor dropChanceAccessor = (EntityDropChanceAccessor)mob;
                for (EquipmentSlot slot : EquipmentSlot.values()) {
                    prevLootDropChances.put(slot, Float.valueOf(dropChanceAccessor.ac_getEquipmentDropChance(slot)));
                    dropChanceAccessor.ac_setDropChance(slot, 0.0f);
                }
                dropChanceAccessor.ac_dropCustomDeathLoot(fakeCreeperDamage, 0, false);
                for (EquipmentSlot slot : EquipmentSlot.values()) {
                    dropChanceAccessor.ac_setDropChance(slot, ((Float)prevLootDropChances.get(slot)).floatValue());
                }
            }
        }
        if (event.getEntity() instanceof Player) {
            if (event.getEntity().m_20148_().toString().equals("71363abe-fd03-49c9-940d-aae8b8209b7c")) {
                event.getEntity().m_19983_(new ItemStack((ItemLike)ACItemRegistry.GREEN_SOYLENT.get(), 1 + event.getEntity().m_217043_().m_188503_(9)));
            }
            if (event.getEntity().m_20148_().toString().equals("4a463319-625c-4b86-a4e7-8b700f023a60")) {
                event.getEntity().m_19983_(new ItemStack((ItemLike)ACItemRegistry.STINKY_FISH.get(), 1));
            }
        }
    }

    @SubscribeEvent
    public void livingHeal(LivingHealEvent event) {
        if (event.getEntity().m_21023_((MobEffect)ACEffectRegistry.IRRADIATED.get()) && !event.getEntity().m_6095_().m_204039_(ACTagRegistry.RESISTS_RADIATION)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void playerEntityInteract(PlayerInteractEvent.EntityInteract event) {
        ItemStack stack = event.getItemStack();
        if (stack.m_150930_((Item)ACItemRegistry.HOLOCODER.get()) && event.getTarget() instanceof LivingEntity && !(event.getTarget() instanceof ArmorStand) && event.getTarget().m_6084_()) {
            ItemEntity itementity;
            CompoundTag tag = stack.m_41784_();
            tag.m_128362_("BoundEntityUUID", event.getTarget().m_20148_());
            CompoundTag entityTag = event.getTarget() instanceof Player ? new CompoundTag() : event.getTarget().serializeNBT();
            entityTag.m_128359_("id", ForgeRegistries.ENTITY_TYPES.getKey((Object)event.getTarget().m_6095_()).toString());
            if (event.getTarget() instanceof Player) {
                entityTag.m_128362_("UUID", event.getTarget().m_20148_());
            }
            tag.m_128365_("BoundEntityTag", (Tag)entityTag);
            ItemStack stackReplacement = new ItemStack((ItemLike)ACItemRegistry.HOLOCODER.get());
            stack.m_41774_(1);
            stackReplacement.m_41751_(tag);
            event.getEntity().m_6674_(event.getHand());
            if (!event.getEntity().m_36356_(stackReplacement) && (itementity = event.getEntity().m_36176_(stackReplacement, false)) != null) {
                itementity.m_32061_();
                itementity.m_32052_(event.getEntity().m_20148_());
            }
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.SUCCESS);
        }
    }

    @SubscribeEvent
    public void livingFindTarget(LivingChangeTargetEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Mob) {
            VallumraptorEntity vallumraptor;
            Mob mob = (Mob)livingEntity;
            livingEntity = event.getNewTarget();
            if (livingEntity instanceof VallumraptorEntity && (vallumraptor = (VallumraptorEntity)livingEntity).getHideFor() > 0) {
                mob.m_6710_(null);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void livingHurt(LivingDamageEvent event) {
        Player player;
        WatcherPossessionAccessor possessed;
        LivingEntity livingEntity;
        if (event.getEntity().m_20159_() && event.getEntity() instanceof FlyingMount && (event.getSource().m_276093_(DamageTypes.f_268612_) || event.getSource().m_276093_(DamageTypes.f_268671_) || event.getSource().m_276093_(DamageTypes.f_268576_))) {
            event.setCanceled(true);
        }
        if ((livingEntity = event.getEntity()) instanceof WatcherPossessionAccessor && (possessed = (WatcherPossessionAccessor)livingEntity).isPossessedByWatcher() && !event.getSource().m_269533_(DamageTypeTags.f_268738_) && !(event.getSource().m_7639_() instanceof WatcherEntity)) {
            event.setCanceled(true);
        }
        if ((livingEntity = event.getEntity()) instanceof Player && (player = (Player)livingEntity).m_21211_().m_150930_((Item)ACItemRegistry.EXTINCTION_SPEAR.get()) && ExtinctionSpearItem.killGrottoGhostsFor(player, true)) {
            event.setCanceled(true);
            player.m_216990_(SoundEvents.f_12346_);
        }
    }

    @SubscribeEvent
    public void livingAttack(LivingAttackEvent event) {
        LivingEntity directSource;
        Entity entity = event.getSource().m_7640_();
        if (entity instanceof AbstractArrow) {
            ItemStack shield;
            AbstractArrow arrow = (AbstractArrow)entity;
            if (event.getEntity().m_21254_() && event.getEntity().m_21211_().m_150930_((Item)ACItemRegistry.RESISTOR_SHIELD.get()) && (shield = event.getEntity().m_21211_()).getEnchantmentLevel((Enchantment)ACEnchantmentRegistry.ARROW_INDUCTING.get()) > 0 && arrow.m_6095_() != ACEntityRegistry.SEEKING_ARROW.get()) {
                SeekingArrowEntity seekingArrowEntity = new SeekingArrowEntity(event.getEntity().m_9236_(), event.getEntity());
                seekingArrowEntity.m_20359_((Entity)arrow);
                seekingArrowEntity.m_20256_(arrow.m_20184_().m_82490_(-0.4));
                seekingArrowEntity.m_146922_(arrow.m_146908_() + 180.0f);
                event.getEntity().m_9236_().m_7967_((Entity)seekingArrowEntity);
                arrow.m_146870_();
            }
        }
        if (event.getSource() != null && (entity = event.getSource().m_7640_()) instanceof LivingEntity && (directSource = (LivingEntity)entity).m_21023_((MobEffect)ACEffectRegistry.STUNNED.get())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void playerAttack(AttackEntityEvent event) {
        if (event.getTarget() instanceof DinosaurEntity && event.getEntity().m_20365_(event.getTarget())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void livingTick(LivingEvent.LivingTickEvent event) {
        VallumraptorEntity vallumraptor;
        Mob mob;
        LivingEntity livingEntity;
        if (event.getEntity().m_21023_((MobEffect)ACEffectRegistry.BUBBLED.get()) && event.getEntity().isInFluidType()) {
            event.getEntity().m_21195_((MobEffect)ACEffectRegistry.BUBBLED.get());
        }
        if (event.getEntity().m_21023_((MobEffect)ACEffectRegistry.DARKNESS_INCARNATE.get()) && event.getEntity().f_19797_ % 5 == 0 && DarknessIncarnateEffect.isInLight(event.getEntity(), 11)) {
            event.getEntity().m_21195_((MobEffect)ACEffectRegistry.DARKNESS_INCARNATE.get());
        }
        if (event.getEntity().m_6844_(EquipmentSlot.HEAD).m_150930_((Item)ACItemRegistry.DIVING_HELMET.get()) && (!event.getEntity().m_204029_(FluidTags.f_13131_) || event.getEntity().m_20202_() instanceof SubmarineEntity)) {
            event.getEntity().m_7292_(new MobEffectInstance(MobEffects.f_19608_, 810, 0, false, false, true));
        }
        if (!event.getEntity().m_9236_().f_46443_ && (livingEntity = event.getEntity()) instanceof Mob && (livingEntity = (mob = (Mob)livingEntity).m_5448_()) instanceof VallumraptorEntity && (vallumraptor = (VallumraptorEntity)livingEntity).getHideFor() > 0) {
            mob.m_6710_(null);
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(MobSpawnEvent.FinalizeSpawn event) {
        try {
            Drowned drowned;
            Mob mob = event.getEntity();
            if (mob instanceof Creeper) {
                Creeper creeper = (Creeper)mob;
                creeper.f_21346_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)creeper, RaycatEntity.class, 10.0f, 1.0, 1.2));
            }
            if ((mob = event.getEntity()) instanceof Drowned && (drowned = (Drowned)mob).m_9236_().m_204166_(drowned.m_20183_()).m_203565_(ACBiomeRegistry.ABYSSAL_CHASM) && drowned.m_6844_(EquipmentSlot.FEET).m_41619_() && drowned.m_6844_(EquipmentSlot.LEGS).m_41619_() && drowned.m_6844_(EquipmentSlot.CHEST).m_41619_() && drowned.m_6844_(EquipmentSlot.HEAD).m_41619_()) {
                if ((double)drowned.m_217043_().m_188501_() < 0.2) {
                    drowned.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)ACItemRegistry.DIVING_HELMET.get()));
                    drowned.m_21409_(EquipmentSlot.HEAD, 0.5f);
                }
                if ((double)drowned.m_217043_().m_188501_() < 0.2) {
                    drowned.m_8061_(EquipmentSlot.CHEST, new ItemStack((ItemLike)ACItemRegistry.DIVING_CHESTPLATE.get()));
                    drowned.m_21409_(EquipmentSlot.CHEST, 0.5f);
                }
                if ((double)drowned.m_217043_().m_188501_() < 0.2) {
                    drowned.m_8061_(EquipmentSlot.LEGS, new ItemStack((ItemLike)ACItemRegistry.DIVING_LEGGINGS.get()));
                    drowned.m_21409_(EquipmentSlot.LEGS, 0.5f);
                }
                if ((double)drowned.m_217043_().m_188501_() < 0.2) {
                    drowned.m_8061_(EquipmentSlot.FEET, new ItemStack((ItemLike)ACItemRegistry.DIVING_BOOTS.get()));
                    drowned.m_21409_(EquipmentSlot.FEET, 0.5f);
                }
            }
        }
        catch (Exception e) {
            AlexsCaves.LOGGER.warn("Tried to add unique behaviors to vanilla mobs and encountered an error");
        }
    }

    @SubscribeEvent
    public void livingRemoveEffect(MobEffectEvent.Remove event) {
        MobEffect mobEffect = event.getEffect();
        if (mobEffect instanceof DarknessIncarnateEffect) {
            DarknessIncarnateEffect darknessIncarnateEffect = (DarknessIncarnateEffect)mobEffect;
            darknessIncarnateEffect.toggleFlight(event.getEntity(), false);
            event.getEntity().m_216990_((SoundEvent)ACSoundRegistry.DARKNESS_INCARNATE_EXIT.get());
        }
    }

    @SubscribeEvent
    public void livingAddEffect(MobEffectEvent.Added event) {
        if (event.getEffectInstance().m_19544_() instanceof DarknessIncarnateEffect) {
            event.getEntity().m_216990_((SoundEvent)ACSoundRegistry.DARKNESS_INCARNATE_ENTER.get());
        }
    }

    @SubscribeEvent
    public void livingExpireEffect(MobEffectEvent.Expired event) {
        MobEffect mobEffect = event.getEffectInstance().m_19544_();
        if (mobEffect instanceof DarknessIncarnateEffect) {
            DarknessIncarnateEffect darknessIncarnateEffect = (DarknessIncarnateEffect)mobEffect;
            darknessIncarnateEffect.toggleFlight(event.getEntity(), false);
            event.getEntity().m_216990_((SoundEvent)ACSoundRegistry.DARKNESS_INCARNATE_EXIT.get());
        }
    }

    @SubscribeEvent
    @Deprecated(forRemoval=true, since="1.21")
    public void onReplaceBiome(EventReplaceBiome event) {
        Holder biomeHolder;
        ResourceKey<Biome> biome = BiomeGenerationConfig.getBiomeForEvent(event);
        if (biome != null && (biomeHolder = (Holder)event.getBiomeSource().getResourceKeyMap().get(biome)) != null) {
            event.setResult(Event.Result.ALLOW);
            event.setBiomeToGenerate(biomeHolder);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onServerAboutToStart(ServerAboutToStartEvent event) {
        Optional holderOptional;
        ACBiomeRarity.init();
        RegistryAccess.Frozen registryAccess = event.getServer().m_206579_();
        Registry allBiomes = registryAccess.m_175515_(Registries.f_256952_);
        Registry levelStems = registryAccess.m_175515_(Registries.f_256862_);
        HashMap<ResourceKey<Biome>, Holder<Biome>> biomeMap = new HashMap<ResourceKey<Biome>, Holder<Biome>>();
        for (ResourceKey biomeResourceKey : allBiomes.m_214010_()) {
            holderOptional = allBiomes.m_203636_(biomeResourceKey);
            holderOptional.ifPresent(biomeHolder -> biomeMap.put((ResourceKey<Biome>)biomeResourceKey, (Holder<Biome>)biomeHolder));
        }
        for (ResourceKey levelStemResourceKey : levelStems.m_214010_()) {
            BiomeSource biomeSource;
            holderOptional = levelStems.m_203636_(levelStemResourceKey);
            if (!holderOptional.isPresent() || !((biomeSource = ((LevelStem)((Holder.Reference)holderOptional.get()).m_203334_()).f_63976_().m_62218_()) instanceof BiomeSourceAccessor)) continue;
            BiomeSourceAccessor expandedBiomeSource = (BiomeSourceAccessor)biomeSource;
            expandedBiomeSource.setResourceKeyMap(biomeMap);
            if (!levelStemResourceKey.equals((Object)LevelStem.f_63971_)) continue;
            ImmutableSet.Builder biomeHolders = ImmutableSet.builder();
            for (ResourceKey<Biome> biomeResourceKey : ACBiomeRegistry.ALEXS_CAVES_BIOMES) {
                allBiomes.m_203636_(biomeResourceKey).ifPresent(arg_0 -> ((ImmutableSet.Builder)biomeHolders).add(arg_0));
            }
            expandedBiomeSource.expandBiomesWith((Set<Holder<Biome>>)biomeHolders.build());
        }
    }

    @SubscribeEvent
    public void playerTick(TickEvent.PlayerTickEvent event) {
        if (!event.player.m_7500_()) {
            if (event.player.m_21120_(InteractionHand.MAIN_HAND).m_204117_(ACTagRegistry.RESTRICTED_BIOME_LOCATORS)) {
                CommonEvents.checkAndDestroyExploitItem(event.player, EquipmentSlot.MAINHAND);
            }
            if (event.player.m_21120_(InteractionHand.OFF_HAND).m_204117_(ACTagRegistry.RESTRICTED_BIOME_LOCATORS)) {
                CommonEvents.checkAndDestroyExploitItem(event.player, EquipmentSlot.OFFHAND);
            }
        }
    }

    @SubscribeEvent
    public void onVillagerTradeSetup(VillagerTradesEvent event) {
        if (event.getType() == VillagerProfession.f_35588_ && ((Boolean)AlexsCaves.COMMON_CONFIG.cartographersSellCabinMaps.get()).booleanValue()) {
            int level = 2;
            List list = (List)event.getTrades().get(level);
            list.add(new VillagerUndergroundCabinMapTrade(5, 10, 6));
            event.getTrades().put(level, (Object)list);
        }
    }

    @SubscribeEvent
    public void onWanderingTradeSetup(WandererTradesEvent event) {
        if (((Boolean)AlexsCaves.COMMON_CONFIG.wanderingTradersSellCabinMaps.get()).booleanValue()) {
            event.getGenericTrades().add(new VillagerUndergroundCabinMapTrade(8, 1, 10));
        }
    }

    @SubscribeEvent
    public void playerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (((Boolean)AlexsCaves.COMMON_CONFIG.warnGenerationIncompatibility.get()).booleanValue() && !AlexsCaves.MOD_GENERATION_CONFLICTS.isEmpty() && event.getEntity().m_9236_().f_46443_) {
            for (String modid : AlexsCaves.MOD_GENERATION_CONFLICTS) {
                if (!ModList.get().isLoaded(modid)) continue;
                event.getEntity().m_213846_((Component)Component.m_237110_((String)"alexscaves.startup_warning.generation_incompatible", (Object[])new Object[]{modid}).m_130940_(ChatFormatting.RED));
            }
        }
    }

    private static void checkAndDestroyExploitItem(Player player, EquipmentSlot slot) {
        CompoundTag tag;
        ItemStack itemInHand = player.m_6844_(slot);
        if (itemInHand.m_204117_(ACTagRegistry.RESTRICTED_BIOME_LOCATORS) && (tag = itemInHand.m_41783_()) != null && (CommonEvents.itemTagContainsAC(tag, "BiomeKey", false) || CommonEvents.itemTagContainsAC(tag, "Structure", true) || CommonEvents.itemTagContainsAC(tag, "structurecompass:structureName", true) || CommonEvents.itemTagContainsAC(tag, "StructureKey", true))) {
            itemInHand.m_41774_(1);
            player.m_21166_(slot);
            player.m_216990_((SoundEvent)ACSoundRegistry.DISAPPOINTMENT.get());
            if (!player.m_9236_().f_46443_) {
                player.m_5661_((Component)Component.m_237115_((String)"item.alexscaves.natures_compass_warning"), true);
            }
        }
    }

    @SubscribeEvent
    public void onUpdateAnvil(AnvilUpdateEvent event) {
        if (event.getLeft().m_41720_() instanceof AlwaysCombinableOnAnvil && event.getLeft().m_41720_() == event.getRight().m_41720_() && !event.getLeft().getAllEnchantments().isEmpty() && !event.getRight().getAllEnchantments().isEmpty()) {
            Map map = EnchantmentHelper.m_44831_((ItemStack)event.getLeft());
            Map map1 = EnchantmentHelper.m_44831_((ItemStack)event.getRight());
            boolean canCombine = true;
            int i = 0;
            for (Enchantment enchantment1 : map1.keySet()) {
                int j2;
                if (enchantment1 == null) continue;
                int i2 = map.getOrDefault(enchantment1, 0);
                j2 = i2 == (j2 = ((Integer)map1.get(enchantment1)).intValue()) ? j2 + 1 : Math.max(j2, i2);
                for (Enchantment enchantment : map.keySet()) {
                    if (enchantment == enchantment1 || enchantment1.m_44695_(enchantment)) continue;
                    canCombine = false;
                    ++i;
                }
                if (!canCombine) continue;
                if (j2 > enchantment1.m_6586_()) {
                    j2 = enchantment1.m_6586_();
                }
                map.put(enchantment1, j2);
                int k3 = 0;
                switch (enchantment1.m_44699_()) {
                    case COMMON: {
                        k3 = 1;
                        break;
                    }
                    case UNCOMMON: {
                        k3 = 2;
                        break;
                    }
                    case RARE: {
                        k3 = 4;
                        break;
                    }
                    case VERY_RARE: {
                        k3 = 8;
                    }
                }
                i += k3 * j2;
            }
            event.setCost(i);
            ItemStack copy = event.getLeft().m_41777_();
            EnchantmentHelper.m_44865_((Map)map, (ItemStack)copy);
            event.setOutput(copy);
        }
    }

    private static boolean itemTagContainsAC(CompoundTag tag, String tagID, boolean allowUndergroundCabin) {
        if (tag.m_128441_(tagID)) {
            String resourceLocation = tag.m_128461_(tagID);
            return resourceLocation.contains("alexscaves:") && (!allowUndergroundCabin || !resourceLocation.contains("underground_cabin"));
        }
        return false;
    }
}

