/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.item;

import com.github.alexmodguy.alexscaves.AlexsCaves;
import com.github.alexmodguy.alexscaves.server.enchantment.ACEnchantmentRegistry;
import com.github.alexmodguy.alexscaves.server.entity.item.WaterBoltEntity;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import java.util.function.Consumer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;

public class SeaStaffItem
extends Item {
    public SeaStaffItem(Item.Properties properties) {
        super(properties);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept((IClientItemExtensions)AlexsCaves.PROXY.getISTERProperties());
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        level.m_6263_((Player)null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)ACSoundRegistry.SEA_STAFF_CAST.get(), SoundSource.PLAYERS, 0.5f, level.m_213780_().m_188501_() * 0.45f + 0.75f);
        player.m_6674_(hand);
        float seekAmount = itemstack.getEnchantmentLevel((Enchantment)ACEnchantmentRegistry.SOAK_SEEKING.get());
        if (!level.f_46443_) {
            double dist = 128.0;
            Entity closestValid = null;
            Vec3 playerEyes = player.m_20299_(1.0f);
            BlockHitResult hitresult = level.m_45547_(new ClipContext(playerEyes, playerEyes.m_82549_(player.m_20154_().m_82490_(dist)), ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, (Entity)player));
            if (hitresult instanceof EntityHitResult) {
                Entity entity = ((EntityHitResult)hitresult).m_82443_();
                if (!entity.equals((Object)player) && !player.m_7307_(entity) && !entity.m_7307_((Entity)player) && entity instanceof Mob && player.m_142582_(entity)) {
                    closestValid = entity;
                }
            } else {
                Vec3 at = hitresult.m_82450_();
                AABB around = new AABB(at.m_82520_(-0.5, -0.5, -0.5), at.m_82520_(0.5, 0.5, 0.5)).m_82400_(15.0);
                for (Entity entity : level.m_45976_(LivingEntity.class, around.m_82400_(dist))) {
                    if (entity.equals((Object)player) || player.m_7307_(entity) || entity.m_7307_((Entity)player) || !(entity instanceof Mob) || !player.m_142582_(entity) || closestValid != null && !(entity.m_20238_(at) < closestValid.m_20238_(at))) continue;
                    closestValid = entity;
                }
            }
            int bolts = itemstack.getEnchantmentLevel((Enchantment)ACEnchantmentRegistry.TRIPLE_SPLASH.get()) > 0 ? 3 : 1;
            for (int i = 0; i < bolts; ++i) {
                float shootRot = i == 0 ? 0.0f : (i == 1 ? -50.0f : 50.0f);
                WaterBoltEntity bolt = new WaterBoltEntity(level, (LivingEntity)player);
                float rot = player.f_20885_ + (float)(hand == InteractionHand.MAIN_HAND ? 45 : -45);
                bolt.m_6034_(player.m_20185_() - (double)player.m_20205_() * (double)1.1f * (double)Mth.m_14031_((float)(rot * ((float)Math.PI / 180))), player.m_20188_() - (double)0.4f, player.m_20189_() + (double)player.m_20205_() * (double)1.1f * (double)Mth.m_14089_((float)(rot * ((float)Math.PI / 180))));
                bolt.m_37251_((Entity)player, player.m_146909_(), player.m_146908_() + shootRot, -20.0f, i > 0 ? 1.0f : 2.0f, 12.0f);
                if (itemstack.getEnchantmentLevel((Enchantment)ACEnchantmentRegistry.ENVELOPING_BUBBLE.get()) > 0) {
                    bolt.setBubbling(player.m_217043_().m_188499_());
                }
                if (itemstack.getEnchantmentLevel((Enchantment)ACEnchantmentRegistry.BOUNCING_BOLT.get()) > 0) {
                    bolt.ricochet = true;
                }
                bolt.seekAmount = 0.3f + seekAmount * 0.2f;
                if (closestValid != null) {
                    bolt.setArcingTowards(closestValid.m_20148_());
                }
                level.m_7967_((Entity)bolt);
            }
        }
        player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        if (!player.m_150110_().f_35937_) {
            itemstack.m_41622_(1, (LivingEntity)player, player1 -> player1.m_21190_(hand));
        }
        return InteractionResultHolder.m_19092_((Object)itemstack, (boolean)level.m_5776_());
    }

    public int m_6473_() {
        return 1;
    }

    public boolean m_8120_(ItemStack stack) {
        return stack.m_41613_() == 1;
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int i, boolean held) {
        LivingEntity living;
        boolean using;
        super.m_6883_(stack, level, entity, i, held);
        boolean bl = using = entity instanceof LivingEntity && (living = (LivingEntity)entity).m_21211_().equals(stack);
        if (!level.f_46443_ && stack.getEnchantmentLevel((Enchantment)ACEnchantmentRegistry.SEAPAIRING.get()) > 0 && !using && level.f_46441_.m_188501_() < 0.02f && entity.m_20071_()) {
            stack.m_41721_(Math.min(0, stack.m_41773_() - 1));
        }
    }
}

