/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.level.structure.piece;

import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import com.github.alexmodguy.alexscaves.server.level.structure.piece.ACStructurePieceRegistry;
import com.github.alexmodguy.alexscaves.server.level.structure.piece.AbstractCaveGenerationStructurePiece;
import com.github.alexmodguy.alexscaves.server.misc.ACMath;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class ForlornCanyonStructurePiece
extends AbstractCaveGenerationStructurePiece {
    public ForlornCanyonStructurePiece(BlockPos chunkCorner, BlockPos holeCenter, int bowlHeight, int bowlRadius) {
        super((StructurePieceType)ACStructurePieceRegistry.FORLORN_CANYON.get(), chunkCorner, holeCenter, bowlHeight, bowlRadius);
    }

    public ForlornCanyonStructurePiece(CompoundTag tag) {
        super((StructurePieceType)ACStructurePieceRegistry.FORLORN_CANYON.get(), tag);
    }

    public ForlornCanyonStructurePiece(StructurePieceSerializationContext structurePieceSerializationContext, CompoundTag tag) {
        this(tag);
    }

    public void m_213694_(WorldGenLevel level, StructureManager featureManager, ChunkGenerator chunkGen, RandomSource random, BoundingBox boundingBox, ChunkPos chunkPos, BlockPos blockPos) {
        int cornerX = this.chunkCorner.m_123341_();
        int cornerY = this.chunkCorner.m_123342_();
        int cornerZ = this.chunkCorner.m_123343_();
        BlockPos.MutableBlockPos carve = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos carveBelow = new BlockPos.MutableBlockPos();
        carve.m_122178_(cornerX, cornerY, cornerZ);
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                MutableBoolean doFloor = new MutableBoolean(false);
                for (int y = 15; y >= 0; --y) {
                    carve.m_122178_(cornerX + x, Mth.m_14045_((int)(cornerY + y), (int)level.m_141937_(), (int)level.m_151558_()), cornerZ + z);
                    if (this.inCircle(carve) && !this.checkedGetBlock(level, (BlockPos)carve).m_60713_(Blocks.f_50752_)) {
                        this.checkedSetBlock(level, (BlockPos)carve, Blocks.f_50627_.m_49966_());
                        this.surroundCornerOfLiquid(level, carve);
                        carveBelow.m_122178_(carve.m_123341_(), carve.m_123342_() - 1, carve.m_123343_());
                        doFloor.setTrue();
                        continue;
                    }
                    if (doFloor.isTrue()) break;
                }
                if (!doFloor.isTrue() || this.checkedGetBlock(level, (BlockPos)carveBelow).m_60795_()) continue;
                this.decorateFloor(level, random, carveBelow);
                doFloor.setFalse();
            }
        }
    }

    private void surroundCornerOfLiquid(WorldGenLevel level, BlockPos.MutableBlockPos center) {
        BlockPos.MutableBlockPos offset = new BlockPos.MutableBlockPos();
        for (Direction dir : Direction.values()) {
            offset.m_122190_((Vec3i)center);
            offset.m_122173_(dir);
            BlockState state = this.checkedGetBlock(level, (BlockPos)offset);
            if (state.m_60819_().m_76178_()) continue;
            this.checkedSetBlock(level, (BlockPos)offset, ((Block)ACBlockRegistry.GUANOSTONE.get()).m_49966_());
        }
    }

    private boolean inCircle(BlockPos.MutableBlockPos carve) {
        float pillarNoise = (ACMath.sampleNoise3D(carve.m_123341_(), (int)((float)carve.m_123342_() * 0.4f), carve.m_123343_(), 30.0f) + 1.0f) * 0.5f;
        float verticalNoise = (ACMath.sampleNoise2D(carve.m_123341_(), carve.m_123343_(), 50.0f) + 1.0f) * 0.2f - (ACMath.smin(ACMath.sampleNoise2D(carve.m_123341_(), carve.m_123343_(), 20.0f), -0.5f, 0.1f) + 0.5f) * 0.7f;
        double distToCenter = carve.m_203202_((double)this.holeCenter.m_123341_(), (double)carve.m_123342_(), (double)this.holeCenter.m_123343_());
        float f = this.getHeightOf(carve);
        float f1 = (float)Math.pow(this.canyonStep(f, 10), 2.5);
        float rawHeight = (float)Math.abs(this.holeCenter.m_123342_() - carve.m_123342_()) / ((float)this.height * 0.5f);
        float reverseRawHeight = 1.0f - rawHeight;
        double yDist = ACMath.smin((float)Math.pow(reverseRawHeight, 0.3f), 1.0f, 0.1f);
        double targetRadius = yDist * (double)((float)this.radius * pillarNoise * f1) * (double)this.radius;
        return distToCenter < targetRadius && rawHeight < 1.0f - verticalNoise;
    }

    private float getHeightOf(BlockPos.MutableBlockPos carve) {
        int halfHeight = this.height / 2;
        if (carve.m_123342_() > this.holeCenter.m_123342_() + halfHeight + 1 || carve.m_123342_() < this.holeCenter.m_123342_() - halfHeight) {
            return 0.0f;
        }
        return 1.0f - (float)(this.holeCenter.m_123342_() + halfHeight - carve.m_123342_()) / (float)(this.height * 2);
    }

    private float canyonStep(float heightScale, int scaleTo) {
        int clampTo100 = (int)(heightScale * (float)scaleTo * (float)scaleTo);
        return Mth.m_14036_((float)((float)Math.round((float)clampTo100 / (float)scaleTo) / (float)scaleTo), (float)0.0f, (float)1.0f);
    }

    private void decorateFloor(WorldGenLevel level, RandomSource rand, BlockPos.MutableBlockPos carveBelow) {
        float floorNoise = (ACMath.sampleNoise2D(carveBelow.m_123341_(), carveBelow.m_123343_(), 50.0f) + 1.0f) * 0.5f;
        this.checkedSetBlock(level, (BlockPos)carveBelow, Blocks.f_220843_.m_49966_());
        int i = 0;
        while ((double)i < Math.ceil(floorNoise * 3.0f)) {
            carveBelow.m_122184_(0, 1, 0);
            this.checkedSetBlock(level, (BlockPos)carveBelow, Blocks.f_220843_.m_49966_());
            ++i;
        }
    }
}

