/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.level.surface;

import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import com.github.alexmodguy.alexscaves.server.level.biome.ACBiomeRegistry;
import com.github.alexmodguy.alexscaves.server.level.surface.ACSurfaceRuleConditionRegistry;
import com.github.alexthe666.citadel.server.generation.SurfaceRulesManager;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Noises;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.VerticalAnchor;

public class ACSurfaceRules {
    public static void setup() {
        SurfaceRulesManager.registerOverworldSurfaceRule((SurfaceRules.ConditionSource)SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{ACBiomeRegistry.MAGNETIC_CAVES}), (SurfaceRules.RuleSource)ACSurfaceRules.createMagneticCavesRules());
        SurfaceRulesManager.registerOverworldSurfaceRule((SurfaceRules.ConditionSource)SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{ACBiomeRegistry.PRIMORDIAL_CAVES}), (SurfaceRules.RuleSource)ACSurfaceRules.createPrimordialCavesRules());
        SurfaceRulesManager.registerOverworldSurfaceRule((SurfaceRules.ConditionSource)SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{ACBiomeRegistry.TOXIC_CAVES}), (SurfaceRules.RuleSource)ACSurfaceRules.createToxicCavesRules());
        SurfaceRulesManager.registerOverworldSurfaceRule((SurfaceRules.ConditionSource)SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{ACBiomeRegistry.ABYSSAL_CHASM}), (SurfaceRules.RuleSource)ACSurfaceRules.createAbyssalChasmRules());
        SurfaceRulesManager.registerOverworldSurfaceRule((SurfaceRules.ConditionSource)SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{ACBiomeRegistry.FORLORN_HOLLOWS}), (SurfaceRules.RuleSource)ACSurfaceRules.createForlornHollowsRules());
    }

    public static SurfaceRules.RuleSource createMagneticCavesRules() {
        SurfaceRules.RuleSource galena = SurfaceRules.m_189390_((BlockState)((Block)ACBlockRegistry.GALENA.get()).m_49966_());
        SurfaceRules.RuleSource scarlet = SurfaceRules.m_189390_((BlockState)((Block)ACBlockRegistry.ENERGIZED_GALENA_SCARLET.get()).m_49966_());
        SurfaceRules.RuleSource azure = SurfaceRules.m_189390_((BlockState)((Block)ACBlockRegistry.ENERGIZED_GALENA_AZURE.get()).m_49966_());
        SurfaceRules.RuleSource neutral = SurfaceRules.m_189390_((BlockState)((Block)ACBlockRegistry.ENERGIZED_GALENA_NEUTRAL.get()).m_49966_());
        SurfaceRules.ConditionSource azureCondition = ACSurfaceRuleConditionRegistry.simplexCondition(-0.025f, 0.025f, 90.0f, 1.0f, 0);
        SurfaceRules.ConditionSource scarletCondition = ACSurfaceRuleConditionRegistry.simplexCondition(-0.025f, 0.025f, 90.0f, 1.0f, 1);
        return SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{ACSurfaceRules.bedrock(), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)azureCondition, (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)scarletCondition, (SurfaceRules.RuleSource)neutral)), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)scarletCondition, (SurfaceRules.RuleSource)scarlet), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)azureCondition, (SurfaceRules.RuleSource)azure), galena});
    }

    public static SurfaceRules.RuleSource createPrimordialCavesRules() {
        SurfaceRules.RuleSource limestone = SurfaceRules.m_189390_((BlockState)((Block)ACBlockRegistry.LIMESTONE.get()).m_49966_());
        SurfaceRules.RuleSource grass = SurfaceRules.m_189390_((BlockState)Blocks.f_50440_.m_49966_());
        SurfaceRules.RuleSource dirt = SurfaceRules.m_189390_((BlockState)Blocks.f_50493_.m_49966_());
        SurfaceRules.RuleSource packedMud = SurfaceRules.m_189390_((BlockState)Blocks.f_220843_.m_49966_());
        SurfaceRules.RuleSource dirtOrPackedMud = SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189412_((ResourceKey)Noises.f_189267_, (double)-0.12, (double)0.2), (SurfaceRules.RuleSource)packedMud), dirt});
        SurfaceRules.ConditionSource isUnderwater = SurfaceRules.m_189382_((int)0, (int)0);
        SurfaceRules.RuleSource grassWaterChecked = SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)isUnderwater, (SurfaceRules.RuleSource)grass), dirtOrPackedMud});
        SurfaceRules.RuleSource floorRules = SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.f_189375_, (SurfaceRules.RuleSource)grassWaterChecked), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.f_189376_, (SurfaceRules.RuleSource)dirtOrPackedMud)});
        return SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{ACSurfaceRules.bedrock(), floorRules, ACSurfaceRules.createSandstoneBands(15, 1, 20), limestone});
    }

    public static SurfaceRules.RuleSource createToxicCavesRules() {
        SurfaceRules.RuleSource radrock = SurfaceRules.m_189390_((BlockState)((Block)ACBlockRegistry.RADROCK.get()).m_49966_());
        return SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{ACSurfaceRules.bedrock(), radrock});
    }

    public static SurfaceRules.RuleSource createAbyssalChasmRules() {
        SurfaceRules.RuleSource abyssmarine = SurfaceRules.m_189390_((BlockState)((Block)ACBlockRegistry.ABYSSMARINE.get()).m_49966_());
        SurfaceRules.RuleSource deepslate = SurfaceRules.m_189390_((BlockState)Blocks.f_152550_.m_49966_());
        SurfaceRules.RuleSource stone = SurfaceRules.m_189390_((BlockState)Blocks.f_50069_.m_49966_());
        SurfaceRules.ConditionSource normalDeepslateCondition = SurfaceRules.m_189403_((String)"deepslate", (VerticalAnchor)VerticalAnchor.m_158922_((int)0), (VerticalAnchor)VerticalAnchor.m_158922_((int)8));
        SurfaceRules.RuleSource stoneOrDeepslate = SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)normalDeepslateCondition, (SurfaceRules.RuleSource)deepslate), stone});
        return SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{ACSurfaceRules.bedrock(), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.f_202169_, (SurfaceRules.RuleSource)stoneOrDeepslate), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189425_(), (SurfaceRules.RuleSource)deepslate), abyssmarine});
    }

    public static SurfaceRules.RuleSource createForlornHollowsRules() {
        SurfaceRules.RuleSource mud = SurfaceRules.m_189390_((BlockState)Blocks.f_220843_.m_49966_());
        SurfaceRules.RuleSource guanostone = SurfaceRules.m_189390_((BlockState)((Block)ACBlockRegistry.GUANOSTONE.get()).m_49966_());
        SurfaceRules.RuleSource corpolith = SurfaceRules.m_189390_((BlockState)((Block)ACBlockRegistry.COPROLITH.get()).m_49966_());
        SurfaceRules.ConditionSource corpolithCondition = ACSurfaceRuleConditionRegistry.simplexCondition(-0.2f, 0.4f, 40.0f, 6.0f, 3);
        return SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{ACSurfaceRules.bedrock(), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.f_189375_, (SurfaceRules.RuleSource)mud), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)corpolithCondition, (SurfaceRules.RuleSource)corpolith), guanostone});
    }

    private static SurfaceRules.RuleSource bedrock() {
        SurfaceRules.RuleSource bedrock = SurfaceRules.m_189390_((BlockState)Blocks.f_50752_.m_49966_());
        SurfaceRules.ConditionSource bedrockCondition = SurfaceRules.m_189403_((String)"bedrock", (VerticalAnchor)VerticalAnchor.m_158921_(), (VerticalAnchor)VerticalAnchor.m_158930_((int)5));
        return SurfaceRules.m_189394_((SurfaceRules.ConditionSource)bedrockCondition, (SurfaceRules.RuleSource)bedrock);
    }

    private static SurfaceRules.RuleSource createSandstoneBands(int layers, int layerThickness, int layerDistance) {
        SurfaceRules.RuleSource sandstone = SurfaceRules.m_189390_((BlockState)Blocks.f_50062_.m_49966_());
        SurfaceRules.RuleSource[] ruleSources = new SurfaceRules.RuleSource[layers];
        for (int i = 1; i <= layers; ++i) {
            int yDown = i * layerDistance;
            int extra = i % 3 == 0 ? 1 : 0;
            SurfaceRules.ConditionSource layer1 = SurfaceRules.m_189400_((VerticalAnchor)VerticalAnchor.m_158922_((int)(62 - yDown)), (int)-1);
            SurfaceRules.ConditionSource layer2 = SurfaceRules.m_189400_((VerticalAnchor)VerticalAnchor.m_158922_((int)(62 + extra + layerThickness - yDown)), (int)0);
            ruleSources[i - 1] = SurfaceRules.m_189394_((SurfaceRules.ConditionSource)layer1, (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189392_((SurfaceRules.ConditionSource)layer2), (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189412_((ResourceKey)Noises.f_189271_, (double)-0.7, (double)0.8), (SurfaceRules.RuleSource)sandstone)));
        }
        return SurfaceRules.m_198272_((SurfaceRules.RuleSource[])ruleSources);
    }
}

