/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.raccompat.items;

import com.github.alexmodguy.alexscaves.client.particle.ACParticleRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.hurts.sskirillss.raccompat.misc.RACLootCollections;
import it.hurts.sskirillss.relics.client.models.items.CurioModel;
import it.hurts.sskirillss.relics.client.models.items.SidedCurioModel;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.IRenderableCurio;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.CastData;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.CastStage;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.CastType;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.WorldUtils;
import java.util.List;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.client.ICurioRenderer;

public class PolarBootItem
extends RelicItem
implements IRenderableCurio {
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"polarity").active(CastData.builder().type(CastType.TOGGLEABLE).build()).icon((player, stack, ability) -> ability + (this.isAbilityTicking((ItemStack)stack, (String)ability) ? "_blue" : "_red")).stat(StatData.builder((String)"speed").initialValue(0.9, 0.95).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.015).formatValue(value -> MathUtils.round((double)(value * 100.0), (int)1)).build()).build()).build()).leveling(new LevelingData(100, 10, 200)).loot(LootData.builder().entry(RACLootCollections.MAGNETIC).build()).build();
    }

    public void castActiveAbility(ItemStack stack, Player player, String ability, CastType type, CastStage stage) {
        if (stage == CastStage.TICK || !ability.equals("polarity")) {
            return;
        }
        Level level = player.m_9236_();
        RandomSource random = level.m_213780_();
        boolean isEnabling = this.isAbilityTicking(stack, "polarity");
        level.m_5594_(null, player.m_20183_(), (SoundEvent)ACSoundRegistry.NEODYMIUM_PLACE.get(), SoundSource.MASTER, 1.0f, isEnabling ? 1.75f : 0.75f);
        for (int i = 0; i < 15; ++i) {
            Vec3 center = player.m_20182_().m_82520_((double)(MathUtils.randomFloat((RandomSource)random) * 0.25f), isEnabling ? (double)player.m_20206_() : 0.0, (double)(MathUtils.randomFloat((RandomSource)random) * 0.25f));
            level.m_7106_(isEnabling ? (ParticleOptions)ACParticleRegistry.SCARLET_SHIELD_LIGHTNING.get() : (ParticleOptions)ACParticleRegistry.AZURE_SHIELD_LIGHTNING.get(), center.m_7096_(), center.m_7098_(), center.m_7094_(), center.m_7096_() + (double)(MathUtils.randomFloat((RandomSource)random) * 3.0f), center.m_7098_() + (double)(player.m_20206_() * (float)(isEnabling ? -1 : 1) * 2.0f), center.m_7094_() + (double)(MathUtils.randomFloat((RandomSource)random) * 3.0f));
        }
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        Level level = player.m_9236_();
        RandomSource random = level.m_213780_();
        int horizontalRadius = 3;
        int verticalRadius = 8;
        Vec3 motion = Vec3.f_82478_;
        if (this.isAbilityTicking(stack, "polarity")) {
            if (player.f_19797_ % 20 == 0) {
                this.spreadExperience((LivingEntity)player, stack, 1);
            }
            for (int x = -horizontalRadius; x <= horizontalRadius; ++x) {
                for (int y = -verticalRadius; y <= verticalRadius / 2; ++y) {
                    for (int z = -horizontalRadius; z <= horizontalRadius; ++z) {
                        BlockPos pos = player.m_20183_().m_7918_(x, y, z);
                        if ((double)pos.m_123342_() > player.m_20188_() || !level.m_8055_(pos).m_280296_()) continue;
                        Vec3 repulsion = player.m_20182_().m_82546_(Vec3.m_82512_((Vec3i)pos));
                        double distance = repulsion.m_82556_();
                        double verticalDamping = (1.0 - Math.abs(player.m_20186_() - (double)pos.m_123342_()) / ((double)verticalRadius * 2.0)) * 0.2;
                        if (!(distance > 0.0)) continue;
                        motion = motion.m_82549_(repulsion.m_82542_(verticalDamping, 1.0, verticalDamping).m_82541_().m_82490_(0.65 / distance * 0.025));
                    }
                }
            }
            if (level.m_5776_()) {
                motion = this.handleAirController(player, motion);
            }
            if (motion.m_82556_() > 0.0) {
                double diff;
                double horizontalSpeed = this.getAbilityValue(stack, "polarity", "speed");
                player.m_20256_(player.m_20184_().m_82542_(horizontalSpeed, 1.0, horizontalSpeed).m_82549_(motion));
                player.f_19812_ = true;
                player.f_19789_ = 0.0f;
                if (level.f_46443_ && player.f_19797_ % 2 == 0 && (diff = Math.min(24.0, player.m_20186_() - WorldUtils.getGroundHeight((Entity)player, (Vec3)player.m_20182_(), (int)24))) > 0.0) {
                    Vec3 start = player.m_20182_().m_82549_(player.m_20184_()).m_82520_((double)(MathUtils.randomFloat((RandomSource)random) * 0.25f), 0.0, (double)(MathUtils.randomFloat((RandomSource)random) * 0.25f));
                    Vec3 delta = player.m_20182_().m_82549_(new Vec3((double)MathUtils.randomFloat((RandomSource)random), -diff, (double)MathUtils.randomFloat((RandomSource)random)));
                    level.m_7106_((ParticleOptions)ACParticleRegistry.AZURE_SHIELD_LIGHTNING.get(), start.m_7096_(), start.m_7098_(), start.m_7094_(), delta.f_82479_, delta.f_82480_, delta.f_82481_);
                }
            }
        } else if (!(player.m_20096_() || player.m_21255_() || player.m_150110_().f_35935_ || player.m_6069_())) {
            double diff;
            player.m_20256_(player.m_20184_().m_82520_(0.0, Math.min((double)-0.02f, motion.m_7098_() * (double)1.075f), 0.0));
            player.f_19812_ = true;
            if (level.f_46443_ && player.f_19797_ % 2 == 0 && (diff = Math.min(24.0, player.m_20186_() - WorldUtils.getGroundHeight((Entity)player, (Vec3)player.m_20182_(), (int)24))) > 0.0) {
                Vec3 start = player.m_20182_().m_82549_(player.m_20184_()).m_82520_((double)(MathUtils.randomFloat((RandomSource)random) * 0.25f), 0.0, (double)(MathUtils.randomFloat((RandomSource)random) * 0.25f));
                Vec3 delta = player.m_20182_().m_82549_(new Vec3((double)MathUtils.randomFloat((RandomSource)random), -diff, (double)MathUtils.randomFloat((RandomSource)random)));
                level.m_7106_((ParticleOptions)ACParticleRegistry.SCARLET_SHIELD_LIGHTNING.get(), start.m_7096_(), start.m_7098_(), start.m_7094_(), delta.f_82479_, delta.f_82480_, delta.f_82481_);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public Vec3 handleAirController(Player player, Vec3 motion) {
        if (!(player instanceof LocalPlayer)) {
            return motion;
        }
        LocalPlayer localPlayer = (LocalPlayer)player;
        if (localPlayer.m_6144_()) {
            motion = motion.m_82520_(0.0, -0.05, 0.0);
        }
        if (localPlayer.f_108618_.f_108572_ && motion.m_7098_() > 0.0) {
            motion = motion.m_82542_(1.0, 1.5, 1.0);
        }
        return motion;
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        Level level = entity.m_9236_();
        RandomSource random = level.m_213780_();
        Item item = stack.m_41720_();
        if (item instanceof IRelicItem) {
            IRelicItem relic = (IRelicItem)item;
            Vec3 offset = entity.m_20182_().m_82520_((double)(MathUtils.randomFloat((RandomSource)random) * 0.25f), 0.0, (double)(MathUtils.randomFloat((RandomSource)random) * 0.25f));
            double distance = Math.min(5.0, PolarBootItem.getGroundDistance((Entity)entity, offset, 5));
            if (relic.isAbilityTicking(stack, "polarity")) {
                if (entity.f_19797_ % 5 != 0) {
                    level.m_7106_((ParticleOptions)ACParticleRegistry.AZURE_SHIELD_LIGHTNING.get(), entity.m_20185_(), entity.m_20186_() + (double)entity.m_20206_(), entity.m_20189_(), offset.m_7096_(), offset.m_7098_() - distance, offset.m_7094_());
                }
                if (distance <= 1.0) {
                    entity.m_20256_(entity.m_20184_().m_82520_(0.0, (double)0.05f, 0.0));
                    entity.f_19812_ = true;
                }
            } else if (entity.f_19797_ % 5 != 0) {
                level.m_7106_((ParticleOptions)ACParticleRegistry.SCARLET_SHIELD_LIGHTNING.get(), entity.m_20185_(), entity.m_20186_() + (double)entity.m_20206_(), entity.m_20189_(), offset.m_7096_(), offset.m_7098_() - distance, offset.m_7094_());
            }
        }
        return false;
    }

    public static double getGroundDistance(Entity entity, Vec3 position, int iterations) {
        return Math.max(0.0, position.m_7098_() - WorldUtils.getGroundHeight((Entity)entity, (Vec3)position, (int)iterations));
    }

    @OnlyIn(value=Dist.CLIENT)
    public CurioModel getModel(ItemStack stack) {
        return new SidedCurioModel(stack.m_41720_());
    }

    public ResourceLocation getTexture(ItemStack stack) {
        ResourceLocation id = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_());
        assert (id != null);
        return new ResourceLocation(id.m_135827_(), "textures/models/items/" + id.m_135815_() + (this.isAbilityTicking(stack, "polarity") ? "_blue" : "_red") + ".png");
    }

    @OnlyIn(value=Dist.CLIENT)
    public <T extends LivingEntity, M extends EntityModel<T>> void render(ItemStack stack, SlotContext slotContext, PoseStack matrixStack, RenderLayerParent<T, M> renderLayerParent, MultiBufferSource renderTypeBuffer, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        CurioModel model = this.getModel(stack);
        if (!(model instanceof SidedCurioModel)) {
            return;
        }
        SidedCurioModel sidedModel = (SidedCurioModel)model;
        sidedModel.setSlot(slotContext.index());
        matrixStack.m_85836_();
        LivingEntity entity = slotContext.entity();
        sidedModel.m_6839_(entity, limbSwing, limbSwingAmount, partialTicks);
        sidedModel.m_6973_(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        ICurioRenderer.followBodyRotations((LivingEntity)entity, (HumanoidModel[])new HumanoidModel[]{sidedModel});
        VertexConsumer vertexconsumer = ItemRenderer.m_115184_((MultiBufferSource)renderTypeBuffer, (RenderType)RenderType.m_110431_((ResourceLocation)this.getTexture(stack)), (boolean)false, (boolean)stack.m_41790_());
        matrixStack.m_252880_(0.0f, 0.0f, -0.025f);
        sidedModel.m_7695_(matrixStack, vertexconsumer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.m_85849_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public LayerDefinition constructLayerDefinition() {
        MeshDefinition mesh = HumanoidModel.m_170681_((CubeDeformation)new CubeDeformation(0.4f), (float)0.0f);
        mesh.m_171576_().m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, 9).m_171488_(-2.9f, 5.5f, -2.5f, 6.0f, 7.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(0, 1).m_171488_(-2.9f, 5.5f, -2.5f, 6.0f, 1.0f, 6.0f, new CubeDeformation(0.175f)).m_171514_(18, 9).m_171488_(-2.9f, 9.5f, -4.5f, 6.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(25, 0).m_171488_(-1.9f, 6.5f, 3.5f, 4.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.9f, (float)12.0f, (float)0.5f));
        mesh.m_171576_().m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(0, 9).m_171488_(-2.9f, 5.5f, -2.5f, 6.0f, 7.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(0, 1).m_171488_(-2.9f, 5.5f, -2.5f, 6.0f, 1.0f, 6.0f, new CubeDeformation(0.175f)).m_171514_(18, 9).m_171488_(-2.9f, 9.5f, -4.5f, 6.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(25, 0).m_171488_(-1.9f, 6.5f, 3.5f, 4.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.9f, (float)12.0f, (float)0.5f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)64, (int)64);
    }

    public List<String> bodyParts() {
        return Lists.newArrayList((Object[])new String[]{"right_leg", "left_leg"});
    }
}

