/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.api.entity.player.task;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.teamlapen.vampirism.api.VampirismRegistries;
import de.teamlapen.vampirism.api.entity.player.task.TaskRequirement;
import de.teamlapen.vampirism.api.entity.player.task.TaskReward;
import de.teamlapen.vampirism.api.entity.player.task.TaskUnlocker;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.util.ExtraCodecs;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Task {
    public static final Codec<Task> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)TaskRequirement.CODEC.fieldOf("requirements").forGetter(i -> i.requirements), (App)TaskReward.CODEC.fieldOf("rewards").forGetter(i -> i.rewards), (App)TaskUnlocker.CODEC.listOf().optionalFieldOf("unlocker").forGetter(i -> Optional.of(List.of(i.unlocker))), (App)ExtraCodecs.f_252442_.optionalFieldOf("description").forGetter(i -> Optional.ofNullable(i.description)), (App)ExtraCodecs.f_252442_.fieldOf("title").forGetter(i -> i.title)).apply((Applicative)inst, Task::new));
    public static final Codec<Holder<Task>> HOLDER_CODEC = RegistryFileCodec.m_135589_(VampirismRegistries.TASK_ID, CODEC);
    @NotNull
    private final TaskRequirement requirements;
    @NotNull
    private final TaskReward rewards;
    @NotNull
    private final TaskUnlocker[] unlocker;
    @NotNull
    private final Component title;
    @Nullable
    private final Component description;

    public Task(@NotNull TaskRequirement requirements, @NotNull TaskReward rewards, @NotNull TaskUnlocker[] unlocker, @Nullable Component description, @NotNull Component title) {
        this.requirements = requirements;
        this.description = description;
        this.rewards = rewards;
        this.unlocker = unlocker;
        this.title = title;
    }

    private Task(@NotNull TaskRequirement requirements, @NotNull TaskReward rewards, @NotNull Optional<List<TaskUnlocker>> unlocker, Optional<Component> description, Component title) {
        this(requirements, rewards, unlocker.map(list -> list.toArray(new TaskUnlocker[0])).orElseGet(() -> new TaskUnlocker[0]), description.orElse(null), title);
    }

    @NotNull
    public TaskRequirement getRequirement() {
        return this.requirements;
    }

    @NotNull
    public TaskReward getReward() {
        return this.rewards;
    }

    @NotNull
    public TaskUnlocker[] getUnlocker() {
        return this.unlocker;
    }

    public Optional<Component> getDescription() {
        return Optional.ofNullable(this.description);
    }

    @NotNull
    public Component getTitle() {
        return this.title;
    }
}

