/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.api.event;

import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.NotNull;

public abstract class ActionEvent
extends Event {
    @NotNull
    private final IFactionPlayer<?> factionPlayer;
    @NotNull
    private final IAction<?> action;

    public ActionEvent(@NotNull IFactionPlayer<?> factionPlayer, @NotNull IAction<?> action) {
        this.factionPlayer = factionPlayer;
        this.action = action;
    }

    @NotNull
    public IFactionPlayer<?> getFactionPlayer() {
        return this.factionPlayer;
    }

    @NotNull
    public IAction<?> getAction() {
        return this.action;
    }

    @Event.HasResult
    public static class ActionUpdateEvent
    extends ActionEvent {
        private final int remainingDuration;
        private boolean overrideDeactivation;

        public ActionUpdateEvent(@NotNull IFactionPlayer<?> factionPlayer, @NotNull IAction<?> action, int remainingDuration) {
            super(factionPlayer, action);
            this.remainingDuration = remainingDuration;
        }

        public int getRemainingDuration() {
            return this.remainingDuration;
        }

        public void setOverrideDeactivation(boolean overrideDeactivation) {
            this.overrideDeactivation = overrideDeactivation;
        }

        public boolean shouldOverrideDeactivation() {
            return this.overrideDeactivation;
        }
    }

    public static class ActionDeactivatedEvent
    extends ActionEvent {
        private final int remainingDuration;
        private int cooldown;

        public ActionDeactivatedEvent(@NotNull IFactionPlayer<?> factionPlayer, @NotNull IAction<?> action, int remainingDuration, int cooldown) {
            super(factionPlayer, action);
            this.remainingDuration = remainingDuration;
            this.cooldown = cooldown;
        }

        public int getRemainingDuration() {
            return this.remainingDuration;
        }

        public int getCooldown() {
            return this.cooldown;
        }

        public void setCooldown(int cooldown) {
            this.cooldown = cooldown;
        }
    }

    @Cancelable
    public static class ActionActivatedEvent
    extends ActionEvent {
        private int cooldown;
        private int duration;

        public ActionActivatedEvent(@NotNull IFactionPlayer<?> factionPlayer, @NotNull IAction<?> action, int cooldown, int duration) {
            super(factionPlayer, action);
            this.cooldown = cooldown;
            this.duration = duration;
        }

        public int getCooldown() {
            return this.cooldown;
        }

        public void setCooldown(int cooldown) {
            this.cooldown = cooldown;
        }

        public int getDuration() {
            return this.duration;
        }

        public void setDuration(int duration) {
            this.duration = duration;
        }
    }
}

