/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.api.items;

import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.factions.IFactionPlayerHandler;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.items.IFactionExclusiveItem;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IFactionLevelItem<T extends IFactionPlayer<T>>
extends IFactionExclusiveItem {
    @OnlyIn(value=Dist.CLIENT)
    @Deprecated(since="1.9", forRemoval=true)
    default public void addFactionLevelToolTip(@NotNull ItemStack stack, @Nullable Level worldIn, @NotNull List<Component> tooltip, TooltipFlag flagIn, @Nullable Player player) {
        this.addFactionToolTips(stack, worldIn, tooltip, flagIn, player);
    }

    @Override
    default public void addFactionToolTips(@NotNull ItemStack stack, @Nullable Level worldIn, @NotNull List<Component> tooltip, TooltipFlag flagIn, @Nullable Player player) {
        ISkill requiredSkill;
        LazyOptional<IFactionPlayerHandler> playerHandler = player != null && player.m_6084_() ? VampirismAPI.getFactionPlayerHandler(player) : LazyOptional.empty();
        IFactionExclusiveItem.super.addFactionToolTips(stack, worldIn, tooltip, flagIn, player);
        boolean correctFaction = playerHandler.map(f -> f.isInFaction(this.getExclusiveFaction(stack))).orElse(false);
        int minLevel = this.getMinLevel(stack);
        if (minLevel > 1) {
            tooltip.add((Component)Component.m_237113_((String)" ").m_7220_((Component)Component.m_237110_((String)"text.vampirism.required_level", (Object[])new Object[]{String.valueOf(minLevel)})).m_130940_(correctFaction ? ChatFormatting.DARK_GREEN : ChatFormatting.DARK_RED));
        }
        if ((requiredSkill = this.getRequiredSkill(stack)) != null) {
            tooltip.add((Component)Component.m_237113_((String)" ").m_7220_((Component)Component.m_237110_((String)"text.vampirism.required_skill", (Object[])new Object[]{requiredSkill.getName()})).m_130940_(correctFaction && playerHandler.map(IFactionPlayerHandler::getCurrentFactionPlayer).flatMap(p -> p.map(d -> d.getSkillHandler().isSkillEnabled(requiredSkill))).orElse(false) != false ? ChatFormatting.DARK_GREEN : ChatFormatting.DARK_RED));
        }
    }

    public int getMinLevel(@NotNull ItemStack var1);

    @Nullable
    public ISkill<T> getRequiredSkill(@NotNull ItemStack var1);
}

