/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blocks;

import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.blocks.VampirismHorizontalBlock;
import de.teamlapen.vampirism.entity.player.hunter.HunterPlayer;
import de.teamlapen.vampirism.entity.player.hunter.skills.HunterSkills;
import de.teamlapen.vampirism.inventory.WeaponTableMenu;
import de.teamlapen.vampirism.util.Helper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WeaponTableBlock
extends VampirismHorizontalBlock {
    public static final int MAX_LAVA = 5;
    public static final int MB_PER_META = 200;
    public static final IntegerProperty LAVA = IntegerProperty.m_61631_((String)"lava", (int)0, (int)5);
    private static final Component name = Component.m_237115_((String)"gui.vampirism.hunter_weapon_table");

    @NotNull
    private static VoxelShape makeShape() {
        VoxelShape a = Block.m_49796_((double)3.0, (double)0.0, (double)0.0, (double)13.0, (double)2.0, (double)8.0);
        VoxelShape b = Block.m_49796_((double)4.0, (double)2.0, (double)1.0, (double)12.0, (double)3.0, (double)7.0);
        VoxelShape c = Block.m_49796_((double)5.0, (double)3.0, (double)2.0, (double)11.0, (double)6.0, (double)6.0);
        VoxelShape d = Block.m_49796_((double)3.0, (double)6.0, (double)0.0, (double)13.0, (double)9.5, (double)8.0);
        VoxelShape e = Block.m_49796_((double)0.0, (double)1.0, (double)9.0, (double)7.0, (double)2.0, (double)16.0);
        VoxelShape e1 = Block.m_49796_((double)0.0, (double)0.0, (double)9.0, (double)2.0, (double)1.0, (double)11.0);
        VoxelShape e2 = Block.m_49796_((double)5.0, (double)0.0, (double)9.0, (double)7.0, (double)1.0, (double)11.0);
        VoxelShape e3 = Block.m_49796_((double)0.0, (double)0.0, (double)14.0, (double)2.0, (double)1.0, (double)16.0);
        VoxelShape e4 = Block.m_49796_((double)5.0, (double)0.0, (double)14.0, (double)7.0, (double)1.0, (double)16.0);
        VoxelShape e5 = Block.m_49796_((double)0.0, (double)1.0, (double)9.0, (double)1.0, (double)7.0, (double)16.0);
        VoxelShape e6 = Block.m_49796_((double)0.0, (double)1.0, (double)9.0, (double)7.0, (double)7.0, (double)10.0);
        VoxelShape e7 = Block.m_49796_((double)0.0, (double)1.0, (double)15.0, (double)7.0, (double)7.0, (double)16.0);
        VoxelShape e8 = Block.m_49796_((double)6.0, (double)1.0, (double)9.0, (double)7.0, (double)7.0, (double)16.0);
        VoxelShape f = Block.m_49796_((double)10.0, (double)0.0, (double)11.0, (double)15.0, (double)3.0, (double)14.0);
        VoxelShape g = Block.m_49796_((double)12.0, (double)3.0, (double)12.0, (double)13.0, (double)10.0, (double)13.0);
        return Shapes.m_83124_((VoxelShape)a, (VoxelShape[])new VoxelShape[]{b, c, d, e, e1, e2, e3, e4, e5, e6, e7, e8, f, g});
    }

    public WeaponTableBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60978_(3.0f).m_60955_(), WeaponTableBlock.makeShape());
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)LAVA, (Comparable)Integer.valueOf(0))).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    @Nullable
    public MenuProvider m_7246_(@NotNull BlockState state, @NotNull Level worldIn, @NotNull BlockPos pos) {
        return new SimpleMenuProvider((id, playerInventory, playerEntity) -> new WeaponTableMenu(id, playerInventory, ContainerLevelAccess.m_39289_((Level)worldIn, (BlockPos)pos)), name);
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        if (!world.f_46443_) {
            if (!Helper.isHunter(player)) {
                player.m_5661_((Component)Component.m_237115_((String)"This seem unfamiliar"), true);
                return InteractionResult.CONSUME;
            }
            int fluid = (Integer)world.m_8055_(pos).m_61143_((Property)LAVA);
            boolean flag = false;
            ItemStack heldItem = player.m_21120_(hand);
            if (fluid < 5) {
                LazyOptional opt = FluidUtil.getFluidHandler((ItemStack)heldItem);
                flag = opt.map(fluidHandler -> {
                    FluidStack drained;
                    FluidStack missing = new FluidStack((Fluid)Fluids.f_76195_, (5 - fluid) * 200);
                    FluidStack drainable = fluidHandler.drain(missing, IFluidHandler.FluidAction.SIMULATE);
                    if (drainable.isEmpty()) {
                        missing.setAmount(1000);
                        drainable = fluidHandler.drain(missing, IFluidHandler.FluidAction.SIMULATE);
                    }
                    if (drainable.getAmount() >= 200 && (drained = fluidHandler.drain(missing, IFluidHandler.FluidAction.EXECUTE)).getAmount() > 0) {
                        world.m_46597_(pos, (BlockState)state.m_61124_((Property)LAVA, (Comparable)Integer.valueOf(Math.min(5, fluid + drained.getAmount() / 200))));
                        player.m_21008_(hand, fluidHandler.getContainer());
                        return true;
                    }
                    return false;
                }).orElse(false);
            }
            if (!flag) {
                if (this.canUse(player) && player instanceof ServerPlayer) {
                    NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new SimpleMenuProvider((id, playerInventory, playerIn) -> new WeaponTableMenu(id, playerInventory, ContainerLevelAccess.m_39289_((Level)playerIn.m_9236_(), (BlockPos)pos)), name), (BlockPos)pos);
                } else {
                    player.m_5661_((Component)Component.m_237115_((String)"You have not learned how to use this"), true);
                }
            }
        }
        return InteractionResult.m_19078_((boolean)world.f_46443_);
    }

    @Override
    protected void m_7926_(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{LAVA, FACING});
    }

    private boolean canUse(@NotNull Player player) {
        if (Helper.isHunter(player)) {
            return HunterPlayer.getOpt(player).map(HunterPlayer::getSkillHandler).map(handler -> handler.isSkillEnabled((ISkill)HunterSkills.WEAPON_TABLE.get())).orElse(false);
        }
        return false;
    }
}

