/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.gui.screens;

import de.teamlapen.lib.lib.client.gui.screens.radialmenu.IRadialMenuSlot;
import de.teamlapen.lib.lib.client.gui.screens.radialmenu.RadialMenu;
import de.teamlapen.lib.lib.client.gui.screens.radialmenu.RadialMenuSlot;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.api.entity.player.actions.IActionHandler;
import de.teamlapen.vampirism.client.ClientConfigHelper;
import de.teamlapen.vampirism.client.core.ModKeys;
import de.teamlapen.vampirism.client.gui.screens.SelectMinionTaskRadialScreen;
import de.teamlapen.vampirism.client.gui.screens.radial.DualSwitchingRadialMenu;
import de.teamlapen.vampirism.entity.player.VampirismPlayerAttributes;
import de.teamlapen.vampirism.network.ServerboundToggleActionPacket;
import de.teamlapen.vampirism.util.RegUtil;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class SelectActionRadialScreen<T extends IFactionPlayer<T>>
extends DualSwitchingRadialMenu<IAction<?>> {
    private final IActionHandler<?> actionHandler;
    private final T player;

    private SelectActionRadialScreen(T player, List<IAction<?>> actions, KeyMapping keyMapping) {
        super(SelectActionRadialScreen.getRadialMenu(actions), keyMapping, SelectMinionTaskRadialScreen::show);
        this.actionHandler = player.getActionHandler();
        this.player = player;
    }

    public static void show() {
        SelectActionRadialScreen.show(ModKeys.ACTION);
    }

    public static void show(KeyMapping keyMapping) {
        IPlayableFaction<?> faction = VampirismPlayerAttributes.get((Player)Minecraft.m_91087_().f_91074_).faction;
        if (faction != null) {
            faction.getPlayerCapability((Player)Minecraft.m_91087_().f_91074_).ifPresent(player -> {
                List<IAction<?>> actions = ClientConfigHelper.getActionOrder(player.getFaction()).stream().filter(f -> player.getActionHandler().isActionUnlocked(f)).collect(Collectors.toList());
                if (!actions.isEmpty()) {
                    Minecraft.m_91087_().m_91152_(new SelectActionRadialScreen<IFactionPlayer>((IFactionPlayer)player, actions, keyMapping));
                } else {
                    Minecraft.m_91087_().f_91074_.m_5661_((Component)Component.m_237115_((String)"text.vampirism.no_actions"), true);
                    Minecraft.m_91087_().m_91152_(null);
                }
            });
        }
    }

    private static RadialMenu<IAction<?>> getRadialMenu(List<IAction<?>> actions) {
        List parts = actions.stream().map(a -> new RadialMenuSlot<IAction>(a.getName(), (IAction)a, Collections.emptyList())).toList();
        return new RadialMenu(i -> VampirismMod.dispatcher.sendToServer(ServerboundToggleActionPacket.createFromRaytrace(RegUtil.id((IAction)((IRadialMenuSlot)parts.get(i)).primarySlotIcon()), Minecraft.m_91087_().f_91077_)), parts, SelectActionRadialScreen::drawActionPart, 0);
    }

    private static void drawActionPart(IAction<?> action, GuiGraphics graphics, int posX, int posY, int size, boolean transparent) {
        ResourceLocation id = RegUtil.id(action);
        ResourceLocation texture = new ResourceLocation(id.m_135827_(), "textures/actions/" + id.m_135815_() + ".png");
        graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        graphics.m_280398_(texture, posX, posY, 0, 0.0f, 0.0f, 16, 16, 16, 16);
    }

    @Override
    public void drawSlice(IRadialMenuSlot<IAction<?>> slot, boolean highlighted, GuiGraphics buffer, float x, float y, float z, float radiusIn, float radiusOut, float startAngle, float endAngle, int r, int g, int b, int a) {
        float actionPercentage = this.actionHandler.getPercentageForAction(slot.primarySlotIcon());
        if (slot.primarySlotIcon().canUse(this.player) != IAction.PERM.ALLOWED) {
            actionPercentage = -1.0f;
        }
        if (actionPercentage == 0.0f) {
            super.drawSlice(slot, highlighted, buffer, x, y, z, radiusIn, radiusOut, startAngle, endAngle, r, g, b, 100);
        } else if (actionPercentage > 0.0f) {
            int color = highlighted ? 200 : 160;
            super.drawSlice(slot, true, buffer, x, y, z, radiusIn, radiusOut, startAngle, endAngle, color, color, 60, 100);
            super.drawSlice(slot, true, buffer, x, y, z, radiusIn, radiusIn + (radiusOut - radiusIn) * actionPercentage, startAngle, endAngle, color, color, 60, 100);
        } else {
            int color = highlighted ? 200 : 160;
            super.drawSlice(slot, true, buffer, x, y, z, radiusIn, radiusOut, startAngle, endAngle, color, 60, 60, 100);
            super.drawSlice(slot, true, buffer, x, y, z, radiusIn, radiusIn + (radiusOut - radiusIn) * -actionPercentage, startAngle, endAngle, color, 60, 60, 100);
        }
    }
}

