/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.gui.screens;

import de.teamlapen.lib.lib.client.gui.components.HoverList;
import de.teamlapen.lib.util.Color;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.client.gui.screens.AppearanceScreen;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.player.VampirismPlayerAttributes;
import de.teamlapen.vampirism.entity.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.entity.player.vampire.VampirePlayerSpecialAttributes;
import de.teamlapen.vampirism.network.ServerboundAppearancePacket;
import java.util.stream.IntStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.widget.ExtendedButton;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class VampirePlayerAppearanceScreen
extends AppearanceScreen<Player> {
    private static final Component NAME = Component.m_237115_((String)"gui.vampirism.appearance");
    private float[] color;
    private int fangType;
    private int eyeType;
    private boolean glowingEyes;
    private boolean titleGender;
    private HoverList<?> eyeList;
    private HoverList<?> fangList;
    private ExtendedButton eyeButton;
    private ExtendedButton fangButton;
    private Checkbox glowingEyesButton;
    private Checkbox titleGenderButton;

    public VampirePlayerAppearanceScreen(@Nullable Screen backScreen) {
        super(NAME, Minecraft.m_91087_().f_91074_, backScreen);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (!this.fangList.m_7979_(mouseX, mouseY, button, dragX, dragY) && !this.eyeList.m_7979_(mouseX, mouseY, button, dragX, dragY)) {
            return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
        }
        return true;
    }

    public void m_7861_() {
        VampirismMod.dispatcher.sendToServer(new ServerboundAppearancePacket(((Player)this.entity).m_19879_(), "", this.fangType, this.eyeType, this.glowingEyes ? 1 : 0, this.titleGender ? 1 : 0));
        super.m_7861_();
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        VampirismPlayerAttributes attributes = VampirismPlayerAttributes.get((Player)Minecraft.m_91087_().f_91074_);
        IPlayableFaction<?> f = attributes.faction;
        this.color = f == null ? Color.GRAY.getRGBColorComponents() : new Color(f.getColor()).getRGBColorComponents();
        VampirePlayerSpecialAttributes vampAtt = attributes.getVampSpecial();
        this.fangType = vampAtt.fangType;
        this.eyeType = vampAtt.eyeType;
        this.glowingEyes = vampAtt.glowingEyes;
        this.titleGender = FactionPlayerHandler.getOpt((Player)Minecraft.m_91087_().f_91074_).map(FactionPlayerHandler::useFemaleLordTitle).orElse(false);
        this.titleGenderButton = (Checkbox)this.m_142416_((GuiEventListener)new Checkbox(this.guiLeft + 20, this.guiTop + 91, 99, 20, (Component)Component.m_237115_((String)"gui.vampirism.appearance.title_gender"), this.titleGender){

            public void m_5691_() {
                super.m_5691_();
                VampirePlayerAppearanceScreen.this.titleGender = this.m_93840_();
                FactionPlayerHandler.getOpt((Player)VampirePlayerAppearanceScreen.this.entity).ifPresent(p -> p.setTitleGender(VampirePlayerAppearanceScreen.this.titleGender));
            }
        });
        this.glowingEyesButton = (Checkbox)this.m_142416_((GuiEventListener)new Checkbox(this.guiLeft + 20, this.guiTop + 70, 99, 20, (Component)Component.m_237115_((String)"gui.vampirism.appearance.glowing_eye"), this.glowingEyes){

            public void m_5691_() {
                super.m_5691_();
                VampirePlayerAppearanceScreen.this.glowingEyes = this.m_93840_();
                VampirePlayer.getOpt((Player)VampirePlayerAppearanceScreen.this.entity).ifPresent(p -> p.setGlowingEyes(VampirePlayerAppearanceScreen.this.glowingEyes));
            }
        });
        this.fangList = (HoverList)this.m_142416_((GuiEventListener)HoverList.builder(this.guiLeft + 20, this.guiTop + 50 + 19, 99, 80).componentsWithClickAndHover(IntStream.range(0, 7).mapToObj(type -> Component.m_237115_((String)"gui.vampirism.appearance.fang").m_130946_(" " + (type + 1))).toList(), this::fang, this::hoverFang).build());
        this.fangButton = (ExtendedButton)this.m_142416_((GuiEventListener)new ExtendedButton(this.fangList.getLeft(), this.fangList.getTop() - 20, this.fangList.getWidth(), 20, (Component)Component.m_237113_((String)""), b -> this.setFangListVisibility(!this.fangList.isVisible)));
        this.eyeList = (HoverList)this.m_142416_((GuiEventListener)HoverList.builder(this.guiLeft + 20, this.guiTop + 30 + 19, 99, 100).componentsWithClickAndHover(IntStream.range(0, 16).mapToObj(type -> Component.m_237115_((String)"gui.vampirism.appearance.eye").m_130946_(" " + (type + 1))).toList(), this::eye, this::hoverEye).build());
        this.eyeButton = (ExtendedButton)this.m_142416_((GuiEventListener)new ExtendedButton(this.eyeList.getLeft(), this.eyeList.getTop() - 20, this.eyeList.getWidth(), 20, (Component)Component.m_237113_((String)""), b -> this.setEyeListVisibility(!this.eyeList.isVisible)));
        this.setEyeListVisibility(false);
        this.setFangListVisibility(false);
    }

    @Override
    protected void renderGuiBackground(@NotNull GuiGraphics graphics) {
        graphics.m_280246_(this.color[0], this.color[1], this.color[2], 1.0f);
        super.renderGuiBackground(graphics);
        graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
    }

    private void eye(int eyeType) {
        VampirePlayer.getOpt((Player)this.f_96541_.f_91074_).ifPresent(vampire -> {
            this.eyeType = eyeType;
            vampire.setEyeType(this.eyeType);
            this.setEyeListVisibility(false);
        });
    }

    private void fang(int fangType) {
        VampirePlayer.getOpt((Player)this.f_96541_.f_91074_).ifPresent(vampire -> {
            this.fangType = fangType;
            vampire.setFangType(this.fangType);
            this.setFangListVisibility(false);
        });
    }

    private void hoverEye(int eyeType, boolean hovered) {
        VampirePlayer.getOpt((Player)this.f_96541_.f_91074_).ifPresent(vampire -> {
            if (hovered) {
                vampire.setEyeType(eyeType);
            } else if (vampire.getEyeType() == eyeType) {
                vampire.setEyeType(this.eyeType);
            }
        });
    }

    private void hoverFang(int fangType, boolean hovered) {
        VampirePlayer.getOpt((Player)this.f_96541_.f_91074_).ifPresent(vampire -> {
            if (hovered) {
                vampire.setFangType(fangType);
            } else if (vampire.getFangType() == fangType) {
                vampire.setFangType(this.fangType);
            }
        });
    }

    private void setEyeListVisibility(boolean show) {
        this.eyeButton.m_93666_((Component)Component.m_237115_((String)"gui.vampirism.appearance.eye").m_130946_(" " + (this.eyeType + 1)));
        this.eyeList.isVisible = show;
        this.fangButton.f_93624_ = !show;
        this.glowingEyesButton.f_93624_ = !show;
        boolean bl = this.titleGenderButton.f_93624_ = !show;
        if (show) {
            this.fangList.isVisible = false;
        }
    }

    private void setFangListVisibility(boolean show) {
        this.fangButton.m_93666_((Component)Component.m_237115_((String)"gui.vampirism.appearance.fang").m_130946_(" " + (this.fangType + 1)));
        this.fangList.isVisible = show;
        this.glowingEyesButton.f_93624_ = !show;
        boolean bl = this.titleGenderButton.f_93624_ = !show;
        if (show) {
            this.eyeList.isVisible = false;
        }
    }
}

