/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import de.teamlapen.vampirism.entity.vampire.VampireBaronEntity;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import org.jetbrains.annotations.NotNull;

public class BaronessModel
extends AgeableListModel<VampireBaronEntity>
implements HeadedModel,
ArmedModel {
    private static final String BODY = "body";
    private static final String HEAD_OVERLAY = "head_overlay";
    private static final String LEG_RIGHT_OVERLAY = "leg_right_overlay";
    private static final String LEG_LEFT_OVERLAY = "leg_left_overlay";
    private static final String ARM_RIGHT_OVERLAY = "arm_right_overlay";
    private static final String ARM_LEFT_OVERLAY = "arm_left_overlay";
    private static final String BODY_OVERLAY = "body_overlay";
    private static final String HEAD = "head";
    private static final String ARM_RIGHT = "arm_right";
    private static final String ARM_LEFT = "arm_left";
    private static final String LEG_RIGHT = "leg_right";
    private static final String LEG_LEFT = "leg_left";
    private static final String CLAWS_RIGHT = "claws_right";
    private static final String CLAWS_LEFT = "claws_left";
    @NotNull
    public final ModelPart body;
    @NotNull
    public final ModelPart headOverlay;
    @NotNull
    public final ModelPart legRightOverlay;
    @NotNull
    public final ModelPart legLeftOverlay;
    @NotNull
    public final ModelPart armRightOverlay;
    @NotNull
    public final ModelPart bodyOverlay;
    @NotNull
    public final ModelPart armLeftOverlay;
    @NotNull
    public final ModelPart head;
    @NotNull
    public final ModelPart armRight;
    @NotNull
    public final ModelPart armLeft;
    @NotNull
    public final ModelPart legRight;
    @NotNull
    public final ModelPart legLeft;
    @NotNull
    public final ModelPart clawsRight;
    @NotNull
    public final ModelPart clawsLeft;
    protected final HumanoidModel.ArmPose leftArmPose = HumanoidModel.ArmPose.EMPTY;
    protected final HumanoidModel.ArmPose rightArmPose = HumanoidModel.ArmPose.EMPTY;

    @NotNull
    public static LayerDefinition createLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition part = mesh.m_171576_();
        CubeDeformation DEFORM_OVERLAY = new CubeDeformation(0.2f);
        PartDefinition body = part.m_171599_(BODY, CubeListBuilder.m_171558_().m_171514_(16, 16).m_171481_(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f), PartPose.f_171404_);
        part.m_171599_(LEG_RIGHT_OVERLAY, CubeListBuilder.m_171558_().m_171514_(0, 32).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, DEFORM_OVERLAY), PartPose.m_171419_((float)-2.0f, (float)12.0f, (float)0.0f));
        part.m_171599_(ARM_LEFT_OVERLAY, CubeListBuilder.m_171558_().m_171514_(48, 48).m_171488_(0.0f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, DEFORM_OVERLAY), PartPose.m_171419_((float)4.0f, (float)2.0f, (float)0.0f));
        body.m_171599_(LEG_LEFT, CubeListBuilder.m_171558_().m_171514_(16, 48).m_171481_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.m_171419_((float)2.0f, (float)12.0f, (float)0.0f));
        part.m_171599_(HEAD_OVERLAY, CubeListBuilder.m_171558_().m_171514_(32, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.5f)), PartPose.f_171404_);
        PartDefinition armLeft = body.m_171599_(ARM_LEFT, CubeListBuilder.m_171558_().m_171514_(32, 48).m_171481_(0.0f, -1.5f, -2.0f, 3.0f, 12.0f, 4.0f), PartPose.m_171419_((float)4.0f, (float)2.0f, (float)0.0f));
        armLeft.m_171599_(CLAWS_LEFT, CubeListBuilder.m_171558_().m_171514_(24, 0).m_171481_(-4.0f, 0.0f, -2.0f, 3.0f, 3.0f, 4.0f), PartPose.f_171404_);
        body.m_171599_(HEAD, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f), PartPose.f_171404_);
        PartDefinition armRight = body.m_171599_(ARM_RIGHT, CubeListBuilder.m_171558_().m_171514_(40, 16).m_171481_(-3.0f, -1.5f, -2.0f, 3.0f, 12.0f, 4.0f), PartPose.m_171419_((float)-4.0f, (float)2.0f, (float)0.0f));
        armRight.m_171599_(CLAWS_RIGHT, CubeListBuilder.m_171558_().m_171514_(24, 0).m_171481_(1.0f, -1.0f, -2.0f, 3.0f, 3.0f, 4.0f), PartPose.f_171404_);
        part.m_171599_(LEG_LEFT_OVERLAY, CubeListBuilder.m_171558_().m_171514_(0, 48).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, DEFORM_OVERLAY), PartPose.m_171419_((float)2.0f, (float)12.0f, (float)0.0f));
        part.m_171599_(ARM_RIGHT_OVERLAY, CubeListBuilder.m_171558_().m_171514_(40, 32).m_171488_(-3.0f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, DEFORM_OVERLAY), PartPose.m_171419_((float)-4.0f, (float)2.0f, (float)0.0f));
        part.m_171599_(BODY_OVERLAY, CubeListBuilder.m_171558_().m_171514_(16, 32).m_171488_(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, DEFORM_OVERLAY), PartPose.f_171404_);
        body.m_171599_(LEG_RIGHT, CubeListBuilder.m_171558_().m_171514_(0, 16).m_171481_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.m_171419_((float)-2.0f, (float)12.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)64, (int)64);
    }

    public BaronessModel(@NotNull ModelPart part) {
        this.body = part.m_171324_(BODY);
        this.headOverlay = part.m_171324_(HEAD_OVERLAY);
        this.legRightOverlay = part.m_171324_(LEG_RIGHT_OVERLAY);
        this.legLeftOverlay = part.m_171324_(LEG_LEFT_OVERLAY);
        this.armRightOverlay = part.m_171324_(ARM_RIGHT_OVERLAY);
        this.armLeftOverlay = part.m_171324_(ARM_LEFT_OVERLAY);
        this.bodyOverlay = part.m_171324_(BODY_OVERLAY);
        this.head = this.body.m_171324_(HEAD);
        this.armRight = this.body.m_171324_(ARM_RIGHT);
        this.armLeft = this.body.m_171324_(ARM_LEFT);
        this.legRight = this.body.m_171324_(LEG_RIGHT);
        this.legLeft = this.body.m_171324_(LEG_LEFT);
        this.clawsLeft = this.armLeft.m_171324_(CLAWS_LEFT);
        this.clawsRight = this.armRight.m_171324_(CLAWS_RIGHT);
    }

    @NotNull
    public ModelPart m_5585_() {
        return this.head;
    }

    public void setupAnim(@NotNull VampireBaronEntity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.body.f_104204_ = 0.0f;
        this.armRight.f_104202_ = 0.0f;
        this.armRight.f_104200_ = -4.0f;
        this.armLeft.f_104202_ = 0.0f;
        this.armLeft.f_104200_ = 4.0f;
        this.armRight.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 2.0f * limbSwingAmount * 0.5f;
        this.armLeft.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 2.0f * limbSwingAmount * 0.5f;
        this.armRight.f_104205_ = 0.0f;
        this.armLeft.f_104205_ = 0.0f;
        this.legRight.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.legLeft.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.legRight.f_104204_ = 0.0f;
        this.legLeft.f_104204_ = 0.0f;
        this.legRight.f_104205_ = 0.0f;
        this.legLeft.f_104205_ = 0.0f;
        this.armRight.f_104204_ = 0.0f;
        this.armRight.f_104205_ = 0.0f;
        switch (this.leftArmPose) {
            case EMPTY: {
                this.armLeft.f_104204_ = 0.0f;
                break;
            }
            case BLOCK: {
                this.armLeft.f_104203_ = this.armLeft.f_104203_ * 0.5f - 0.9424779f;
                this.armLeft.f_104204_ = 0.5235988f;
                break;
            }
            case ITEM: {
                this.armLeft.f_104203_ = this.armLeft.f_104203_ * 0.5f - 0.31415927f;
                this.armLeft.f_104204_ = 0.0f;
            }
        }
        switch (this.rightArmPose) {
            case EMPTY: {
                this.armRight.f_104204_ = 0.0f;
                break;
            }
            case BLOCK: {
                this.armRight.f_104203_ = this.armRight.f_104203_ * 0.5f - 0.9424779f;
                this.armRight.f_104204_ = -0.5235988f;
                break;
            }
            case ITEM: {
                this.armRight.f_104203_ = this.armRight.f_104203_ * 0.5f - 0.31415927f;
                this.armRight.f_104204_ = 0.0f;
            }
        }
        if (this.f_102608_ > 0.0f) {
            HumanoidArm handside = this.getSwingingSide(entityIn);
            ModelPart ModelRenderer = this.getArmForSide(handside);
            float f1 = this.f_102608_;
            this.body.f_104204_ = Mth.m_14031_((float)(Mth.m_14116_((float)f1) * ((float)Math.PI * 2))) * 0.2f;
            if (handside == HumanoidArm.LEFT) {
                this.body.f_104204_ *= -1.0f;
            }
            this.armRight.f_104200_ = -Mth.m_14089_((float)this.body.f_104204_) * 4.0f;
            this.armLeft.f_104200_ = Mth.m_14089_((float)this.body.f_104204_) * 4.0f;
            this.armLeft.f_104203_ += this.body.f_104204_;
            f1 = 1.0f - this.f_102608_;
            f1 *= f1;
            f1 *= f1;
            f1 = 1.0f - f1;
            float f2 = Mth.m_14031_((float)(f1 * (float)Math.PI));
            float f3 = Mth.m_14031_((float)(this.f_102608_ * (float)Math.PI)) * -(this.head.f_104203_ - 0.7f) * 0.75f;
            ModelRenderer.f_104203_ = (float)((double)ModelRenderer.f_104203_ - ((double)f2 * 1.2 + (double)f3));
        }
        this.body.f_104203_ = 0.0f;
        this.legRight.f_104202_ = 0.1f;
        this.legLeft.f_104202_ = 0.1f;
        this.legRight.f_104201_ = 12.0f;
        this.legLeft.f_104201_ = 12.0f;
        this.head.f_104201_ = 0.0f;
        this.armRight.f_104203_ = (float)((double)this.armRight.f_104203_ + ((double)(Mth.m_14031_((float)(ageInTicks * 0.067f)) * 0.06f) - 0.03));
        this.armLeft.f_104203_ = (float)((double)this.armLeft.f_104203_ - ((double)(Mth.m_14031_((float)(ageInTicks * 0.067f)) * 0.06f) + 0.03));
        this.headOverlay.m_104315_(this.head);
        this.armLeftOverlay.m_104315_(this.armLeft);
        this.armRightOverlay.m_104315_(this.armRight);
        this.clawsLeft.m_104315_(this.armLeft);
        this.clawsLeft.f_104201_ = (float)((double)this.clawsLeft.f_104201_ + 8.5);
        this.clawsRight.m_104315_(this.armRight);
        this.clawsRight.f_104201_ = (float)((double)this.clawsRight.f_104201_ + 9.5);
    }

    public void m_6002_(@NotNull HumanoidArm sideIn, @NotNull PoseStack matrixStackIn) {
        this.getArmForSide(sideIn).m_104299_(matrixStackIn);
    }

    protected ModelPart getArmForSide(HumanoidArm side) {
        return side == HumanoidArm.LEFT ? this.armLeft : this.armRight;
    }

    @NotNull
    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.body, (Object)this.headOverlay, (Object)this.bodyOverlay, (Object)this.armLeftOverlay, (Object)this.armRightOverlay, (Object)this.legLeftOverlay, (Object)this.legRightOverlay);
    }

    @NotNull
    protected HumanoidArm getSwingingSide(@NotNull VampireBaronEntity entity) {
        HumanoidArm handside = entity.m_5737_();
        return entity.f_20912_ == InteractionHand.MAIN_HAND ? handside : handside.m_20828_();
    }

    @NotNull
    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of((Object)this.head);
    }
}

