/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import de.teamlapen.vampirism.client.core.ModEntitiesRender;
import de.teamlapen.vampirism.client.model.WingModel;
import de.teamlapen.vampirism.entity.vampire.VampireBaronEntity;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;

public class WingsLayer<T extends LivingEntity, Q extends EntityModel<T>>
extends RenderLayer<T, Q> {
    @NotNull
    private final WingModel<T> model;
    private final Predicate<T> predicateRender;
    private final BiFunction<T, Q, ModelPart> bodyPartFunction;
    private final ResourceLocation texture = new ResourceLocation("vampirism", "textures/entity/wings.png");

    public WingsLayer(@NotNull RenderLayerParent<T, Q> entityRendererIn, @NotNull EntityModelSet modelSet, Predicate<T> predicateRender, BiFunction<T, Q, ModelPart> bodyPartFunction) {
        super(entityRendererIn);
        this.model = new WingModel(modelSet.m_171103_(ModEntitiesRender.WING));
        this.predicateRender = predicateRender;
        this.bodyPartFunction = bodyPartFunction;
    }

    public void render(@NotNull PoseStack stack, @NotNull MultiBufferSource buffer, int packedLight, @NotNull T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!entity.m_20145_() && this.predicateRender.test(entity)) {
            this.model.copyRotationFromBody(this.bodyPartFunction.apply(entity, this.m_117386_()));
            float s = 1.0f;
            if (entity instanceof VampireBaronEntity) {
                s = ((VampireBaronEntity)entity).getEnragedProgress();
            }
            stack.m_85836_();
            stack.m_252880_(0.0f, 0.0f, 0.02f);
            stack.m_85841_(s, s, s);
            WingsLayer.m_117359_((EntityModel)this.m_117386_(), this.model, (ResourceLocation)this.texture, (PoseStack)stack, (MultiBufferSource)buffer, (int)packedLight, entity, (float)limbSwing, (float)limbSwingAmount, (float)ageInTicks, (float)netHeadYaw, (float)headPitch, (float)partialTicks, (float)1.0f, (float)1.0f, (float)1.0f);
            stack.m_85849_();
        }
    }
}

