/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.command.arguments;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class BiomeArgument
implements ArgumentType<ResourceLocation> {
    public static final DynamicCommandExceptionType BIOME_UNKNOWN_TYPE = new DynamicCommandExceptionType(id -> Component.m_237110_((String)"command.vampirism.biome.not_found", (Object[])new Object[]{id}));

    @NotNull
    public static BiomeArgument biome() {
        return new BiomeArgument();
    }

    public static ResourceLocation getBiomeId(@NotNull CommandContext<CommandSourceStack> context, String name) throws CommandSyntaxException {
        return BiomeArgument.checkIfEntityExists((ResourceLocation)context.getArgument(name, ResourceLocation.class));
    }

    private static ResourceLocation checkIfEntityExists(ResourceLocation id) throws CommandSyntaxException {
        if (ForgeRegistries.BIOMES.getValue(id) == null) {
            throw BIOME_UNKNOWN_TYPE.create((Object)id);
        }
        return id;
    }

    @NotNull
    public ResourceLocation parse(@NotNull StringReader reader) throws CommandSyntaxException {
        return BiomeArgument.checkIfEntityExists(ResourceLocation.m_135818_((StringReader)reader));
    }
}

