/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.core;

import de.teamlapen.vampirism.api.VampirismRegistries;
import de.teamlapen.vampirism.api.entity.player.refinement.IRefinement;
import de.teamlapen.vampirism.api.entity.player.refinement.IRefinementSet;
import de.teamlapen.vampirism.api.items.IRefinementItem;
import de.teamlapen.vampirism.core.ModRefinements;
import de.teamlapen.vampirism.entity.player.refinements.RefinementSet;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public class ModRefinementSets {
    public static final DeferredRegister<IRefinementSet> REFINEMENT_SETS = DeferredRegister.create(VampirismRegistries.REFINEMENT_SET_ID, (String)"vampirism");

    public static void register(IEventBus bus) {
        REFINEMENT_SETS.register(bus);
    }

    @SafeVarargs
    @NotNull
    private static IRefinementSet commonV(RegistryObject<? extends IRefinement> ... refinements) {
        return ModRefinementSets.vampire(IRefinementSet.Rarity.COMMON, refinements);
    }

    @SafeVarargs
    @NotNull
    private static IRefinementSet uncommonV(RegistryObject<? extends IRefinement> ... refinements) {
        return ModRefinementSets.vampire(IRefinementSet.Rarity.UNCOMMON, refinements);
    }

    @SafeVarargs
    @NotNull
    private static IRefinementSet rareV(RegistryObject<? extends IRefinement> ... refinements) {
        return ModRefinementSets.vampire(IRefinementSet.Rarity.RARE, refinements);
    }

    @SafeVarargs
    @NotNull
    private static IRefinementSet epicV(RegistryObject<? extends IRefinement> ... refinements) {
        return ModRefinementSets.vampire(IRefinementSet.Rarity.EPIC, refinements);
    }

    @SafeVarargs
    @NotNull
    private static RefinementSet vampire(@NotNull IRefinementSet.Rarity rarity, RegistryObject<? extends IRefinement> ... refinements) {
        return new RefinementSet.VampireRefinementSet(rarity, (int)rarity.color.m_126665_(), refinements);
    }

    static {
        REFINEMENT_SETS.register("armor1", () -> ModRefinementSets.commonV(ModRefinements.ARMOR1));
        REFINEMENT_SETS.register("health1", () -> ModRefinementSets.commonV(ModRefinements.HEALTH1));
        REFINEMENT_SETS.register("speed1", () -> ModRefinementSets.commonV(ModRefinements.SPEED1));
        REFINEMENT_SETS.register("attack_speed1", () -> ModRefinementSets.commonV(ModRefinements.ATTACK_SPEED1));
        REFINEMENT_SETS.register("damage1", () -> ModRefinementSets.commonV(ModRefinements.DAMAGE1));
        REFINEMENT_SETS.register("damage1_attack_speed1_n_armor2", () -> ModRefinementSets.commonV(ModRefinements.DAMAGE1, ModRefinements.ATTACK_SPEED1, ModRefinements.N_ARMOR2));
        REFINEMENT_SETS.register("armor1_health1_n_attack_speed2", () -> ModRefinementSets.commonV(ModRefinements.ARMOR1, ModRefinements.HEALTH1, ModRefinements.N_ATTACK_SPEED2));
        REFINEMENT_SETS.register("regeneration", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.COMMON, 15580939, ModRefinements.REGENERATION));
        REFINEMENT_SETS.register("sword_trained_amount", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.COMMON, 15547147, ModRefinements.SWORD_TRAINED_AMOUNT));
        REFINEMENT_SETS.register("blood_charge_speed", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.COMMON, 15541515, ModRefinements.BLOOD_CHARGE_SPEED));
        REFINEMENT_SETS.register("freeze_duration", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.COMMON, 778221, ModRefinements.FREEZE_DURATION));
        REFINEMENT_SETS.register("sword_finisher", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.COMMON, 13697286, ModRefinements.SWORD_FINISHER));
        REFINEMENT_SETS.register("regeneration_buffed", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.COMMON, 15580939, ModRefinements.REGENERATION, ModRefinements.SPEED1));
        REFINEMENT_SETS.register("sword_trained_amount_buffed", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.COMMON, 15547147, ModRefinements.SWORD_TRAINED_AMOUNT, ModRefinements.DAMAGE1));
        REFINEMENT_SETS.register("blood_charge_speed_buffed", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.COMMON, 15541515, ModRefinements.BLOOD_CHARGE_SPEED, ModRefinements.ATTACK_SPEED1));
        REFINEMENT_SETS.register("freeze_duration_buffed", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.COMMON, 778221, ModRefinements.FREEZE_DURATION, ModRefinements.HEALTH1));
        REFINEMENT_SETS.register("sword_finisher_buffed", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.COMMON, 13697286, ModRefinements.SWORD_FINISHER, ModRefinements.ARMOR1));
        REFINEMENT_SETS.register("regeneration_debuffed", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.COMMON, 15580939, ModRefinements.REGENERATION, ModRefinements.N_SPEED1));
        REFINEMENT_SETS.register("sword_trained_amount_debuffed", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.COMMON, 15547147, ModRefinements.SWORD_TRAINED_AMOUNT, ModRefinements.N_DAMAGE1));
        REFINEMENT_SETS.register("blood_charge_speed_debuffed", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.COMMON, 15541515, ModRefinements.BLOOD_CHARGE_SPEED, ModRefinements.N_ATTACK_SPEED1));
        REFINEMENT_SETS.register("freeze_duration_debuffed", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.COMMON, 778221, ModRefinements.FREEZE_DURATION, ModRefinements.N_HEALTH1));
        REFINEMENT_SETS.register("sword_finisher_debuffed", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.COMMON, 13697286, ModRefinements.SWORD_FINISHER, ModRefinements.N_ARMOR1));
        REFINEMENT_SETS.register("armor2_n_health2", () -> ModRefinementSets.uncommonV(ModRefinements.ARMOR2, ModRefinements.N_HEALTH2));
        REFINEMENT_SETS.register("health2_n_damage1", () -> ModRefinementSets.uncommonV(ModRefinements.HEALTH2, ModRefinements.N_DAMAGE1));
        REFINEMENT_SETS.register("attack_speed2_n_armor1", () -> ModRefinementSets.uncommonV(ModRefinements.ATTACK_SPEED2, ModRefinements.N_ARMOR1));
        REFINEMENT_SETS.register("damage2_n_speed1", () -> ModRefinementSets.uncommonV(ModRefinements.DAMAGE2, ModRefinements.N_SPEED1));
        REFINEMENT_SETS.register("speed2_n_damage1", () -> ModRefinementSets.uncommonV(ModRefinements.SPEED2, ModRefinements.N_DAMAGE1));
        REFINEMENT_SETS.register("armor3_n_health3", () -> ModRefinementSets.uncommonV(ModRefinements.ARMOR3, ModRefinements.N_HEALTH3));
        REFINEMENT_SETS.register("health3_n_damage2", () -> ModRefinementSets.uncommonV(ModRefinements.HEALTH3, ModRefinements.N_DAMAGE2));
        REFINEMENT_SETS.register("attack_speed3_n_armor2", () -> ModRefinementSets.uncommonV(ModRefinements.ATTACK_SPEED3, ModRefinements.N_ARMOR2));
        REFINEMENT_SETS.register("damage3_n_speed2", () -> ModRefinementSets.uncommonV(ModRefinements.DAMAGE3, ModRefinements.N_SPEED3));
        REFINEMENT_SETS.register("speed3_n_damage2", () -> ModRefinementSets.uncommonV(ModRefinements.SPEED3, ModRefinements.N_DAMAGE2));
        REFINEMENT_SETS.register("vista", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.UNCOMMON, 765933, ModRefinements.VISTA));
        REFINEMENT_SETS.register("teleport_distance", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.UNCOMMON, 427861, ModRefinements.TELEPORT_DISTANCE));
        REFINEMENT_SETS.register("dark_blood_projectile_damage", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.UNCOMMON, 14877695, ModRefinements.DARK_BLOOD_PROJECTILE_DAMAGE));
        REFINEMENT_SETS.register("dark_blood_projectile_penetration", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.UNCOMMON, 14877695, ModRefinements.DARK_BLOOD_PROJECTILE_PENETRATION).onlyFor(IRefinementItem.AccessorySlotType.RING));
        REFINEMENT_SETS.register("dark_blood_projectile_multi_shot", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.UNCOMMON, 14877695, ModRefinements.DARK_BLOOD_PROJECTILE_MULTI_SHOT).onlyFor(IRefinementItem.AccessorySlotType.RING));
        REFINEMENT_SETS.register("vista_buffed", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.UNCOMMON, 765933, ModRefinements.VISTA, ModRefinements.SPEED1));
        REFINEMENT_SETS.register("teleport_distance_buffed", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.UNCOMMON, 427861, ModRefinements.TELEPORT_DISTANCE, ModRefinements.SPEED1));
        REFINEMENT_SETS.register("dark_blood_projectile_damage_buffed", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.UNCOMMON, 14877695, ModRefinements.DARK_BLOOD_PROJECTILE_DAMAGE, ModRefinements.DAMAGE1));
        REFINEMENT_SETS.register("dark_blood_projectile_penetration_buffed", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.UNCOMMON, 14877695, ModRefinements.DARK_BLOOD_PROJECTILE_PENETRATION, ModRefinements.ATTACK_SPEED1).onlyFor(IRefinementItem.AccessorySlotType.RING));
        REFINEMENT_SETS.register("dark_blood_projectile_multi_shot_buffed", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.UNCOMMON, 14877695, ModRefinements.DARK_BLOOD_PROJECTILE_MULTI_SHOT, ModRefinements.ATTACK_SPEED1).onlyFor(IRefinementItem.AccessorySlotType.RING));
        REFINEMENT_SETS.register("vista_debuffed", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.UNCOMMON, 765933, ModRefinements.VISTA, ModRefinements.N_SPEED1));
        REFINEMENT_SETS.register("teleport_distance_debuffed", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.UNCOMMON, 427861, ModRefinements.TELEPORT_DISTANCE, ModRefinements.N_SPEED1));
        REFINEMENT_SETS.register("dark_blood_projectile_damage_debuffed", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.UNCOMMON, 14877695, ModRefinements.DARK_BLOOD_PROJECTILE_DAMAGE, ModRefinements.N_DAMAGE1));
        REFINEMENT_SETS.register("dark_blood_projectile_penetration_debuffed", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.UNCOMMON, 14877695, ModRefinements.DARK_BLOOD_PROJECTILE_PENETRATION, ModRefinements.N_ATTACK_SPEED1).onlyFor(IRefinementItem.AccessorySlotType.RING));
        REFINEMENT_SETS.register("dark_blood_projectile_multi_shot_debuffed", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.UNCOMMON, 14877695, ModRefinements.DARK_BLOOD_PROJECTILE_MULTI_SHOT, ModRefinements.N_ATTACK_SPEED1).onlyFor(IRefinementItem.AccessorySlotType.RING));
        REFINEMENT_SETS.register("armor3_n_health2", () -> ModRefinementSets.rareV(ModRefinements.ARMOR3, ModRefinements.N_HEALTH2));
        REFINEMENT_SETS.register("health3_n_armor1", () -> ModRefinementSets.rareV(ModRefinements.HEALTH3, ModRefinements.N_ARMOR1));
        REFINEMENT_SETS.register("attack_speed3_n_speed1", () -> ModRefinementSets.rareV(ModRefinements.ATTACK_SPEED3, ModRefinements.N_SPEED1));
        REFINEMENT_SETS.register("speed1_armor1_health1", () -> ModRefinementSets.rareV(ModRefinements.SPEED1, ModRefinements.ARMOR1, ModRefinements.HEALTH1));
        REFINEMENT_SETS.register("damage3_n_armor1", () -> ModRefinementSets.rareV(ModRefinements.DAMAGE3, ModRefinements.N_ARMOR2));
        REFINEMENT_SETS.register("speed3_n_attack_speed1", () -> ModRefinementSets.rareV(ModRefinements.SPEED3, ModRefinements.N_ATTACK_SPEED1));
        REFINEMENT_SETS.register("damage1_attack_speed1", () -> ModRefinementSets.rareV(ModRefinements.DAMAGE1, ModRefinements.ATTACK_SPEED1));
        REFINEMENT_SETS.register("half_invulnerable", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.RARE, 11103671, ModRefinements.HALF_INVULNERABLE));
        REFINEMENT_SETS.register("summon_bats", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.RARE, 9144977, ModRefinements.SUMMON_BATS));
        REFINEMENT_SETS.register("sun_screen", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.RARE, 15581707, ModRefinements.SUN_SCREEN));
        REFINEMENT_SETS.register("dark_blood_projectile_speed", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.RARE, 15641549, ModRefinements.DARK_BLOOD_PROJECTILE_SPEED));
        REFINEMENT_SETS.register("half_invulnerable_debuffed", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.RARE, 11103671, ModRefinements.HALF_INVULNERABLE, ModRefinements.N_ARMOR1));
        REFINEMENT_SETS.register("summon_bats_debuffed", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.RARE, 9144977, ModRefinements.SUMMON_BATS, ModRefinements.N_HEALTH1));
        REFINEMENT_SETS.register("sun_screen_debuffed", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.RARE, 15581707, ModRefinements.SUN_SCREEN, ModRefinements.N_ARMOR1));
        REFINEMENT_SETS.register("crucifix_resistant", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.UNCOMMON, 8241873, ModRefinements.CRUCIFIX_RESISTANT));
        REFINEMENT_SETS.register("vampire_sword", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.EPIC, 15547147, ModRefinements.SWORD_TRAINED_AMOUNT, ModRefinements.BLOOD_CHARGE_SPEED));
        REFINEMENT_SETS.register("dark_blood_projectile", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.EPIC, 14877695, ModRefinements.DARK_BLOOD_PROJECTILE_PENETRATION, ModRefinements.DARK_BLOOD_PROJECTILE_MULTI_SHOT).onlyFor(IRefinementItem.AccessorySlotType.RING));
        REFINEMENT_SETS.register("rage_fury", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.EPIC, 12648962, ModRefinements.RAGE_FURY));
        REFINEMENT_SETS.register("summon_bats_buffed", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.EPIC, 9144977, ModRefinements.SUMMON_BATS, ModRefinements.HEALTH1));
        REFINEMENT_SETS.register("dark_blood_projectile_aoe", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.EPIC, 14877695, ModRefinements.DARK_BLOOD_PROJECTILE_AOE).onlyFor(IRefinementItem.AccessorySlotType.RING));
        REFINEMENT_SETS.register("half_invulnerable_buffed", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.EPIC, 11103671, ModRefinements.HALF_INVULNERABLE, ModRefinements.ARMOR1));
        REFINEMENT_SETS.register("sun_screen_buffed", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.EPIC, 15581707, ModRefinements.SUN_SCREEN, ModRefinements.ARMOR1));
        REFINEMENT_SETS.register("dark_blood_projectile_speed_buffed", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.EPIC, 15641453, ModRefinements.DARK_BLOOD_PROJECTILE_SPEED, ModRefinements.SPEED1));
        REFINEMENT_SETS.register("dark_blood_projectile_aoe_debuffed", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.EPIC, 14877695, ModRefinements.DARK_BLOOD_PROJECTILE_AOE, ModRefinements.N_HEALTH1).onlyFor(IRefinementItem.AccessorySlotType.RING));
        REFINEMENT_SETS.register("rage_fury_debuffed", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.EPIC, 12648962, ModRefinements.RAGE_FURY, ModRefinements.N_ARMOR1));
        REFINEMENT_SETS.register("crucifix_resistant_speed", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.EPIC, 8213969, ModRefinements.CRUCIFIX_RESISTANT, ModRefinements.ATTACK_SPEED1));
        REFINEMENT_SETS.register("crucifix_resistant_health", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.EPIC, 8213969, ModRefinements.CRUCIFIX_RESISTANT, ModRefinements.HEALTH2));
        REFINEMENT_SETS.register("dark_blood_projectile_aoe_buffed", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.LEGENDARY, 14877695, ModRefinements.DARK_BLOOD_PROJECTILE_AOE, ModRefinements.HEALTH1).onlyFor(IRefinementItem.AccessorySlotType.RING));
        REFINEMENT_SETS.register("rage_fury_buffed", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.LEGENDARY, 12648962, ModRefinements.RAGE_FURY, ModRefinements.ARMOR1));
        REFINEMENT_SETS.register("dark_blood_projectile_speed_double_buffed", () -> new RefinementSet.VampireRefinementSet(IRefinementSet.Rarity.LEGENDARY, 15620813, ModRefinements.DARK_BLOOD_PROJECTILE_SPEED, ModRefinements.SPEED3));
    }
}

