/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.data.provider;

import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.data.reloadlistener.ConvertiblesReloadListener;
import de.teamlapen.vampirism.entity.converted.ConvertedCowEntity;
import de.teamlapen.vampirism.entity.converted.ConvertedDonkeyEntity;
import de.teamlapen.vampirism.entity.converted.ConvertedFoxEntity;
import de.teamlapen.vampirism.entity.converted.ConvertedGoatEntity;
import de.teamlapen.vampirism.entity.converted.ConvertedHorseEntity;
import de.teamlapen.vampirism.entity.converted.ConvertedMuleEntity;
import de.teamlapen.vampirism.entity.converted.ConvertedSheepEntity;
import de.teamlapen.vampirism.entity.converted.ConvertedVillagerEntity;
import de.teamlapen.vampirism.entity.converted.converter.SpecialConverter;
import de.teamlapen.vampirism.util.RegUtil;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import org.jetbrains.annotations.NotNull;

public class ConvertiblesProvider
implements DataProvider {
    protected final PackOutput.PathProvider pathProvider;
    private final String modId;

    public ConvertiblesProvider(PackOutput packOutput, String modId) {
        this.pathProvider = packOutput.m_245269_(PackOutput.Target.DATA_PACK, "vampirism");
        this.modId = modId;
    }

    @NotNull
    public CompletableFuture<?> m_213708_(@NotNull CachedOutput pOutput) {
        HashMap entries = new HashMap();
        this.registerConvertibles((type, entry) -> {
            if (entries.containsKey(type)) {
                throw new IllegalStateException("Duplicate entry for " + type);
            }
            entries.put(type, entry);
        });
        return CompletableFuture.allOf((CompletableFuture[])entries.entrySet().stream().map(entry -> {
            ResourceLocation id = RegUtil.id((EntityType)entry.getKey());
            JsonElement jsonElement = (JsonElement)ConvertiblesReloadListener.EntityEntry.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)((ConvertiblesReloadListener.EntityEntry)entry.getValue())).getOrThrow(false, System.err::println);
            return DataProvider.m_253162_((CachedOutput)pOutput, (JsonElement)jsonElement, (Path)this.pathProvider.m_245731_(new ResourceLocation(this.modId, "convertibles/" + id.m_135827_() + "/" + id.m_135815_())));
        }).toArray(CompletableFuture[]::new));
    }

    private void registerConvertibles(BiConsumer<EntityType<? extends PathfinderMob>, ConvertiblesReloadListener.EntityEntry> consumer) {
        Function<String, ResourceLocation> overlay = name -> new ResourceLocation("vampirism", String.format("textures/entity/vanilla/%s_overlay.png", name));
        consumer.accept((EntityType<? extends PathfinderMob>)EntityType.f_20557_, new ConvertiblesReloadListener.EntityEntry(new SpecialConverter((Supplier<EntityType<ConvertedCowEntity>>)ModEntities.CONVERTED_COW), overlay.apply("cow")));
        consumer.accept((EntityType<? extends PathfinderMob>)EntityType.f_20466_, new ConvertiblesReloadListener.EntityEntry(overlay.apply("llama")));
        consumer.accept((EntityType<? extends PathfinderMob>)EntityType.f_20505_, new ConvertiblesReloadListener.EntityEntry(overlay.apply("cat")));
        consumer.accept((EntityType<? extends PathfinderMob>)EntityType.f_20507_, new ConvertiblesReloadListener.EntityEntry(overlay.apply("panda")));
        consumer.accept((EntityType<? extends PathfinderMob>)EntityType.f_20510_, new ConvertiblesReloadListener.EntityEntry(overlay.apply("pig")));
        consumer.accept((EntityType<? extends PathfinderMob>)EntityType.f_20514_, new ConvertiblesReloadListener.EntityEntry(overlay.apply("polarbear")));
        consumer.accept((EntityType<? extends PathfinderMob>)EntityType.f_20517_, new ConvertiblesReloadListener.EntityEntry(overlay.apply("rabbit")));
        consumer.accept((EntityType<? extends PathfinderMob>)EntityType.f_20520_, new ConvertiblesReloadListener.EntityEntry(new SpecialConverter((Supplier<EntityType<ConvertedSheepEntity>>)ModEntities.CONVERTED_SHEEP), overlay.apply("sheep")));
        consumer.accept((EntityType<? extends PathfinderMob>)EntityType.f_20492_, new ConvertiblesReloadListener.EntityEntry(new SpecialConverter((Supplier<EntityType<ConvertedVillagerEntity>>)ModEntities.VILLAGER_CONVERTED), overlay.apply("villager")));
        consumer.accept((EntityType<? extends PathfinderMob>)EntityType.f_20457_, new ConvertiblesReloadListener.EntityEntry(new SpecialConverter((Supplier<EntityType<ConvertedHorseEntity>>)ModEntities.CONVERTED_HORSE), overlay.apply("horse")));
        consumer.accept((EntityType<? extends PathfinderMob>)EntityType.f_20560_, new ConvertiblesReloadListener.EntityEntry(new SpecialConverter((Supplier<EntityType<ConvertedDonkeyEntity>>)ModEntities.CONVERTED_DONKEY), overlay.apply("horse")));
        consumer.accept((EntityType<? extends PathfinderMob>)EntityType.f_20503_, new ConvertiblesReloadListener.EntityEntry(new SpecialConverter((Supplier<EntityType<ConvertedMuleEntity>>)ModEntities.CONVERTED_MULE), overlay.apply("horse")));
        consumer.accept((EntityType<? extends PathfinderMob>)EntityType.f_20452_, new ConvertiblesReloadListener.EntityEntry(new SpecialConverter((Supplier<EntityType<ConvertedFoxEntity>>)ModEntities.CONVERTED_FOX), overlay.apply("fox")));
        consumer.accept((EntityType<? extends PathfinderMob>)EntityType.f_147035_, new ConvertiblesReloadListener.EntityEntry(new SpecialConverter((Supplier<EntityType<ConvertedGoatEntity>>)ModEntities.CONVERTED_GOAT), overlay.apply("goat")));
    }

    @NotNull
    public String m_6055_() {
        return "Vampirism Convertible Entities";
    }
}

