/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.data.recipebuilder;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.teamlapen.vampirism.advancements.critereon.SkillUnlockedCriterionTrigger;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.core.ModRecipes;
import de.teamlapen.vampirism.entity.player.hunter.skills.HunterSkills;
import de.teamlapen.vampirism.mixin.ShapedRecipeBuilderAccessor;
import de.teamlapen.vampirism.util.RegUtil;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShapedWeaponTableRecipeBuilder
extends ShapedRecipeBuilder {
    @Nullable
    private final JsonObject extraNbt;
    private int lava = 1;
    private ISkill<?>[] skills;
    private int level = 1;

    @NotNull
    public static ShapedWeaponTableRecipeBuilder shapedWeaponTable(@NotNull RecipeCategory category, @NotNull ItemLike item) {
        return new ShapedWeaponTableRecipeBuilder(category, item, 1, null);
    }

    @NotNull
    public static ShapedWeaponTableRecipeBuilder shapedWeaponTable(@NotNull RecipeCategory category, @NotNull ItemLike item, int count) {
        return new ShapedWeaponTableRecipeBuilder(category, item, count, null);
    }

    @NotNull
    public static ShapedWeaponTableRecipeBuilder shapedWeaponTable(@NotNull RecipeCategory category, @NotNull ItemLike item, int count, @NotNull JsonObject nbt) {
        return new ShapedWeaponTableRecipeBuilder(category, item, count, nbt);
    }

    public ShapedWeaponTableRecipeBuilder(@NotNull RecipeCategory category, @NotNull ItemLike item, int count, @Nullable JsonObject extraNbt) {
        super(category, item, count);
        this.extraNbt = extraNbt;
    }

    @NotNull
    public ShapedWeaponTableRecipeBuilder define(@NotNull Character symbol, @NotNull ItemLike itemIn) {
        return (ShapedWeaponTableRecipeBuilder)super.m_126127_(symbol, itemIn);
    }

    @NotNull
    public ShapedWeaponTableRecipeBuilder define(@NotNull Character symbol, @NotNull Ingredient ingredientIn) {
        return (ShapedWeaponTableRecipeBuilder)super.m_126124_(symbol, ingredientIn);
    }

    @NotNull
    public ShapedWeaponTableRecipeBuilder define(@NotNull Character symbol, @NotNull TagKey<Item> tagIn) {
        return (ShapedWeaponTableRecipeBuilder)super.m_206416_(symbol, tagIn);
    }

    @NotNull
    public ShapedWeaponTableRecipeBuilder group(@Nullable String groupIn) {
        return (ShapedWeaponTableRecipeBuilder)super.m_126145_(groupIn);
    }

    @NotNull
    public ShapedWeaponTableRecipeBuilder pattern(@NotNull String patternIn) {
        return (ShapedWeaponTableRecipeBuilder)super.m_126130_(patternIn);
    }

    @NotNull
    public ShapedWeaponTableRecipeBuilder showNotification(boolean p_273326_) {
        return (ShapedWeaponTableRecipeBuilder)super.m_271710_(p_273326_);
    }

    @NotNull
    public ShapedWeaponTableRecipeBuilder lava(int amount) {
        this.lava = amount;
        return this;
    }

    @NotNull
    public ShapedWeaponTableRecipeBuilder level(int level) {
        this.level = level;
        return this;
    }

    public void m_126140_(@NotNull Consumer<FinishedRecipe> consumer, @NotNull ResourceLocation id) {
        id = new ResourceLocation(id.m_135827_(), "weapontable/" + id.m_135815_());
        this.f_126110_.m_138386_("has_skill", (CriterionTriggerInstance)SkillUnlockedCriterionTrigger.builder(this.skills != null && this.skills.length >= 1 ? this.skills[0] : (ISkill<?>)HunterSkills.WEAPON_TABLE.get()));
        this.m_126143_(id);
        this.f_126110_.m_138396_(new ResourceLocation("recipes/root")).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)id)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)id)).m_138360_(RequirementsStrategy.f_15979_);
        consumer.accept((FinishedRecipe)new Result(id, this.f_126106_, this.f_126107_, this.f_126111_ == null ? "" : this.f_126111_, ShapedWeaponTableRecipeBuilder.m_245179_((RecipeCategory)((ShapedRecipeBuilderAccessor)((Object)this)).getRecipeCategory()), this.f_126108_, this.f_126109_, this.f_126110_, id.m_247449_("recipes/" + ((ShapedRecipeBuilderAccessor)((Object)this)).getRecipeCategory().m_247710_() + "/" + id.m_135815_()), this.lava, this.skills != null ? this.skills : new ISkill[]{}, this.level, this.extraNbt, ((ShapedRecipeBuilderAccessor)((Object)this)).getShowNotification()));
    }

    @NotNull
    public ShapedWeaponTableRecipeBuilder unlockedBy(@NotNull String name, @NotNull CriterionTriggerInstance criterionIn) {
        return (ShapedWeaponTableRecipeBuilder)super.m_126132_(name, criterionIn);
    }

    @NotNull
    public ShapedWeaponTableRecipeBuilder skills(ISkill<?> ... skills) {
        this.skills = skills;
        return this;
    }

    private static class Result
    extends ShapedRecipeBuilder.Result {
        private final int lava;
        private final ISkill<?>[] skills;
        private final int level;
        @Nullable
        private final JsonObject extraNbt;

        public Result(@NotNull ResourceLocation id, @NotNull Item item, int count, @NotNull String group, CraftingBookCategory category, @NotNull List<String> pattern, @NotNull Map<Character, Ingredient> ingredients, @NotNull Advancement.Builder advancementBuilder, @NotNull ResourceLocation advancementId, int lava, @NotNull ISkill<?>[] skills, int level, @Nullable JsonObject extraNbt, boolean showNotification) {
            super(id, item, count, group, category, pattern, ingredients, advancementBuilder, advancementId, showNotification);
            this.lava = lava;
            this.skills = skills;
            this.level = level;
            this.extraNbt = extraNbt;
        }

        @NotNull
        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)ModRecipes.SHAPED_CRAFTING_WEAPONTABLE.get();
        }

        public void m_7917_(@NotNull JsonObject jsonObject) {
            super.m_7917_(jsonObject);
            jsonObject.addProperty("lava", (Number)this.lava);
            JsonArray skills = new JsonArray();
            for (ISkill<?> skill : this.skills) {
                skills.add(RegUtil.id(skill).toString());
            }
            jsonObject.add("skill", (JsonElement)skills);
            jsonObject.addProperty("level", (Number)this.level);
            if (this.extraNbt != null) {
                jsonObject.get("result").getAsJsonObject().add("nbt", (JsonElement)this.extraNbt);
            }
        }
    }
}

