/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.data.reloadlistener;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.convertible.Converter;
import de.teamlapen.vampirism.config.BalanceMobProps;
import de.teamlapen.vampirism.data.reloadlistener.bloodvalues.BloodValueBuilder;
import de.teamlapen.vampirism.data.reloadlistener.bloodvalues.BloodValueReader;
import de.teamlapen.vampirism.entity.converted.VampirismEntityRegistry;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.valueproviders.ConstantFloat;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConvertiblesReloadListener {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new Gson();
    private static final String PATH_SUFFIX = ".json";
    private static final int PATH_SUFFIX_LENGTH = ".json".length();
    private static final String DIRECTORY = "vampirism/convertibles";
    private final BloodValueReader bloodValueReader;

    public ConvertiblesReloadListener(BloodValueReader bloodValueReader) {
        this.bloodValueReader = bloodValueReader;
    }

    @NotNull
    public CompletableFuture<Pair<Map<EntityType<? extends PathfinderMob>, EntityEntry>, Map<String, BloodValueBuilder>>> prepare(@NotNull ResourceManager manager, Executor executor) {
        CompletableFuture<Map> convertibles = CompletableFuture.supplyAsync(() -> this.load(manager), executor);
        CompletableFuture<Map<String, BloodValueBuilder>> bloodValues = this.bloodValueReader.prepare(manager, executor);
        return convertibles.thenCombine(bloodValues, Pair::of);
    }

    public void apply(Pair<Map<EntityType<? extends PathfinderMob>, EntityEntry>, Map<String, BloodValueBuilder>> entries) {
        ((VampirismEntityRegistry)VampirismAPI.entityRegistry()).applyDataConvertibles((Map)entries.getKey());
        this.bloodValueReader.load((Map)entries.getValue());
    }

    private Map<EntityType<? extends PathfinderMob>, EntityEntry> load(ResourceManager manager) {
        IForgeRegistry entityTypes = ForgeRegistries.ENTITY_TYPES;
        HashMap<EntityType<? extends PathfinderMob>, EntityEntry> values = new HashMap<EntityType<? extends PathfinderMob>, EntityEntry>();
        for (Map.Entry entry : manager.m_214160_(DIRECTORY, file -> file.m_135815_().endsWith(PATH_SUFFIX)).entrySet()) {
            ResourceLocation resourceLocation = (ResourceLocation)entry.getKey();
            String s = resourceLocation.m_135815_();
            String substring = s.substring(DIRECTORY.length() + 1, s.length() - PATH_SUFFIX_LENGTH);
            ResourceLocation resourceName = new ResourceLocation(resourceLocation.m_135827_(), substring);
            ResourceLocation entityName = new ResourceLocation(substring.replace('/', ':'));
            for (Resource resource : (List)entry.getValue()) {
                try {
                    BufferedReader reader = resource.m_215508_();
                    try {
                        JsonElement jsonElement = (JsonElement)GSON.fromJson((Reader)reader, JsonElement.class);
                        EntityEntry entityEntry = (EntityEntry)EntityEntry.CODEC.parse(new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)jsonElement)).getOrThrow(false, arg_0 -> ((Logger)LOGGER).error(arg_0));
                        EntityType entity = (EntityType)entityTypes.getValue(entityName);
                        values.put((EntityType<? extends PathfinderMob>)entity, entityEntry);
                    }
                    finally {
                        if (reader == null) continue;
                        ((Reader)reader).close();
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Couldn't read {} converting file from {}", (Object)resourceName, (Object)resource.m_215506_(), (Object)e);
                }
            }
        }
        return values;
    }

    public record EntityEntry(Optional<Converter> converter, Optional<ResourceLocation> overlay) {
        public static final Codec<EntityEntry> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Converter.CODEC.optionalFieldOf("handler").forGetter(i -> i.converter), (App)ResourceLocation.f_135803_.optionalFieldOf("overlay").forGetter(i -> i.overlay)).apply((Applicative)inst, EntityEntry::new));

        public EntityEntry(Converter converter, ResourceLocation overlay) {
            this(Optional.of(converter), Optional.of(overlay));
        }

        public EntityEntry(@Nullable ResourceLocation overlay) {
            this(Optional.empty(), Optional.ofNullable(overlay));
        }

        public EntityEntry(Converter converter) {
            this(Optional.of(converter), Optional.empty());
        }

        public record ConvertingAttributeModifier(Map<Attribute, com.mojang.datafixers.util.Pair<FloatProvider, Double>> attributeModifier) {
            public static ConvertingAttributeModifier DEFAULT;
            private static final Codec<com.mojang.datafixers.util.Pair<Attribute, com.mojang.datafixers.util.Pair<FloatProvider, Double>>> CODEC_PAIR;
            public static final Codec<ConvertingAttributeModifier> CODEC;

            public ConvertingAttributeModifier(List<com.mojang.datafixers.util.Pair<Attribute, com.mojang.datafixers.util.Pair<FloatProvider, Double>>> values) {
                this(values.stream().collect(Collectors.toMap(com.mojang.datafixers.util.Pair::getFirst, com.mojang.datafixers.util.Pair::getSecond, (a, b) -> b)));
            }

            public com.mojang.datafixers.util.Pair<FloatProvider, Double> modifier(Attribute attribute) {
                return this.attributeModifier.get(attribute);
            }

            static {
                ConstantFloat constantFloat = ConstantFloat.m_146458_((float)1.3f);
                Objects.requireNonNull(BalanceMobProps.mobProps);
                com.mojang.datafixers.util.Pair pair = com.mojang.datafixers.util.Pair.of((Object)constantFloat, (Object)1.0);
                com.mojang.datafixers.util.Pair pair2 = com.mojang.datafixers.util.Pair.of((Object)ConstantFloat.m_146458_((float)1.3f), (Object)BalanceMobProps.mobProps.CONVERTED_MOB_DEFAULT_KNOCKBACK_RESISTANCE);
                ConstantFloat constantFloat2 = ConstantFloat.m_146458_((float)1.5f);
                Objects.requireNonNull(BalanceMobProps.mobProps);
                com.mojang.datafixers.util.Pair pair3 = com.mojang.datafixers.util.Pair.of((Object)constantFloat2, (Object)1.0);
                ConstantFloat constantFloat3 = ConstantFloat.m_146458_((float)1.2f);
                Objects.requireNonNull(BalanceMobProps.mobProps);
                DEFAULT = new ConvertingAttributeModifier(Map.of(Attributes.f_22281_, pair, Attributes.f_22278_, pair2, Attributes.f_22276_, pair3, Attributes.f_22279_, com.mojang.datafixers.util.Pair.of((Object)constantFloat3, (Object)1.0)));
                CODEC_PAIR = RecordCodecBuilder.create(inst -> inst.group((App)ForgeRegistries.ATTRIBUTES.getCodec().fieldOf("attribute").forGetter(com.mojang.datafixers.util.Pair::getFirst), (App)FloatProvider.f_146502_.fieldOf("modifier").forGetter(s -> (FloatProvider)((com.mojang.datafixers.util.Pair)s.getSecond()).getFirst()), (App)Codec.DOUBLE.optionalFieldOf("fallback_base", (Object)1.0).forGetter(s -> (Double)((com.mojang.datafixers.util.Pair)s.getSecond()).getSecond())).apply((Applicative)inst, (attribute, floatProvider, aDouble) -> com.mojang.datafixers.util.Pair.of((Object)attribute, (Object)com.mojang.datafixers.util.Pair.of((Object)floatProvider, (Object)aDouble))));
                CODEC = CODEC_PAIR.listOf().xmap(ConvertingAttributeModifier::new, x -> x.attributeModifier.entrySet().stream().map(s -> com.mojang.datafixers.util.Pair.of((Object)((Attribute)s.getKey()), (Object)com.mojang.datafixers.util.Pair.of((Object)((FloatProvider)((com.mojang.datafixers.util.Pair)s.getValue()).getFirst()), (Object)((Double)((com.mojang.datafixers.util.Pair)s.getValue()).getSecond())))).collect(Collectors.toList()));
            }
        }
    }
}

