/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.player.tasks.unlock;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.task.TaskUnlocker;
import de.teamlapen.vampirism.core.ModTasks;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class LordLvlUnlocker
implements TaskUnlocker {
    public static final Codec<LordLvlUnlocker> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.INT.fieldOf("reqLordLevel").forGetter(i -> i.reqLordLevel), (App)Codec.BOOL.fieldOf("exact").forGetter(i -> i.exact)).apply((Applicative)inst, LordLvlUnlocker::new));
    private final int reqLordLevel;
    private final boolean exact;

    public LordLvlUnlocker(int reqLordLevel, boolean exact) {
        this.reqLordLevel = reqLordLevel;
        this.exact = exact;
    }

    public LordLvlUnlocker(int reqLordLevel) {
        this(reqLordLevel, false);
    }

    @Override
    @NotNull
    public Component getDescription() {
        return Component.m_237115_((String)"text.vampirism.lord").m_7220_((Component)Component.m_237113_((String)" ")).m_7220_((Component)Component.m_237115_((String)"text.vampirism.level")).m_7220_((Component)Component.m_237113_((String)((this.exact ? " = " : " ") + this.reqLordLevel)));
    }

    @Override
    public boolean isUnlocked(@NotNull IFactionPlayer<?> playerEntity) {
        int aL = FactionPlayerHandler.getOpt(playerEntity.getRepresentingPlayer()).map(FactionPlayerHandler::getLordLevel).orElse(0);
        return this.exact ? aL == this.reqLordLevel : aL >= this.reqLordLevel;
    }

    @Override
    public Codec<? extends TaskUnlocker> codec() {
        return (Codec)ModTasks.LORD_LEVEL_UNLOCKER.get();
    }
}

