/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.inventory;

import de.teamlapen.lib.lib.inventory.InventoryHelper;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.core.ModContainer;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.hunter.HunterTrainerEntity;
import de.teamlapen.vampirism.entity.player.hunter.HunterLeveling;
import de.teamlapen.vampirism.inventory.ModifiedItemCombinerMenuSlotDefinition;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.ItemCombinerMenu;
import net.minecraft.world.inventory.ItemCombinerMenuSlotDefinition;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HunterTrainerMenu
extends ItemCombinerMenu {
    @NotNull
    private final Player player;
    @Nullable
    private final HunterTrainerEntity entity;
    @NotNull
    private Optional<HunterLeveling.HunterTrainerRequirement> lvlRequirement;

    @Deprecated
    public HunterTrainerMenu(int id, @NotNull Inventory playerInventory) {
        this(id, playerInventory, null);
    }

    public HunterTrainerMenu(int id, @NotNull Inventory playerInventory, @Nullable HunterTrainerEntity trainer) {
        super((MenuType)ModContainer.HUNTER_TRAINER.get(), id, playerInventory, trainer == null ? ContainerLevelAccess.f_39287_ : ContainerLevelAccess.m_39289_((Level)trainer.m_9236_(), (BlockPos)trainer.m_20183_()));
        this.player = playerInventory.f_35978_;
        this.entity = trainer;
        this.lvlRequirement = HunterLeveling.getTrainerRequirement(FactionPlayerHandler.getOpt(this.player).map(h -> h.getCurrentLevel(VReference.HUNTER_FACTION)).orElse(0) + 1);
    }

    protected boolean m_6560_(@NotNull Player pPlayer, boolean pHasStack) {
        return true;
    }

    protected void m_142365_(@NotNull Player player, @NotNull ItemStack stack) {
    }

    protected boolean m_8039_(@NotNull BlockState pState) {
        return true;
    }

    public void m_6640_() {
    }

    @NotNull
    protected ItemCombinerMenuSlotDefinition m_266183_() {
        return ModifiedItemCombinerMenuSlotDefinition.createWithoutResult().withSlot(0, 27, 26, stack -> this.lvlRequirement.filter(req -> req.ironQuantity() > 0).isPresent() && stack.m_150930_(Items.f_42416_)).withSlot(1, 57, 26, stack -> this.lvlRequirement.filter(req -> req.goldQuantity() > 0).isPresent() && stack.m_150930_(Items.f_42417_)).withSlot(2, 86, 26, stack -> this.lvlRequirement.map(req -> req.tableRequirement().resultIntelItem().get()).filter(arg_0 -> ((ItemStack)stack).m_150930_(arg_0)).isPresent()).build();
    }

    public void m_266430_(@NotNull ItemCombinerMenuSlotDefinition definition) {
    }

    public boolean canLevelup() {
        return this.lvlRequirement.map(req -> req.ironQuantity() <= this.f_39769_.m_18947_(Items.f_42416_) && req.goldQuantity() <= this.f_39769_.m_18947_(Items.f_42417_) && this.f_39769_.m_18947_((Item)req.tableRequirement().resultIntelItem().get()) >= 1).orElse(false);
    }

    public Optional<HunterLeveling.HunterTrainerRequirement> getRequirement() {
        return this.lvlRequirement;
    }

    public void onLevelupClicked() {
        if (this.canLevelup()) {
            this.lvlRequirement.ifPresent(req -> {
                FactionPlayerHandler.get(this.player).setFactionLevel(VReference.HUNTER_FACTION, req.targetLevel());
                InventoryHelper.removeItems(this.f_39769_, req.ironQuantity(), req.goldQuantity(), 1);
                this.player.m_7292_(new MobEffectInstance((MobEffect)ModEffects.SATURATION.get(), 400, 2));
                this.lvlRequirement = HunterLeveling.getTrainerRequirement(req.targetLevel() + 1);
            });
        }
    }

    public boolean m_6875_(@NotNull Player player) {
        if (this.entity == null) {
            return false;
        }
        return new Vec3(player.m_20185_(), player.m_20186_(), player.m_20189_()).m_82557_(new Vec3(this.entity.m_20185_(), this.entity.m_20186_(), this.entity.m_20189_())) < 64.0;
    }
}

