/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.items.IFactionExclusiveItem;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.entity.player.VampirismPlayerAttributes;
import de.teamlapen.vampirism.util.Helper;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Tuple;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VampirismHunterArmorItem
extends ArmorItem
implements IFactionExclusiveItem {
    protected static final UUID[] VAMPIRISM_ARMOR_MODIFIER = new UUID[]{UUID.fromString("f0b9a417-0cec-4629-8623-053cd0feec3c"), UUID.fromString("e54474a9-62a0-48ee-baaf-7efddca3d711"), UUID.fromString("ac0c33f4-ebbf-44fe-9be3-a729f7633329"), UUID.fromString("8839e157-d576-4cff-bf34-0a788131fe0f")};
    @NotNull
    private final Multimap<Attribute, AttributeModifier> modifierMultimap;
    private String descriptionId;

    public VampirismHunterArmorItem(@NotNull ArmorMaterial materialIn, @NotNull ArmorItem.Type type, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Item.Properties props) {
        this(materialIn, type, props, (Map<Attribute, Tuple<Double, AttributeModifier.Operation>>)ImmutableMap.of());
    }

    public VampirismHunterArmorItem(@NotNull ArmorMaterial materialIn, @NotNull ArmorItem.Type type, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Item.Properties props, @NotNull Map<Attribute, Tuple<Double, AttributeModifier.Operation>> modifiers) {
        super(materialIn, type, props);
        ImmutableMultimap.Builder builder = new ImmutableMultimap.Builder();
        builder.putAll(this.m_7167_(type.m_266308_()));
        for (Map.Entry<Attribute, Tuple<Double, AttributeModifier.Operation>> modifier : modifiers.entrySet()) {
            builder.put((Object)modifier.getKey(), (Object)new AttributeModifier(VAMPIRISM_ARMOR_MODIFIER[type.m_266308_().m_20749_()], "Vampirism armor modifier", ((Double)modifier.getValue().m_14418_()).doubleValue(), (AttributeModifier.Operation)modifier.getValue().m_14419_()));
        }
        this.modifierMultimap = builder.build();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(@NotNull ItemStack stack, @Nullable Level worldIn, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        this.addFactionToolTips(stack, worldIn, tooltip, flagIn, VampirismMod.proxy.getClientPlayer());
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        if (slot == this.f_265916_.m_266308_()) {
            return this.modifierMultimap;
        }
        return ImmutableMultimap.of();
    }

    @Override
    @Nullable
    public IFaction<?> getExclusiveFaction(@NotNull ItemStack stack) {
        return VReference.HUNTER_FACTION;
    }

    public void onArmorTick(ItemStack stack, Level world, @NotNull Player player) {
        IPlayableFaction<?> f;
        if (player.f_19797_ % 16 == 8 && (f = VampirismPlayerAttributes.get((Player)player).faction) != null && !VReference.HUNTER_FACTION.equals(f)) {
            player.m_7292_(new MobEffectInstance((MobEffect)ModEffects.POISON.get(), 20, 1));
        }
    }

    public boolean canEquip(ItemStack stack, EquipmentSlot armorType, Entity entity) {
        return super.canEquip(stack, armorType, entity) && Helper.isHunter(entity);
    }

    protected String getTextureLocation(String name, EquipmentSlot slot, @Nullable String type) {
        return String.format("vampirism:textures/models/armor/%s_layer_%d%s.png", name, slot == EquipmentSlot.LEGS ? 2 : 1, type == null ? "" : "_overlay");
    }

    @NotNull
    protected String m_41467_() {
        if (this.descriptionId == null) {
            this.descriptionId = super.m_41467_().replaceAll("_normal|_enhanced|_ultimate", "");
        }
        return this.descriptionId;
    }
}

