/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.particle;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.teamlapen.vampirism.core.ModParticles;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public record FlyingBloodParticleOptions(int maxAge, boolean direct, double targetX, double targetY, double targetZ, ResourceLocation texture, float scale) implements ParticleOptions
{
    public static final Codec<FlyingBloodParticleOptions> CODEC = RecordCodecBuilder.create(p_239803_0_ -> p_239803_0_.group((App)Codec.INT.fieldOf("a").forGetter(p_239807_0_ -> p_239807_0_.maxAge), (App)Codec.BOOL.fieldOf("d").forGetter(p_239806_0_ -> p_239806_0_.direct), (App)Codec.DOUBLE.fieldOf("x").forGetter(p_239805_0_ -> p_239805_0_.targetX), (App)Codec.DOUBLE.fieldOf("y").forGetter(p_239804_0_ -> p_239804_0_.targetY), (App)Codec.DOUBLE.fieldOf("z").forGetter(p_239804_0_ -> p_239804_0_.targetZ), (App)Codec.STRING.fieldOf("t").forGetter(p_239804_0_ -> p_239804_0_.texture.toString()), (App)Codec.FLOAT.fieldOf("s").forGetter(p_239804_0_ -> Float.valueOf(p_239804_0_.scale))).apply((Applicative)p_239803_0_, (a, d, x, y, z, t, s) -> new FlyingBloodParticleOptions((int)a, (boolean)d, (double)x, (double)y, (double)z, new ResourceLocation(t), s.floatValue())));
    public static final ParticleOptions.Deserializer<FlyingBloodParticleOptions> DESERIALIZER = new ParticleOptions.Deserializer<FlyingBloodParticleOptions>(){

        @NotNull
        public FlyingBloodParticleOptions fromCommand(@NotNull ParticleType<FlyingBloodParticleOptions> particleTypeIn, @NotNull StringReader reader) throws CommandSyntaxException {
            return new FlyingBloodParticleOptions(reader.readInt(), reader.readBoolean(), reader.readDouble(), reader.readDouble(), reader.readDouble(), ResourceLocation.m_135818_((StringReader)reader), reader.readFloat());
        }

        @NotNull
        public FlyingBloodParticleOptions fromNetwork(@NotNull ParticleType<FlyingBloodParticleOptions> particleTypeIn, @NotNull FriendlyByteBuf buffer) {
            return new FlyingBloodParticleOptions(buffer.m_130242_(), buffer.readBoolean(), buffer.readDouble(), buffer.readDouble(), buffer.readDouble(), buffer.m_130281_(), buffer.readFloat());
        }
    };

    public FlyingBloodParticleOptions(int maxAgeIn, boolean direct, double targetX, double targetY, double targetZ) {
        this(maxAgeIn, direct, targetX, targetY, targetZ, 1.0f);
    }

    public FlyingBloodParticleOptions(int maxAgeIn, boolean direct, double targetX, double targetY, double targetZ, float scale) {
        this(maxAgeIn, direct, targetX, targetY, targetZ, new ResourceLocation("minecraft", "critical_hit"), scale);
    }

    public FlyingBloodParticleOptions(int maxAge, boolean direct, double targetX, double targetY, double targetZ, ResourceLocation texture) {
        this(maxAge, direct, targetX, targetY, targetZ, texture, 1.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getMaxAge() {
        return this.maxAge;
    }

    public void m_7711_(@NotNull FriendlyByteBuf buffer) {
        buffer.m_130130_(this.maxAge);
        buffer.writeBoolean(this.direct);
        buffer.writeDouble(this.targetX);
        buffer.writeDouble(this.targetY);
        buffer.writeDouble(this.targetZ);
        buffer.m_130085_(this.texture);
        buffer.writeFloat(this.scale);
    }

    @NotNull
    public ParticleType<?> m_6012_() {
        return (ParticleType)ModParticles.FLYING_BLOOD.get();
    }

    @NotNull
    public String m_5942_() {
        return ForgeRegistries.PARTICLE_TYPES.getKey(this.m_6012_()) + " " + this.maxAge + " " + this.texture;
    }
}

