/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Either;
import de.teamlapen.vampirism.api.entity.player.hunter.IHunterPlayer;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillHandler;
import de.teamlapen.vampirism.core.ModRecipes;
import de.teamlapen.vampirism.recipes.VampirismRecipeHelper;
import de.teamlapen.vampirism.util.RegUtil;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.CookingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import org.jetbrains.annotations.NotNull;

public class AlchemicalCauldronRecipe
extends AbstractCookingRecipe {
    private static final ISkill<?>[] EMPTY_SKILLS = new ISkill[0];
    private final Either<Ingredient, FluidStack> fluid;
    @NotNull
    private final ISkill<?>[] skills;
    private final int reqLevel;

    public AlchemicalCauldronRecipe(@NotNull ResourceLocation idIn, @NotNull String groupIn, CookingBookCategory category, @NotNull Ingredient ingredientIn, Either<Ingredient, FluidStack> fluidIn, @NotNull ItemStack resultIn, @NotNull ISkill<?>[] skillsIn, int reqLevelIn, int cookTimeIn, float exp) {
        super((RecipeType)ModRecipes.ALCHEMICAL_CAULDRON_TYPE.get(), idIn, groupIn, category, ingredientIn, resultIn, exp, cookTimeIn);
        this.fluid = fluidIn;
        this.skills = skillsIn;
        this.reqLevel = reqLevelIn;
    }

    public boolean canBeCooked(int level, @NotNull ISkillHandler<IHunterPlayer> skillHandler) {
        if (level < this.reqLevel) {
            return false;
        }
        for (ISkill<?> s : this.skills) {
            if (skillHandler.isSkillEnabled(s)) continue;
            return false;
        }
        return true;
    }

    public Either<Ingredient, FluidStack> getFluid() {
        return this.fluid;
    }

    @NotNull
    public Ingredient getIngredient() {
        return this.f_43729_;
    }

    public int getRequiredLevel() {
        return this.reqLevel;
    }

    @NotNull
    public ISkill<?>[] getRequiredSkills() {
        return this.skills;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipes.ALCHEMICAL_CAULDRON.get();
    }

    public boolean m_5818_(@NotNull Container inv, @NotNull Level worldIn) {
        boolean match = this.f_43729_.test(inv.m_8020_(1));
        AtomicBoolean fluidMatch = new AtomicBoolean(true);
        this.fluid.ifLeft(ingredient1 -> fluidMatch.set(ingredient1.test(inv.m_8020_(0))));
        this.fluid.ifRight(ingredient1 -> {
            fluidMatch.set(false);
            Optional stack = FluidUtil.getFluidContained((ItemStack)inv.m_8020_(0));
            stack.ifPresent(handlerItem -> fluidMatch.set(ingredient1.isFluidEqual(handlerItem) && ingredient1.getAmount() <= handlerItem.getAmount()));
        });
        return match && fluidMatch.get();
    }

    @NotNull
    public String toString() {
        return "AlchemicalCauldronRecipe{cookingTime=" + this.f_43732_ + ", skills=" + Arrays.toString(this.skills) + ", output=" + this.f_43730_ + ", ingredient=" + this.f_43729_ + ", reqLevel=" + this.reqLevel + ", experience=" + this.f_43731_ + ", fluid=" + this.fluid + "}";
    }

    public static class Serializer
    implements RecipeSerializer<AlchemicalCauldronRecipe> {
        @NotNull
        public AlchemicalCauldronRecipe fromJson(@NotNull ResourceLocation recipeId, @NotNull JsonObject json) {
            String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            CookingBookCategory category = (CookingBookCategory)CookingBookCategory.f_244271_.m_262792_(GsonHelper.m_13851_((JsonObject)json, (String)"category", (String)null), (Enum)CookingBookCategory.MISC);
            Ingredient ingredients = Ingredient.m_43917_((JsonElement)(GsonHelper.m_13885_((JsonObject)json, (String)"ingredient") ? GsonHelper.m_13933_((JsonObject)json, (String)"ingredient") : GsonHelper.m_13930_((JsonObject)json, (String)"ingredient")));
            int level = GsonHelper.m_13824_((JsonObject)json, (String)"level", (int)1);
            ISkill<?>[] skills = VampirismRecipeHelper.deserializeSkills(GsonHelper.m_13832_((JsonObject)json, (String)"skill", null));
            ItemStack result = CraftingHelper.getItemStack((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"), (boolean)true);
            Either<Ingredient, FluidStack> fluid = VampirismRecipeHelper.getFluidOrItem(json);
            int cookTime = GsonHelper.m_13824_((JsonObject)json, (String)"cookTime", (int)200);
            float exp = GsonHelper.m_13820_((JsonObject)json, (String)"experience", (float)0.2f);
            return new AlchemicalCauldronRecipe(recipeId, group, category, ingredients, fluid, result, skills, level, cookTime, exp);
        }

        public AlchemicalCauldronRecipe fromNetwork(@NotNull ResourceLocation recipeId, @NotNull FriendlyByteBuf buffer) {
            String group = buffer.m_130136_(Short.MAX_VALUE);
            CookingBookCategory cookingbookcategory = (CookingBookCategory)buffer.m_130066_(CookingBookCategory.class);
            ItemStack result = buffer.m_130267_();
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            Either fluid = buffer.readBoolean() ? Either.left((Object)Ingredient.m_43940_((FriendlyByteBuf)buffer)) : Either.right((Object)FluidStack.readFromPacket((FriendlyByteBuf)buffer));
            float exp = buffer.readFloat();
            int cookingtime = buffer.m_130242_();
            int level = buffer.m_130242_();
            ISkill[] skills = new ISkill[buffer.m_130242_()];
            for (int i = 0; i < skills.length; ++i) {
                skills[i] = RegUtil.getSkill(buffer.m_130281_());
            }
            return new AlchemicalCauldronRecipe(recipeId, group, cookingbookcategory, ingredient, (Either<Ingredient, FluidStack>)fluid, result, skills, level, cookingtime, exp);
        }

        public void toNetwork(@NotNull FriendlyByteBuf buffer, @NotNull AlchemicalCauldronRecipe recipe) {
            buffer.m_130070_(recipe.f_43728_);
            buffer.m_130068_((Enum)recipe.m_245534_());
            buffer.m_130055_(recipe.f_43730_);
            recipe.f_43729_.m_43923_(buffer);
            if (recipe.fluid.left().isPresent()) {
                buffer.writeBoolean(true);
                ((Ingredient)recipe.fluid.left().get()).m_43923_(buffer);
            } else {
                assert (recipe.fluid.right().isPresent());
                buffer.writeBoolean(false);
                ((FluidStack)recipe.fluid.right().get()).writeToPacket(buffer);
            }
            buffer.writeFloat(recipe.f_43731_);
            buffer.m_130130_(recipe.f_43732_);
            buffer.m_130130_(recipe.reqLevel);
            buffer.m_130130_(recipe.skills.length);
            for (ISkill<?> skill : recipe.skills) {
                buffer.m_130085_(RegUtil.id(skill));
            }
        }
    }
}

