/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.util;

import de.teamlapen.vampirism.api.items.oil.IApplicableOil;
import de.teamlapen.vampirism.api.items.oil.IArmorOil;
import de.teamlapen.vampirism.api.items.oil.IOil;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.core.ModOils;
import de.teamlapen.vampirism.items.OilBottleItem;
import de.teamlapen.vampirism.util.RegUtil;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class OilUtils {
    @NotNull
    public static IOil getOil(@NotNull ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        IOil oil = null;
        if (tag != null && tag.m_128441_("oil")) {
            String oilStr = stack.m_41783_().m_128461_("oil");
            oil = RegUtil.getOil(new ResourceLocation(oilStr));
        }
        return oil != null ? oil : (IOil)ModOils.EMPTY.get();
    }

    @NotNull
    public static ItemStack setOil(@NotNull ItemStack stack, @NotNull IOil oil) {
        stack.m_41784_().m_128359_("oil", RegUtil.id(oil).toString());
        return stack;
    }

    public static ItemStack createOilItem(IOil oil) {
        return ((OilBottleItem)ModItems.OIL_BOTTLE.get()).withOil(oil);
    }

    public static Collection<IArmorOil> getEquippedArmorOils(Player player) {
        return StreamSupport.stream(player.m_6168_().spliterator(), false).map(OilUtils::getAppliedOil).filter(o -> o.isPresent() && o.get() instanceof IArmorOil).map(iApplicableOil -> (IArmorOil)iApplicableOil.get()).collect(Collectors.toList());
    }

    @NotNull
    public static Optional<IApplicableOil> getAppliedOil(@NotNull ItemStack stack) {
        return OilUtils.getAppliedOilStatus(stack).map(Pair::getLeft);
    }

    public static boolean reduceAppliedOilDuration(@NotNull ItemStack stack) {
        return OilUtils.getAppliedOil(stack).map(oil -> OilUtils.reduceAppliedOilDuration(stack, oil, oil.getDurationReduction())).orElse(true);
    }

    public static boolean reduceAppliedOilDuration(@NotNull ItemStack stack, IApplicableOil oil, int durationReduction) {
        CompoundTag compound;
        if (stack.m_41782_() && (compound = stack.m_41783_().m_128469_("applied_oil")).m_128461_("oil").equals(RegUtil.id(oil).toString())) {
            int duration = compound.m_128451_("duration") - durationReduction;
            if (duration <= 0) {
                OilUtils.removeAppliedOil(stack);
                return true;
            }
            compound.m_128405_("duration", duration);
            return false;
        }
        return true;
    }

    public static boolean hasAppliedOil(@NotNull ItemStack stack) {
        return stack.m_41782_() && stack.m_41783_().m_128469_("applied_oil").m_128441_("oil");
    }

    @NotNull
    public static Optional<Pair<IApplicableOil, Integer>> getAppliedOilStatus(@NotNull ItemStack stack) {
        if (!stack.m_41782_()) {
            return Optional.empty();
        }
        CompoundTag compound = stack.m_41783_().m_128469_("applied_oil");
        if (compound.m_128441_("oil")) {
            IOil oil = RegUtil.getOil(new ResourceLocation(compound.m_128461_("oil")));
            int duration = compound.m_128451_("duration");
            if (oil instanceof IApplicableOil && duration > 0) {
                return Optional.of(Pair.of((Object)((IApplicableOil)oil), (Object)duration));
            }
            OilUtils.removeAppliedOil(stack);
            return Optional.empty();
        }
        return Optional.empty();
    }

    @NotNull
    public static ItemStack removeAppliedOil(@NotNull ItemStack stack) {
        if (stack.m_41782_()) {
            stack.m_41783_().m_128473_("applied_oil");
        }
        return stack;
    }

    @NotNull
    public static ItemStack setAppliedOil(@NotNull ItemStack stack, @NotNull IApplicableOil oil) {
        return OilUtils.setAppliedOil(stack, oil, oil.getMaxDuration(stack));
    }

    @NotNull
    public static ItemStack setAppliedOil(@NotNull ItemStack stack, IApplicableOil oil, int duration) {
        if (duration <= 0) {
            return OilUtils.removeAppliedOil(stack);
        }
        CompoundTag compound = new CompoundTag();
        compound.m_128359_("oil", RegUtil.id(oil).toString());
        compound.m_128405_("duration", duration);
        stack.m_41784_().m_128365_("applied_oil", (Tag)compound);
        return stack;
    }
}

