/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.util;

import de.teamlapen.vampirism.REFERENCE;
import de.teamlapen.vampirism.config.VampirismConfig;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.stream.Collectors;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.util.thread.EffectiveSide;
import net.minecraftforge.versions.mcp.MCPVersion;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TelemetryCollector {
    public static final Logger LOGGER = LogManager.getLogger();

    public static void execute() {
        if (((Boolean)DistExecutor.unsafeRunForDist(() -> () -> true, () -> () -> true)).booleanValue() && ((Boolean)VampirismConfig.COMMON.collectStats.get()).booleanValue()) {
            TelemetryCollector.send();
        }
    }

    private static void send() {
        try {
            StringBuilder builder = new StringBuilder();
            builder.append("https://api.vampirism.dev/api/v1");
            builder.append("/telemetry/basic");
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("mod_version", REFERENCE.VERSION.toString());
            params.put("mc_version", MCPVersion.getMCVersion());
            params.put("mod_count", Integer.toString(ModList.get().size()));
            params.put("side", EffectiveSide.get() == LogicalSide.CLIENT ? "client" : "server");
            builder.append("?");
            builder.append(params.entrySet().stream().map(s -> (String)s.getKey() + "=" + URLEncoder.encode((String)s.getValue(), StandardCharsets.UTF_8)).collect(Collectors.joining("&")));
            HttpClient.newHttpClient().send(HttpRequest.newBuilder().uri(new URI(builder.toString())).build(), HttpResponse.BodyHandlers.ofString());
        }
        catch (IOException | InterruptedException | URISyntaxException e) {
            LOGGER.error("Failed to send telemetry data", (Throwable)e);
        }
    }
}

