/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.world;

import de.teamlapen.vampirism.core.ModDamageTypes;
import de.teamlapen.vampirism.entity.minion.MinionEntity;
import de.teamlapen.vampirism.entity.minion.management.MinionDamageSource;
import de.teamlapen.vampirism.util.DBNODamageSource;
import de.teamlapen.vampirism.util.PlayerAttackDamageSourceBypassArmor;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModDamageSources {
    private final Registry<DamageType> damageTypes;
    private final DamageSource sunDamage;
    private final DamageSource vampireOnFire;
    private final DamageSource vampireInFire;
    private final DamageSource holyWater;
    private final DamageSource noBlood;
    private final DamageSource mother;

    public ModDamageSources(RegistryAccess access) {
        this.damageTypes = access.m_175515_(Registries.f_268580_);
        this.sunDamage = this.init(ModDamageTypes.SUN_DAMAGE);
        this.vampireOnFire = this.init(ModDamageTypes.VAMPIRE_ON_FIRE);
        this.vampireInFire = this.init(ModDamageTypes.VAMPIRE_IN_FIRE);
        this.holyWater = this.init(ModDamageTypes.HOLY_WATER);
        this.noBlood = this.init(ModDamageTypes.NO_BLOOD);
        this.mother = this.init(ModDamageTypes.MOTHER);
    }

    private DamageSource init(ResourceKey<DamageType> key) {
        return new DamageSource((Holder)this.damageTypes.m_246971_(key));
    }

    public DamageSource sunDamage() {
        return this.sunDamage;
    }

    public DamageSource vampireOnFire() {
        return this.vampireOnFire;
    }

    public DamageSource vampireInFire() {
        return this.vampireInFire;
    }

    public DamageSource holyWater() {
        return this.holyWater;
    }

    public DamageSource noBlood() {
        return this.noBlood;
    }

    public DamageSource mother() {
        return this.mother;
    }

    public DamageSource stake(LivingEntity attacker) {
        return new DamageSource((Holder)this.damageTypes.m_246971_(ModDamageTypes.STAKE), (Entity)attacker);
    }

    public MinionDamageSource minion(@NotNull MinionEntity<?> entity) {
        return new MinionDamageSource((Holder<DamageType>)this.damageTypes.m_246971_(ModDamageTypes.MINION), entity);
    }

    public DBNODamageSource dbno(@Nullable Component originalSource) {
        return new DBNODamageSource((Holder<DamageType>)this.damageTypes.m_246971_(ModDamageTypes.DBNO), originalSource);
    }

    public PlayerAttackDamageSourceBypassArmor getPlayerAttackWithBypassArmor(@NotNull Player attacker) {
        return new PlayerAttackDamageSourceBypassArmor((Holder<DamageType>)this.damageTypes.m_246971_(DamageTypes.f_268464_), (Entity)attacker);
    }
}

