/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.world.loot.conditions;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import de.teamlapen.vampirism.api.difficulty.IAdjustableLevel;
import de.teamlapen.vampirism.core.ModLoot;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import org.jetbrains.annotations.NotNull;

public class AdjustableLevelCondition
implements LootItemCondition {
    private final int levelTest;
    private final LootContext.EntityTarget target;

    @NotNull
    public static LootItemCondition.Builder builder(int level, LootContext.EntityTarget target) {
        return () -> new AdjustableLevelCondition(level, target);
    }

    public AdjustableLevelCondition(int level, LootContext.EntityTarget targetIn) {
        this.levelTest = level;
        this.target = targetIn;
    }

    @NotNull
    public LootItemConditionType m_7940_() {
        return (LootItemConditionType)ModLoot.ADJUSTABLE_LEVEL.get();
    }

    public boolean test(@NotNull LootContext lootContext) {
        Entity e = (Entity)lootContext.m_78953_(this.target.m_79003_());
        if (e instanceof IAdjustableLevel) {
            int l = ((IAdjustableLevel)e).getEntityLevel();
            if (this.levelTest != -1) {
                return this.levelTest == l;
            }
        }
        return false;
    }

    public static class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<AdjustableLevelCondition> {
        @NotNull
        public AdjustableLevelCondition deserialize(@NotNull JsonObject json, @NotNull JsonDeserializationContext context) {
            return new AdjustableLevelCondition(json.has("level") ? GsonHelper.m_13927_((JsonObject)json, (String)"level") : -1, (LootContext.EntityTarget)GsonHelper.m_13836_((JsonObject)json, (String)"entity", (JsonDeserializationContext)context, LootContext.EntityTarget.class));
        }

        public void serialize(@NotNull JsonObject json, @NotNull AdjustableLevelCondition lootFunction, @NotNull JsonSerializationContext context) {
            json.add("level", context.serialize((Object)lootFunction.levelTest));
            json.add("entity", context.serialize((Object)lootFunction.target));
        }
    }
}

