/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.api.nutrients;

import com.github.elenterius.biomancy.init.ModItems;
import com.github.elenterius.biomancy.init.tags.ModItemTags;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.function.IntUnaryOperator;
import net.minecraft.util.Mth;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public final class Nutrients {
    private static final Object2IntMap<Item> FUEL_VALUES = new Object2IntArrayMap();
    private static final Object2IntMap<Item> REPAIR_VALUES = new Object2IntArrayMap();
    public static final IntUnaryOperator RAW_MEAT_NUTRITION_MODIFIER = nutrition -> nutrition > 0 ? Mth.m_14165_((double)(3.75 * Math.exp(0.215 * (double)nutrition))) : 0;

    private Nutrients() {
    }

    public static void registerFuel(Item resourceItem, int value) {
        FUEL_VALUES.put((Object)resourceItem, value);
    }

    public static void registerRepairMaterial(Item resourceItem, int value) {
        REPAIR_VALUES.put((Object)resourceItem, value);
    }

    public static boolean isValidRepairMaterial(ItemStack resource) {
        if (resource.m_41619_()) {
            return false;
        }
        if (REPAIR_VALUES.containsKey((Object)resource.m_41720_())) {
            return true;
        }
        if (resource.m_41614_()) {
            FoodProperties foodProperties = resource.getFoodProperties(null);
            if (foodProperties == null) {
                return false;
            }
            return foodProperties.m_38746_() && resource.m_204117_(ModItemTags.RAW_MEATS) && foodProperties.m_38744_() > 0;
        }
        return false;
    }

    public static int getRepairValue(ItemStack resource) {
        if (resource.m_41619_()) {
            return 0;
        }
        Item item = resource.m_41720_();
        if (REPAIR_VALUES.containsKey((Object)item)) {
            return REPAIR_VALUES.getInt((Object)item);
        }
        if (resource.m_41614_()) {
            FoodProperties foodProperties = resource.getFoodProperties(null);
            if (foodProperties == null) {
                return 0;
            }
            if (foodProperties.m_38746_() && resource.m_204117_(ModItemTags.RAW_MEATS)) {
                return RAW_MEAT_NUTRITION_MODIFIER.applyAsInt(foodProperties.m_38744_()) * 2;
            }
        }
        return 0;
    }

    public static boolean isValidFuel(ItemStack resource) {
        if (resource.m_41619_()) {
            return false;
        }
        if (FUEL_VALUES.containsKey((Object)resource.m_41720_())) {
            return true;
        }
        if (resource.m_41614_()) {
            FoodProperties foodProperties = resource.getFoodProperties(null);
            return foodProperties != null && foodProperties.m_38744_() > 0;
        }
        return false;
    }

    public static int getFuelValue(ItemStack resource) {
        if (resource.m_41619_()) {
            return 0;
        }
        Item item = resource.m_41720_();
        if (FUEL_VALUES.containsKey((Object)item)) {
            return FUEL_VALUES.getInt((Object)item);
        }
        if (resource.m_41614_()) {
            FoodProperties foodProperties = resource.getFoodProperties(null);
            if (foodProperties == null) {
                return 0;
            }
            int nutrition = foodProperties.m_38744_();
            if (foodProperties.m_38746_() && resource.m_204117_(ModItemTags.RAW_MEATS)) {
                return RAW_MEAT_NUTRITION_MODIFIER.applyAsInt(nutrition);
            }
            return nutrition;
        }
        return 0;
    }

    static {
        Nutrients.registerFuel((Item)ModItems.NUTRIENT_PASTE.get(), 3);
        Nutrients.registerFuel((Item)ModItems.NUTRIENT_BAR.get(), 27);
        Nutrients.registerRepairMaterial((Item)ModItems.NUTRIENT_PASTE.get(), 6);
        Nutrients.registerRepairMaterial((Item)ModItems.NUTRIENT_BAR.get(), 54);
    }
}

