/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.api.nutrients;

import java.util.function.Predicate;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public interface NutrientsContainerItem {
    public static final String NUTRIENTS_TAG_KEY = "biomancy:nutrients";
    public static final Predicate<ItemStack> NEED_NUTRIENTS_PREDICATE = stack -> {
        NutrientsContainerItem item;
        Item patt643$temp = stack.m_41720_();
        return patt643$temp instanceof NutrientsContainerItem && (item = (NutrientsContainerItem)patt643$temp).getNutrients((ItemStack)stack) < item.getMaxNutrients((ItemStack)stack);
    };

    default public void decreaseNutrients(ItemStack container, int decrement) {
        this.increaseNutrients(container, -decrement);
    }

    default public void increaseNutrients(ItemStack container, int increment) {
        int nutrients = this.getNutrients(container);
        this.setNutrients(container, nutrients + increment);
    }

    default public boolean consumeNutrients(ItemStack container, int amount) {
        int nutrients = this.getNutrients(container);
        if (nutrients < amount) {
            return false;
        }
        this.setNutrients(container, nutrients - amount);
        return true;
    }

    default public boolean addNutrients(ItemStack container, int amount) {
        int maxNutrients;
        int nutrients = this.getNutrients(container);
        if (nutrients + amount > (maxNutrients = this.getMaxNutrients(container))) {
            return false;
        }
        this.setNutrients(container, nutrients + amount);
        return true;
    }

    public int getMaxNutrients(ItemStack var1);

    public void onNutrientsChanged(ItemStack var1, int var2, int var3);

    default public int getNutrients(ItemStack container) {
        return container.m_41784_().m_128451_(NUTRIENTS_TAG_KEY);
    }

    default public boolean hasNutrients(ItemStack container) {
        return this.getNutrients(container) > 0;
    }

    default public void setNutrients(ItemStack container, int amount) {
        int maxNutrients = this.getMaxNutrients(container);
        int oldValue = this.getNutrients(container);
        int newValue = Mth.m_14045_((int)amount, (int)0, (int)maxNutrients);
        container.m_41784_().m_128405_(NUTRIENTS_TAG_KEY, newValue);
        this.onNutrientsChanged(container, oldValue, newValue);
    }

    default public float getNutrientsPct(ItemStack container) {
        return (float)this.getNutrients(container) / (float)this.getMaxNutrients(container);
    }

    public boolean isValidNutrientsResource(ItemStack var1, ItemStack var2);

    public int getNutrientsResourceValue(ItemStack var1, ItemStack var2);

    default public ItemStack insertNutrients(ItemStack container, ItemStack resource) {
        int maxNutrients;
        if (resource.m_41619_()) {
            return resource;
        }
        if (!this.isValidNutrientsResource(container, resource)) {
            return resource;
        }
        int nutrients = this.getNutrients(container);
        if (nutrients >= (maxNutrients = this.getMaxNutrients(container))) {
            return resource;
        }
        int resourceValue = this.getNutrientsResourceValue(container, resource);
        if (resourceValue <= 0) {
            return resource;
        }
        int neededAmount = Mth.m_14143_((float)((float)Math.max(0, maxNutrients - nutrients) / (float)resourceValue));
        if (neededAmount > 0) {
            this.setNutrients(container, nutrients + resourceValue);
            return ItemHandlerHelper.copyStackWithSize((ItemStack)resource, (int)(resource.m_41613_() - 1));
        }
        return resource;
    }

    default public boolean handleOverrideStackedOnOther(ItemStack livingTool, Slot slot, ClickAction action, Player player) {
        if (livingTool.m_41613_() > 1) {
            return false;
        }
        if (action != ClickAction.SECONDARY || !slot.m_150651_(player)) {
            return false;
        }
        if (!slot.m_7993_().m_41619_()) {
            ItemStack potentialResource = slot.m_7993_();
            ItemStack remainder = this.insertNutrients(livingTool, potentialResource);
            int insertedAmount = potentialResource.m_41613_() - remainder.m_41613_();
            if (insertedAmount > 0) {
                return !slot.m_150647_(insertedAmount, insertedAmount, player).m_41619_();
            }
        }
        return false;
    }

    default public boolean handleOverrideOtherStackedOnMe(ItemStack livingTool, ItemStack potentialResource, Slot slot, ClickAction action, Player player, SlotAccess access) {
        if (livingTool.m_41613_() > 1) {
            return false;
        }
        if (action != ClickAction.SECONDARY || !slot.m_150651_(player)) {
            return false;
        }
        if (!potentialResource.m_41619_()) {
            ItemStack remainder = this.insertNutrients(livingTool, potentialResource);
            int insertedAmount = potentialResource.m_41613_() - remainder.m_41613_();
            if (insertedAmount > 0) {
                potentialResource.m_41774_(insertedAmount);
                return true;
            }
        }
        return false;
    }
}

